#ifndef _TSTORE_H_
#define _TSTORE_H_

#include <qobject.h>
#include <qlist.h>
#include <qdict.h>
#include <qwidget.h>
#include <qfileinf.h>
#include <qstrlist.h>

#include <iostream.h>

#include "TStoreType.h"

typedef struct TClassInfo {
	QString libraryName;
	QString parentClassName;
} TClassInfo;



typedef struct TLibrary {
  void *library;
  QString libName;
} TLibrary;



class TStore: public QObject {
  Q_OBJECT
friend ostream &operator<<(ostream &os, TStore &s);
public:
  TStore(QStrList &directories, QObject *parent=0, const char *name=0);
  ~TStore(void);

  TStoreTypeCreateFn type(QString name);
  QDict<TIntLibraryInfo> &dictionary() {return fTypeDict;};
protected:
  bool loadLibrary(QString);
  void getLibraryInfo(QFileInfo *parfile);
private:
  QDict<TIntLibraryInfo> fTypeDict;
  QList<TLibrary> fLibraryList;

  QDict<QStrList> libraryDict;
  QDict<TClassInfo> classInfoDict;

  QStrList halfOpenedLibraries;
};




#endif /* _TSTORE_H_ */
