#ifndef _TSTORETYPE_H_
#define _TSTORETYPE_H_

#include "TObjectTree.h"
#include "TStoreProperty.h"

#include <qtstream.h>
#include <qpixmap.h>
class TLayoutWindow;


enum TObjectType { otWidget, otLayout, otObject };




TStoreType* createTypeQObject(TStoreType*, TLayoutWindow *);
QPixmap *pixmapQObject();
bool isCreatableQObject();
bool isBaseClassQObject();




/*!
  \class TStoreType TStoreType.h
  \brief The TStoreType provides the dynamic functionality
  for a QObject to be added to the component library for MAWC.
  */
class TStoreType: public TObjectTree {
  Q_OBJECT
public:

  TStoreType(TStoreType *parent, TLayoutWindow *);
  virtual ~TStoreType();

  virtual QString storeTypeName(void);
  virtual QString headerFile(void);
  virtual TObjectType type(void);

  TStoreProperty *property(QString);
  virtual QString nextName(QObject*, QString);

  virtual void writeHFile(QTextStream &os, QString);
  virtual void writeCFileConstructor(QTextStream &os, QString, QString);
  virtual void writeCFileProperties(QTextStream &os, QString);
  virtual void writeCFileData(QTextStream &os,  QString);
  virtual void writeLayout(QTextStream &os, int);
  virtual void readLayoutItem(QTextStream &os, QString);

  virtual void copyDetails(TStoreType *);

  TStorePropertyList *getProperties(void);
  TSignalList *getSignals(void);
  TSlotList *getSlots(void);

  virtual bool isCreatable();
  virtual bool isVisible();
  virtual bool canItHaveChildren();

  virtual void propertyChanged(const char *, const char *, const char *);

  virtual void postLayoutLoad();



  TStoreType *parent(void) { return (TStoreType*)TObjectTree::parent();};
  TStoreType *next(bool r=TRUE) { return (TStoreType*)TObjectTree::next(r);};
  TStoreType *prev(bool r=TRUE) { return (TStoreType*)TObjectTree::prev(r);};
  TStoreType *nextSibling() { return (TStoreType*)TObjectTree::nextSibling();};
  TStoreType *prevSibling() { return (TStoreType*)TObjectTree::prevSibling();};
  TStoreType *root(void) { return (TStoreType*)TObjectTree::root();};
  TStoreType *firstChild(void) { return (TStoreType*)TObjectTree::firstChild();};
  TStoreType *lastChild(void) { return (TStoreType*)TObjectTree::lastChild();};

  TStoreType *find(const QObject *o) { return (TStoreType*)TObjectTree::find(o);};
  TStoreType *findByObjName(const QString str) { 
    return (TStoreType*)TObjectTree::findByObjName(str);
  };
  TStoreType *findByValidName(const QString str) { 
    return (TStoreType*)TObjectTree::findByValidName(str);
  };
  TStoreType *find(TStoreType *o, bool r=TRUE) { 
    return (TStoreType*)TObjectTree::find(o, r);
  };
  TStoreType *child(uint i) { return (TStoreType*)TObjectTree::child(i);};

  TLayoutWindow *layoutWindow() { return fLayoutWindow; }; 
protected:

  bool QObjectSetNameFunc(QString AValue);
  QString QObjectGetNameFunc();
  bool QObjectSetVariableFunc(QString AValue);
  QString QObjectGetVariableFunc();
  
  void addProperties();
  void addSignals();

  TStorePropertyList fProperties;
  TStoreType *fParent;
  TSignalList fSignalList;
  TSlotList fSlotList;

  TLayoutWindow *fLayoutWindow;
};


#include "TLayoutWindow.h"
#endif /* _TSTORETYPE_H_ */
