#include "TStoreProperty.h"
#include "TLayoutWindow.h"
#include "TObjectTree.h"
#include "TPaletteDialog.h"
#include "TFileIO.h"
#include "TStoreTypeQWidget.h"

#include <qpixmap.h>
#include <qfile.h>
#include <qdstream.h>
#include <qfiledlg.h>
#include <qobjcoll.h>
#include <qapp.h>

#include <kcolordlg.h>
#include <kfontdialog.h>
#include <kapp.h>
#include <kmsgbox.h>

#include <assert.h>
#include <stdlib.h>
#include <dlfcn.h>




TStoreType *createTypeQWidget(TStoreType *parent, TLayoutWindow *lw) {
  return (new TStoreTypeQWidget(parent, lw));
}

QPixmap *pixmapQWidget() {
  return pixmapQObject();
}

bool isCreatableQWidget() {
  return FALSE;
}

bool isBaseClassQWidget() {
  return TRUE;
}

TStoreTypeQWidget::TStoreTypeQWidget(TStoreType *par, TLayoutWindow *lw) : TStoreType(par, lw) {
	QWidget *w;
	
	addProperties();
  
	if (object())
		delete object();
	
	if (parent()) {
		QString str = nextName(parent()->object(), name());
		
		w = new QWidget((QWidget*)parent()->object(), str);
	}
	else {
		w = new QWidget(lw, "Widget1");
	}	  
	object(w);
}


TStoreTypeQWidget::~TStoreTypeQWidget() {
}


bool TStoreTypeQWidget::isCreatable() {
  return FALSE;
}

bool TStoreTypeQWidget::isVisible() {
  return FALSE;
}

bool TStoreTypeQWidget::canItHaveChildren() {
  return TRUE;
}


void TStoreTypeQWidget::addProperties() {
  TStoreProperty *se=NULL;
  
  se = new TStoreProperty("Caption", ptText,
						  SETFUNC(&QWidgetSetCaptionFunc),
						  GETFUNC(&QWidgetGetCaptionFunc), 
						  0,
						  0, FALSE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("X", ptText,
						  SETFUNC(&QWidgetSetXFunc),
						  GETFUNC(&QWidgetGetXFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Y", ptText,
						  SETFUNC(&QWidgetSetYFunc),
						  GETFUNC(&QWidgetGetYFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Width", ptText,
						  SETFUNC(&QWidgetSetWidthFunc),
						  GETFUNC(&QWidgetGetWidthFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Height", ptText,
						  SETFUNC(&QWidgetSetHeightFunc),
						  GETFUNC(&QWidgetGetHeightFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("MinWidth", ptText,
						  SETFUNC(&QWidgetSetMinWidthFunc),
						  GETFUNC(&QWidgetGetMinWidthFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("MinHeight", ptText,
						  SETFUNC(&QWidgetSetMinHeightFunc),
						  GETFUNC(&QWidgetGetMinHeightFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("MaxWidth", ptText,
						  SETFUNC(&QWidgetSetMaxWidthFunc),
						  GETFUNC(&QWidgetGetMaxWidthFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("MaxHeight", ptText,
						  SETFUNC(&QWidgetSetMaxHeightFunc),
						  GETFUNC(&QWidgetGetMaxHeightFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Size Increment X", ptText,
						  SETFUNC(&QWidgetSetXIncrementFunc),
						  GETFUNC(&QWidgetGetXIncrementFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Size Increment Y", ptText,
						  SETFUNC(&QWidgetSetYIncrementFunc),
						  GETFUNC(&QWidgetGetYIncrementFunc), 
						  0,
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Background Pixmap", ptButton,
						  SETFUNC(&QWidgetSetBkgPixmapFunc),
						  GETFUNC(&QWidgetGetBkgPixmapFunc),
						  0,
						  ACTIVEFUNC(&QWidgetActivateBkgPixmapFunc), TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Font", ptButton,
						  SETFUNC(&QWidgetSetFontFunc),
						  GETFUNC(&QWidgetGetFontFunc),
						  0,
						  ACTIVEFUNC(&QWidgetActivateFontFunc), TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Palette", ptButton,
						  SETFUNC(&QWidgetSetPaletteFunc),
						  GETFUNC(&QWidgetGetPaletteFunc),
						  0,
						  ACTIVEFUNC(&QWidgetActivatePaletteFunc), TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Mouse Tracking", ptList,
						  SETFUNC(&QWidgetSetMouseTrackingFunc),
						  GETFUNC(&QWidgetGetMouseTrackingFunc),
						  INITFUNC(&QWidgetInitMouseTrackingFunc),
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
}




void TStoreTypeQWidget::addSlots() {
  fSlotList.inSort(new TSlot("setEnabled", "bool", spPublic, TRUE));
  fSlotList.inSort(new TSlot("setMouseTracking", "bool"));
  fSlotList.inSort(new TSlot("setUpdatesEnabled", "bool"));
  fSlotList.inSort(new TSlot("update", ""));
  fSlotList.inSort(new TSlot("update", "int, int, int, int"));
  fSlotList.inSort(new TSlot("update", "const QRect &"));
  fSlotList.inSort(new TSlot("repaint", "bool"));
  fSlotList.inSort(new TSlot("repaint", "int, int, int, int, bool"));
  fSlotList.inSort(new TSlot("repaint", "const QRect &, bool"));
  fSlotList.inSort(new TSlot("show", "", spPublic, TRUE));
  fSlotList.inSort(new TSlot("hide", "", spPublic, TRUE));
  fSlotList.inSort(new TSlot("iconify", ""));
}




QString TStoreTypeQWidget::storeTypeName() {
  return "QWidget";
}



QString TStoreTypeQWidget::headerFile() {
  return "qwidget.h";
}



TObjectType TStoreTypeQWidget::type() {
  return otWidget;
}



void TStoreTypeQWidget::writeHFile(QTextStream &os, QString var) {
  os << "\tQWidget *" << var << ";" << endl;
}




void TStoreTypeQWidget::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QWidget ( ";
  os << parent;
  os << name() << ");" << endl;
}



void TStoreTypeQWidget::writeCFileProperties(QTextStream &os, QString var) {
  TStoreType::writeCFileProperties(os, var);

  QString s;
  if (var!="")
    s = var + "->";

  // Caption
  os << "\t" << s << "setCaption( \"" << QWidgetGetCaptionFunc() << "\" );" << endl;

  // Geometry
  os << "\t" << s << "setGeometry( "
     << QWidgetGetXFunc() << ", " << QWidgetGetYFunc()
     << ", " << QWidgetGetWidthFunc() << ", "
     << QWidgetGetHeightFunc() << " );" << endl;
  
  // Min Size
  os << "\t" << s << "setMinimumSize( "
     << QWidgetGetMinWidthFunc() << ", " << QWidgetGetMinHeightFunc()
     << " );" << endl;
  
  // Max Size
  os << "\t" << s << "setMaximumSize( "
     << QWidgetGetMaxWidthFunc() << ", " <<
    QWidgetGetMaxHeightFunc() << " );" << endl;

  // Font

  QFont f = ((QWidget*)object())->font();
  if (f != *KApplication::font()) {
    os << "\t" << s << "setFont( QFont( \"" 
       << f.family() << "\", " 
       << f.pointSize() << ", " 
       << f.weight() << ", " 
       << f.italic() << "));" 
       << endl;
  }

  // Mouse Tracking
  QString track = ((QWidget*)object())->hasMouseTracking() ? "TRUE" : "FALSE";
  os << "\t" << s << "setMouseTracking( " << track << ");" << endl;

  
  if( ((QWidget*)object())->backgroundPixmap()) {
    os << "\tQPixmap " << var << "_bgPix;" << endl;
    os << "\t" << var << "_bgPix.loadFromData(" << var << "_backgroundPixmap, "
       << var << "_backgroundPixmapSize);" << endl;
    os << "\t" << s << "setBackgroundPixmap( " << var << "_bgPix);" << endl;
  }
  
  // Size Increment
  os << "\t" << s << "setSizeIncrement( "
     << QWidgetGetXIncrementFunc() << ", " 
     << QWidgetGetYIncrementFunc() << " );" << endl;
  
  // Background Colour
  QPalette palette = ((QWidget*)object())->palette();
  if( palette != *QApplication::palette() ) {
    os << "\tQPalette " << var << "_palette;" << endl;
    os << "\tQByteArray " << var << "_paletteArray ( " << var << "_paletteSize );" << endl;
    os << "\t" << var << "_paletteArray.setRawData ( (const char *) "
       << var << "_paletteData, " << var << "_paletteSize);" << endl;
    os << "\tQDataStream " << var << "_paletteStream ( " 
       << var << "_paletteArray, IO_ReadOnly);" << endl; 
    os << "\t" << var << "_paletteStream >> " << var << "_palette;" << endl;
    os << "\t" << var << "_paletteArray.resetRawData( (const char *) " 
       << var << "_paletteArray, " << var << "_paletteSize);" << endl;
    os << "\t" << s << "setPalette ( " << var << "_palette.copy() );" << endl; 
  }
}





void TStoreTypeQWidget::writeCFileData(QTextStream &data, QString var) {
  TStoreType::writeCFileData(data, var);

  writeCFileBackgroundPixmap(data, var);  
  writeCFilePalette(data, var);
}



void TStoreTypeQWidget::writeCFilePalette(QTextStream &data, QString var) {
  QPalette palette = ((QWidget*)object())->palette();
  if( palette != *QApplication::palette() ) {
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);
    QPalette pal = ((QWidget*)object())->palette();
    
    dstream << pal;
    
    data << "#include <qfile.h>" << endl;
    data << "#include <qdstream.h>" << endl;
    data << "#include <qarray.h>" << endl;
    data << "static const uint " << var << "_paletteSize = " << array.size() << " ;" << endl;
    data << "static const uchar " << var << "_paletteData []={";
    
    for (uint i=0 ; i<array.size() ; i++) {
      if (0==(i%16))
	data << "\n\t";
      data << (uint)((uchar)array[i]) << " , ";
    }
    data << "};" << endl;
  }
}





void TStoreTypeQWidget::writeCFileBackgroundPixmap(QTextStream &data, QString var) {
  if (((QWidget*)object())->backgroundPixmap()) {
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);
    QPixmap pix = *((QWidget*)object())->backgroundPixmap();
    QString str;
    
    dstream << pix;
    
    data << "#include <qpixmap.h>" << endl;
    data << "static const uint " << var << "_backgroundPixmapSize = " 
	 << array.size() << " ;" << endl;
    data << "static const uchar " << var << "_backgroundPixmap [] = {";
    
    for (uint i=0 ; i<array.size() ; i++) {
      if ((i%16)==0)
	data << endl << "  ";
      data << (uint)((uchar)array[i]) << " , ";
    }
    data << endl << "};" << endl;
  }
}










void TStoreTypeQWidget::writeLayout(QTextStream &os, int tabs) {
  TStoreType::writeLayout(os, tabs);


  QWidget *widget = (QWidget*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TFileIO::writeLayoutString(os, tabstr, "Caption", widget->caption() );
  TFileIO::writeLayoutInt(os, tabstr, "X", widget->x() );
  TFileIO::writeLayoutInt(os, tabstr, "Y", widget->y() );
  TFileIO::writeLayoutInt(os, tabstr, "Width", widget->width() );
  TFileIO::writeLayoutInt(os, tabstr, "Height", widget->height() );
  TFileIO::writeLayoutInt(os, tabstr, "Minimum Width", widget->minimumSize().width() );
  TFileIO::writeLayoutInt(os, tabstr, "Minimum Height", widget->minimumSize().height() );
  TFileIO::writeLayoutInt(os, tabstr, "Maximum Width", widget->maximumSize().width() );
  TFileIO::writeLayoutInt(os, tabstr, "Maximum Height", widget->maximumSize().height() );
  TFileIO::writeLayoutInt(os, tabstr, "Size Increment X", widget->sizeIncrement().width() );
  TFileIO::writeLayoutInt(os, tabstr, "Size Increment Y", widget->sizeIncrement().height() );
  if (widget->backgroundPixmap()) {
    QPixmap pix = *widget->backgroundPixmap();
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);
    dstream << pix;
    
    TFileIO::writeLayoutData(os, tabstr, "Background Pixmap", array );
  }

  QFont f = widget->font();
  if (f != *KApplication::font()) {
    os << tabstr << "Font { \"" << TFileIO::delimitString(f.family()) << "\" " 
       << f.pointSize() << " " << f.weight() << " " << f.italic() << " }" << endl;
  }

  if( widget->palette() != *QApplication::palette() ) {
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);

    dstream << widget->palette();
    TFileIO::writeLayoutData(os, tabstr, "Palette", array );
  }
  TFileIO::writeLayoutBool(os, tabstr, "Mouse Tracking", widget->hasMouseTracking() );
}


void TStoreTypeQWidget::readLayoutItem(QTextStream &is, QString propName) {
  QWidget *widget = (QWidget*) object();

  if (propName=="Caption")
    widget->setCaption(TFileIO::readLayoutString(is));
  else if (propName=="X")
    widget->move(TFileIO::readLayoutInt(is), widget->y());
  else if (propName=="Y")
    widget->move(widget->x(), TFileIO::readLayoutInt(is));
  else if (propName=="Width")
    widget->resize(TFileIO::readLayoutInt(is), widget->height());
  else if (propName=="Height")
    widget->resize(widget->width(), TFileIO::readLayoutInt(is));
  else if (propName=="Minimum Width")
    widget->setMinimumSize(TFileIO::readLayoutInt(is), widget->minimumSize().height());
  else if (propName=="Minimum Height")
    widget->setMinimumSize(widget->minimumSize().width(), TFileIO::readLayoutInt(is));
  else if (propName=="Maximum Width")
    widget->setMaximumSize(TFileIO::readLayoutInt(is), widget->maximumSize().height());
  else if (propName=="Maximum Height")
    widget->setMaximumSize(widget->maximumSize().width(), TFileIO::readLayoutInt(is));
  else if (propName=="Size Increment X")
    widget->setSizeIncrement(TFileIO::readLayoutInt(is), widget->sizeIncrement().height());
  else if (propName=="Size Increment Y")
    widget->setSizeIncrement(widget->sizeIncrement().width(), TFileIO::readLayoutInt(is));
  else if (propName=="Mouse Tracking")
    widget->setMouseTracking(TFileIO::readLayoutBool(is));
  else if (propName=="Background Pixmap") {
    QPixmap pix;
    QByteArray array = TFileIO::readLayoutData(is);
    
    pix.loadFromData( (uchar *)array.data(), array.size());
    widget->setBackgroundPixmap(pix);
  }
  else if (propName=="Palette") {
    QPalette pal;
    QByteArray array = TFileIO::readLayoutData(is);
    
    QDataStream ds(array, IO_ReadOnly);
    ds >> pal;
    widget->setPalette(pal);
  }
  else if (propName=="Font") {
    QString fontName = TFileIO::readDelimitedString(is);
    fontName = TFileIO::undelimitString(fontName);
    int size, weight, italic;
    is >> size >> weight >> italic;
    
    QFont font(fontName, size, weight, italic);

    widget->setFont(font);
    TFileIO::readLayoutUntil(is, '}');
  }
  else
    TStoreType::readLayoutItem(is, propName);
}




void TStoreTypeQWidget::copyDetails(TStoreType *oldObj) {
  QWidget *n = (QWidget *)object();
  QWidget *o = (QWidget *)oldObj->object();
  
  TStoreType::copyDetails(oldObj);
  
  n->setCaption(o->caption());
  n->setGeometry(QRect(o->pos(), o->size()));
  n->setMinimumSize(o->minimumSize());
  n->setMaximumSize(o->maximumSize());
  n->setBackgroundColor(o->backgroundColor());
  n->setSizeIncrement(o->sizeIncrement());

  if (o->backgroundPixmap()) {
    QPixmap pix = *o->backgroundPixmap();
    pix.detach();
    n->setBackgroundPixmap(pix);
    o->setBackgroundPixmap(pix);
  }
  n->setPalette(o->palette());
  n->setFont(o->font());
  n->setMouseTracking(o->hasMouseTracking());
}







bool TStoreTypeQWidget::QWidgetSetXFunc(QString AValue) {
  int lX;
  
  lX = AValue.toInt(NULL);
  ((QWidget*)object())->move(lX, ((QWidget*)object())->y());
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetXFunc() {
  int lX;
  QString s;
  lX = ((QWidget*)object())->x();
  
  return (s.setNum(lX));
}


bool TStoreTypeQWidget::QWidgetSetYFunc(QString AValue) {
  int lY;
  
  lY = AValue.toInt(NULL);
  ((QWidget*)object())->move(((QWidget*)object())->x(), lY);
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetYFunc() {
  int lY;
  QString s;
  lY = ((QWidget*)object())->y();
  
  return (s.setNum(lY));
}


bool TStoreTypeQWidget::QWidgetSetWidthFunc(QString AValue) {
  int lWidth;
  
  lWidth = AValue.toInt(NULL);
  ((QWidget*)object())->resize(lWidth, ((QWidget*)object())->height());
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetWidthFunc() {
  int lWidth;
  QString s;
  lWidth = ((QWidget*)object())->width();
  
  return (s.setNum(lWidth));
}


bool TStoreTypeQWidget::QWidgetSetHeightFunc(QString AValue) {
  int lHeight;
  
  lHeight = AValue.toInt(NULL);
  ((QWidget*)object())->resize(((QWidget*)object())->width(), lHeight);
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetHeightFunc() {
  int lHeight;
  QString s;
  lHeight = ((QWidget*)object())->height();
  
  return (s.setNum(lHeight));
}


bool TStoreTypeQWidget::QWidgetSetMinWidthFunc(QString AValue) {
  int lWidth;
  QWidget *wid = (QWidget*)object();
  
  lWidth = AValue.toInt(NULL);
  wid->setMinimumSize(lWidth, wid->minimumSize().height());
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetMinWidthFunc() {
  int lWidth;
  QString s;
  
  lWidth = ((QWidget*)object())->minimumSize().width();
  
  return (s.setNum(lWidth));
}


bool TStoreTypeQWidget::QWidgetSetMinHeightFunc(QString AValue) {
  int lHeight;
  QWidget *wid = (QWidget*)object();

  lHeight = AValue.toInt(NULL);
  wid->setMinimumSize( wid->minimumSize().width(), lHeight);
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetMinHeightFunc() {
  int lHeight;
  QString s;
  lHeight = ((QWidget*)object())->minimumSize().height();
  
  return (s.setNum(lHeight));
}


bool TStoreTypeQWidget::QWidgetSetMaxWidthFunc(QString AValue) {
  int lWidth;
  QWidget *wid = (QWidget*)object();

  lWidth = AValue.toInt(NULL);
  wid->setMaximumSize(lWidth, wid->maximumSize().height());
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetMaxWidthFunc() {
  int lWidth;
  QString s;
  lWidth = ((QWidget*)object())->maximumSize().width();
  
  return (s.setNum(lWidth));
}


bool TStoreTypeQWidget::QWidgetSetMaxHeightFunc(QString AValue) {
  int lHeight;
  QWidget *wid = (QWidget*)object();
  
  lHeight = AValue.toInt(NULL);
  wid->setMaximumSize( wid->maximumSize().width(), lHeight);
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetMaxHeightFunc() {
  int lHeight;
  QString s;
  lHeight = ((QWidget*)object())->maximumSize().height();
  
  return (s.setNum(lHeight));
}



bool TStoreTypeQWidget::QWidgetSetXIncrementFunc(QString AValue) {
  int inc = AValue.toInt();
  QWidget *wid = (QWidget*)object();
  wid->setSizeIncrement( inc, wid->sizeIncrement().height() );
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetXIncrementFunc() {
  QString s;
  int inc = ((QWidget*)object())->sizeIncrement().width();
  return (s.setNum(inc));
}



bool TStoreTypeQWidget::QWidgetSetYIncrementFunc(QString AValue) {
  int inc = AValue.toInt();
  QWidget *wid = (QWidget*)object();
  wid->setSizeIncrement( wid->sizeIncrement().width() , inc);
  return TRUE;
}
QString TStoreTypeQWidget::QWidgetGetYIncrementFunc() {
  QString s;
  int inc = ((QWidget*)object())->sizeIncrement().height();
  return (s.setNum(inc));
}



bool TStoreTypeQWidget::QWidgetSetBkgPixmapFunc(QString str) {
	if (QT_VERSION == 131 && object()->inherits("QButton")) {
		KMsgBox::message(NULL, "Pixmap Error", "Due to a bug in QT 1.31 you can not set the Background Pixmap for QButtons");
		return FALSE;
	}


	QPixmap pix(str);
	if (!pix.isNull()) {
		((QWidget*)object())->setBackgroundPixmap(pix);
		return TRUE;
	}
	else
		return FALSE;
}

QString TStoreTypeQWidget::QWidgetGetBkgPixmapFunc() {
  return ("QPixmap");
}

void TStoreTypeQWidget::QWidgetActivateBkgPixmapFunc() {
	if (QT_VERSION == 131 && object()->inherits("QButton")) {
		KMsgBox::message(NULL, "Pixmap Error", "Due to a bug in QT 1.31 you can not set the Background Pixmap for QButtons");
		return;
	}
	QString fileName = QFileDialog::getOpenFileName();
	if ( !fileName.isNull() ) {                 // got a file name
		QWidgetSetBkgPixmapFunc(fileName);
	}
}


bool TStoreTypeQWidget::QWidgetSetCaptionFunc(QString aValue) {
  ((QWidget*)object())->setCaption(aValue);
  return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetCaptionFunc() {
  return (((QWidget*)object())->caption());
}




bool TStoreTypeQWidget::QWidgetSetPaletteFunc(QString) {
	return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetPaletteFunc() {
  return "palette";
}

void TStoreTypeQWidget::QWidgetActivatePaletteFunc() {
  TPaletteDialog *pd = new TPaletteDialog();
  QWidget *wid = (QWidget*) object();
  
  pd->palette( wid->palette() );
  if (pd->exec())
    wid->setPalette(pd->palette());
  delete pd;
}















bool TStoreTypeQWidget::QWidgetSetFontFunc(QString) {
	return TRUE;
}

QString TStoreTypeQWidget::QWidgetGetFontFunc() {
  return "Font";
}

void TStoreTypeQWidget::QWidgetActivateFontFunc() {
  QWidget *wid = (QWidget*)object();

  QFont f = wid->font();

  if (KFontDialog::getFont(f))
    wid->setFont(f);
  wid->repaint(TRUE);
}



bool TStoreTypeQWidget::QWidgetSetMouseTrackingFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  QWidget *wid = (QWidget*)object();

  wid->setMouseTracking(TRUE);
  wid->setMouseTracking(FALSE);

  wid->setMouseTracking(val);
  return (TRUE);
}

QString TStoreTypeQWidget::QWidgetGetMouseTrackingFunc() {
  if (((QWidget*)object())->hasMouseTracking())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQWidget::QWidgetInitMouseTrackingFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an MouseTracking property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}





