/*
** $Source: /usr/local/share/cvs/frugal/mawc/mawc/TToolWindow.cpp,v $
** $Author: frugal $
** $Date: 1998/01/13 18:48:43 $
** $Revision: 1.1.1.1 $
** $State: Exp $
** $Log: TToolWindow.cpp,v $
** Revision 1.1.1.1  1998/01/13 18:48:43  frugal
**
** Revision 1.2  1998/01/11 13:01:46  frugal
** Enxured that certain variables were always initialised
**
** Revision 1.1.1.1  1998/01/09 12:01:32  frugal
** MAWC initial import
**
** Revision 1.2  1997/07/09 19:08:50  frugal
** - Renamed TBoundWindow to TLayoutWindow
**
** Revision 1.1  1997/06/01 13:53:35  frugal
** Initial revision
**
**
** All source code written by Frugal (frugal@wardrobe.demon.co.uk)
*/

#include <ostream.h>
#include <qpixmap.h>
#include <qobjcoll.h>
#include <qtooltip.h>

#include <kapp.h>
#include <kconfig.h>

#include "TToolWindow.h"
#include "TLayoutWindow.h"

#include "pics/AlignTop.xpm"
#include "pics/AlignLeft.xpm"
#include "pics/AlignRight.xpm"
#include "pics/AlignBottom.xpm"
#include "pics/AlignWidths.xpm"
#include "pics/AlignHeights.xpm"
#include "pics/AlignVCentre.xpm"
#include "pics/AlignHCentre.xpm"
#include "pics/AlignVSpread.xpm"
#include "pics/AlignHSpread.xpm"
#include "pics/PosHCentre.xpm"
#include "pics/PosVCentre.xpm"

#define Max(a,b) ((a)>(b) ? (a) : (b))

TToolWindow::TToolWindow(QWidget *parent, const char *name):
QWidget(parent, name) {
  QPixmap *pix;

  setCaption("Alignment Palette");

  btnAlignTop = new QPushButton(this, "Align Top");
  pix = new QPixmap((const char**)AlignTop_xpm);
  btnAlignTop->setPixmap(*pix);
  btnAlignTop->resize(btnAlignTop->sizeHint());
  btnAlignTop->move(32, 0);
  btnAlignTop->show();
  connect(btnAlignTop, SIGNAL(clicked()), SLOT(setAlignTop()));
  QToolTip::add(btnAlignTop, "Align tops of Widgets");
  
  btnAlignLeft = new QPushButton(this, "Align Left");
  pix = new QPixmap((const char**)AlignLeft_xpm);
  btnAlignLeft->setPixmap(*pix);
  btnAlignLeft->resize(btnAlignLeft->sizeHint());
  btnAlignLeft->move(0, 32);
  btnAlignLeft->show();
  connect(btnAlignLeft, SIGNAL(clicked()), SLOT(setAlignLeft()));
  QToolTip::add(btnAlignLeft, "Align left edges of Widgets");

  btnAlignRight = new QPushButton(this, "Align Right");
  pix = new QPixmap((const char**)AlignRight_xpm);
  btnAlignRight->setPixmap(*pix);
  btnAlignRight->resize(btnAlignRight->sizeHint());
  btnAlignRight->move(64, 32);
  btnAlignRight->show();
  connect(btnAlignRight, SIGNAL(clicked()), SLOT(setAlignRight()));
  QToolTip::add(btnAlignRight, "Align right edges of Widgets");

  btnAlignBottom = new QPushButton(this, "Align Bottom");
  pix = new QPixmap((const char**)AlignBottom_xpm);
  btnAlignBottom->setPixmap(*pix);
  btnAlignBottom->resize(btnAlignBottom->sizeHint());
  btnAlignBottom->move(32, 64);
  btnAlignBottom->show();
  connect(btnAlignBottom, SIGNAL(clicked()), SLOT(setAlignBottom()));
  QToolTip::add(btnAlignBottom, "Align bottom edge of Widgets");


  btnAlignWidths = new QPushButton(this, "Align Widths");
  pix = new QPixmap((const char**)AlignWidths_xpm);
  btnAlignWidths->setPixmap(*pix);
  btnAlignWidths->resize(btnAlignWidths->sizeHint());
  btnAlignWidths->move(96, 16);
  btnAlignWidths->show();
  connect(btnAlignWidths, SIGNAL(clicked()), SLOT(setAlignWidths()));
  QToolTip::add(btnAlignWidths, "Align widths of Widgets");

  btnAlignHeights = new QPushButton(this, "Align Heights");
  pix = new QPixmap((const char**)AlignHeights_xpm);
  btnAlignHeights->setPixmap(*pix);
  btnAlignHeights->resize(btnAlignHeights->sizeHint());
  btnAlignHeights->move(96, 48);
  btnAlignHeights->show();
  connect(btnAlignHeights, SIGNAL(clicked()), SLOT(setAlignHeights()));
  QToolTip::add(btnAlignHeights, "Align heights of Widgets");

  

  btnAlignHSpread = new QPushButton(this, "Align HSpread");
  pix = new QPixmap((const char**)AlignHSpread_xpm);
  btnAlignHSpread->setPixmap(*pix);
  btnAlignHSpread->resize(btnAlignHSpread->sizeHint());
  btnAlignHSpread->move(128, 16);
  btnAlignHSpread->show();
  connect(btnAlignHSpread, SIGNAL(clicked()), SLOT(setAlignHSpread()));
  QToolTip::add(btnAlignHSpread, "Evenly spread the widgets horizontally");

  btnAlignVSpread = new QPushButton(this, "Align VSpread");
  pix = new QPixmap((const char**)AlignVSpread_xpm);
  btnAlignVSpread->setPixmap(*pix);
  btnAlignVSpread->resize(btnAlignVSpread->sizeHint());
  btnAlignVSpread->move(128, 48);
  btnAlignVSpread->show();
  connect(btnAlignVSpread, SIGNAL(clicked()), SLOT(setAlignVSpread()));
  QToolTip::add(btnAlignVSpread, "Evenly spread the widgets vertically");

  

  btnAlignHCentres = new QPushButton(this, "Align HCentres");
  pix = new QPixmap((const char**)AlignHCentre_xpm);
  btnAlignHCentres->setPixmap(*pix);
  btnAlignHCentres->resize(btnAlignHCentres->sizeHint());
  btnAlignHCentres->move(160, 16);
  btnAlignHCentres->show();
  connect(btnAlignHCentres, SIGNAL(clicked()), SLOT(setAlignHCentres()));
  QToolTip::add(btnAlignHCentres, "Horizontally align the centres of the widgets");

  btnAlignVCentres = new QPushButton(this, "Align VCentres");
  pix = new QPixmap((const char**)AlignVCentre_xpm);
  btnAlignVCentres->setPixmap(*pix);
  btnAlignVCentres->resize(btnAlignVCentres->sizeHint());
  btnAlignVCentres->move(160, 48);
  btnAlignVCentres->show();
  connect(btnAlignVCentres, SIGNAL(clicked()), SLOT(setAlignVCentres()));
  QToolTip::add(btnAlignVCentres, "Vertically align the centres of the widgets");

  

  btnPosHCentre = new QPushButton(this, "Pos HCentre");
  pix = new QPixmap((const char**)PosHCentre_xpm);
  btnPosHCentre->setPixmap(*pix);
  btnPosHCentre->resize(btnPosHCentre->sizeHint());
  btnPosHCentre->move(192, 16);
  btnPosHCentre->show();
  connect(btnPosHCentre, SIGNAL(clicked()), SLOT(setPosHCentre()));
  QToolTip::add(btnPosHCentre, "Position widgets horizontally in the centre of the parent");

  btnPosVCentre = new QPushButton(this, "Pos VCentre");
  pix = new QPixmap((const char**)PosVCentre_xpm);
  btnPosVCentre->setPixmap(*pix);
  btnPosVCentre->resize(btnPosVCentre->sizeHint());
  btnPosVCentre->move(192, 48);
  btnPosVCentre->show();
  connect(btnPosVCentre, SIGNAL(clicked()), SLOT(setPosVCentre()));
  QToolTip::add(btnPosVCentre, "Position widgets vertically in the centre of the parent");

  adjustSize();

  cout << "Load the Tool Window geometry" << endl;
  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup( "WindosPos" );
  if (config) {
    QString str;
    str = config->readEntry(className());
    if (!str.isEmpty()) {
      int a,b,c,d;
      if (4 == sscanf(str.data(), "%d %d %d %d", &a, &b, &c, &d))
	setGeometry(a,b,c,d);
    }
  }
};




TToolWindow::~TToolWindow() {
  cout << "Delete the Tool Window" << endl;
  if (KApplication::APPCONFIG_READWRITE==
      KApplication::getKApplication()->getConfigState()) {

    KConfig *config = KApplication::getKApplication()->getConfig();
    config->setGroup( "WindosPos" );
    
    QString str;
    str.sprintf("%d %d %d %d", x(), y(), width(), height());
    config->writeEntry(className(), str);
    config->sync();
  }
}



void TToolWindow::setLayoutWindow(TLayoutWindow *b) {
  if (b != fLayoutWindow) {
    fLayoutWindow = b;
  }
};


void TToolWindow::setAlignTop(void) {
  int top=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	top = w->y();
      }
      else
	w->move(w->x(), top);
    }
  }
}




void TToolWindow::setAlignLeft(void) {
  int left=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	left = w->x();
      }
      else
	w->move(left, w->y());
    }
  }
}

void TToolWindow::setAlignRight(void) {
  int right=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	right = w->x() + w->width();
      }
      else
	w->move((right - w->width())+1, w->y());
    }
  }
};



void TToolWindow::setAlignBottom(void) {
  int bottom=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	bottom = w->y() + w->height();
      }
      else
	w->move(w->x(), ( bottom - w->height() ) + 1 );
    }
  }
};



void TToolWindow::setAlignWidths(void) {
  int width=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	width = w->width();
      }
      else
	w->resize(width, w->height());
    }
  }
};



void TToolWindow::setAlignHeights(void) {
  int height=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	height = w->height();
      }
      else
	w->resize(w->width(), height);
    }
  }
};



void TToolWindow::setAlignHCentres(void) {
  int centre=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	centre = w->x() + (w->width()/2);
      }
      else
	w->move(centre - w->width()/2, w->y());
    }
  }
};





void TToolWindow::setAlignVCentres(void) {
  int centre=0;
  bool set=FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	set = TRUE;
	centre = w->y() + (w->height()/2);
      }
      else
	w->move( w->x(), centre - w->height()/2 );
    }
  }
};



typedef QListIterator<QWidget> TWidgetTopListIterator;
class TWidgetTopList: public QList<QWidget> {
public:
private:
  int compareItems(GCI s1, GCI s2) {
    QWidget *w1 = (QWidget*)s1;
    QWidget *w2 = (QWidget*)s2;

    return (w1->x() - w2->x());
  }
};

void TToolWindow::setAlignVSpread(void) {
  int top=0, bottom=0, totalheight=0, totalspace=0;
  int cumulativegap=0, cumulativeheight=0, i=0;
  TWidgetTopList sortedlist;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  
  for ( ; it.current() ; ++it)
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      bottom = Max(bottom, w->y() + w->height());
      totalheight += w->height();
      sortedlist.inSort(w);
    }

  
  TWidgetTopListIterator it2(sortedlist);
  top = it2.current()->y();
  totalspace = (bottom - top) - totalheight;
  for ( i=0 ; it2.current() ; ++it2, i++) {
    cumulativegap = (i * totalspace) / (it2.count()-1);

    int ny = top + cumulativeheight + cumulativegap;
    it2.current()->move(it2.current()->x(), ny);
    cumulativeheight += it2.current()->height();
  }
};



typedef QListIterator<QWidget> TWidgetLeftListIterator;
class TWidgetLeftList: public QList<QWidget> {
public:
private:
  int compareItems(GCI s1, GCI s2) {
    QWidget *w1 = (QWidget*)s1;
    QWidget *w2 = (QWidget*)s2;

    return (w1->y() - w2->y());
  }
};

void TToolWindow::setAlignHSpread(void) {
  int left=0, right=0, totalwidth=0, totalspace=0;
  int cumulativegap=0, cumulativewidth=0, i=0;
  TWidgetTopList sortedlist;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  if (it.count()<2)
    return;
  
  for ( ; it.current() ; ++it)
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      right = Max(right, w->x() + w->width());
      totalwidth += w->width();
      sortedlist.inSort(w);
    }

  
  TWidgetTopListIterator it2(sortedlist);
  left = it2.current()->x();
  totalspace = (right - left) - totalwidth;
  for ( i=0 ; it2.current() ; ++it2, i++) {
    cumulativegap = (i * totalspace) / (it2.count()-1);

    int nx = left + cumulativewidth + cumulativegap;
    it2.current()->move(nx, it2.current()->y());
    cumulativewidth += it2.current()->width();
  }
};




QRect TToolWindow::calcBounds(void) {
  QRect bounds = QRect(0,0,0,0);
  bool set = FALSE;
  
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return bounds;
  }

  QObjectListIt it(fLayoutWindow->selectedList());
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      if (!set) {
	bounds = QRect(w->pos(), w->size());
	set = TRUE;
      }
      else {
	if (w->x() < bounds.left())
	  bounds.setLeft(w->x());
	if ((w->x()+w->width()) > bounds.right())
	  bounds.setRight(w->x() + w->width());
	if (w->y() < bounds.top())
	  bounds.setTop(w->y());
	if ((w->y()+w->height()) > bounds.bottom())
	  bounds.setBottom(w->y() + w->height());
      }
    }
  }
  return bounds;
}



void TToolWindow::setPosHCentre(void) {
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QRect bounds = calcBounds();
  int offsetx = (fLayoutWindow->width() - bounds.width())/2 - bounds.left();

  QObjectListIt it(fLayoutWindow->selectedList());
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      w->move(w->x()+offsetx, w->y());
    }
  }
};



void TToolWindow::setPosVCentre(void) {
  if (!fLayoutWindow) {
    cerr << "Not attached to an editing window" << endl;
    return;
  }

  QRect bounds = calcBounds();
  int offsety = (fLayoutWindow->height() - bounds.height())/2 - bounds.top();

  QObjectListIt it(fLayoutWindow->selectedList());
  for ( ; it.current() ; ++it) {
    if (it.current()->isWidgetType()) {
      QWidget *w = (QWidget*)it.current();
      w->move(w->x(), w->y()+offsety);
    }
  }
};



