#include "TStoreTypeQButton.h"
#include <TStoreProperty.h>
#include <TObjectTree.h>
#include <TFileIO.h>

#include <qbutton.h>
#include <qcombo.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledlg.h>

#include <dlfcn.h>
#include <assert.h>



TStoreType *createStoreTypeQButton(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQButton(parent, lw));
}




TStoreTypeQButton::TStoreTypeQButton(TStoreType *p, TLayoutWindow *lw) : TStoreTypeQWidget(p,lw) {
	initMetaObject();

  addProperties();

  fSignalList.inSort(new TSignal("pressed", ""));
  fSignalList.inSort(new TSignal("released", ""));
  fSignalList.inSort(new TSignal("clicked", ""));
  fSignalList.inSort(new TSignal("toggled", "bool"));

  fSlotList.inSort(new TSlot("animateClick", ""));

  if (object()) 
	  delete object();
  if (parent()) {
	  QString foo = nextName(parent()->object(), storeTypeName());
	  object(new QButton((QWidget*)parent()->object(), foo));
  }
  else 
	  object(new QButton(lw, "Button1"));
}

bool TStoreTypeQButton::isCreatable() {
  return TRUE;
}

bool TStoreTypeQButton::isVisible() {
  return TRUE;
}

bool TStoreTypeQButton::canItHaveChildren() {
  return FALSE;
}


void TStoreTypeQButton::addProperties() {
  TStoreProperty *sp = NULL;

  sp = new TStoreProperty("Text", ptText,
			  SETFUNC(&QButtonSetTextFunc),
			  GETFUNC(&QButtonGetTextFunc), 
			  0,
			  0, FALSE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("AutoResize", ptList,
			  SETFUNC(&QButtonSetAutoResizeFunc),
			  GETFUNC(&QButtonGetAutoResizeFunc),
			  INITFUNC(&QButtonInitAutoResizeFunc), 
			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("AutoRepeat", ptList,
			  SETFUNC(&QButtonSetAutoRepeatFunc),
			  GETFUNC(&QButtonGetAutoRepeatFunc),
			  INITFUNC(&QButtonInitAutoRepeatFunc), 
			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Pixmap", ptButton,
			  SETFUNC(&QButtonSetPixmapFunc),
			  GETFUNC(&QButtonGetPixmapFunc),
			  0,
			  ACTIVEFUNC(&QButtonActivatePixmapFunc), TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);
}







QString TStoreTypeQButton::storeTypeName() {
  return "QButton";
}




QString TStoreTypeQButton::headerFile() {
  return "qbutton.h";
}





void TStoreTypeQButton::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQButton *" << var << ";" << endl;
}



void TStoreTypeQButton::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QButton ( ";
  os << parent;
  os << ", \"" << object()->name() << "\");" << endl;
}



void TStoreTypeQButton::writeCFileProperties(QTextStream &os, QString var) {
  TStoreTypeQWidget::writeCFileProperties(os, var);
  
  QButton *but = (QButton*) object();
  os << "\t" << var << "->setText( \"" << but->text() << "\" );" << endl;

  QString s = but->autoResize() ? "TRUE" : "FALSE";
  os << "\t" << var << "->setAutoResize( " << s << " );" << endl;

  s = but->autoRepeat() ? "TRUE" : "FALSE";
  os << "\t" << var << "->setAutoRepeat( " << s << " );" << endl;

  if( but->pixmap()) {
    os << "\tQPixmap " << var << "_Pixmap;" << endl;
    os << "\t" << var << "_Pixmap.loadFromData(" << var << "_PixmapData, "
       << var << "_PixmapSize);" << endl;
    os << "\t" << var << "->setPixmap( " << var << "_Pixmap);" << endl;
  }


}



void TStoreTypeQButton::writeCFileData(QTextStream &data, QString var) {
  TStoreTypeQWidget::writeCFileData(data, var);

  if (((QButton*)object())->pixmap()) {
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);
    QPixmap pix = *((QButton*)object())->pixmap();
    QString str;
    
    dstream << pix;
    
    data << "#include <qpixmap.h>" << endl;
    data << "static const uint " << var << "_PixmapSize = " 
	 << array.size() << " ;" << endl;
    data << "static const uchar " << var << "_PixmapData [] = {";
    
    for (uint i=0 ; i<array.size() ; i++) {
      if ((i%16)==0)
	data << endl << "  ";
      data << (uint)((uchar)array[i]) << " , ";
    }
    data << endl << "};" << endl;
  }
}



void TStoreTypeQButton::writeLayout(QTextStream &os, int tabs) {
  QButton *button = (QButton*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQWidget::writeLayout(os, tabs);

  TFileIO::writeLayoutString(os, tabstr, "Text", button->text() );
  TFileIO::writeLayoutBool(os, tabstr, "Auto Resize", button->autoResize() );
  TFileIO::writeLayoutBool(os, tabstr, "Auto Repeat", button->autoRepeat() );

  if (button->pixmap()) {
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);
    QPixmap pix = *button->pixmap();
    dstream << pix;
    
    TFileIO::writeLayoutData(os, tabstr, "Pixmap", array );
  }
}


void TStoreTypeQButton::readLayoutItem(QTextStream &is, QString propName) {
  QButton *button = (QButton*) object();

  if (propName=="Text")
    button->setText(TFileIO::readLayoutString(is));
  else if (propName=="Auto Resize")
    button->setAutoResize(TFileIO::readLayoutBool(is));
  else if (propName=="Auto Repeat")
    button->setAutoRepeat(TFileIO::readLayoutBool(is));
  else if (propName=="Pixmap") {
    QPixmap pix;
    QByteArray array = TFileIO::readLayoutData(is);
    
    pix.loadFromData( (uchar *)array.data(), array.size());
    button->setPixmap(pix);
  }
  else
    TStoreTypeQWidget::readLayoutItem(is, propName);    
}







void TStoreTypeQButton::copyDetails(TStoreType *oldObj) {
  cout << "QButton::copyDetails" << endl;
  QButton *n = (QButton *)object();
  QButton *o = (QButton *)oldObj->object();

  TStoreTypeQWidget::copyDetails(oldObj);

  n->setText(o->text());
  n->setAutoResize(o->autoResize());
  if (o->pixmap())
    n->setPixmap(*o->pixmap());
  n->setAutoRepeat(o->autoRepeat());
  
  cout << "QButton::copyDetails" << endl;
}




bool TStoreTypeQButton::QButtonSetTextFunc(QString AValue) {
  ((QButton*)object())->setText(AValue);
  return TRUE;
}

QString TStoreTypeQButton::QButtonGetTextFunc() {
  return (((QButton*)object())->text());
}




bool TStoreTypeQButton::QButtonSetAutoResizeFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  ((QButton*)object())->setAutoResize(TRUE);
  ((QButton*)object())->setAutoResize(FALSE);

  ((QButton*)object())->setAutoResize(val);
  return TRUE;
}

QString TStoreTypeQButton::QButtonGetAutoResizeFunc() {
  if (((QButton*)object())->autoResize())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQButton::QButtonInitAutoResizeFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an AutoResize property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}




bool TStoreTypeQButton::QButtonSetAutoRepeatFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  ((QButton*)object())->setAutoRepeat(TRUE);
  ((QButton*)object())->setAutoRepeat(FALSE);

  ((QButton*)object())->setAutoRepeat(val);
  return TRUE;
}

QString TStoreTypeQButton::QButtonGetAutoRepeatFunc() {
  if (((QButton*)object())->autoRepeat())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQButton::QButtonInitAutoRepeatFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an AutoResize property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}






bool TStoreTypeQButton::QButtonSetPixmapFunc(QString str) {
  QPixmap pix(str);

  if (pix.isNull())
	  return FALSE;

  ((QButton*)object())->setPixmap(pix);
  return TRUE;
}

QString TStoreTypeQButton::QButtonGetPixmapFunc() {
  return ("QPixmap");
}

void TStoreTypeQButton::QButtonActivatePixmapFunc() {
  QString fileName = QFileDialog::getOpenFileName();
  if ( !fileName.isNull() ) {                 // got a file name
    QButtonSetPixmapFunc(fileName);
  }
}

