#include "TStoreTypeQRadioButton.h"
#include <TStoreProperty.h>
#include <TFileIO.h>

#include <qradiobt.h>
#include <qcombo.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledlg.h>

#include <dlfcn.h>
#include <assert.h>




// The functions that the outside world sees have to in extern "C" wrappers because
// the outside world is a c++ world
TStoreType *createStoreTypeQRadioButton(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQRadioButton(parent, lw));
}



TStoreTypeQRadioButton::TStoreTypeQRadioButton(TStoreType *p, TLayoutWindow *lw) : TStoreTypeQButton(p, lw) {
  addProperties();

  QRadioButton *widget;
  if (parent()) {
	  QString foo = nextName(parent()->object(), storeTypeName());

	  widget = new QRadioButton((QWidget*)parent()->object(), foo);
	  widget->setText(foo);
  }
  else {
	  widget = new QRadioButton(lw, "QRadioButton1");
	  widget->setText("QRadioButton1");
  }
  if (object())
	  delete object();
  object(widget);
		  
}


void TStoreTypeQRadioButton::addProperties() {
  TStoreProperty *sp = NULL;

  // Set up a list property
  sp = new TStoreProperty("Checked", ptList,
						  SETFUNC(&QRadioButtonSetCheckedFunc),
						  GETFUNC(&QRadioButtonGetCheckedFunc),
						  INITFUNC(&QRadioButtonInitCheckedFunc), 
						  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);
}



// The name of this type
QString TStoreTypeQRadioButton::storeTypeName() {
  return "QRadioButton";
}



// the headerfile for this type
QString TStoreTypeQRadioButton::headerFile() {
  return "qradiobt.h";
}




// The declaration line for the header file we write out
void TStoreTypeQRadioButton::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQRadioButton *" << var << ";" << endl;
}



// The constructor line for the file we write out
void TStoreTypeQRadioButton::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QRadioButton ( ";
  os << parent;
  os << ", \"" << name() << "\");" << endl;
}


// Any properties that this type has, are written to the C file we generate
void TStoreTypeQRadioButton::writeCFileProperties(QTextStream &os, QString var) {
  // make sure that the parent properties are written as well
  TStoreTypeQButton::writeCFileProperties(os, var);
  
  if ( ((QRadioButton*)object())->isChecked() )
    os << "\t" << var << "->setChecked( TRUE );" << endl;
  else
    os << "\t" << var << "->setChecked( FALSE );" << endl;
}





void TStoreTypeQRadioButton::writeLayout(QTextStream &os, int tabs) {
  QRadioButton *widget = (QRadioButton*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQButton::writeLayout(os, tabs);
  TFileIO::writeLayoutBool(os, tabstr, "Checked", widget->isChecked() );
}


void TStoreTypeQRadioButton::readLayoutItem(QTextStream &is, QString propName) {
  QRadioButton *widget = (QRadioButton*) object();

  if (propName=="Checked")
    widget->setChecked(TFileIO::readLayoutBool(is));
  else
    TStoreTypeQButton::readLayoutItem(is, propName);
}




// Copy the details from one object to the other
void TStoreTypeQRadioButton::copyDetails(TStoreType *oldObj) {
  cout << "QRadioButton::copyDetails" << endl;
  QRadioButton *n = (QRadioButton *)object();
  QRadioButton *o = (QRadioButton *)oldObj->object();

  TStoreTypeQButton::copyDetails(oldObj);

  n->setChecked(o->isChecked());
  
  cout << "QRadioButton::copyDetails" << endl;
}








/********************************************************************************
**
**  Property Functions
**
**  These are used by the addProperties function to perform the underlying functionality
**
********************************************************************************/



// A ptList Property

bool TStoreTypeQRadioButton::QRadioButtonSetCheckedFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  ((QRadioButton*)object())->setChecked(TRUE);
  ((QRadioButton*)object())->setChecked(FALSE);

  ((QRadioButton*)object())->setChecked(val);
  return TRUE;
}

QString TStoreTypeQRadioButton::QRadioButtonGetCheckedFunc() {
  if (((QRadioButton*)object())->isChecked())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQRadioButton::QRadioButtonInitCheckedFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as a Checked property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}
