#include "TStoreTypeQButton.h"
#include "TStoreTypeQPushButton.h"
#include "TStoreTypeQRadioButton.h"
#include "TStoreTypeQCheckBox.h"

#include "QButton.xpm"
#include "QPushButton.xpm"
#include "QRadioButton.xpm"
#include "QCheckBox.xpm"



TIntLibraryInfoList *info=NULL;

extern "C" {
	TIntLibraryInfoList &libraryInfo(void) {
		if (!info) {
			info = new TIntLibraryInfoList;

			TIntLibraryInfo *li;

			// Button
			li = new TIntLibraryInfo;
			li->pixmap = QPixmap((const char **)QButton_xpm);
			li->createFn = createStoreTypeQButton;
			li->isCreatable = TRUE;
			li->isBaseClass = FALSE;
			li->storeName = "QButton";
			info->append(li);

			// Push Button
			li = new TIntLibraryInfo;
			li->pixmap = QPixmap((const char **)QPushButton_xpm);
			li->createFn = createStoreTypeQPushButton;
			li->isCreatable = TRUE;
			li->isBaseClass = FALSE;
			li->storeName = "QPushButton";
			info->append(li);

			// CheckBox
			li = new TIntLibraryInfo;
			li->pixmap = QPixmap((const char **)QCheckBox_xpm);
			li->createFn = createStoreTypeQCheckBox;
			li->isCreatable = TRUE;
			li->isBaseClass = FALSE;
			li->storeName = "QCheckBox";
			info->append(li);

			// RadioButton
			li = new TIntLibraryInfo;
			li->pixmap = QPixmap((const char **)QRadioButton_xpm);
			li->createFn = createStoreTypeQRadioButton;
			li->isCreatable = TRUE;
			li->isBaseClass = FALSE;
			li->storeName = "QRadioButton";
			info->append(li);
		}
		return *info;
	}
}
