#include "TStoreTypeQFrame.h"
#include <TStoreProperty.h>
#include <TFileIO.h>

#include <qbutton.h>
#include <qcombo.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qframe.h>

#include <dlfcn.h>
#include <assert.h>
#include <stdlib.h>



TStoreType *createStoreTypeQFrame(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQFrame(parent, lw));
}

TStoreTypeQFrame::TStoreTypeQFrame(TStoreType *p, TLayoutWindow *lw): TStoreTypeQWidget(p,lw) {
	addProperties();

	if (object()) 
		delete object();

	if (parent()) {
		QString foo = nextName(parent()->object(), storeTypeName());
		object(new QFrame((QWidget*)parent()->object(), foo));
	}
	else {
		object(new QFrame(lw, "Frame1"));
	}
	((QFrame*)object())->setFrameStyle(QFrame::Panel | QFrame::Raised);
}

bool TStoreTypeQFrame::isCreatable() {
	return TRUE;
}

bool TStoreTypeQFrame::isVisible() {
	return TRUE;
}


// creates a list of all of the properties available to this type,
// including all of the properties from the parent
//
// There are 3 types of properties, ptText, ptList, and ptButton.
//   ptText is the most common and allows the user to type an arbitrary piece
//          of text (such as a name, or a number)
//   ptList allows the user to select from a list of options, usefull
//          for bools and enums
//   ptButton pops up a dialog with more questions, such as a file dialog which 
//          is used to select a bitmap file.
void TStoreTypeQFrame::addProperties() {
  TStoreProperty *sp = NULL;

  //set up a text property
  sp = new TStoreProperty("Line Width", ptText,
  			  SETFUNC(&QFrameSetLineWidthFunc),
			  GETFUNC(&QFrameGetLineWidthFunc), 
  			  0,
  			  0, FALSE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Mid Line Width", ptText,
  			  SETFUNC(&QFrameSetMidWidthFunc),
			  GETFUNC(&QFrameGetMidWidthFunc), 
  			  0,
  			  0, FALSE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Frame Shape", ptList,
  			  SETFUNC(&QFrameSetFrameShapeFunc),
  			  GETFUNC(&QFrameGetFrameShapeFunc),
  			  INITFUNC(&QFrameInitFrameShapeFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);


  sp = new TStoreProperty("Frame Style", ptList,
  			  SETFUNC(&QFrameSetShadowFunc),
  			  GETFUNC(&QFrameGetShadowFunc),
  			  INITFUNC(&QFrameInitShadowFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

}




// The name of this type
QString TStoreTypeQFrame::storeTypeName() {
  return "QFrame";
}



// the headerfile for this type
QString TStoreTypeQFrame::headerFile() {
  return "qframe.h";
}




// The declaration line for the header file we write out
void TStoreTypeQFrame::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQFrame *" << var << ";" << endl;
}



// The constructor line for the file we write out
void TStoreTypeQFrame::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QFrame ( ";
  os << parent;
  os << ", \"" << object()->name() << "\");" << endl;
}


// Any properties that this type has, are written to the C file we generate
void TStoreTypeQFrame::writeCFileProperties(QTextStream &os, QString var) {
  // make sure that the parent properties are written as well
  TStoreTypeQWidget::writeCFileProperties(os, var);


  os << "\t" << var << "->setLineWidth( " << ((QFrame*)object())->lineWidth() << " );" << endl;
  os << "\t" << var << "->setMidLineWidth( " << ((QFrame*)object())->midLineWidth() << " );" << endl;


  if (QFrame::NoFrame != ((QFrame*)object())->frameShape())
	  os << "\t" << var << "->setFrameStyle( QFrame::" << QFrameGetFrameShapeFunc() 
		 << " | QFrame::" << QFrameGetShadowFunc() << " );" << endl;
}


void TStoreTypeQFrame::writeLayout(QTextStream &os, int tabs) {
  QFrame *frame = (QFrame*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQWidget::writeLayout(os, tabs);

  TFileIO::writeLayoutInt(os, tabstr, "Line Width", frame->lineWidth() );
  TFileIO::writeLayoutInt(os, tabstr, "Mid Line Width", frame->midLineWidth() );
  TFileIO::writeLayoutString(os, tabstr, "Frame Shape", QFrameGetFrameShapeFunc());
  TFileIO::writeLayoutString(os, tabstr, "Frame Style", QFrameGetShadowFunc());
}


void TStoreTypeQFrame::readLayoutItem(QTextStream &is, QString propName) {
  QFrame *frame = (QFrame*) object();

  if (propName=="Line Width")
    frame->setLineWidth(TFileIO::readLayoutInt(is));
  else if (propName=="Mid Line Width")
    frame->setMidLineWidth(TFileIO::readLayoutInt(is));
  else if (propName=="Frame Shape")
    QFrameSetFrameShapeFunc(TFileIO::readLayoutString(is));
  else if (propName=="Frame Style")
    QFrameSetShadowFunc(TFileIO::readLayoutString(is));
  else
    TStoreTypeQWidget::readLayoutItem(is, propName);    
}


// Copy the details from one object to the other
void TStoreTypeQFrame::copyDetails(TStoreType *oldObj) {
  cout << "QFrame::copyDetails" << endl;
  QFrame *n = (QFrame *)object();
  QFrame *o = (QFrame *)oldObj->object();

  TStoreTypeQWidget::copyDetails(oldObj);

  n->setFrameStyle(o->frameStyle());
  n->setLineWidth(o->lineWidth());
  n->setMidLineWidth(o->lineWidth());
  
  cout << "QFrame::copyDetails" << endl;
}








/********************************************************************************
**
**  Property Functions
**
**  These are used by the addProperties function to perform the underlying functionality
**
********************************************************************************/



// A ptText property

bool TStoreTypeQFrame::QFrameSetLineWidthFunc(QString AValue) {
  ((QFrame*)object())->setLineWidth( AValue.toInt() );
  ((QFrame*)object())->repaint();
  return TRUE;
}

QString TStoreTypeQFrame::QFrameGetLineWidthFunc() {
  QString s;
  s.setNum( ((QFrame*)object())->lineWidth() );
  return s;
}




bool TStoreTypeQFrame::QFrameSetMidWidthFunc(QString AValue) {
  ((QFrame*)object())->setMidLineWidth( AValue.toInt() );
  ((QFrame*)object())->repaint();
  return TRUE;
}

QString TStoreTypeQFrame::QFrameGetMidWidthFunc() {
  QString s;
  s.setNum( ((QFrame*)object())->midLineWidth() );
  return s;
}




// A ptList Property

bool TStoreTypeQFrame::QFrameSetFrameShapeFunc(QString AValue) {
  int val;
  int shadow = ((QFrame*)object())->frameShadow();
  
  if (shadow==0)
    shadow = QFrame::Plain;

  cout << "going to try and set frame shape to: " << AValue << endl;
  if (0==stricmp(AValue, "Box"))
    val = QFrame::Box;
  else if (0==stricmp(AValue, "Panel"))
    val = QFrame::Panel;
  else if (0==stricmp(AValue, "WinPanel"))
    val = QFrame::WinPanel;
  else if (0==stricmp(AValue, "HLine"))
    val = QFrame::HLine;
  else if (0==stricmp(AValue, "VLine"))
    val = QFrame::VLine;
  else
    val = QFrame::NoFrame;

  cout << "val = " << val << endl;
  cout << "shadow = " << shadow << endl;
  if (QFrame::NoFrame == val)
	  ((QFrame*)object())->setFrameStyle(QFrame::NoFrame );
  else
	  ((QFrame*)object())->setFrameStyle(val | shadow );
  ((QFrame*)object())->repaint();
  return TRUE;
}

QString TStoreTypeQFrame::QFrameGetFrameShapeFunc() {
  int i = ((QFrame*)object())->frameShape();

  switch (i) {
  case QFrame::NoFrame:
    return "NoFrame"; break;
  case QFrame::Box:
    return "Box"; break;
  case QFrame::Panel:
    return "Panel"; break;
  case QFrame::WinPanel:
    return "WinPanel"; break;
  case QFrame::HLine:
    return "HLine"; break;
  case QFrame::VLine:
    return "VLine"; break;
  default: 
    return "NoFrame"; break;
  }
}

void TStoreTypeQFrame::QFrameInitFrameShapeFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("NoFrame");
    ((QComboBox *)w)->insertItem("Box");
    ((QComboBox *)w)->insertItem("Panel");
    ((QComboBox *)w)->insertItem("WinPanel");
    ((QComboBox *)w)->insertItem("Hline");
    ((QComboBox *)w)->insertItem("VLine");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an FrameShape property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}








bool TStoreTypeQFrame::QFrameSetShadowFunc(QString AValue) {
  int val;
  int style = ((QFrame*)object())->frameShape();

  if (style==0)
    style=QFrame::NoFrame;

  if (0==stricmp(AValue, "Raised"))
    val = QFrame::Raised;
  else if (0==stricmp(AValue, "Sunken"))
    val = QFrame::Sunken;
  else 
    val = QFrame::Plain;

  if (QFrame::NoFrame==style)
	  ((QFrame*)object())->setFrameStyle(QFrame::NoFrame );
  else
	  ((QFrame*)object())->setFrameStyle(val | style );
  ((QFrame*)object())->repaint();
  return TRUE;
}

QString TStoreTypeQFrame::QFrameGetShadowFunc() {
  int i = ((QFrame*)object())->frameShadow();

  switch (i) {
  case QFrame::Plain:
    return "Plain"; break;
  case QFrame::Sunken:
    return "Sunken"; break;
  case QFrame::Raised:
    return "Raised"; break;
  default: 
    return "Plain"; break;
  }
}

void TStoreTypeQFrame::QFrameInitShadowFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("Plain");
    ((QComboBox *)w)->insertItem("Raised");
    ((QComboBox *)w)->insertItem("Sunken");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an Shadow property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}
