#include "TStoreTypeQGroupBox.h"
#include <TStoreProperty.h>
#include <TFileIO.h>

#include <qbutton.h>
#include <qcombo.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qgrpbox.h>

#include <dlfcn.h>
#include <assert.h>


TStoreType *createStoreTypeQGroupBox(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQGroupBox(parent, lw));
}




TStoreTypeQGroupBox::TStoreTypeQGroupBox(TStoreType *p, TLayoutWindow *lw): TStoreTypeQFrame(p, lw) {
  addProperties();

  if (object())
	  delete object();
  if (parent()) {
	  QString foo = nextName(parent()->object(), storeTypeName());

	  QGroupBox *widget = new QGroupBox((QWidget*)parent()->object(), foo);
	  CHECK_PTR(widget);
	  widget->setTitle(foo);
	  object(widget);
  }
  else {
	  object(new QGroupBox(lw, "QGroupBox1"));
	  ((QGroupBox*)object())->setTitle("QGroupBox1");
  }
}


// creates a list of all of the properties available to this type,
// including all of the properties from the parent
//
// There are 3 types of properties, ptText, ptList, and ptButton.
//   ptText is the most common and allows the user to type an arbitrary piece
//          of text (such as a name, or a number)
//   ptList allows the user to select from a list of options, usefull
//          for bools and enums
//   ptButton pops up a dialog with more questions, such as a file dialog which 
//          is used to select a bitmap file.
void TStoreTypeQGroupBox::addProperties() {
  TStoreProperty *sp = NULL;

  // set up a text property
  sp = new TStoreProperty("Title", ptText,
						  SETFUNC(&QGroupBoxSetTitleFunc),
						  GETFUNC(&QGroupBoxGetTitleFunc), 
						  0,
						  0, FALSE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);


  // Set up a list property
  sp = new TStoreProperty("Alignment", ptList,
						  SETFUNC(&QGroupBoxSetAlignmentFunc),
						  GETFUNC(&QGroupBoxGetAlignmentFunc),
						  INITFUNC(&QGroupBoxInitAlignmentFunc), 
						  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

}



// The name of this type
QString TStoreTypeQGroupBox::storeTypeName() {
  return "QGroupBox";
}



// the headerfile for this type
QString TStoreTypeQGroupBox::headerFile() {
  return "qgrpbox.h";
}




// The declaration line for the header file we write out
void TStoreTypeQGroupBox::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQGroupBox *" << var << ";" << endl;
}



// The constructor line for the file we write out
void TStoreTypeQGroupBox::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QGroupBox ( ";
  os << parent;
  os << ", \"" << object()->name() << "\");" << endl;
}


// Any properties that this type has, are written to the C file we generate
void TStoreTypeQGroupBox::writeCFileProperties(QTextStream &os, QString var) {
  // make sure that the parent properties are written as well
  TStoreTypeQFrame::writeCFileProperties(os, var);
  
  os << "\t" << var << "->setTitle( \"" << ((QGroupBox*)object())->title() 
     << "\" );" << endl;

  os << "\t" << var << "->setAlignment( " << QGroupBoxGetAlignmentFunc()
     << " );" << endl;
}



void TStoreTypeQGroupBox::writeLayout(QTextStream &os, int tabs) {
  QGroupBox *widget = (QGroupBox*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQFrame::writeLayout(os, tabs);

   TFileIO::writeLayoutString(os, tabstr, "Title", widget->title() );
   TFileIO::writeLayoutString(os, tabstr, "Alignment", QGroupBoxGetAlignmentFunc() );
}


void TStoreTypeQGroupBox::readLayoutItem(QTextStream &is, QString propName) {
  QGroupBox *widget = (QGroupBox*) object();

  if (propName=="Title")
     widget->setTitle(TFileIO::readLayoutString(is));
  else if (propName == "Alignment")
    QGroupBoxSetAlignmentFunc(TFileIO::readLayoutString(is));
  else
    TStoreTypeQFrame::readLayoutItem(is, propName);
}




// Copy the details from one object to the other
void TStoreTypeQGroupBox::copyDetails(TStoreType *oldObj) {
  cout << "QGroupBox::copyDetails" << endl;
  QGroupBox *n = (QGroupBox *)object();
  QGroupBox *o = (QGroupBox *)oldObj->object();

  TStoreTypeQGroupBox::copyDetails(oldObj);

  n->setTitle(o->title());
  n->setAlignment(o->alignment());
  
  cout << "QGroupBox::copyDetails" << endl;
}








/********************************************************************************
**
**  Property Functions
**
**  These are used by the addProperties function to perform the underlying functionality
**
********************************************************************************/



// A ptText property

bool TStoreTypeQGroupBox::QGroupBoxSetTitleFunc(QString AValue) {
  ((QGroupBox*)object())->setTitle(AValue);
  return TRUE;
}

QString TStoreTypeQGroupBox::QGroupBoxGetTitleFunc() {
  return (((QGroupBox*)object())->title());
}




// A ptList Property
bool TStoreTypeQGroupBox::QGroupBoxSetAlignmentFunc(QString AValue) {
  int align = ((QGroupBox*)object())->alignment();
  int val=0;

  int hvals = AlignLeft | AlignRight | AlignHCenter;
  align = align & ~hvals;

  if (align==0)
    align=AlignVCenter;

  if ("AlignLeft"==AValue) 
    val = AlignLeft;
  else if ("AlignHCenter"==AValue) 
    val = AlignHCenter;
  else if ("AlignRight"==AValue) 
    val = AlignRight;

  ((QGroupBox*)object())->setAlignment(align|val);
  return TRUE;
}

QString TStoreTypeQGroupBox::QGroupBoxGetAlignmentFunc() {
  int align = ((QGroupBox*)object())->alignment();
  QString rVal;

  if (align & AlignLeft)
    rVal = "AlignLeft";
  else if (align & AlignRight)
    rVal = "AlignRight";
  else 
    rVal = "AlignHCenter";
  return rVal;
}

void TStoreTypeQGroupBox::QGroupBoxInitAlignmentFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    QComboBox *c = (QComboBox *)w;
    QGroupBox *l = (QGroupBox *)object();
    c->clear();
    c->insertItem("AlignLeft");
    c->insertItem("AlignHCenter");
    c->insertItem("AlignRight");
    if ( l->alignment() & AlignLeft) 
      c->setCurrentItem(0);
    else if ( l->alignment() & AlignRight) 
      c->setCurrentItem(2);
    else
      c->setCurrentItem(1);
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an Alignment property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}



