#include "TStoreTypeQLabel.h"
#include <TStoreProperty.h>
#include <TLayoutWindow.h>
#include <TObjectTree.h>
#include <TFileIO.h>

#include <qbutton.h>
#include <qcombo.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qlabel.h>

#include <dlfcn.h>
#include <assert.h>
#include <stdlib.h>



TStoreType *createStoreTypeQLabel(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQLabel(parent, lw));
}




TStoreTypeQLabel::TStoreTypeQLabel(TStoreType *p, TLayoutWindow *lw): TStoreTypeQFrame(p, lw) {
  addProperties();
  
  if (object())
	  delete object();
  if (parent()) {
	  QString foo = nextName(parent()->object(), storeTypeName());
	  object( new QLabel(foo, (QWidget *)parent()->object(), foo));
  }
  else
	  object( new QLabel("QLabel1", lw, "QLabel1"));
}

void TStoreTypeQLabel::addProperties() {
  TStoreProperty *sp = NULL;
  
  // set up a text property
  sp = new TStoreProperty("Text", ptText,
  			  SETFUNC(&QLabelSetTextFunc),
			  GETFUNC(&QLabelGetTextFunc), 
  			  0,
  			  0, FALSE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Margin", ptText,
  			  SETFUNC(&QLabelSetMarginFunc),
			  GETFUNC(&QLabelGetMarginFunc), 
  			  0,
  			  0, FALSE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);


  // Set up a list property
  sp = new TStoreProperty("Alignment H", ptList,
  			  SETFUNC(&QLabelSetAlignHFunc),
  			  GETFUNC(&QLabelGetAlignHFunc),
  			  INITFUNC(&QLabelInitAlignHFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Alignment V", ptList,
  			  SETFUNC(&QLabelSetAlignVFunc),
  			  GETFUNC(&QLabelGetAlignVFunc),
  			  INITFUNC(&QLabelInitAlignVFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Word Break", ptList,
  			  SETFUNC(&QLabelSetWordBreakFunc),
  			  GETFUNC(&QLabelGetWordBreakFunc),
  			  INITFUNC(&QLabelInitWordBreakFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Expand Tabs", ptList,
  			  SETFUNC(&QLabelSetExpandTabsFunc),
  			  GETFUNC(&QLabelGetExpandTabsFunc),
  			  INITFUNC(&QLabelInitExpandTabsFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Show Prefix", ptList,
  			  SETFUNC(&QLabelSetShowPrefixFunc),
  			  GETFUNC(&QLabelGetShowPrefixFunc),
  			  INITFUNC(&QLabelInitShowPrefixFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Auto Resize", ptList,
  			  SETFUNC(&QLabelSetAutoResizeFunc),
  			  GETFUNC(&QLabelGetAutoResizeFunc),
  			  INITFUNC(&QLabelInitAutoResizeFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  sp = new TStoreProperty("Buddy", ptList,
   			  SETFUNC(&QLabelSetBuddyFunc),
   			  GETFUNC(&QLabelGetBuddyFunc),
   			  INITFUNC(&QLabelInitBuddyFunc), 
			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

  // Set up a Button Property
  sp = new TStoreProperty("Pixmap", ptButton,
  			  SETFUNC(&QLabelSetPixmapFunc),
  			  GETFUNC(&QLabelGetPixmapFunc),
  			  0,
  			  ACTIVEFUNC(&QLabelActivatePixmapFunc), TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);

}





bool TStoreTypeQLabel::canItHaveChildren() {
  return FALSE;
}


// The name of this type
QString TStoreTypeQLabel::storeTypeName() {
  return "QLabel";
}



// the headerfile for this type
QString TStoreTypeQLabel::headerFile() {
  return "qlabel.h";
}




// The declaration line for the header file we write out
void TStoreTypeQLabel::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQLabel *" << var << ";" << endl;
}



// The constructor line for the file we write out
void TStoreTypeQLabel::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QLabel ( ";
  os << parent;
  os << ", \"" << name() << "\");" << endl;
}


// Any properties that this type has, are written to the C file we generate
void TStoreTypeQLabel::writeCFileProperties(QTextStream &os, QString var) {
  // make sure that the parent properties are written as well
  TStoreTypeQFrame::writeCFileProperties(os, var);

  QLabel *label = (QLabel*)object();

  os << "\t" << var << "->setText( \"" << label->text() << "\" );" << endl;
  os << "\t" << var << "->setMargin( " << label->margin() << " );" << endl;

  os << "\t" << var << "->setAlignment( ";
  os << QLabelGetAlignHFunc() << " | " << QLabelGetAlignVFunc();
  if (label->alignment() & ExpandTabs)
    os << " | ExpandTabs";
  if (label->alignment() & ShowPrefix)
    os << " | ShowPrefix";
  if (label->alignment() & WordBreak)
    os << " | WordBreak";
  os << " );" << endl;

  os << "\t" << var << "->setAutoResize( " << QLabelGetAutoResizeFunc() << " );" << endl;

  if( label->pixmap()) {
    os << "\tQPixmap " << var << "_Pixmap;" << endl;
    os << "\t" << var << "_Pixmap.loadFromData(" << var << "_PixmapData, "
       << var << "_PixmapSize);" << endl;
    os << "\t" << var << "->setPixmap( " << var << "_Pixmap);" << endl;
  }

  if ( label->buddy() ) {
    QObject *ptr = label->buddy();
    while (ptr->parent())
      ptr = ptr->parent();

    cout << "Root of Buddy is " << ptr->className() << "::" << ptr->name() << endl;
    assert(ptr->inherits("TLayoutWindow"));
    TLayoutWindow *bw = (TLayoutWindow*)ptr;
    TObjectTree *tree = bw->objectTree().find( label->buddy() );
    if (tree!=NULL)
      os << "\t" << var << "->setBuddy( " << tree->validName() << " );" << endl;
  }
}


// For certain types, such as bitmaps we need to store the data in a seperate file
void TStoreTypeQLabel::writeCFileData(QTextStream &data, QString var) {
  // write out the data for the parent type
  TStoreTypeQFrame::writeCFileData(data, var);
  
  QLabel *label = (QLabel*)object();
  // Write out a pixmap
  if (label->pixmap()) {
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);
    QPixmap pix = *label->pixmap();
    QString str;
    
    dstream << pix;
    
    data << "#include <qpixmap.h>" << endl;
    data << "static const uint " << var << "_PixmapSize = " 
  	 << array.size() << " ;" << endl;
    data << "static const uchar " << var << "_PixmapData [] = {";
    
    for (uint i=0 ; i<array.size() ; i++) {
      if ((i%16)==0)
  	data << endl << "  ";
      data << (uint)((uchar)array[i]) << " , ";
    }
    data << endl << "};" << endl;
  }
}

void TStoreTypeQLabel::writeLayout(QTextStream &os, int tabs) {
  QLabel *label = (QLabel*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQFrame::writeLayout(os, tabs);

  TFileIO::writeLayoutString(os, tabstr, "Text", label->text() );
  TFileIO::writeLayoutInt(os, tabstr, "Margin", label->margin() );
  TFileIO::writeLayoutString(os, tabstr, "Alignment H", QLabelGetAlignHFunc());
  TFileIO::writeLayoutString(os, tabstr, "Alignment V", QLabelGetAlignVFunc());
  TFileIO::writeLayoutBool(os, tabstr, "Word Break", label->alignment() & WordBreak );
  TFileIO::writeLayoutBool(os, tabstr, "Expand Tabs", label->alignment() & ExpandTabs );
  TFileIO::writeLayoutBool(os, tabstr, "Show Prefix", label->alignment() & ShowPrefix );
  TFileIO::writeLayoutBool(os, tabstr, "Auto Resize", label->autoResize() );
  TFileIO::writeLayoutString(os, tabstr, "Buddy", QLabelGetBuddyFunc() );
  if (label->pixmap()) {
    QByteArray array;
    QDataStream dstream(array, IO_WriteOnly);
    QPixmap pix = *label->pixmap();
    dstream << pix;
    
    TFileIO::writeLayoutData(os, tabstr, "Pixmap", array );
  }

}


void TStoreTypeQLabel::readLayoutItem(QTextStream &is, QString propName) {
  QLabel *label = (QLabel*) object();

  if (propName=="Text")
    label->setText(TFileIO::readLayoutString(is));
  else if (propName=="Margin")
    label->setMargin(TFileIO::readLayoutInt(is));
  else if (propName=="Alignment H")
    QLabelSetAlignHFunc(TFileIO::readLayoutString(is));
  else if (propName=="Alignment V")
    QLabelSetAlignVFunc(TFileIO::readLayoutString(is));
  else if (propName=="Word Break") {
    if (TFileIO::readLayoutBool(is))
      label->setAlignment( label->alignment() | WordBreak);
  }
  else if (propName=="Expand Tabs") {
    if (TFileIO::readLayoutBool(is))
      label->setAlignment( label->alignment() | ExpandTabs );
  }
  else if (propName=="Show Prefix") {
    if (TFileIO::readLayoutBool(is))
      label->setAlignment( label->alignment() | ShowPrefix );
  }
  else if (propName=="Auto Resize")
      label->setAutoResize ( TFileIO::readLayoutBool(is) );
  else if (propName=="Buddy")
    QLabelSetBuddyFunc(TFileIO::readLayoutString(is));
  else if (propName=="Pixmap") {
    QPixmap pix;
    QByteArray array = TFileIO::readLayoutData(is);
    
    pix.loadFromData( (uchar *)array.data(), array.size());
    label->setPixmap(pix);
  }
  else
    TStoreTypeQFrame::readLayoutItem(is, propName);    
}








// Copy the details from one object to the other
void TStoreTypeQLabel::copyDetails(TStoreType *oldObj) {
  cout << "QLabel::copyDetails" << endl;
  QLabel *n = (QLabel *)object();
  QLabel *o = (QLabel *)oldObj->object();

  TStoreTypeQFrame::copyDetails(oldObj);

  n->setText(o->text());
  n->setAutoResize(o->autoResize());
  n->setMargin(o->margin());
  n->setAlignment(o->alignment());
  if (o->pixmap())
    n->setPixmap(*o->pixmap());

  if (o->buddy())
    ; // Search for the buddy by name

  cout << "QLabel::copyDetails" << endl;
}








/********************************************************************************
**
**  Property Functions
**
**  These are used by the addProperties function to perform the underlying functionality
**
********************************************************************************/



// A ptText property

bool TStoreTypeQLabel::QLabelSetTextFunc(QString AValue) {
  ((QLabel*)object())->setText(AValue);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetTextFunc() {
  return (((QLabel*)object())->text());
}



bool TStoreTypeQLabel::QLabelSetMarginFunc(QString AValue) {
  ((QLabel*)object())->setMargin(AValue.toInt());
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetMarginFunc() {
  QString s;
  s.setNum( ((QLabel*)object())->margin());
  return s;
}




// A ptList Property

bool TStoreTypeQLabel::QLabelSetAutoResizeFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  QLabel *label = (QLabel*) object();

  label->setAutoResize(TRUE);
  label->setAutoResize(FALSE);

  label->setAutoResize(val);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetAutoResizeFunc() {
  if (((QLabel*)object())->autoResize())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQLabel::QLabelInitAutoResizeFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an AutoResize property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}




bool TStoreTypeQLabel::QLabelSetAlignHFunc(QString AValue) {
  int align = ((QLabel*)object())->alignment();
  int val=0;

  int hvals = AlignLeft | AlignRight | AlignHCenter;
  align = align & ~hvals;

  if (align==0)
    align=AlignVCenter;

  if ("AlignLeft"==AValue) 
    val = AlignLeft;
  else if ("AlignHCenter"==AValue) 
    val = AlignHCenter;
  else if ("AlignRight"==AValue) 
    val = AlignRight;

  ((QLabel*)object())->setAlignment(align|val);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetAlignHFunc() {
  int align = ((QLabel*)object())->alignment();
  QString rVal;

  if (align & AlignLeft)
    rVal = "AlignLeft";
  else if (align & AlignRight)
    rVal = "AlignRight";
  else 
    rVal = "AlignHCenter";
  return rVal;
}

void TStoreTypeQLabel::QLabelInitAlignHFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    QComboBox *c = (QComboBox *)w;
    QLabel *l = (QLabel *)object();
    c->clear();
    c->insertItem("AlignLeft");
    c->insertItem("AlignHCenter");
    c->insertItem("AlignRight");
    if ( l->alignment() & AlignLeft) 
      c->setCurrentItem(0);
    else if ( l->alignment() & AlignRight) 
      c->setCurrentItem(2);
    else
      c->setCurrentItem(1);
  
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an AlignH property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}




bool TStoreTypeQLabel::QLabelSetAlignVFunc(QString AValue) {
  int align = ((QLabel*)object())->alignment();
  int val=0;

  uint hvals = AlignTop | AlignBottom | AlignVCenter;
  hvals = ~hvals;
  align = align & hvals;

  if (align==0)
    align=AlignLeft;

  if ("AlignTop"==AValue) 
    val = AlignTop;
  else if ("AlignVCenter"==AValue) 
    val = AlignVCenter;
  else if ("AlignBottom"==AValue) 
    val = AlignBottom;

  ((QLabel*)object())->setAlignment(align|val);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetAlignVFunc() {
  int align = ((QLabel*)object())->alignment();
  QString rVal;

  if (align & AlignTop)
    rVal = "AlignTop";
  else if (align & AlignBottom)
    rVal = "AlignBottom";
  else 
    rVal = "AlignVCenter";

  return rVal;
}

void TStoreTypeQLabel::QLabelInitAlignVFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    QComboBox *c = (QComboBox *)w;
    QLabel *l = (QLabel *)object();
    c->clear();
    c->insertItem("AlignTop");
    c->insertItem("AlignVCenter");
    c->insertItem("AlignBottom");

    if ( l->alignment() & AlignTop) 
      c->setCurrentItem(0);
    else if ( l->alignment() & AlignBottom) 
      c->setCurrentItem(2);
    else
      c->setCurrentItem(1);

  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an AlignV property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}




bool TStoreTypeQLabel::QLabelSetWordBreakFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  int align = ((QLabel*)object())->alignment();

  align = align & ~WordBreak;
  
  align = align | (val ? WordBreak : 0);

  ((QLabel*)object())->setAlignment(align);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetWordBreakFunc() {
  if (((QLabel*)object())->alignment() & WordBreak)
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQLabel::QLabelInitWordBreakFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an WordBreak property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}





bool TStoreTypeQLabel::QLabelSetExpandTabsFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  int align = ((QLabel*)object())->alignment();
  align = align & ~ExpandTabs;

  align = align | (val ? ExpandTabs : 0);
  ((QLabel*)object())->setAlignment(align);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetExpandTabsFunc() {
  if (((QLabel*)object())->alignment() & ExpandTabs)
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQLabel::QLabelInitExpandTabsFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an ExpandTabs property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}




bool TStoreTypeQLabel::QLabelSetShowPrefixFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  int align = ((QLabel*)object())->alignment();
  align = align & ~ShowPrefix;

  align = align | (val ? ShowPrefix : 0);
  ((QLabel*)object())->setAlignment(align);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetShowPrefixFunc() {
  if (((QLabel*)object())->alignment() & ShowPrefix)
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQLabel::QLabelInitShowPrefixFunc(QObject *combo) {
  // set up the list with the required strings
  if (combo->inherits("QComboBox")) {
    ((QComboBox *)combo)->clear();
    ((QComboBox *)combo)->insertItem("FALSE");
    ((QComboBox *)combo)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << combo->name()
      << " as an ShowPrefix property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}





bool TStoreTypeQLabel::QLabelSetBuddyFunc(QString AValue) {
  cout << "SetBuddy: " << AValue << endl;
  QLabel *label = (QLabel*)object();

  if (AValue.isEmpty() || AValue=="")
    label->setBuddy( label);
  else {
    QObject *ptr = label;
    while (ptr->parent())
      ptr = ptr->parent();
    assert(ptr->inherits("TLayoutWindow"));
    
    TStoreType *o = ((TLayoutWindow*)ptr)->objectTree().findByObjName(AValue);

    if (o) {
      cout << "Found Buddy " << o->object()->className() << "::" << o->object()->name() << endl;
      label->setBuddy( (QWidget*)o->object());
    }
    else
      label->setBuddy(NULL);
  }
  return TRUE;
}


QString TStoreTypeQLabel::QLabelGetBuddyFunc() {
  QWidget *widget = ((QLabel*)object())->buddy();

  if (widget)
    return widget->name();
  else
    return "";
}

void TStoreTypeQLabel::QLabelInitBuddyFunc(QObject *combo) {
  // set up the list with the required strings
  if (combo->inherits("QComboBox")) {
    ((QComboBox *)combo)->clear();
    ((QComboBox *)combo)->insertItem("");
    
    QObject *ptr = object();
    while (ptr->parent())
      ptr = ptr->parent();
    assert(ptr->inherits("TLayoutWindow"));
    TLayoutWindow *bw = (TLayoutWindow*)ptr;
    TObjectTree *tree = &bw->objectTree();
    while (tree) {
      if ( (tree->object()->isWidgetType()) && (tree->object() != object()) )
	((QComboBox *)combo)->insertItem(tree->object()->name());
      tree = (TObjectTree*) tree->next();
    }
  }
  else {
    cerr << "Tried to initialise " << combo->name()
      << " as an ShowPrefix property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}






// ptButton Property
bool TStoreTypeQLabel::QLabelSetPixmapFunc(QString str) {
  QPixmap pix(str);

  if (pix.isNull())
	  return FALSE;

  ((QLabel*)object())->setPixmap(pix);
  return TRUE;
}

QString TStoreTypeQLabel::QLabelGetPixmapFunc() {
  return ("QPixmap");
}

void TStoreTypeQLabel::QLabelActivatePixmapFunc() {
  QString fileName = QFileDialog::getOpenFileName();
  if ( !fileName.isNull() ) {                 // got a file name
    QLabelSetPixmapFunc(fileName);
  }
}
