#ifndef TSTORETYPE_QLABEL_H
#define TSTORETYPE_QLABEL_H

#include "TStoreTypeQFrame.h"

class TStoreTypeQLabel: public TStoreTypeQFrame {
Q_OBJECT
public:
  TStoreTypeQLabel(TStoreType *, TLayoutWindow *);

  QString storeTypeName();
  QString headerFile();
  
  bool canItHaveChildren();

  void writeHFile(QTextStream &os,  QString);
  void writeCFileConstructor(QTextStream &os,  QString, QString);
  void writeCFileProperties(QTextStream &os,  QString);
  void writeCFileData(QTextStream &data, QString var);
  void writeLayout(QTextStream &data, int);
  void readLayoutItem(QTextStream &os, QString);
  
  void copyDetails(TStoreType *oldObj);
protected:
  void addProperties();


// Prototypes for the property functions
// Text Properties
	bool QLabelSetTextFunc(QString AValue);
	QString QLabelGetTextFunc();
	
	bool QLabelSetMarginFunc(QString AValue);
	QString QLabelGetMarginFunc();
	
// List Properties
	bool QLabelSetAlignHFunc(QString AValue);
	QString QLabelGetAlignHFunc();
	void QLabelInitAlignHFunc(QObject * );
	
	bool QLabelSetAlignVFunc(QString AValue);
	QString QLabelGetAlignVFunc();
	void QLabelInitAlignVFunc(QObject * );
	
	bool QLabelSetWordBreakFunc(QString AValue);
	QString QLabelGetWordBreakFunc();
	void QLabelInitWordBreakFunc(QObject * );
	
	bool QLabelSetExpandTabsFunc(QString AValue);
	QString QLabelGetExpandTabsFunc();
	void QLabelInitExpandTabsFunc(QObject * );
	
	bool QLabelSetShowPrefixFunc(QString AValue);
	QString QLabelGetShowPrefixFunc();
	void QLabelInitShowPrefixFunc(QObject * );
	
	bool QLabelSetAutoResizeFunc(QString);
	QString QLabelGetAutoResizeFunc();
	void QLabelInitAutoResizeFunc(QObject * );
	
	bool QLabelSetBuddyFunc(QString);
	QString QLabelGetBuddyFunc();
	void QLabelInitBuddyFunc(QObject * );
	
// Button Properties
	bool QLabelSetPixmapFunc(QString);
	QString QLabelGetPixmapFunc();
	void QLabelActivatePixmapFunc();
	void readPixmap(QTextStream &data, const char *dataName,
					const char *dataLengthStr);
private:
};

TStoreType *createStoreTypeQLabel(TStoreType *parent, TLayoutWindow *lw);

#endif /* TSTORETYPE_QLABEL_H */
