#include <assert.h>

#include <qobjcoll.h>
#include <qlayout.h>

#include "TBoxLayoutWindow.h"




TBoxLayoutWindow::TBoxLayoutWindow(TStoreType *tree, QWidget *parent, 
				   const char *name) : QDialog(parent, name, TRUE) {
  initMetaObject();

  fTaggedObjects.setAutoDelete(TRUE);


  btnOk = new QPushButton("OK", this);
  btnOk->setMinimumSize(btnOk->size());
  connect(btnOk, SIGNAL(clicked()), SLOT(okClicked()));

  btnCancel = new QPushButton("Cancel", this);
  btnCancel->setMinimumSize(btnOk->size());
  connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));

  btnWidget = new QPushButton("+ Widget", this);
  btnWidget->setMinimumSize(btnOk->size());
  connect(btnWidget, SIGNAL(clicked()), SLOT(addWidget()));

  btnLayout = new QPushButton("+ Layout", this);
  btnLayout->setMinimumSize(btnOk->size());
  connect(btnLayout, SIGNAL(clicked()), SLOT(addLayout()));

  btnSpace = new QPushButton("+ Space", this);
  btnSpace->setMinimumSize(btnOk->size());
  connect(btnSpace, SIGNAL(clicked()), SLOT(addSpace()));

  btnStretch = new QPushButton("+ Stretch", this);
  btnStretch->setMinimumSize(btnOk->size());
  connect(btnStretch, SIGNAL(clicked()), SLOT(addStretch()));

  btnStrut = new QPushButton("+ Strut", this);
  btnStrut->setMinimumSize(btnOk->size());
  connect(btnStrut, SIGNAL(clicked()), SLOT(addStrut()));

  btnDelete = new QPushButton("Delete", this);
  btnDelete->setMinimumSize(btnOk->size());
  connect(btnDelete, SIGNAL(clicked()), SLOT(deleteItem()));
   
  TBoxLayoutData *data = (TBoxLayoutData*) tree->findData("QBoxLayout");
  boxTable = new TBoxLayoutTable(data->direction, this);
  boxTable->setMinimumSize(btnOk->size());

  QBoxLayout *mainLayout = new QBoxLayout(this, QBoxLayout::TopToBottom, 5);
  QBoxLayout *subLayout = new QBoxLayout(QBoxLayout::LeftToRight);
  QBoxLayout *contLayout1 = new QBoxLayout(QBoxLayout::TopToBottom);
  QBoxLayout *contLayout2 = new QBoxLayout(QBoxLayout::TopToBottom);
  QBoxLayout *okLayout = new QBoxLayout(QBoxLayout::LeftToRight);

  mainLayout->addLayout(subLayout, 1);
  mainLayout->addLayout(okLayout);

  subLayout->addLayout(contLayout1);
  subLayout->addLayout(contLayout2, 1);

  
  okLayout->addStretch(1);
  okLayout->addWidget(btnOk);
  okLayout->addSpacing(5);
  okLayout->addWidget(btnCancel);
  okLayout->addStretch(1);

  contLayout1->addWidget(btnWidget);
  contLayout1->addWidget(btnLayout);
  contLayout1->addWidget(btnStretch);
  contLayout1->addWidget(btnSpace);
  contLayout1->addWidget(btnStrut);
  contLayout1->addStretch(1);

  contLayout2->addWidget(boxTable, 1);
  contLayout2->addWidget(btnDelete);

  mainLayout->activate();

  resize(500,500);

  setTree(tree);
}



TBoxLayoutWindow::~TBoxLayoutWindow() {
;
}

void TBoxLayoutWindow::addWidget() {
  TDataListBoxDlg *widgetList = new TDataListBoxDlg();
  
  populateObjectListBox(widgetList, "QWidget");
  if (widgetList->count()) {
    if (widgetList->exec()) {
      TStoreType *tree = (TStoreType*)widgetList->data();
      boxTable->addWidget( tree );
      tagObject(tree, TRUE);
    }
  }
  delete widgetList;
}



void TBoxLayoutWindow::addLayout() {
  TDataListBoxDlg *widgetList = new TDataListBoxDlg();
  
  //populateObjectListBox(widgetList, "QLayout");
  populateObjectListBox(widgetList, "QObject");
  if (widgetList->count()) {
    if (widgetList->exec()) {
      TStoreType *tree = (TStoreType*)widgetList->data();
      boxTable->addLayout( tree );
      tagObject(tree, TRUE);
    }
  }
  delete widgetList;
}


void TBoxLayoutWindow::populateObjectListBox(TDataListBoxDlg *widgetList, const char *dtype) {
  QString str;

  QListIterator<TTaggedObject> it(fTaggedObjects);
  for ( ; it.current() ; ++it) {
    if (!it.current()->inLayout && it.current()->tree->object()->inherits(dtype)) {
      TStoreType *tree = fTree->parent()->find(it.current()->tree);
      str.sprintf("%s::%s", tree->storeTypeName().data(), 
		  tree->object()->name());
      widgetList->insertItem(str, tree);
    }
  }
}


void TBoxLayoutWindow::addSpace() {
  boxTable->addSpacing(0);
}

void TBoxLayoutWindow::addStrut() {
  boxTable->addStrut(0);
}

void TBoxLayoutWindow::addStretch() {
  boxTable->addStretch(0);
}

void TBoxLayoutWindow::deleteItem() {
  TBoxLayoutDataItem *item = boxTable->data();
  if (item->type == TBoxLayoutDataItem::Widget ||
      item->type == TBoxLayoutDataItem::Layout)
    tagObject(item->objectTree, FALSE);
    
  boxTable->deleteItem();
}

void TBoxLayoutWindow::tagObject(TStoreType *tree, bool val) {
  QListIterator<TTaggedObject> it(fTaggedObjects);
  for ( ; it.current() ; ++it) {
    if (it.current()->tree == tree) {
      cout << "Tagging object: " << (void*) tree << " " << tree->object()->name() 
	   << " to be: " << val << endl;
      it.current()->inLayout = val;
      return;
    }
  }
}

void TBoxLayoutWindow::setTree(TStoreType *tree) {
  fTree = tree;
  boxTable->clear();

  if (!tree)
    return;

  TBoxLayoutData *data = (TBoxLayoutData*) tree->findData("QBoxLayout");
  QListIterator<TBoxLayoutDataItem> it(data->items);
  for ( ; it.current() ; ++it) {
    TBoxLayoutDataItem *item = it.current();
    switch(item->type) {
    case TBoxLayoutDataItem::Widget:
      boxTable->addWidget(item->objectTree, item->size, item->alignment);
      break;
    case TBoxLayoutDataItem::Layout:
      boxTable->addLayout(item->objectTree, item->size);
      break;
    case TBoxLayoutDataItem::Space:
      boxTable->addSpacing(item->size);
      break;
    case TBoxLayoutDataItem::Stretch:
      boxTable->addStretch(item->size);
      break;
    case TBoxLayoutDataItem::Strut:
      boxTable->addStrut(item->size);
      break;
    }
  }  


  fTaggedObjects.clear();
  TStoreType *node;
  TStoreType *root = tree->parent();
  cout << "###\n### Adding objects from: " << root->object()->name() << endl; 
  for ( node=root->firstChild() ; node ; node=node->nextSibling() ) {
    // we do not want to include the base widget, or this layout.
    if (node->object() == root->object())
      continue;
    if (node->object() == tree->object())
      continue;

    TTaggedObject *tobj = new TTaggedObject;
    tobj->tree = node;

    TLayoutDataItem *layoutdata = (TLayoutDataItem*) node->findAppliedData("QLayout");
    if (layoutdata && layoutdata->parentLayoutTree)
      tobj->inLayout = TRUE;
    else
      tobj->inLayout = FALSE;
    fTaggedObjects.append(tobj);

    cout << "@@@ adding: " << tobj->tree->object()->name() << endl;
  }
}



void TBoxLayoutWindow::okClicked() {
  accept();
}





