#ifndef _TSTORETYPEQLAYOUT_H_
#define _TSTORETYPEQLAYOUT_H_


#include <qlayout.h>

#include <TStoreType.h>

typedef struct TLayoutDataItem {
  TStoreType *parentLayoutTree;
} TLayoutDataItem;

class TStoreTypeQLayout : public TStoreType {
	Q_OBJECT
public:
  TStoreTypeQLayout(TStoreType *, TLayoutWindow *);
  ~TStoreTypeQLayout();

  QString storeTypeName();
  QString headerFile();
  TObjectType type();
  
  bool isCreatable();
  bool isVisible();
  bool canItHaveChildren();

  virtual void rebuildLayout();
  virtual void recreateLayout(QLayout *parent);
  virtual void repopulateLayout();
  virtual void writePropertiesLayoutTree(QTextStream &, QString);
  virtual void layoutMemberDeleted(TStoreType *);

  virtual void rebuild(bool);
  bool rebuild() { return fRebuilding;};
  virtual void deleteLayoutTree();
public slots:
  void deleted();
protected:
  void addProperties();
private:
  bool fRebuilding; 
};

TStoreType *createStoreTypeQLayout(TStoreType *, TLayoutWindow *);

#endif /* _TSTORETYPEQLAYOUT_H_ */
