/* fpios.hh
 * Written by Joshua Rowe
 * File-based persistent object streams
 */

#ifndef	__FPIOS_HH__
#define	__FPIOS_HH__

class	fdpstreambuf;
class	fdpstream;
class	ifdpstream;
class	ofdpstream;
class	fpstreambuf;
class	fpstream;
class	ifpstream;
class	ofpstream;
class	iofpstream;

#include	"pios.hh"

class	fdpstreambuf	: public pstreambuf
{
protected:
  int		fd;
public:
  fdpstreambuf();
  fdpstreambuf(int afd, int aflags);
  ~fdpstreambuf();
  virtual void	close();
  void		open(int afd, int aflags = 0);
  virtual pvoid	read(pvoid d, int l);
  virtual void	write(pvoid d, int l);
};

class	fdpstream	: virtual public pstream
{
protected:
public:
  fdpstream();
  fdpstream(int afd, int aflags = 0);
  void		open(int afd, int aflags = 0);
};

class	ifdpstream	: virtual public fdpstream, virtual public ipstream
{
protected:
public:
  ifdpstream();
  ifdpstream(int afd, int aflags = 0);
};

class	ofdpstream	: virtual public fdpstream, virtual public opstream
{
protected:
public:
  ofdpstream();
  ofdpstream(int afd, int aflags = 0);
};

class	iofdpstream	: virtual public ifdpstream, virtual public ofdpstream
{
protected:
public:
  iofdpstream();
  iofdpstream(int afd, int aflags = 0);
};

class	fpstreambuf	: public fdpstreambuf
{
protected:
public:
  fpstreambuf();
  fpstreambuf(char *aname, int aflags, int amode = 0644);
  void		open(char *aname, int aflags, int amode = 0644);
};

class	fpstream	: virtual public fdpstream
{
protected:
public:
  fpstream();
  fpstream(char *aname, int aflags, int amode = 0644);
  void		open(char *aname, int aflags, int amode = 0644);
};

class	ifpstream	: virtual public fpstream, virtual public ifdpstream
{
protected:
public:
  ifpstream();
  ifpstream(char *aname, int aflags = 0, int amode = 0644);
};

class	ofpstream	: virtual public fpstream, virtual public ofdpstream
{
protected:
public:
  ofpstream();
  ofpstream(char *aname, int aflags = xxcreat, int amode = 0644);
};

class	iofpstream	: virtual public ifpstream, virtual public ofpstream
{
protected:
public:
  iofpstream();
  iofpstream(char *aname, int aflags = xxcreat, int amode = 0644);
};

#endif

