/* pios.hh
 * Written by Joshua Rowe
 * Really cool persistent object stream library
 */

#ifndef	__PIOS_HH__
#define	__PIOS_HH__

#ifndef	pvoid
typedef	void *	pvoid;
#endif

class	pstream;
class	opstream;
class	ipstream;
class	pstreamed;
class	pstreamable;
class	pstreamreg;
class	pstreambuf;

typedef	pstreamable * (*BUILDER)();

enum	pstreamableInit
{
  pstreamableinit
};

class	pstream
{
protected:
  pstreambuf *	buf;
  int		curid;
  int		err;
  int		flags;
  pstreamed *	streamed;
public:
  enum	psFlags {
    xxclose	= 0x0001,
    xxread	= 0x0002,
    xxwrite	= 0x0004,
    xxtrunc	= 0x0008,
    xxexcl	= 0x0010,
    xxcreat	= 0x0020,
    xxappen	= 0x0040,
    xxkill	= 0x0080
    };
  enum	ptTypes {
      ptNULL,
      ptIndex,
      ptObject
    };
  enum	peError {
      peNULL,
      peNotRegistered,
      peNoBuffer
    };
  pstream(pstreambuf *abuf = 0, int aflags = 0);
  virtual	~pstream();
  void		addstreamed(pstreamable *obj);
  void		close();
  void		error(int aerror);
  int		error();
  int		lookup(pvoid q); // Look up an already written object by
				  // its pointer.
  pstreamed *	lookup(int id);	  // Look up an already read object
				  // by its id number
  int		operator !();	  // Returns err
};

class	opstream	: virtual public pstream
{
protected:
public:
  opstream(pstreambuf *abuf = 0, int aflags = 0);
  void		writebyte(char c);
  virtual void	writebytes(pvoid d, int l);
  void		writeint(int i);
  void		writeobj(pstreamable *obj);
  void		writestring(char *s);
friend	opstream &	operator <<(opstream &os, char c);
friend	opstream &	operator <<(opstream &os, char * s);
friend	opstream &	operator <<(opstream &os, short c);
friend	opstream &	operator <<(opstream &os, int c);
friend	opstream &	operator <<(opstream &os, long c);
friend	opstream &	operator <<(opstream &os, float c);
friend	opstream &	operator <<(opstream &os, double c);
friend	opstream &	operator <<(opstream &os, pstreamable &x);
friend	opstream &	operator <<(opstream &os, pstreamable *x);
};

class	ipstream	: virtual public pstream
{
protected:
public:	
  ipstream(pstreambuf *abuf = 0, int aflags = 0);
  char		readbyte();
  virtual pvoid	readbytes(pvoid d, int l);
  int		readint();
  pvoid		readobj(pstreamreg *d, pstreamable *m);
  char *	readstring();
friend	ipstream &	operator >>(ipstream &os, char &c);
friend	ipstream &	operator >>(ipstream &os, char * &s);
friend	ipstream &	operator >>(ipstream &os, short &c);
friend	ipstream &	operator >>(ipstream &os, int &c);
friend	ipstream &	operator >>(ipstream &os, long &c);
friend	ipstream &	operator >>(ipstream &os, float &c);
friend	ipstream &	operator >>(ipstream &os, double &c);
friend	ipstream &	operator >>(ipstream &os, pstreamable &x);
friend	ipstream &	operator >>(ipstream &os, pvoid &x);
};

class	pstreamed
{
friend	opstream &	operator <<(opstream &os, pstreamable &x);
friend	opstream &	operator <<(opstream &os, pstreamable *x);
friend	ipstream &	operator >>(ipstream &os, pstreamable &x);
friend	ipstream &	operator >>(ipstream &os, pvoid &x);
friend class	pstream;
friend class	ipstream;
friend class	opstream;
protected:
  int		id;
  pstreamed *	next;
  pvoid		p;
  pstreamed(int aid, pstreamed * anext, pvoid ap);
};

class	pstreamable
{
  friend class	opstream;
  friend class	ipstream;
  virtual char *	streamableName() const	= 0;
protected:
  virtual pvoid		read(ipstream &os)	= 0;
  virtual void		write(opstream &os)	= 0;
public:
  pstreamable();
  pstreamable(pstreamableInit);
};

class	pstreamreg
{
  friend class	opstream;
  friend class	ipstream;
protected:
  char *	name;
  pstreamreg *	next;
  BUILDER	builder;
  int		delta;
public:
  pstreamreg(char * aname, BUILDER abuilder, int adelta);
  static pstreamreg *	findclass(char * aname);
};

class	pstreambuf
{
friend class	pstream;
friend class	opstream;
friend class	ipstream;
protected:
  int		err;
  int		flags;
public:
  pstreambuf(int aflags = 0);
  virtual	~pstreambuf();
  virtual void	close();
  int		error();
  void		error(int aerror);
  virtual pvoid	read(pvoid d, int l)	= 0;
  virtual void	write(pvoid d, int l)	= 0;
};

#define	__PSTREAM_LINK(t)	extern pstreamreg t;
#define	__PSTREAM_DELTA(d)	(int((pstreamable *)(d *)1) - 1)

#endif				// __PIOS_HH__

