// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of Common C++.
// 
// The exception is that, if you link the Common C++ library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the Common C++ library code into it.
//
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
//
// This exception applies only to the code released under the 
// name Common C++.  If you copy code from other releases into a copy of
// Common C++, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for Common C++, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "config.h"
#include "macros.h"
#include "thread.h"
#include "socket.h"
#include <errno.h>

#ifndef	O_NONBLOCK
#define	O_NONBLOCK	O_NDELAY
#endif

UDPTransmit::UDPTransmit(const InetAddress &ia, tpport_t port) : 
UDPSocket(ia, port)
{
	Disconnect();	// assure not started live
	shutdown(so, 0);
}

UDPTransmit::UDPTransmit() : UDPSocket()
{
	Disconnect();
	shutdown(so, 0);
}

sockerror_t UDPTransmit::Connect(const InetHostAddress &ia, tpport_t port)
{
	int len = sizeof(peer);

	if(isBroadcast())
		setBroadcast(false);

	peer.sin_family = AF_INET;
	peer.sin_addr = getaddress(ia);
	peer.sin_port = htons(port);
	if(connect(so, (sockaddr *)&peer, len))
		return connectError();
	return SOCKET_SUCCESS;
}

sockerror_t UDPTransmit::Connect(const BroadcastAddress &subnet, tpport_t  port)
{
	int len = sizeof(peer);

	if(!isBroadcast())
		setBroadcast(true);

	peer.sin_family = AF_INET;
	peer.sin_addr = getaddress(subnet);
	peer.sin_port = htons(port);
	if(connect(so, (sockaddr *)&peer, len))
		return connectError();
	return SOCKET_SUCCESS;
}

#ifdef	AF_UNSPEC
sockerror_t UDPTransmit::Disconnect(void)
{
	struct sockaddr_in addr;
	int len = sizeof(addr);

	memset(&addr, 0, len);
	addr.sin_family = AF_UNSPEC;
	if(connect(so, (sockaddr *)&addr, len))
		return connectError();
	return SOCKET_SUCCESS;
}
#else
sockerror_t UDPTransmit::Disconnect(void)
{
	return Connect(getLocal());
}
#endif

UDPReceive::UDPReceive(const InetAddress &ia, tpport_t port) : 
UDPSocket(ia, port)
{
	shutdown(so, 1);
}

sockerror_t UDPReceive::Connect(const InetHostAddress &ia, tpport_t port)
{
	int len = sizeof(peer);

	peer.sin_family = AF_INET;
	peer.sin_addr = getaddress(ia);
	peer.sin_port = htons(port);
	if(connect(so, (sockaddr *)&peer, len))
		return connectError();
	return SOCKET_SUCCESS;
}

#ifdef	AF_UNSPEC
sockerror_t UDPReceive::Disconnect(void)
{
	struct sockaddr_in addr;
	int len = sizeof(addr);

	memset(&addr, 0, len);
	addr.sin_family = AF_UNSPEC;
	if(connect(so, (sockaddr *)&addr, len))
		return connectError();
	return SOCKET_SUCCESS;
}
#else
sockerror_t UDPReceive::Disconnect(void)
{
	return Connect(getLocal());
}
#endif

UDPDuplex::UDPDuplex(const InetAddress &bind, tpport_t port) :
UDPTransmit(bind, port + 1), UDPReceive(bind, port)
{};

sockerror_t UDPDuplex::Connect(const InetHostAddress &host, tpport_t port)
{
	sockerror_t rtn = UDPTransmit::Connect(host, port);
	if(rtn)
	{
		UDPTransmit::Disconnect();
		UDPReceive::Disconnect();
		return rtn;
	}
	return UDPReceive::Connect(host, port + 1);
}

sockerror_t UDPDuplex::Disconnect(void)
{
	sockerror_t rtn = UDPTransmit::Disconnect();
	return UDPReceive::Disconnect();
}

