/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.check;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.management.NodeInfo;
import org.apache.activemq.artemis.cli.commands.check.CheckAbstract;
import org.apache.activemq.artemis.cli.commands.check.CheckContext;
import org.apache.activemq.artemis.cli.commands.check.CheckException;
import org.apache.activemq.artemis.cli.commands.check.CheckTask;

@Command(name="node", description="Check a node")
public class NodeCheck
extends CheckAbstract {
    @Option(name={"--up"}, description="Check that the node is started, it is executed by default if there are no other checks")
    private boolean up;
    @Option(name={"--diskUsage"}, description="Disk usage percentage to check or -1 to use the max-disk-usage")
    private Integer diskUsage;
    @Option(name={"--memoryUsage"}, description="Memory usage percentage to check")
    private Integer memoryUsage;
    @Option(name={"--live"}, description="Check that the node has a live")
    private boolean live;
    @Option(name={"--backup"}, description="Check that the node has a backup")
    private boolean backup;
    @Option(name={"--peers"}, description="Number of peers to check")
    private Integer peers;

    public boolean isUp() {
        return this.up;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public Integer getDiskUsage() {
        return this.diskUsage;
    }

    public void setDiskUsage(Integer diskUsage) {
        this.diskUsage = diskUsage;
    }

    public Integer getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(Integer memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public Integer getPeers() {
        return this.peers;
    }

    public void setPeers(Integer peers) {
        this.peers = peers;
    }

    @Override
    protected CheckTask[] getCheckTasks() {
        ArrayList<CheckTask> checkTasks = new ArrayList<CheckTask>();
        if (this.live) {
            checkTasks.add(new CheckTask("the node has a live", this::checkNodeLive));
        }
        if (this.backup) {
            checkTasks.add(new CheckTask("the node has a backup", this::checkNodeBackup));
        }
        if (this.peers != null) {
            if (this.peers > 0) {
                checkTasks.add(new CheckTask(String.format("there are %d peers", this.peers), this::checkNodePeers));
            } else {
                throw new IllegalArgumentException("Invalid peers number to check: " + this.peers);
            }
        }
        if (this.diskUsage != null) {
            if (this.diskUsage == -1) {
                checkTasks.add(new CheckTask("the disk usage is less then the max-disk-usage", this::checkNodeDiskUsage));
            } else if (this.diskUsage > 0 && this.diskUsage < 100) {
                checkTasks.add(new CheckTask("the disk usage is less then " + this.diskUsage, this::checkNodeDiskUsage));
            } else {
                throw new IllegalArgumentException("Invalid disk usage percentage: " + this.diskUsage);
            }
        }
        if (this.memoryUsage != null) {
            if (this.memoryUsage > 0 && this.memoryUsage < 100) {
                checkTasks.add(new CheckTask("the memory usage is less then " + this.memoryUsage, this::checkNodeMemoryUsage));
            } else {
                throw new IllegalArgumentException("Invalid memory usage percentage: " + this.memoryUsage);
            }
        }
        if (this.up || checkTasks.size() == 0) {
            checkTasks.add(0, new CheckTask("the node is started", this::checkNodeUp));
        }
        return checkTasks.toArray(new CheckTask[checkTasks.size()]);
    }

    private void checkNodeUp(CheckContext context) throws Exception {
        if (!((Boolean)context.getManagementProxy().invokeOperation(Boolean.class, "broker", "isStarted", new Object[0])).booleanValue()) {
            throw new CheckException("The node isn't started.");
        }
    }

    private void checkNodeLive(CheckContext context) throws Exception {
        NodeInfo node;
        String nodeId = this.getName();
        if (nodeId == null) {
            nodeId = context.getNodeId();
        }
        if ((node = context.getTopology().get(nodeId)) == null || node.getLive() == null) {
            throw new CheckException("No live found for the node " + nodeId);
        }
    }

    private void checkNodeBackup(CheckContext context) throws Exception {
        NodeInfo node;
        String nodeId = this.getName();
        if (nodeId == null) {
            nodeId = context.getNodeId();
        }
        if ((node = context.getTopology().get(nodeId)) == null || node.getBackup() == null) {
            throw new CheckException("No backup found for the node " + nodeId);
        }
    }

    private void checkNodePeers(CheckContext context) throws Exception {
        int topologyPeers = context.getTopology().values().stream().mapToInt(node -> (node.getLive() != null ? 1 : 0) + (node.getBackup() != null ? 1 : 0)).sum();
        if (topologyPeers < this.peers) {
            throw new CheckException("Insufficient peers: " + this.peers);
        }
    }

    private void checkNodeDiskUsage(CheckContext context) throws Exception {
        int thresholdValue = this.diskUsage == -1 ? ((Integer)context.getManagementProxy().invokeOperation(Integer.TYPE, "broker", "getMaxDiskUsage", new Object[0])).intValue() : this.diskUsage.intValue();
        this.checkNodeUsage(context, "getDiskStoreUsage", thresholdValue);
    }

    private void checkNodeMemoryUsage(CheckContext context) throws Exception {
        this.checkNodeUsage(context, "getAddressMemoryUsagePercentage", this.memoryUsage);
    }

    private void checkNodeUsage(CheckContext context, String name, int thresholdValue) throws Exception {
        int usageValue = (Integer)context.getManagementProxy().invokeOperation(Integer.TYPE, "broker", name, new Object[0]);
        if (usageValue > thresholdValue) {
            throw new CheckException("The " + (name.startsWith("get") ? name.substring(3) : name) + " " + usageValue + " is less than " + thresholdValue);
        }
    }
}

