/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActivationFailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.PostQueueCreationCallback;
import org.apache.activemq.artemis.core.server.PostQueueDeletionCallback;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.federation.FederationManager;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.ConnectorsService;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQPluginRunnable;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBridgePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConnectionPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerCriticalPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerFederationPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerMessagePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerSessionPlugin;
import org.apache.activemq.artemis.core.server.reload.ReloadManager;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;

public interface ActiveMQServer
extends ServiceComponent {
    public void setState(SERVER_STATE var1);

    public SERVER_STATE getState();

    public void setIdentity(String var1);

    public String getIdentity();

    public String describe();

    public void addActivationParam(String var1, Object var2);

    public Configuration getConfiguration();

    public ServiceRegistry getServiceRegistry();

    public RemotingService getRemotingService();

    public StorageManager getStorageManager();

    public PagingManager getPagingManager();

    public PagingManager createPagingManager() throws Exception;

    public ManagementService getManagementService();

    public ActiveMQSecurityManager getSecurityManager();

    public NetworkHealthCheck getNetworkHealthCheck();

    public Version getVersion();

    public NodeManager getNodeManager();

    public CriticalAnalyzer getCriticalAnalyzer();

    public ReplicationEndpoint getReplicationEndpoint();

    public void unlockActivation();

    public void lockActivation();

    public ActiveMQServerControlImpl getActiveMQServerControl();

    public void registerActivateCallback(ActivateCallback var1);

    public void unregisterActivateCallback(ActivateCallback var1);

    public void registerActivationFailureListener(ActivationFailureListener var1);

    public void unregisterActivationFailureListener(ActivationFailureListener var1);

    public void callActivationFailureListeners(Exception var1);

    public void registerPostQueueCreationCallback(PostQueueCreationCallback var1);

    public void unregisterPostQueueCreationCallback(PostQueueCreationCallback var1);

    public void callPostQueueCreationCallbacks(SimpleString var1) throws Exception;

    public void registerPostQueueDeletionCallback(PostQueueDeletionCallback var1);

    public void unregisterPostQueueDeletionCallback(PostQueueDeletionCallback var1);

    public void callPostQueueDeletionCallbacks(SimpleString var1, SimpleString var2) throws Exception;

    public void registerBrokerPlugin(ActiveMQServerBasePlugin var1);

    public void unRegisterBrokerPlugin(ActiveMQServerBasePlugin var1);

    public void registerBrokerPlugins(List<ActiveMQServerBasePlugin> var1);

    public List<ActiveMQServerBasePlugin> getBrokerPlugins();

    public List<ActiveMQServerConnectionPlugin> getBrokerConnectionPlugins();

    public List<ActiveMQServerSessionPlugin> getBrokerSessionPlugins();

    public List<ActiveMQServerConsumerPlugin> getBrokerConsumerPlugins();

    public List<ActiveMQServerAddressPlugin> getBrokerAddressPlugins();

    public List<ActiveMQServerQueuePlugin> getBrokerQueuePlugins();

    public List<ActiveMQServerBindingPlugin> getBrokerBindingPlugins();

    public List<ActiveMQServerMessagePlugin> getBrokerMessagePlugins();

    public List<ActiveMQServerBridgePlugin> getBrokerBridgePlugins();

    public List<ActiveMQServerCriticalPlugin> getBrokerCriticalPlugins();

    public List<ActiveMQServerFederationPlugin> getBrokerFederationPlugins();

    public void callBrokerPlugins(ActiveMQPluginRunnable var1) throws ActiveMQException;

    public void callBrokerConnectionPlugins(ActiveMQPluginRunnable<ActiveMQServerConnectionPlugin> var1) throws ActiveMQException;

    public void callBrokerSessionPlugins(ActiveMQPluginRunnable<ActiveMQServerSessionPlugin> var1) throws ActiveMQException;

    public void callBrokerConsumerPlugins(ActiveMQPluginRunnable<ActiveMQServerConsumerPlugin> var1) throws ActiveMQException;

    public void callBrokerAddressPlugins(ActiveMQPluginRunnable<ActiveMQServerAddressPlugin> var1) throws ActiveMQException;

    public void callBrokerQueuePlugins(ActiveMQPluginRunnable<ActiveMQServerQueuePlugin> var1) throws ActiveMQException;

    public void callBrokerBindingPlugins(ActiveMQPluginRunnable<ActiveMQServerBindingPlugin> var1) throws ActiveMQException;

    public void callBrokerMessagePlugins(ActiveMQPluginRunnable<ActiveMQServerMessagePlugin> var1) throws ActiveMQException;

    public void callBrokerBridgePlugins(ActiveMQPluginRunnable<ActiveMQServerBridgePlugin> var1) throws ActiveMQException;

    public void callBrokerCriticalPlugins(ActiveMQPluginRunnable<ActiveMQServerCriticalPlugin> var1) throws ActiveMQException;

    public void callBrokerFederationPlugins(ActiveMQPluginRunnable<ActiveMQServerFederationPlugin> var1) throws ActiveMQException;

    public boolean hasBrokerPlugins();

    public boolean hasBrokerConnectionPlugins();

    public boolean hasBrokerSessionPlugins();

    public boolean hasBrokerConsumerPlugins();

    public boolean hasBrokerAddressPlugins();

    public boolean hasBrokerQueuePlugins();

    public boolean hasBrokerBindingPlugins();

    public boolean hasBrokerMessagePlugins();

    public boolean hasBrokerBridgePlugins();

    public boolean hasBrokerCriticalPlugins();

    public boolean hasBrokerFederationPlugins();

    public void checkQueueCreationLimit(String var1) throws Exception;

    public ServerSession createSession(String var1, String var2, String var3, int var4, RemotingConnection var5, boolean var6, boolean var7, boolean var8, boolean var9, String var10, SessionCallback var11, boolean var12, OperationContext var13, Map<SimpleString, RoutingType> var14, String var15) throws Exception;

    public SecurityStore getSecurityStore();

    public void removeSession(String var1) throws Exception;

    public Set<ServerSession> getSessions();

    public HierarchicalRepository<Set<Role>> getSecurityRepository();

    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository();

    public OperationContext newOperationContext();

    public int getConnectionCount();

    public long getTotalConnectionCount();

    public long getTotalMessageCount();

    public long getTotalMessagesAdded();

    public long getTotalMessagesAcknowledged();

    public long getTotalConsumerCount();

    public PostOffice getPostOffice();

    public void clearAddressCache();

    public QueueFactory getQueueFactory();

    public ResourceManager getResourceManager();

    public MetricsManager getMetricsManager();

    public List<ServerSession> getSessions(String var1);

    public ServerSession lookupSession(String var1, String var2);

    public ClusterManager getClusterManager();

    public SimpleString getNodeID();

    public boolean isActive();

    public String getUptime();

    public long getUptimeMillis();

    public boolean isReplicaSync();

    public boolean waitForActivation(long var1, TimeUnit var3) throws InterruptedException;

    @Deprecated
    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6) throws Exception;

    @Deprecated
    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10) throws Exception;

    @Deprecated
    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, SimpleString var13, boolean var14, int var15, long var16, boolean var18, long var19, long var21) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, SimpleString var13, boolean var14, int var15, long var16, boolean var18, long var19, long var21, boolean var23) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10, int var11, SimpleString var12, boolean var13, SimpleString var14, boolean var15, int var16, long var17, boolean var19, long var20, long var22, boolean var24) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10, int var11, SimpleString var12, boolean var13, SimpleString var14, boolean var15, int var16, long var17, boolean var19, long var20, long var22, boolean var24, long var25) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, Integer var9, Boolean var10, boolean var11) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, boolean var7, Integer var8, Boolean var9, boolean var10) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, boolean var7, Integer var8, Boolean var9, Boolean var10, Boolean var11, boolean var12) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, boolean var7, Integer var8, Boolean var9, Boolean var10, Boolean var11, Integer var12, Boolean var13, SimpleString var14, Boolean var15, Integer var16, Long var17, Boolean var18, Long var19, Long var20, boolean var21) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, boolean var7, Integer var8, Boolean var9, Boolean var10, Boolean var11, Integer var12, SimpleString var13, Boolean var14, SimpleString var15, Boolean var16, Integer var17, Long var18, Boolean var19, Long var20, Long var21, boolean var22) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, boolean var7, Integer var8, Boolean var9, Boolean var10, Boolean var11, Integer var12, SimpleString var13, Boolean var14, SimpleString var15, Boolean var16, Integer var17, Long var18, Boolean var19, Long var20, Long var21, boolean var22, Long var23) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13, boolean var14, boolean var15) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13, boolean var14, int var15, boolean var16, SimpleString var17, boolean var18, int var19, long var20, boolean var22, long var23, long var25, boolean var27) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13, boolean var14, int var15, SimpleString var16, boolean var17, SimpleString var18, boolean var19, int var20, long var21, boolean var23, long var24, long var26, boolean var28) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13, boolean var14, int var15, SimpleString var16, boolean var17, SimpleString var18, boolean var19, int var20, long var21, boolean var23, long var24, long var26, boolean var28, long var29) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    @Deprecated
    public Queue deployQueue(String var1, String var2, String var3, boolean var4, boolean var5) throws Exception;

    @Deprecated
    public Queue deployQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public Queue createQueue(QueueConfiguration var1) throws Exception;

    public Queue createQueue(QueueConfiguration var1, boolean var2) throws Exception;

    public void createSharedQueue(QueueConfiguration var1) throws Exception;

    @Deprecated
    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10, int var11, SimpleString var12, boolean var13, SimpleString var14, boolean var15, int var16, long var17, boolean var19, long var20, long var22) throws Exception;

    public Queue locateQueue(SimpleString var1);

    default public Queue locateQueue(String queueName) {
        return this.locateQueue(SimpleString.toSimpleString((String)queueName));
    }

    default public BindingQueryResult bindingQuery(SimpleString address) throws Exception {
        return this.bindingQuery(address, true);
    }

    public BindingQueryResult bindingQuery(SimpleString var1, boolean var2) throws Exception;

    public QueueQueryResult queueQuery(SimpleString var1) throws Exception;

    public AddressQueryResult addressQuery(SimpleString var1) throws Exception;

    public void destroyQueue(SimpleString var1) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2, boolean var3) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2, boolean var3, boolean var4) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2, boolean var3, boolean var4, boolean var5) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2, boolean var3, boolean var4, boolean var5, boolean var6) throws Exception;

    public String destroyConnectionWithSessionMetadata(String var1, String var2) throws Exception;

    public ScheduledExecutorService getScheduledPool();

    public ExecutorFactory getExecutorFactory();

    public ExecutorFactory getIOExecutorFactory();

    public void setGroupingHandler(GroupingHandler var1);

    public GroupingHandler getGroupingHandler();

    public ReplicationManager getReplicationManager();

    public FederationManager getFederationManager();

    public Divert deployDivert(DivertConfiguration var1) throws Exception;

    public Divert updateDivert(DivertConfiguration var1) throws Exception;

    public void destroyDivert(SimpleString var1) throws Exception;

    public ConnectorsService getConnectorsService();

    public void deployBridge(BridgeConfiguration var1) throws Exception;

    public void destroyBridge(String var1) throws Exception;

    public void deployFederation(FederationConfiguration var1) throws Exception;

    public void undeployFederation(String var1) throws Exception;

    public ServerSession getSessionByID(String var1);

    public void threadDump();

    public boolean isAddressBound(String var1) throws Exception;

    public void fail(boolean var1) throws Exception;

    public void stop(boolean var1, boolean var2) throws Exception;

    @Deprecated
    public Queue updateQueue(String var1, RoutingType var2, Integer var3, Boolean var4) throws Exception;

    @Deprecated
    public Queue updateQueue(String var1, RoutingType var2, Integer var3, Boolean var4, Boolean var5) throws Exception;

    @Deprecated
    public Queue updateQueue(String var1, RoutingType var2, Integer var3, Boolean var4, Boolean var5, String var6) throws Exception;

    @Deprecated
    public Queue updateQueue(String var1, RoutingType var2, String var3, Integer var4, Boolean var5, Boolean var6, Boolean var7, Integer var8, Boolean var9, Integer var10, Long var11, String var12) throws Exception;

    @Deprecated
    public Queue updateQueue(String var1, RoutingType var2, String var3, Integer var4, Boolean var5, Boolean var6, Boolean var7, Integer var8, String var9, Boolean var10, Integer var11, Long var12, String var13) throws Exception;

    @Deprecated
    public Queue updateQueue(String var1, RoutingType var2, String var3, Integer var4, Boolean var5, Boolean var6, Boolean var7, Integer var8, String var9, Boolean var10, Integer var11, Long var12, String var13, Long var14) throws Exception;

    public Queue updateQueue(QueueConfiguration var1) throws Exception;

    public Queue updateQueue(QueueConfiguration var1, boolean var2) throws Exception;

    public void addProtocolManagerFactory(ProtocolManagerFactory var1);

    public void removeProtocolManagerFactory(ProtocolManagerFactory var1);

    public ReloadManager getReloadManager();

    public ActiveMQServer createBackupServer(Configuration var1);

    public void addScaledDownNode(SimpleString var1);

    public boolean hasScaledDown(SimpleString var1);

    public Activation getActivation();

    public HAPolicy getHAPolicy();

    public void setHAPolicy(HAPolicy var1);

    public void setMBeanServer(MBeanServer var1);

    public void addExternalComponent(ActiveMQComponent var1);

    public List<ActiveMQComponent> getExternalComponents();

    public boolean addClientConnection(String var1, boolean var2);

    public void removeClientConnection(String var1);

    public Executor getThreadPool();

    public AddressInfo getAddressInfo(SimpleString var1);

    public boolean updateAddressInfo(SimpleString var1, EnumSet<RoutingType> var2) throws Exception;

    @Deprecated
    public boolean updateAddressInfo(SimpleString var1, Collection<RoutingType> var2) throws Exception;

    public boolean addAddressInfo(AddressInfo var1) throws Exception;

    public AddressInfo addOrUpdateAddressInfo(AddressInfo var1) throws Exception;

    public void removeAddressInfo(SimpleString var1, SecurityAuth var2) throws Exception;

    public void removeAddressInfo(SimpleString var1, SecurityAuth var2, boolean var3) throws Exception;

    public String getInternalNamingPrefix();

    public double getDiskStoreUsage();

    public static enum SERVER_STATE {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

