/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingConsumer<V> {
    public void process(V var1) throws Exception;

    public static <T> Consumer<T> asUnchecked(ThrowingConsumer<T> consumer) {
        return input -> {
            try {
                consumer.process(input);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException((Throwable)e);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException((Throwable)e);
            }
        };
    }
}

