/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.BTreeJobGenParams;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.util.LogRedactionUtil;

public class BTreeAccessMethod
implements IAccessMethod {
    private static final List<Pair<FunctionIdentifier, Boolean>> FUNC_IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(new Pair((Object)AlgebricksBuiltinFunctions.EQ, (Object)false), new Pair((Object)AlgebricksBuiltinFunctions.LE, (Object)false), new Pair((Object)AlgebricksBuiltinFunctions.GE, (Object)false), new Pair((Object)AlgebricksBuiltinFunctions.LT, (Object)false), new Pair((Object)AlgebricksBuiltinFunctions.GT, (Object)false)));
    public static final BTreeAccessMethod INSTANCE = new BTreeAccessMethod();

    @Override
    public List<Pair<FunctionIdentifier, Boolean>> getOptimizableFunctions() {
        return FUNC_IDENTIFIERS;
    }

    @Override
    public boolean analyzeFuncExprArgsAndUpdateAnalysisCtx(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        boolean matches = AccessMethodUtils.analyzeFuncExprArgsForOneConstAndVarAndUpdateAnalysisCtx(funcExpr, analysisCtx, context, typeEnvironment);
        if (!matches) {
            matches = AccessMethodUtils.analyzeFuncExprArgsForTwoVarsAndUpdateAnalysisCtx(funcExpr, analysisCtx);
        }
        return matches;
    }

    @Override
    public boolean matchAllIndexExprs(Index index) {
        return index.getKeyFieldTypes().size() > 1 && this.hasUnknownableField(index);
    }

    @Override
    public boolean matchPrefixIndexExprs(Index index) {
        return !this.matchAllIndexExprs(index);
    }

    private boolean hasUnknownableField(Index index) {
        if (index.isSecondaryIndex() && index.isOverridingKeyFieldTypes() && !index.isEnforced()) {
            return true;
        }
        for (IAType fieldType : index.getKeyFieldTypes()) {
            if (!NonTaggedFormatUtil.isOptional((IAType)fieldType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean applySelectPlanTransformation(List<Mutable<ILogicalOperator>> afterSelectRefs, Mutable<ILogicalOperator> selectRef, OptimizableOperatorSubTree subTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context) throws AlgebricksException {
        SelectOperator selectOp = (SelectOperator)selectRef.getValue();
        Mutable conditionRef = selectOp.getCondition();
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)conditionRef.getValue();
        Mutable<ILogicalOperator> assignBeforeSelectOpRef = subTree.getAssignsAndUnnestsRefs().isEmpty() ? null : subTree.getAssignsAndUnnestsRefs().get(0);
        ILogicalOperator assignBeforeSelectOp = null;
        if (assignBeforeSelectOpRef != null) {
            assignBeforeSelectOp = (ILogicalOperator)assignBeforeSelectOpRef.getValue();
        }
        Dataset dataset = subTree.getDataset();
        boolean isIndexOnlyPlan = false;
        boolean requireVerificationAfterSIdxSearch = false;
        Pair<Boolean, Boolean> functionFalsePositiveCheck = AccessMethodUtils.canFunctionGenerateFalsePositiveResultsUsingIndex(funcExpr, FUNC_IDENTIFIERS);
        if (!((Boolean)functionFalsePositiveCheck.first).booleanValue()) {
            return false;
        }
        requireVerificationAfterSIdxSearch = (Boolean)functionFalsePositiveCheck.second;
        Quadruple indexOnlyPlanInfo = new Quadruple((Object)isIndexOnlyPlan, (Object)false, (Object)requireVerificationAfterSIdxSearch, (Object)false);
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL && !chosenIndex.isPrimaryIndex()) {
            AccessMethodUtils.indexOnlyPlanCheck(afterSelectRefs, selectRef, subTree, null, chosenIndex, analysisCtx, context, (Quadruple<Boolean, Boolean, Boolean, Boolean>)indexOnlyPlanInfo);
            isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
        }
        analysisCtx.setIndexOnlyPlanInfo((Quadruple<Boolean, Boolean, Boolean, Boolean>)indexOnlyPlanInfo);
        ILogicalOperator primaryIndexUnnestOp = this.createIndexSearchPlan(afterSelectRefs, selectRef, (Mutable<ILogicalExpression>)conditionRef, subTree.getAssignsAndUnnestsRefs(), subTree, null, chosenIndex, analysisCtx, AccessMethodUtils.retainInputs(subTree.getDataSourceVariables(), (ILogicalOperator)subTree.getDataSourceRef().getValue(), afterSelectRefs), false, ((ILogicalOperator)((Mutable)((ILogicalOperator)subTree.getDataSourceRef().getValue()).getInputs().get(0)).getValue()).getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED, context, null);
        if (primaryIndexUnnestOp == null) {
            return false;
        }
        if (conditionRef.getValue() != null) {
            if (assignBeforeSelectOp != null) {
                if (isIndexOnlyPlan && dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                    ILogicalOperator dataSourceRefOp = AccessMethodUtils.findDataSourceFromIndexUtilizationPlan(primaryIndexUnnestOp);
                    if (dataSourceRefOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
                        subTree.getDataSourceRef().setValue((Object)dataSourceRefOp);
                    }
                    selectRef.setValue((Object)primaryIndexUnnestOp);
                } else {
                    selectOp.getInputs().clear();
                    subTree.getDataSourceRef().setValue((Object)primaryIndexUnnestOp);
                    selectOp.getInputs().add(new MutableObject((Object)assignBeforeSelectOp));
                }
            } else {
                selectOp.getInputs().clear();
                selectOp.getInputs().add(new MutableObject((Object)primaryIndexUnnestOp));
            }
        } else {
            ((AbstractLogicalOperator)primaryIndexUnnestOp).setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            if (assignBeforeSelectOp != null) {
                subTree.getDataSourceRef().setValue((Object)primaryIndexUnnestOp);
                selectRef.setValue((Object)assignBeforeSelectOp);
            } else {
                selectRef.setValue((Object)primaryIndexUnnestOp);
            }
        }
        return true;
    }

    @Override
    public boolean applyJoinPlanTransformation(List<Mutable<ILogicalOperator>> afterJoinRefs, Mutable<ILogicalOperator> joinRef, OptimizableOperatorSubTree leftSubTree, OptimizableOperatorSubTree rightSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, boolean isLeftOuterJoin, boolean isLeftOuterJoinWithSpecialGroupBy) throws AlgebricksException {
        boolean canContinue;
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)joinRef.getValue();
        Mutable conditionRef = joinOp.getCondition();
        AbstractFunctionCallExpression funcExpr = null;
        if (((ILogicalExpression)conditionRef.getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            funcExpr = (AbstractFunctionCallExpression)conditionRef.getValue();
        }
        Dataset dataset = analysisCtx.getIndexDatasetMap().get(chosenIndex);
        OptimizableOperatorSubTree indexSubTree = null;
        OptimizableOperatorSubTree probeSubTree = null;
        if (!rightSubTree.hasDataSourceScan() || !dataset.getDatasetName().equals(rightSubTree.getDataset().getDatasetName())) {
            return false;
        }
        indexSubTree = rightSubTree;
        probeSubTree = leftSubTree;
        LogicalVariable newNullPlaceHolderVar = null;
        if (isLeftOuterJoin) {
            newNullPlaceHolderVar = indexSubTree.getDataSourceVariables().get(0);
        }
        if (!(canContinue = AccessMethodUtils.setIndexOnlyPlanInfo(afterJoinRefs, joinRef, probeSubTree, indexSubTree, chosenIndex, analysisCtx, context, funcExpr, FUNC_IDENTIFIERS))) {
            return false;
        }
        ILogicalOperator indexSearchOp = this.createIndexSearchPlan(afterJoinRefs, joinRef, (Mutable<ILogicalExpression>)conditionRef, indexSubTree.getAssignsAndUnnestsRefs(), indexSubTree, probeSubTree, chosenIndex, analysisCtx, true, isLeftOuterJoin, true, context, newNullPlaceHolderVar);
        if (indexSearchOp == null) {
            return false;
        }
        return AccessMethodUtils.finalizeJoinPlanTransformation(afterJoinRefs, joinRef, indexSubTree, probeSubTree, analysisCtx, context, isLeftOuterJoin, isLeftOuterJoinWithSpecialGroupBy, indexSearchOp, newNullPlaceHolderVar, (Mutable<ILogicalExpression>)conditionRef, dataset);
    }

    @Override
    public ILogicalOperator createIndexSearchPlan(List<Mutable<ILogicalOperator>> afterTopOpRefs, Mutable<ILogicalOperator> topOpRef, Mutable<ILogicalExpression> conditionRef, List<Mutable<ILogicalOperator>> assignBeforeTheOpRefs, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, boolean retainInput, boolean retainMissing, boolean requiresBroadcast, IOptimizationContext context, LogicalVariable newMissingPlaceHolderForLOJ) throws AlgebricksException {
        ILogicalOperator inputOp;
        int i;
        Dataset dataset = indexSubTree.getDataset();
        ARecordType recordType = indexSubTree.getRecordType();
        ARecordType metaRecordType = indexSubTree.getMetaRecordType();
        AbstractDataSourceOperator dataSourceOp = (AbstractDataSourceOperator)indexSubTree.getDataSourceRef().getValue();
        List<Pair<Integer, Integer>> exprAndVarList = analysisCtx.getIndexExprsFromIndexExprsAndVars(chosenIndex);
        int numSecondaryKeys = analysisCtx.getNumberOfMatchedKeys(chosenIndex);
        Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo = analysisCtx.getIndexOnlyPlanInfo();
        boolean isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
        boolean generateInstantTrylockResultFromIndexSearch = false;
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL && isIndexOnlyPlan) {
            generateInstantTrylockResultFromIndexSearch = true;
        }
        HashSet<ILogicalExpression> replacedFuncExprs = new HashSet<ILogicalExpression>();
        ILogicalExpression[] lowKeyExprs = new ILogicalExpression[numSecondaryKeys];
        ILogicalExpression[] highKeyExprs = new ILogicalExpression[numSecondaryKeys];
        LimitType[] lowKeyLimits = new LimitType[numSecondaryKeys];
        LimitType[] highKeyLimits = new LimitType[numSecondaryKeys];
        boolean[] lowKeyInclusive = new boolean[numSecondaryKeys];
        boolean[] highKeyInclusive = new boolean[numSecondaryKeys];
        ILogicalExpression[] lowKeyConstAtRuntimeExpressions = new ILogicalExpression[numSecondaryKeys];
        ILogicalExpression[] highKeyConstantAtRuntimeExpressions = new ILogicalExpression[numSecondaryKeys];
        LogicalVariable[] lowKeyConstAtRuntimeExprVars = new LogicalVariable[numSecondaryKeys];
        LogicalVariable[] highKeyConstAtRuntimeExprVars = new LogicalVariable[numSecondaryKeys];
        boolean couldntFigureOut = false;
        boolean doneWithExprs = false;
        boolean isEqCondition = false;
        BitSet setLowKeys = new BitSet(numSecondaryKeys);
        BitSet setHighKeys = new BitSet(numSecondaryKeys);
        for (Pair<Integer, Integer> exprIndex : exprAndVarList) {
            IOptimizableFuncExpr optFuncExpr = analysisCtx.getMatchedFuncExpr((Integer)exprIndex.first);
            int keyPos = BTreeAccessMethod.indexOf(optFuncExpr.getFieldName(0), optFuncExpr.getFieldSource(0), chosenIndex.getKeyFieldNames(), chosenIndex.getKeyFieldSourceIndicators());
            if (keyPos < 0 && optFuncExpr.getNumLogicalVars() > 1) {
                keyPos = BTreeAccessMethod.indexOf(optFuncExpr.getFieldName(1), optFuncExpr.getFieldSource(1), chosenIndex.getKeyFieldNames(), chosenIndex.getKeyFieldSourceIndicators());
            }
            if (keyPos < 0) {
                throw CompilationException.create((int)1032, (SourceLocation)optFuncExpr.getFuncExpr().getSourceLocation(), (Serializable[])new Serializable[0]);
            }
            IAType indexedFieldType = (IAType)chosenIndex.getKeyFieldTypes().get(keyPos);
            Triple<ILogicalExpression, ILogicalExpression, Boolean> returnedSearchKeyExpr = AccessMethodUtils.createSearchKeyExpr(chosenIndex, optFuncExpr, indexedFieldType, probeSubTree);
            ILogicalExpression searchKeyExpr = (ILogicalExpression)returnedSearchKeyExpr.first;
            ILogicalExpression searchKeyEQExpr = null;
            boolean realTypeConvertedToIntegerType = (Boolean)returnedSearchKeyExpr.third;
            LimitType limit = this.getLimitType(optFuncExpr, probeSubTree);
            if (limit == null) {
                return null;
            }
            if (limit == LimitType.EQUAL && returnedSearchKeyExpr.second != null) {
                searchKeyEQExpr = (ILogicalExpression)returnedSearchKeyExpr.second;
            }
            if (this.relaxLimitTypeToInclusive(chosenIndex, keyPos, realTypeConvertedToIntegerType)) {
                if (limit == LimitType.HIGH_EXCLUSIVE) {
                    limit = LimitType.HIGH_INCLUSIVE;
                } else if (limit == LimitType.LOW_EXCLUSIVE) {
                    limit = LimitType.LOW_INCLUSIVE;
                }
            }
            if (searchKeyExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                LogicalVariable constAtRuntimeExprVar = context.newVar();
                VariableReferenceExpression constAtRuntimeExprVarRef = new VariableReferenceExpression(constAtRuntimeExprVar);
                constAtRuntimeExprVarRef.setSourceLocation(searchKeyExpr.getSourceLocation());
                if (limit == LimitType.LOW_INCLUSIVE || limit == LimitType.LOW_EXCLUSIVE || limit == LimitType.EQUAL) {
                    lowKeyConstAtRuntimeExpressions[keyPos] = searchKeyExpr;
                    lowKeyConstAtRuntimeExprVars[keyPos] = constAtRuntimeExprVar;
                }
                if (limit == LimitType.HIGH_INCLUSIVE || limit == LimitType.HIGH_EXCLUSIVE || limit == LimitType.EQUAL) {
                    highKeyConstantAtRuntimeExpressions[keyPos] = searchKeyExpr;
                    highKeyConstAtRuntimeExprVars[keyPos] = constAtRuntimeExprVar;
                }
                searchKeyExpr = constAtRuntimeExprVarRef;
            }
            switch (limit) {
                case EQUAL: {
                    if (lowKeyLimits[keyPos] == null && highKeyLimits[keyPos] == null) {
                        lowKeyLimits[keyPos] = highKeyLimits[keyPos] = limit;
                        highKeyInclusive[keyPos] = true;
                        lowKeyInclusive[keyPos] = true;
                        if (searchKeyEQExpr == null) {
                            lowKeyExprs[keyPos] = highKeyExprs[keyPos] = searchKeyExpr;
                        } else {
                            lowKeyExprs[keyPos] = searchKeyExpr;
                            highKeyExprs[keyPos] = searchKeyEQExpr;
                        }
                        setLowKeys.set(keyPos);
                        setHighKeys.set(keyPos);
                        isEqCondition = true;
                    } else {
                        if (lowKeyLimits[keyPos] == limit && lowKeyInclusive[keyPos] && lowKeyExprs[keyPos].equals(searchKeyExpr) && highKeyLimits[keyPos] == limit && highKeyInclusive[keyPos] && highKeyExprs[keyPos].equals(searchKeyExpr)) {
                            isEqCondition = true;
                            break;
                        }
                        couldntFigureOut = true;
                    }
                    if (setLowKeys.cardinality() != numSecondaryKeys || setHighKeys.cardinality() != numSecondaryKeys) break;
                    doneWithExprs = true;
                    break;
                }
                case HIGH_EXCLUSIVE: {
                    if (highKeyLimits[keyPos] == null || highKeyLimits[keyPos] != null && highKeyInclusive[keyPos]) {
                        highKeyLimits[keyPos] = limit;
                        highKeyExprs[keyPos] = searchKeyExpr;
                        highKeyInclusive[keyPos] = false;
                        break;
                    }
                    if (highKeyLimits[keyPos] == limit && !highKeyInclusive[keyPos] && highKeyExprs[keyPos].equals(searchKeyExpr)) break;
                    couldntFigureOut = true;
                    doneWithExprs = true;
                    break;
                }
                case HIGH_INCLUSIVE: {
                    if (highKeyLimits[keyPos] == null) {
                        highKeyLimits[keyPos] = limit;
                        highKeyExprs[keyPos] = searchKeyExpr;
                        highKeyInclusive[keyPos] = true;
                        break;
                    }
                    if (highKeyLimits[keyPos] == limit && highKeyInclusive[keyPos] && highKeyExprs[keyPos].equals(searchKeyExpr)) break;
                    couldntFigureOut = true;
                    doneWithExprs = true;
                    break;
                }
                case LOW_EXCLUSIVE: {
                    if (lowKeyLimits[keyPos] == null || lowKeyLimits[keyPos] != null && lowKeyInclusive[keyPos]) {
                        lowKeyLimits[keyPos] = limit;
                        lowKeyExprs[keyPos] = searchKeyExpr;
                        lowKeyInclusive[keyPos] = false;
                        break;
                    }
                    if (lowKeyLimits[keyPos] == limit && !lowKeyInclusive[keyPos] && lowKeyExprs[keyPos].equals(searchKeyExpr)) break;
                    couldntFigureOut = true;
                    doneWithExprs = true;
                    break;
                }
                case LOW_INCLUSIVE: {
                    if (lowKeyLimits[keyPos] == null) {
                        lowKeyLimits[keyPos] = limit;
                        lowKeyExprs[keyPos] = searchKeyExpr;
                        lowKeyInclusive[keyPos] = true;
                        break;
                    }
                    if (lowKeyLimits[keyPos] == limit && lowKeyInclusive[keyPos] && lowKeyExprs[keyPos].equals(searchKeyExpr)) break;
                    couldntFigureOut = true;
                    doneWithExprs = true;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!couldntFigureOut) {
                replacedFuncExprs.add((ILogicalExpression)analysisCtx.getMatchedFuncExpr((Integer)exprIndex.first).getFuncExpr());
            }
            if (!doneWithExprs) continue;
            break;
        }
        if (couldntFigureOut) {
            return null;
        }
        boolean primaryIndexPostProccessingIsNeeded = false;
        for (i = 0; i < numSecondaryKeys - 1; ++i) {
            if (LimitType.EQUAL.equals((Object)lowKeyLimits[i]) && LimitType.EQUAL.equals((Object)highKeyLimits[i])) continue;
            primaryIndexPostProccessingIsNeeded = true;
        }
        for (i = 1; i < lowKeyExprs.length; ++i) {
            if (!(lowKeyLimits[0] == null && lowKeyLimits[i] != null || lowKeyLimits[0] != null && lowKeyLimits[i] == null || highKeyLimits[0] == null && highKeyLimits[i] != null) && (highKeyLimits[0] == null || highKeyLimits[i] != null)) continue;
            numSecondaryKeys = i;
            primaryIndexPostProccessingIsNeeded = true;
            break;
        }
        if (primaryIndexPostProccessingIsNeeded) {
            Arrays.fill(lowKeyInclusive, true);
            Arrays.fill(highKeyInclusive, true);
        }
        if (lowKeyLimits[0] == null) {
            lowKeyInclusive[0] = true;
        }
        if (highKeyLimits[0] == null) {
            highKeyInclusive[0] = true;
        }
        ArrayList<LogicalVariable> keyVarList = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> assignKeyVarList = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> assignKeyExprList = new ArrayList<Mutable<ILogicalExpression>>();
        int numLowKeys = this.createKeyVarsAndExprs(numSecondaryKeys, lowKeyLimits, lowKeyExprs, assignKeyVarList, assignKeyExprList, keyVarList, context, lowKeyConstAtRuntimeExpressions, lowKeyConstAtRuntimeExprVars);
        int numHighKeys = this.createKeyVarsAndExprs(numSecondaryKeys, highKeyLimits, highKeyExprs, assignKeyVarList, assignKeyExprList, keyVarList, context, highKeyConstantAtRuntimeExpressions, highKeyConstAtRuntimeExprVars);
        BTreeJobGenParams jobGenParams = new BTreeJobGenParams(chosenIndex.getIndexName(), DatasetConfig.IndexType.BTREE, dataset.getDataverseName(), dataset.getDatasetName(), retainInput, requiresBroadcast);
        jobGenParams.setLowKeyInclusive(lowKeyInclusive[primaryIndexPostProccessingIsNeeded ? 0 : numSecondaryKeys - 1]);
        jobGenParams.setHighKeyInclusive(highKeyInclusive[primaryIndexPostProccessingIsNeeded ? 0 : numSecondaryKeys - 1]);
        jobGenParams.setIsEqCondition(isEqCondition);
        jobGenParams.setLowKeyVarList(keyVarList, 0, numLowKeys);
        jobGenParams.setHighKeyVarList(keyVarList, numLowKeys, numHighKeys);
        if (!assignKeyVarList.isEmpty()) {
            AssignOperator assignSearchKeys = new AssignOperator(assignKeyVarList, assignKeyExprList);
            assignSearchKeys.setSourceLocation(dataSourceOp.getSourceLocation());
            if (probeSubTree == null) {
                assignSearchKeys.getInputs().add(new MutableObject((Object)OperatorManipulationUtil.deepCopy((ILogicalOperator)((ILogicalOperator)((Mutable)dataSourceOp.getInputs().get(0)).getValue()))));
                assignSearchKeys.setExecutionMode(dataSourceOp.getExecutionMode());
            } else {
                assignSearchKeys.getInputs().add(probeSubTree.getRootRef());
                assignSearchKeys.setExecutionMode(((ILogicalOperator)probeSubTree.getRootRef().getValue()).getExecutionMode());
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignSearchKeys);
            inputOp = assignSearchKeys;
        } else if (probeSubTree == null) {
            ILogicalOperator checkOp = (ILogicalOperator)((Mutable)dataSourceOp.getInputs().get(0)).getValue();
            while (checkOp.getExecutionMode() != AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) {
                if (checkOp.getInputs().size() == 1) {
                    checkOp = (ILogicalOperator)((Mutable)checkOp.getInputs().get(0)).getValue();
                    continue;
                }
                return null;
            }
            inputOp = (ILogicalOperator)((Mutable)dataSourceOp.getInputs().get(0)).getValue();
        } else {
            inputOp = probeSubTree.getRoot();
        }
        ILogicalOperator secondaryIndexUnnestOp = AccessMethodUtils.createSecondaryIndexUnnestMap(dataset, recordType, metaRecordType, chosenIndex, inputOp, jobGenParams, context, retainInput, retainMissing, generateInstantTrylockResultFromIndexSearch);
        ILogicalOperator indexSearchOp = null;
        boolean isPrimaryIndex = chosenIndex.isPrimaryIndex();
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            UnnestMapOperator externalDataAccessOp = AccessMethodUtils.createExternalDataLookupUnnestMap(dataSourceOp, dataset, recordType, metaRecordType, secondaryIndexUnnestOp, context, chosenIndex, retainInput, retainMissing);
            indexSubTree.getDataSourceRef().setValue((Object)externalDataAccessOp);
            return externalDataAccessOp;
        }
        if (!isPrimaryIndex) {
            indexSearchOp = AccessMethodUtils.createRestOfIndexSearchPlan(afterTopOpRefs, topOpRef, conditionRef, assignBeforeTheOpRefs, dataSourceOp, dataset, recordType, metaRecordType, secondaryIndexUnnestOp, context, true, retainInput, retainMissing, false, chosenIndex, analysisCtx, indexSubTree, newMissingPlaceHolderForLOJ);
            if (isIndexOnlyPlan) {
                ILogicalOperator dataSourceRefOp = AccessMethodUtils.findDataSourceFromIndexUtilizationPlan(indexSearchOp);
                if (dataSourceRefOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP || dataSourceRefOp.getOperatorTag() == LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP) {
                    EquivalenceClassUtils.addEquivalenceClassesForPrimaryIndexAccess(indexSearchOp, dataSourceOp.getVariables(), recordType, metaRecordType, dataset, context);
                }
            } else {
                EquivalenceClassUtils.addEquivalenceClassesForPrimaryIndexAccess(indexSearchOp, dataSourceOp.getVariables(), recordType, metaRecordType, dataset, context);
            }
        } else {
            ArrayList<Object> primaryIndexOutputTypes = new ArrayList<Object>();
            AccessMethodUtils.appendPrimaryIndexTypes(dataset, (IAType)recordType, (IAType)metaRecordType, primaryIndexOutputTypes);
            List scanVariables = dataSourceOp.getVariables();
            if (!primaryIndexPostProccessingIsNeeded) {
                ArrayList<Mutable<ILogicalExpression>> remainingFuncExprs = new ArrayList<Mutable<ILogicalExpression>>();
                try {
                    this.getNewConditionExprs(conditionRef, replacedFuncExprs, remainingFuncExprs);
                }
                catch (CompilationException e) {
                    return null;
                }
                if (!remainingFuncExprs.isEmpty()) {
                    ILogicalExpression pulledCond = this.createSelectCondition(remainingFuncExprs);
                    conditionRef.setValue((Object)pulledCond);
                } else {
                    conditionRef.setValue(null);
                }
            }
            boolean leftOuterUnnestMapRequired = false;
            leftOuterUnnestMapRequired = retainMissing && retainInput;
            if (conditionRef.getValue() != null) {
                ArrayList<Mutable<ILogicalExpression>> primaryIndexFuncArgs = new ArrayList<Mutable<ILogicalExpression>>();
                jobGenParams.writeToFuncArgs(primaryIndexFuncArgs);
                BuiltinFunctionInfo primaryIndexSearch = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.INDEX_SEARCH);
                UnnestingFunctionCallExpression primaryIndexSearchFunc = new UnnestingFunctionCallExpression((IFunctionInfo)primaryIndexSearch, primaryIndexFuncArgs);
                primaryIndexSearchFunc.setSourceLocation(dataSourceOp.getSourceLocation());
                primaryIndexSearchFunc.setReturnsUniqueValues(true);
                Object unnestMapOp = !leftOuterUnnestMapRequired ? new UnnestMapOperator(scanVariables, (Mutable)new MutableObject((Object)primaryIndexSearchFunc), primaryIndexOutputTypes, retainInput) : new LeftOuterUnnestMapOperator(scanVariables, (Mutable)new MutableObject((Object)primaryIndexSearchFunc), primaryIndexOutputTypes, true);
                unnestMapOp.setSourceLocation(dataSourceOp.getSourceLocation());
                indexSearchOp = unnestMapOp;
            } else {
                Object unnestMapOp = !leftOuterUnnestMapRequired ? new UnnestMapOperator(scanVariables, ((UnnestMapOperator)secondaryIndexUnnestOp).getExpressionRef(), primaryIndexOutputTypes, retainInput) : new LeftOuterUnnestMapOperator(scanVariables, ((LeftOuterUnnestMapOperator)secondaryIndexUnnestOp).getExpressionRef(), primaryIndexOutputTypes, true);
                unnestMapOp.setSourceLocation(dataSourceOp.getSourceLocation());
                indexSearchOp = unnestMapOp;
            }
            indexSearchOp.getInputs().add(new MutableObject((Object)inputOp));
            EquivalenceClassUtils.addEquivalenceClassesForPrimaryIndexAccess(indexSearchOp, scanVariables, recordType, metaRecordType, dataset, context);
        }
        return indexSearchOp;
    }

    private int createKeyVarsAndExprs(int numKeys, LimitType[] keyLimits, ILogicalExpression[] searchKeyExprs, ArrayList<LogicalVariable> assignKeyVarList, ArrayList<Mutable<ILogicalExpression>> assignKeyExprList, ArrayList<LogicalVariable> keyVarList, IOptimizationContext context, ILogicalExpression[] constExpressions, LogicalVariable[] constExprVars) {
        if (keyLimits[0] == null) {
            return 0;
        }
        for (int i = 0; i < numKeys; ++i) {
            ILogicalExpression searchKeyExpr = searchKeyExprs[i];
            ILogicalExpression constExpression = constExpressions[i];
            LogicalVariable keyVar = null;
            if (searchKeyExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                keyVar = context.newVar();
                assignKeyExprList.add((Mutable<ILogicalExpression>)new MutableObject((Object)searchKeyExpr));
                assignKeyVarList.add(keyVar);
            } else {
                keyVar = ((VariableReferenceExpression)searchKeyExpr).getVariableReference();
                if (constExpression != null) {
                    if (constExpression.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                        constExpression = constExpression.cloneExpression();
                    }
                    assignKeyExprList.add((Mutable<ILogicalExpression>)new MutableObject((Object)constExpression));
                    assignKeyVarList.add(constExprVars[i]);
                }
            }
            keyVarList.add(keyVar);
        }
        return numKeys;
    }

    private void getNewConditionExprs(Mutable<ILogicalExpression> conditionRef, Set<ILogicalExpression> replacedFuncExprs, List<Mutable<ILogicalExpression>> remainingFuncExprs) throws CompilationException {
        remainingFuncExprs.clear();
        if (replacedFuncExprs.isEmpty()) {
            return;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)conditionRef.getValue();
        if (replacedFuncExprs.size() == 1) {
            Iterator<ILogicalExpression> it = replacedFuncExprs.iterator();
            if (!it.hasNext()) {
                return;
            }
            if (funcExpr == it.next()) {
                return;
            }
        }
        if (funcExpr.getFunctionIdentifier() != AlgebricksBuiltinFunctions.AND) {
            throw new CompilationException(1026, funcExpr.getSourceLocation(), new Serializable[]{LogRedactionUtil.userData((String)funcExpr.toString())});
        }
        for (Mutable arg : funcExpr.getArguments()) {
            ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
            if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || replacedFuncExprs.contains(argExpr)) continue;
            remainingFuncExprs.add((Mutable<ILogicalExpression>)arg);
        }
    }

    private static int indexOf(List<String> fieldName, int fieldSource, List<List<String>> keyNames, List<Integer> keySources) {
        int i = 0;
        for (List<String> keyName : keyNames) {
            if (keyName.equals(fieldName) && BTreeAccessMethod.keyMatches(keySources, i, fieldSource)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean keyMatches(List<Integer> keySources, int keyIndex, int fieldSource) {
        return keySources == null ? fieldSource == 0 : keySources.get(keyIndex) == fieldSource;
    }

    private LimitType getLimitType(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree probeSubTree) {
        AlgebricksBuiltinFunctions.ComparisonKind ck = AlgebricksBuiltinFunctions.getComparisonType((FunctionIdentifier)optFuncExpr.getFuncExpr().getFunctionIdentifier());
        LimitType limit = null;
        switch (ck) {
            case EQ: {
                limit = LimitType.EQUAL;
                break;
            }
            case GE: {
                limit = this.probeIsOnLhs(optFuncExpr, probeSubTree) ? LimitType.HIGH_INCLUSIVE : LimitType.LOW_INCLUSIVE;
                break;
            }
            case GT: {
                limit = this.probeIsOnLhs(optFuncExpr, probeSubTree) ? LimitType.HIGH_EXCLUSIVE : LimitType.LOW_EXCLUSIVE;
                break;
            }
            case LE: {
                limit = this.probeIsOnLhs(optFuncExpr, probeSubTree) ? LimitType.LOW_INCLUSIVE : LimitType.HIGH_INCLUSIVE;
                break;
            }
            case LT: {
                limit = this.probeIsOnLhs(optFuncExpr, probeSubTree) ? LimitType.LOW_EXCLUSIVE : LimitType.HIGH_EXCLUSIVE;
                break;
            }
            case NEQ: {
                limit = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return limit;
    }

    private boolean relaxLimitTypeToInclusive(Index chosenIndex, int keyPos, boolean realTypeConvertedToIntegerType) {
        if (chosenIndex.isEnforced() && realTypeConvertedToIntegerType) {
            return true;
        }
        if (chosenIndex.isOverridingKeyFieldTypes() && !chosenIndex.isEnforced()) {
            IAType indexedKeyType = (IAType)chosenIndex.getKeyFieldTypes().get(keyPos);
            if (NonTaggedFormatUtil.isOptional((IAType)indexedKeyType)) {
                indexedKeyType = ((AUnionType)indexedKeyType).getActualType();
            }
            switch (indexedKeyType.getTypeTag()) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean probeIsOnLhs(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree probeSubTree) {
        if (probeSubTree == null) {
            if (optFuncExpr.getConstantExpressions().length == 0) {
                return optFuncExpr.getLogicalExpr(0) == null;
            }
            return optFuncExpr.getFuncExpr().getArguments().get(0) == optFuncExpr.getConstantExpr(0);
        }
        return optFuncExpr.getOperatorSubTree(0) == null || optFuncExpr.getOperatorSubTree(0) == probeSubTree;
    }

    private ILogicalExpression createSelectCondition(List<Mutable<ILogicalExpression>> predList) {
        if (predList.size() > 1) {
            BuiltinFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND);
            ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)finfo, predList);
            andExpr.setSourceLocation(((ILogicalExpression)predList.get(0).getValue()).getSourceLocation());
            return andExpr;
        }
        return (ILogicalExpression)predList.get(0).getValue();
    }

    @Override
    public boolean exprIsOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) throws AlgebricksException {
        if (optFuncExpr.getNumLogicalVars() == 2) {
            if (optFuncExpr.getOperatorSubTree(0) == optFuncExpr.getOperatorSubTree(1)) {
                if (!(optFuncExpr.getSourceVar(0) == null && optFuncExpr.getFieldType(0) != null || optFuncExpr.getSourceVar(1) == null && optFuncExpr.getFieldType(1) != null)) {
                    return false;
                }
            } else if (!optFuncExpr.getFuncExpr().getAnnotations().containsKey(IndexedNLJoinExpressionAnnotation.INSTANCE)) {
                return false;
            }
        }
        return index.isPrimaryIndex() || !optFuncExpr.getFuncExpr().getAnnotations().containsKey(SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE);
    }

    @Override
    public String getName() {
        return "BTREE_ACCESS_METHOD";
    }

    @Override
    public int compareTo(IAccessMethod o) {
        return this.getName().compareTo(o.getName());
    }

    private static enum LimitType {
        LOW_INCLUSIVE,
        LOW_EXCLUSIVE,
        HIGH_INCLUSIVE,
        HIGH_EXCLUSIVE,
        EQUAL;

    }
}

