/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.IDeallocatableFramePool;

public class DeallocatableFramePool
implements IDeallocatableFramePool {
    private final IHyracksFrameMgrContext ctx;
    private final int memBudget;
    private int allocated;
    private LinkedList<ByteBuffer> buffers;

    public DeallocatableFramePool(IHyracksFrameMgrContext ctx, int memBudgetInBytes) {
        this.ctx = ctx;
        this.memBudget = memBudgetInBytes;
        this.allocated = 0;
        this.buffers = new LinkedList();
    }

    @Override
    public int getMinFrameSize() {
        return this.ctx.getInitialFrameSize();
    }

    @Override
    public int getMemoryBudgetBytes() {
        return this.memBudget;
    }

    @Override
    public ByteBuffer allocateFrame(int frameSize) throws HyracksDataException {
        ByteBuffer buffer = this.findExistingFrame(frameSize);
        if (buffer != null) {
            return buffer;
        }
        if (this.haveEnoughFreeSpace(frameSize)) {
            return this.createNewFrame(frameSize);
        }
        return this.mergeExistingFrames(frameSize);
    }

    private ByteBuffer mergeExistingFrames(int frameSize) throws HyracksDataException {
        int mergedSize = this.memBudget - this.allocated;
        Iterator iter = this.buffers.iterator();
        while (iter.hasNext()) {
            ByteBuffer buffer = (ByteBuffer)iter.next();
            iter.remove();
            this.ctx.deallocateFrames(buffer.capacity());
            this.allocated -= buffer.capacity();
            if ((mergedSize += buffer.capacity()) < frameSize) continue;
            return this.createNewFrame(mergedSize);
        }
        return null;
    }

    private ByteBuffer createNewFrame(int frameSize) throws HyracksDataException {
        this.allocated += frameSize;
        return this.ctx.allocateFrame(frameSize);
    }

    private boolean haveEnoughFreeSpace(int frameSize) {
        return this.allocated + frameSize <= this.memBudget;
    }

    private ByteBuffer findExistingFrame(int frameSize) {
        Iterator iter = this.buffers.iterator();
        while (iter.hasNext()) {
            ByteBuffer next = (ByteBuffer)iter.next();
            if (next.capacity() < frameSize) continue;
            iter.remove();
            return next;
        }
        return null;
    }

    @Override
    public void deAllocateBuffer(ByteBuffer buffer) {
        if (buffer.capacity() != this.ctx.getInitialFrameSize()) {
            this.ctx.deallocateFrames(buffer.capacity());
            this.allocated -= buffer.capacity();
        } else {
            this.buffers.add(buffer);
        }
    }

    @Override
    public void reset() {
        this.allocated = 0;
        this.buffers.clear();
    }

    @Override
    public void close() {
        Iterator iter = this.buffers.iterator();
        while (iter.hasNext()) {
            ByteBuffer next = (ByteBuffer)iter.next();
            this.ctx.deallocateFrames(next.capacity());
            iter.remove();
        }
        this.allocated = 0;
        this.buffers.clear();
    }
}

