/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.application.IServerContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobParameterByteStore;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.lifecycle.LifeCycleComponentManager;
import org.apache.hyracks.api.network.INetworkSecurityConfig;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.control.common.NodeControllerData;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.heartbeat.HeartbeatSchema;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.ipc.ClusterControllerRemoteProxy;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.work.FutureValue;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.common.work.WorkQueue;
import org.apache.hyracks.control.nc.BaseNCApplication;
import org.apache.hyracks.control.nc.CcConnection;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerIPCI;
import org.apache.hyracks.control.nc.application.NCServiceContext;
import org.apache.hyracks.control.nc.heartbeat.HeartbeatComputeTask;
import org.apache.hyracks.control.nc.heartbeat.HeartbeatManager;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.control.nc.net.MessagingNetworkManager;
import org.apache.hyracks.control.nc.net.NetworkManager;
import org.apache.hyracks.control.nc.net.ResultNetworkManager;
import org.apache.hyracks.control.nc.partitions.PartitionManager;
import org.apache.hyracks.control.nc.resources.memory.MemoryManager;
import org.apache.hyracks.control.nc.result.ResultPartitionManager;
import org.apache.hyracks.control.nc.work.AbortAllJobsWork;
import org.apache.hyracks.control.nc.work.BuildJobProfilesWork;
import org.apache.hyracks.ipc.api.IIPCEventListener;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.security.NetworkSecurityConfig;
import org.apache.hyracks.ipc.security.NetworkSecurityManager;
import org.apache.hyracks.net.protocols.muxdemux.FullFrameChannelInterfaceFactory;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.MXHelper;
import org.apache.hyracks.util.MaintainedThreadNameExecutorService;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.hyracks.util.trace.Tracer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kohsuke.args4j.CmdLineException;

public class NodeControllerService
implements IControllerService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double MEMORY_FUDGE_FACTOR = 0.8;
    private static final int HEARTBEAT_REFRESH_MILLIS = 60000;
    private final NCConfig ncConfig;
    private final String id;
    private final IOManager ioManager;
    private IPCSystem ipc;
    private PartitionManager partitionManager;
    private NetworkManager netManager;
    private IResultPartitionManager resultPartitionManager;
    private ResultNetworkManager resultNetworkManager;
    private final WorkQueue workQueue;
    private final Timer timer;
    private CcId primaryCcId;
    private final Object ccLock = new Object();
    private final Map<CcId, CcConnection> ccMap = Collections.synchronizedMap(new HashMap());
    private final Map<InetSocketAddress, CcId> ccAddressMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, CcConnection> pendingRegistrations = Collections.synchronizedMap(new HashMap());
    private final Map<JobId, Joblet> jobletMap;
    private final Map<Long, ActivityClusterGraph> deployedJobSpecActivityClusterGraphMap;
    private final Map<JobId, JobParameterByteStore> jobParameterByteStoreMap = new HashMap<JobId, JobParameterByteStore>();
    private ExecutorService executor;
    private Map<CcId, HeartbeatManager> heartbeatManagers = new ConcurrentHashMap<CcId, HeartbeatManager>();
    private Map<CcId, Timer> ccTimers = new ConcurrentHashMap<CcId, Timer>();
    private final ServerContext serverCtx;
    private NCServiceContext serviceCtx;
    private final INCApplication application;
    private final ILifeCycleComponentManager lccm;
    private final Mutable<FutureValue<Map<String, NodeControllerInfo>>> getNodeControllerInfosAcceptor;
    private final MemoryManager memoryManager;
    private final INetworkSecurityManager networkSecurityManager;
    private StackTraceElement[] shutdownCallStack;
    private MessagingNetworkManager messagingNetManager;
    private final ConfigManager configManager;
    private final Map<CcId, AtomicLong> maxJobIds = new ConcurrentHashMap<CcId, AtomicLong>();
    private volatile NodeStatus status = NodeStatus.ACTIVE;
    private NodeRegistration nodeRegistration;
    private NodeControllerData ncData;
    private HeartbeatComputeTask hbTask;
    private static final AtomicInteger nextRegistrationId = new AtomicInteger();

    public NodeControllerService(NCConfig config) throws Exception {
        this(config, NodeControllerService.getApplication(config));
    }

    public NodeControllerService(NCConfig config, INCApplication application) throws IOException, CmdLineException {
        this.ncConfig = config;
        this.configManager = this.ncConfig.getConfigManager();
        if (application == null) {
            throw new IllegalArgumentException("INCApplication cannot be null");
        }
        INetworkSecurityConfig securityConfig = this.getNetworkSecurityConfig();
        this.networkSecurityManager = new NetworkSecurityManager(securityConfig);
        this.application = application;
        this.id = this.ncConfig.getNodeId();
        if (this.id == null) {
            throw new HyracksException("id not set");
        }
        this.lccm = new LifeCycleComponentManager();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Setting uncaught exception handler " + this.getLifeCycleComponentManager());
        }
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this.getLifeCycleComponentManager());
        this.ioManager = new IOManager(IODeviceHandle.getDevices((String[])this.ncConfig.getIODevices()), application.getFileDeviceResolver(), this.ncConfig.getIOParallelism(), this.ncConfig.getIOQueueSize());
        try {
            this.workQueue = new WorkQueue(this.id, 5);
            this.jobletMap = new ConcurrentHashMap<JobId, Joblet>();
            this.deployedJobSpecActivityClusterGraphMap = new Hashtable<Long, ActivityClusterGraph>();
            this.timer = new Timer(true);
            File ncBaseDir = this.ioManager.getWorkspacePath(0);
            this.serverCtx = new ServerContext(IServerContext.ServerType.NODE_CONTROLLER, ncBaseDir);
            this.getNodeControllerInfosAcceptor = new MutableObject();
            this.memoryManager = new MemoryManager((long)((double)MXHelper.memoryMXBean.getHeapMemoryUsage().getMax() * 0.8));
        }
        catch (Throwable th) {
            CleanupUtils.close((AutoCloseable)((Object)this.ioManager), (Throwable)th);
            throw th;
        }
    }

    public IOManager getIoManager() {
        return this.ioManager;
    }

    public NCServiceContext getContext() {
        return this.serviceCtx;
    }

    public ILifeCycleComponentManager getLifeCycleComponentManager() {
        return this.lccm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NodeControllerInfo> getNodeControllersInfo() throws Exception {
        FutureValue fv = new FutureValue();
        Mutable<FutureValue<Map<String, NodeControllerInfo>>> mutable = this.getNodeControllerInfosAcceptor;
        synchronized (mutable) {
            while (this.getNodeControllerInfosAcceptor.getValue() != null) {
                this.getNodeControllerInfosAcceptor.wait();
            }
            this.getNodeControllerInfosAcceptor.setValue((Object)fv);
        }
        this.getPrimaryClusterController().getNodeControllerInfos();
        return (Map)fv.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodeControllersInfo(Map<String, NodeControllerInfo> ncInfos) {
        FutureValue fv;
        Mutable<FutureValue<Map<String, NodeControllerInfo>>> mutable = this.getNodeControllerInfosAcceptor;
        synchronized (mutable) {
            fv = (FutureValue)this.getNodeControllerInfosAcceptor.getValue();
            this.getNodeControllerInfosAcceptor.setValue(null);
            this.getNodeControllerInfosAcceptor.notifyAll();
        }
        fv.setValue(ncInfos);
    }

    private void init() {
        this.resultPartitionManager = new ResultPartitionManager(this, this.executor, this.ncConfig.getResultManagerMemory(), this.ncConfig.getResultTTL(), this.ncConfig.getResultSweepThreshold());
        this.resultNetworkManager = new ResultNetworkManager(this.ncConfig.getResultListenAddress(), this.ncConfig.getResultListenPort(), this.resultPartitionManager, this.ncConfig.getNetThreadCount(), this.ncConfig.getNetBufferCount(), this.ncConfig.getResultPublicAddress(), this.ncConfig.getResultPublicPort(), FullFrameChannelInterfaceFactory.INSTANCE, this.networkSecurityManager.getSocketChannelFactory());
        if (this.ncConfig.getMessagingListenAddress() != null && this.serviceCtx.getMessagingChannelInterfaceFactory() != null) {
            this.messagingNetManager = new MessagingNetworkManager(this, this.ncConfig.getMessagingListenAddress(), this.ncConfig.getMessagingListenPort(), this.ncConfig.getNetThreadCount(), this.ncConfig.getMessagingPublicAddress(), this.ncConfig.getMessagingPublicPort(), this.serviceCtx.getMessagingChannelInterfaceFactory(), this.networkSecurityManager.getSocketChannelFactory());
        }
    }

    public void start() throws Exception {
        LOGGER.log(Level.INFO, "Starting NodeControllerService");
        this.ipc = new IPCSystem(new InetSocketAddress(this.ncConfig.getClusterListenAddress(), this.ncConfig.getClusterListenPort()), this.networkSecurityManager.getSocketChannelFactory(), (IIPCI)new NodeControllerIPCI(this), (IPayloadSerializerDeserializer)new CCNCFunctions.SerializerDeserializer());
        this.ipc.start();
        this.partitionManager = new PartitionManager(this);
        this.netManager = new NetworkManager(this.ncConfig.getDataListenAddress(), this.ncConfig.getDataListenPort(), this.partitionManager, this.ncConfig.getNetThreadCount(), this.ncConfig.getNetBufferCount(), this.ncConfig.getDataPublicAddress(), this.ncConfig.getDataPublicPort(), FullFrameChannelInterfaceFactory.INSTANCE, this.networkSecurityManager.getSocketChannelFactory());
        this.netManager.start();
        this.startApplication();
        this.init();
        this.resultNetworkManager.start();
        if (this.messagingNetManager != null) {
            this.messagingNetManager.start();
        }
        this.initNodeControllerState();
        this.hbTask = new HeartbeatComputeTask(this);
        this.primaryCcId = this.addCc(new InetSocketAddress(this.ncConfig.getClusterAddress(), this.ncConfig.getClusterPort()));
        this.workQueue.start();
        this.timer.schedule((TimerTask)this.hbTask, 60000L, 60000L);
        this.timer.schedule((TimerTask)new TraceCurrentTimeTask(this.serviceCtx.getTracer()), 0L, 60000L);
        LOGGER.log(Level.INFO, "Started NodeControllerService");
        this.application.startupCompleted();
    }

    private void initNodeControllerState() {
        NetworkAddress ncAddress = this.ncConfig.getClusterPublicPort() == 0 ? new NetworkAddress(this.ipc.getSocketAddress()) : new NetworkAddress(this.ncConfig.getClusterPublicAddress(), this.ncConfig.getClusterPublicPort());
        HeartbeatSchema.GarbageCollectorInfo[] gcInfos = new HeartbeatSchema.GarbageCollectorInfo[MXHelper.gcMXBeans.size()];
        for (int i = 0; i < gcInfos.length; ++i) {
            gcInfos[i] = new HeartbeatSchema.GarbageCollectorInfo(((GarbageCollectorMXBean)MXHelper.gcMXBeans.get(i)).getName());
        }
        HeartbeatSchema hbSchema = new HeartbeatSchema(gcInfos);
        NetworkAddress resultAddress = this.resultNetworkManager.getPublicNetworkAddress();
        NetworkAddress netAddress = this.netManager.getPublicNetworkAddress();
        NetworkAddress messagingAddress = this.messagingNetManager != null ? this.messagingNetManager.getPublicNetworkAddress() : null;
        this.nodeRegistration = new NodeRegistration(ncAddress, this.id, this.ncConfig, netAddress, resultAddress, hbSchema, messagingAddress, this.application.getCapacity());
        this.ncData = new NodeControllerData(this.nodeRegistration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CcId addCc(final InetSocketAddress ccAddress) throws Exception {
        Object object = this.ccLock;
        synchronized (object) {
            LOGGER.info("addCc: {}", (Object)ccAddress);
            if (ccAddress.isUnresolved()) {
                throw new IllegalArgumentException("must use resolved InetSocketAddress");
            }
            if (this.ccAddressMap.containsKey(ccAddress)) {
                throw new IllegalStateException("cc already registered: " + ccAddress);
            }
            IIPCEventListener ipcEventListener = new IIPCEventListener(){

                public void ipcHandleRestored(IIPCHandle handle) throws IPCException {
                    CcConnection ccConnection = NodeControllerService.this.getCcConnection(NodeControllerService.this.ccAddressMap.get(ccAddress));
                    try {
                        ccConnection.forceReregister(NodeControllerService.this);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IPCException((Throwable)e);
                    }
                }
            };
            ClusterControllerRemoteProxy ccProxy = new ClusterControllerRemoteProxy(this.ipc.getHandle(ccAddress, this.ncConfig.getClusterConnectRetries(), 1, ipcEventListener));
            return this.registerNode(new CcConnection((IClusterController)ccProxy, ccAddress));
        }
    }

    public void makePrimaryCc(InetSocketAddress ccAddress) {
        LOGGER.info("makePrimaryCc: {}", (Object)ccAddress);
        if (ccAddress.isUnresolved()) {
            throw new IllegalArgumentException("must use resolved InetSocketAddress");
        }
        CcId newPrimaryCc = this.ccAddressMap.get(ccAddress);
        if (newPrimaryCc == null) {
            throw new IllegalArgumentException("unknown cc: " + ccAddress);
        }
        this.primaryCcId = newPrimaryCc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCc(InetSocketAddress ccAddress) throws Exception {
        Object object = this.ccLock;
        synchronized (object) {
            Timer ccTimer;
            LOGGER.info("removeCc: {}", (Object)ccAddress);
            if (ccAddress.isUnresolved()) {
                throw new IllegalArgumentException("must use resolved InetSocketAddress");
            }
            CcId ccId = this.ccAddressMap.get(ccAddress);
            if (ccId == null) {
                LOGGER.warn("ignoring request to remove unknown cc: {}", (Object)ccAddress);
                return;
            }
            if (this.primaryCcId.equals((Object)ccId)) {
                throw new IllegalStateException("cannot remove primary cc: " + ccAddress);
            }
            try {
                CcConnection ccc = this.getCcConnection(ccId);
                ccc.getClusterControllerService().unregisterNode(this.id);
            }
            catch (Exception e) {
                LOGGER.warn("ignoring exception trying to gracefully unregister cc {}: ", new Supplier[]{() -> ccId, () -> String.valueOf(e)});
            }
            this.getWorkQueue().scheduleAndSync((SynchronizableWork)new AbortAllJobsWork(this, ccId));
            HeartbeatManager hbMgr = this.heartbeatManagers.remove(ccId);
            if (hbMgr != null) {
                hbMgr.shutdown();
            }
            if ((ccTimer = this.ccTimers.remove(ccId)) != null) {
                ccTimer.cancel();
            }
            this.ccMap.remove(ccId);
            this.ccAddressMap.remove(ccAddress);
        }
    }

    public CcId registerNode(CcConnection ccc) throws Exception {
        LOGGER.info("Registering with Cluster Controller {}", (Object)ccc);
        int registrationId = nextRegistrationId.incrementAndGet();
        this.pendingRegistrations.put(registrationId, ccc);
        CcId ccId = ccc.registerNode(this.nodeRegistration, registrationId);
        this.ccMap.put(ccId, ccc);
        this.ccAddressMap.put(ccc.getCcAddress(), ccId);
        Serializable distributedState = ccc.getNodeParameters().getDistributedState();
        if (distributedState != null) {
            this.getDistributedState().put(ccId, distributedState);
        }
        IClusterController ccs = ccc.getClusterControllerService();
        NodeParameters nodeParameters = ccc.getNodeParameters();
        this.heartbeatManagers.computeIfAbsent(ccId, newCcId -> HeartbeatManager.init(this, ccc, this.hbTask.getHeartbeatData(), this.nodeRegistration.getNodeControllerAddress().resolveInetSocketAddress()));
        if (!this.ccTimers.containsKey(ccId) && nodeParameters.getProfileDumpPeriod() > 0) {
            Timer ccTimer = new Timer("Timer-" + ccId, true);
            ccTimer.schedule((TimerTask)new ProfileDumpTask(ccs, ccId), 0L, (long)nodeParameters.getProfileDumpPeriod());
            this.ccTimers.put(ccId, ccTimer);
        }
        ccc.notifyRegistrationCompleted();
        LOGGER.info("Registering with Cluster Controller {} completed", (Object)ccc);
        return ccId;
    }

    void setNodeRegistrationResult(NodeParameters parameters, Exception exception) {
        CcConnection ccc = this.getPendingNodeRegistration(parameters);
        ccc.setNodeRegistrationResult(parameters, exception);
    }

    private CcConnection getCcConnection(CcId ccId) {
        CcConnection ccConnection = this.ccMap.get(ccId);
        if (ccConnection == null) {
            throw new IllegalArgumentException("unknown ccId: " + ccId);
        }
        return ccConnection;
    }

    private CcConnection getPendingNodeRegistration(NodeParameters nodeParameters) {
        CcConnection ccConnection = this.pendingRegistrations.remove(nodeParameters.getRegistrationId());
        if (ccConnection == null) {
            throw new IllegalStateException("Unknown pending node registration " + nodeParameters.getRegistrationId() + " for " + nodeParameters.getClusterControllerInfo().getCcId());
        }
        return ccConnection;
    }

    private ConcurrentHashMap<CcId, Serializable> getDistributedState() {
        return (ConcurrentHashMap)this.serviceCtx.getDistributedState();
    }

    private void startApplication() throws Exception {
        this.serviceCtx = new NCServiceContext(this, this.serverCtx, this.ioManager, this.id, this.memoryManager, this.lccm, this.ncConfig.getNodeScopedAppConfig());
        this.application.init((IServiceContext)this.serviceCtx);
        this.executor = MaintainedThreadNameExecutorService.newCachedThreadPool((ThreadFactory)this.serviceCtx.getThreadFactory());
        this.application.start(this.ncConfig.getAppArgsArray());
    }

    public void updateMaxJobId(JobId jobId) {
        this.maxJobIds.computeIfAbsent(jobId.getCcId(), key -> new AtomicLong()).getAndUpdate(currentMaxId -> Math.max(currentMaxId, jobId.getId()));
    }

    public long getMaxJobId(CcId ccId) {
        return this.maxJobIds.computeIfAbsent(ccId, key -> new AtomicLong(ccId.toLongMask())).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        if (this.shutdownCallStack != null) {
            LOGGER.error("Duplicate shutdown call; original: " + Arrays.toString(this.shutdownCallStack), (Throwable)new Exception("Duplicate shutdown call"));
            return;
        }
        this.shutdownCallStack = new Throwable().getStackTrace();
        LOGGER.info("Stopping NodeControllerService");
        this.application.preStop();
        this.executor.shutdownNow();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            LOGGER.log(Level.ERROR, "Some jobs failed to exit, continuing with abnormal shutdown");
        }
        this.partitionManager.close();
        this.resultPartitionManager.close();
        this.netManager.stop();
        this.resultNetworkManager.stop();
        if (this.messagingNetManager != null) {
            this.messagingNetManager.stop();
        }
        this.workQueue.stop();
        this.application.stop();
        this.heartbeatManagers.values().parallelStream().forEach(HeartbeatManager::shutdown);
        Object object = this.ccLock;
        synchronized (object) {
            this.ccMap.values().parallelStream().forEach(cc -> {
                try {
                    cc.getClusterControllerService().notifyShutdown(this.id);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARN, "Exception notifying CC of shutdown", (Throwable)e);
                }
            });
        }
        this.ipc.stop();
        this.ioManager.close();
        LOGGER.info("Stopped NodeControllerService");
    }

    public String getId() {
        return this.id;
    }

    public ServerContext getServerContext() {
        return this.serverCtx;
    }

    public Map<JobId, Joblet> getJobletMap() {
        return this.jobletMap;
    }

    public void removeJobParameterByteStore(JobId jobId) {
        this.jobParameterByteStoreMap.remove(jobId);
    }

    public JobParameterByteStore createOrGetJobParameterByteStore(JobId jobId) {
        return this.jobParameterByteStoreMap.computeIfAbsent(jobId, jid -> new JobParameterByteStore());
    }

    public void storeActivityClusterGraph(DeployedJobSpecId deployedJobSpecId, ActivityClusterGraph acg) throws HyracksException {
        this.deployedJobSpecActivityClusterGraphMap.put(deployedJobSpecId.getId(), acg);
    }

    public void removeActivityClusterGraph(DeployedJobSpecId deployedJobSpecId) throws HyracksException {
        if (this.deployedJobSpecActivityClusterGraphMap.get(deployedJobSpecId.getId()) == null) {
            throw HyracksException.create((ErrorCode)ErrorCode.ERROR_FINDING_DEPLOYED_JOB, (Serializable[])new Serializable[]{deployedJobSpecId});
        }
        this.deployedJobSpecActivityClusterGraphMap.remove(deployedJobSpecId.getId());
    }

    public void checkForDuplicateDeployedJobSpec(DeployedJobSpecId deployedJobSpecId) throws HyracksException {
        if (this.deployedJobSpecActivityClusterGraphMap.get(deployedJobSpecId.getId()) != null) {
            throw HyracksException.create((ErrorCode)ErrorCode.DUPLICATE_DEPLOYED_JOB, (Serializable[])new Serializable[]{deployedJobSpecId});
        }
    }

    public ActivityClusterGraph getActivityClusterGraph(DeployedJobSpecId deployedJobSpecId) {
        return this.deployedJobSpecActivityClusterGraphMap.get(deployedJobSpecId.getId());
    }

    public NetworkManager getNetworkManager() {
        return this.netManager;
    }

    public ResultNetworkManager getResultNetworkManager() {
        return this.resultNetworkManager;
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public CcId getPrimaryCcId() {
        return this.primaryCcId;
    }

    public IClusterController getPrimaryClusterController() {
        return this.getClusterController(this.primaryCcId);
    }

    public IClusterController getClusterController(CcId ccId) {
        return this.getCcConnection(ccId).getClusterControllerService();
    }

    public NodeParameters getNodeParameters(CcId ccId) {
        return this.getCcConnection(ccId).getNodeParameters();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public NCConfig getConfiguration() {
        return this.ncConfig;
    }

    public WorkQueue getWorkQueue() {
        return this.workQueue;
    }

    public NodeStatus getNodeStatus() {
        return this.status;
    }

    public void setNodeStatus(NodeStatus status) {
        this.status = status;
    }

    public NodeControllerData getNodeControllerData() {
        return this.ncData;
    }

    public IPCSystem getIpcSystem() {
        return this.ipc;
    }

    public void sendApplicationMessageToCC(CcId ccId, byte[] data, DeploymentId deploymentId) throws Exception {
        this.getClusterController(ccId).sendApplicationMessageToCC(data, deploymentId, this.id);
    }

    public void sendRealTimeApplicationMessageToCC(CcId ccId, byte[] data, DeploymentId deploymentId) throws Exception {
        this.getClusterController(ccId).sendRealTimeApplicationMessageToCC(data, deploymentId, this.id);
    }

    public IResultPartitionManager getResultPartitionManager() {
        return this.resultPartitionManager;
    }

    public MessagingNetworkManager getMessagingNetworkManager() {
        return this.messagingNetManager;
    }

    public void notifyTasksCompleted(CcId ccId) throws Exception {
        this.partitionManager.jobsCompleted(ccId);
        this.application.tasksCompleted(ccId);
    }

    private static INCApplication getApplication(NCConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (config.getAppClass() != null) {
            Class<?> c = Class.forName(config.getAppClass());
            return (INCApplication)c.newInstance();
        }
        return BaseNCApplication.INSTANCE;
    }

    public Object getApplicationContext() {
        return this.application.getApplicationContext();
    }

    public HeartbeatManager getHeartbeatManager(CcId ccId) {
        return this.heartbeatManagers.get(ccId);
    }

    public NodeRegistration getNodeRegistration() {
        return this.nodeRegistration;
    }

    public INCApplication getApplication() {
        return this.application;
    }

    public INetworkSecurityManager getNetworkSecurityManager() {
        return this.networkSecurityManager;
    }

    protected INetworkSecurityConfig getNetworkSecurityConfig() {
        return NetworkSecurityConfig.of((boolean)this.ncConfig.isSslEnabled(), (String)this.ncConfig.getKeyStorePath(), (String)this.ncConfig.getKeyStorePassword(), (String)this.ncConfig.getTrustStorePath());
    }

    static {
        ExitUtil.init();
    }

    private class TraceCurrentTimeTask
    extends TimerTask {
        private ITracer tracer;
        private long traceCategory;

        public TraceCurrentTimeTask(ITracer tracer) {
            this.tracer = tracer;
            this.traceCategory = tracer.getRegistry().get("Timestamp");
        }

        @Override
        public void run() {
            try {
                this.tracer.instant("CurrentTime", this.traceCategory, ITracer.Scope.p, Tracer.dateTimeStamp());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Exception tracing current time", (Throwable)e);
            }
        }
    }

    private class ProfileDumpTask
    extends TimerTask {
        private final IClusterController cc;
        private final CcId ccId;

        public ProfileDumpTask(IClusterController cc, CcId ccId) {
            this.cc = cc;
            this.ccId = ccId;
        }

        @Override
        public void run() {
            try {
                FutureValue fv = new FutureValue();
                BuildJobProfilesWork bjpw = new BuildJobProfilesWork(NodeControllerService.this, this.ccId, (FutureValue<List<JobProfile>>)fv);
                NodeControllerService.this.workQueue.scheduleAndSync((SynchronizableWork)bjpw);
                List profiles = (List)fv.get();
                if (!profiles.isEmpty()) {
                    this.cc.reportProfile(NodeControllerService.this.id, profiles);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Exception reporting profile", (Throwable)e);
            }
        }
    }
}

