/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.bitwise.AbstractBitSingleValueEvaluator;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

@MissingNullInOutFunction
public class BitNotDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 549770812101511988L;
    public static final IFunctionDescriptorFactory FACTORY = BitNotDescriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.BIT_NOT;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBitSingleValueEvaluator(ctx, args, BitNotDescriptor.this.getIdentifier(), BitNotDescriptor.this.sourceLoc){
                    private final AMutableInt64 resultMutableInt64;
                    private final ISerializerDeserializer aInt64Serde;
                    {
                        this.resultMutableInt64 = new AMutableInt64(0L);
                        this.aInt64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                    }

                    @Override
                    void applyBitwiseOperation(long value) {
                        this.resultMutableInt64.setValue(value ^ 0xFFFFFFFFFFFFFFFFL);
                    }

                    @Override
                    void writeResult(IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.aInt64Serde.serialize((Object)this.resultMutableInt64, this.resultStorage.getDataOutput());
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

