/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalMemoryRequirements;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class AbstractGroupByPOperator
extends AbstractPhysicalOperator {
    public static final int MIN_FRAME_LIMIT_FOR_GROUP_BY = 4;
    protected List<LogicalVariable> columnList;

    AbstractGroupByPOperator(List<LogicalVariable> columnList) {
        this.columnList = columnList;
    }

    List<LogicalVariable> getGroupByColumns() {
        return this.columnList;
    }

    int[] getFdColumns(GroupByOperator gby, IOperatorSchema inputSchema) throws AlgebricksException {
        int numFds = gby.getDecorList().size();
        int[] fdColumns = new int[numFds];
        int j = 0;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : gby.getDecorList()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.EXPR_NOT_NORMALIZED, (SourceLocation)expr.getSourceLocation(), (Serializable[])new Serializable[0]);
            }
            VariableReferenceExpression v = (VariableReferenceExpression)expr;
            LogicalVariable decor = v.getVariableReference();
            fdColumns[j++] = inputSchema.findVariable(decor);
        }
        return fdColumns;
    }

    void checkGroupAll(GroupByOperator groupByOp) throws AlgebricksException {
        if (groupByOp.isGroupAll() && !groupByOp.getDecorList().isEmpty()) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.GROUP_ALL_DECOR, (SourceLocation)groupByOp.getSourceLocation(), (Serializable[])new Serializable[0]);
        }
    }

    public void setGroupByColumns(List<LogicalVariable> columnList) {
        this.columnList = columnList;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }

    @Override
    public void createLocalMemoryRequirements(ILogicalOperator op) {
        this.localMemoryRequirements = LocalMemoryRequirements.variableMemoryBudget(4);
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + this.columnList;
    }
}

