/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;

public abstract class AbstractIntegerTypeConvertComputer
implements ITypeConvertComputer {
    private final boolean strict;

    protected AbstractIntegerTypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    protected void convertIntegerType(byte[] data, int start, int length, DataOutput out, ATypeTag targetType, int targetTypeLength) throws IOException {
        long num = AbstractIntegerTypeConvertComputer.asLong(data, start, length);
        num = this.validate(num, targetType);
        out.writeByte(targetType.serialize());
        this.writeTargetValue(num, out, targetTypeLength);
    }

    static long asLong(byte[] data, int start, int length) throws RuntimeDataException {
        switch (length) {
            case 1: {
                return BytePointable.getByte((byte[])data, (int)start);
            }
            case 2: {
                return ShortPointable.getShort((byte[])data, (int)start);
            }
            case 4: {
                return IntegerPointable.getInteger((byte[])data, (int)start);
            }
            case 8: {
                return LongPointable.getLong((byte[])data, (int)start);
            }
        }
        throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_INTEGER_SOURCE, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
    }

    private void writeTargetValue(long num, DataOutput out, int targetTypeLength) throws IOException {
        switch (targetTypeLength) {
            case 1: {
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            case 2: {
                out.writeByte((byte)(num >> 8 & 0xFFL));
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            case 4: {
                out.writeByte((byte)(num >> 24 & 0xFFL));
                out.writeByte((byte)(num >> 16 & 0xFFL));
                out.writeByte((byte)(num >> 8 & 0xFFL));
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            case 8: {
                out.writeByte((byte)(num >> 56 & 0xFFL));
                out.writeByte((byte)(num >> 48 & 0xFFL));
                out.writeByte((byte)(num >> 40 & 0xFFL));
                out.writeByte((byte)(num >> 32 & 0xFFL));
                out.writeByte((byte)(num >> 24 & 0xFFL));
                out.writeByte((byte)(num >> 16 & 0xFFL));
                out.writeByte((byte)(num >> 8 & 0xFFL));
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_INTEGER_TARGET, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
            }
        }
    }

    protected IAObject convertIntegerType(IAObject sourceObject, ATypeTag targetType) throws HyracksDataException {
        long num;
        switch (sourceObject.getType().getTypeTag()) {
            case TINYINT: {
                num = ((AInt8)sourceObject).getByteValue();
                break;
            }
            case SMALLINT: {
                num = ((AInt16)sourceObject).getShortValue();
                break;
            }
            case INTEGER: {
                num = ((AInt32)sourceObject).getIntegerValue();
                break;
            }
            case BIGINT: {
                num = ((AInt64)sourceObject).getLongValue();
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_INTEGER_SOURCE, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
            }
        }
        num = this.validate(num, targetType);
        switch (targetType) {
            case TINYINT: {
                return new AInt8((byte)num);
            }
            case SMALLINT: {
                return new AInt16((short)num);
            }
            case INTEGER: {
                return new AInt32((int)num);
            }
            case BIGINT: {
                return new AInt64(num);
            }
        }
        throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_INTEGER_TARGET, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
    }

    protected long convertIntegerType(byte[] data, int start, ATypeTag sourceTypeTag, ATypeTag targetType) throws HyracksDataException {
        long num;
        switch (sourceTypeTag) {
            case TINYINT: {
                num = BytePointable.getByte((byte[])data, (int)start);
                break;
            }
            case SMALLINT: {
                num = ShortPointable.getShort((byte[])data, (int)start);
                break;
            }
            case INTEGER: {
                num = IntegerPointable.getInteger((byte[])data, (int)start);
                break;
            }
            case BIGINT: {
                num = LongPointable.getLong((byte[])data, (int)start);
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_INTEGER_SOURCE, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
            }
        }
        return this.validate(num, targetType);
    }

    private long validate(long num, ATypeTag targetType) throws HyracksDataException {
        switch (targetType) {
            case TINYINT: {
                if (num > 127L) {
                    if (this.strict) {
                        this.raiseBoundaryException(num, targetType, 127L, -128L);
                        break;
                    }
                    return 127L;
                }
                if (num >= -128L) break;
                if (this.strict) {
                    this.raiseBoundaryException(num, targetType, 127L, -128L);
                    break;
                }
                return -128L;
            }
            case SMALLINT: {
                if (num > 32767L) {
                    if (this.strict) {
                        this.raiseBoundaryException(num, targetType, 32767L, -32768L);
                        break;
                    }
                    return 32767L;
                }
                if (num >= -32768L) break;
                if (this.strict) {
                    this.raiseBoundaryException(num, targetType, 32767L, -32768L);
                    break;
                }
                return -32768L;
            }
            case INTEGER: {
                if (num > Integer.MAX_VALUE) {
                    if (this.strict) {
                        this.raiseBoundaryException(num, targetType, Integer.MAX_VALUE, Integer.MIN_VALUE);
                        break;
                    }
                    return Integer.MAX_VALUE;
                }
                if (num >= Integer.MIN_VALUE) break;
                if (this.strict) {
                    this.raiseBoundaryException(num, targetType, Integer.MAX_VALUE, Integer.MIN_VALUE);
                    break;
                }
                return Integer.MIN_VALUE;
            }
        }
        return num;
    }

    private void raiseBoundaryException(long num, ATypeTag targetType, long maxValue, long minValue) throws HyracksDataException {
        throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_OUT_OF_BOUND, new Serializable[]{Long.valueOf(num), targetType, Long.valueOf(maxValue), Long.valueOf(minValue)});
    }
}

