/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushSortDownRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator operator = (ILogicalOperator)opRef.getValue();
        if (operator.getOperatorTag() != LogicalOperatorTag.ORDER) {
            return false;
        }
        OrderOperator orderOperator = (OrderOperator)operator;
        List orderKeys = orderOperator.getOrderExpressions();
        HashSet orderUsedVars = new HashSet();
        for (Pair orderKey : orderKeys) {
            ((ILogicalExpression)((Mutable)orderKey.second).getValue()).getUsedVariables(orderUsedVars);
        }
        Mutable inputOpRef = (Mutable)orderOperator.getInputs().get(0);
        ILogicalOperator inputOperator = (ILogicalOperator)inputOpRef.getValue();
        if (inputOperator.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        HashSet inputProducedVars = new HashSet();
        VariableUtilities.getProducedVariables((ILogicalOperator)inputOperator, inputProducedVars);
        orderUsedVars.retainAll(inputProducedVars);
        if (!orderUsedVars.isEmpty()) {
            return false;
        }
        opRef.setValue((Object)inputOperator);
        inputOpRef.setValue((Object)((ILogicalOperator)((Mutable)inputOperator.getInputs().get(0)).getValue()));
        ((Mutable)inputOperator.getInputs().get(0)).setValue((Object)orderOperator);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)orderOperator);
        context.computeAndSetTypeEnvironmentForOperator(inputOperator);
        return true;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

