/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.result;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IResultManager;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.common.result.AbstractResultManager;
import org.apache.hyracks.control.common.result.ResultStateSweeper;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import org.apache.hyracks.control.nc.result.ResultMemoryManager;
import org.apache.hyracks.control.nc.result.ResultPartitionReader;
import org.apache.hyracks.control.nc.result.ResultPartitionWriter;
import org.apache.hyracks.control.nc.result.ResultSetMap;
import org.apache.hyracks.control.nc.result.ResultState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultPartitionManager
extends AbstractResultManager
implements IResultPartitionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final Executor executor;
    private final Map<JobId, ResultSetMap> partitionResultStateMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;
    private final ResultMemoryManager resultMemoryManager;

    public ResultPartitionManager(NodeControllerService ncs, Executor executor, int availableMemory, long resultTTL, long resultSweepThreshold) {
        super(resultTTL);
        this.ncs = ncs;
        this.executor = executor;
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory(this.deallocatableRegistry, ncs.getIoManager());
        this.resultMemoryManager = availableMemory >= ResultMemoryManager.getPageSize() ? new ResultMemoryManager(availableMemory) : null;
        this.partitionResultStateMap = new HashMap<JobId, ResultSetMap>();
        executor.execute((Runnable)new ResultStateSweeper((IResultManager)this, resultSweepThreshold, LOGGER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFrameWriter createResultPartitionWriter(IHyracksTaskContext ctx, ResultSetId rsId, IResultMetadata metadata, boolean asyncMode, int partition, int nPartitions, long maxReads) {
        ResultPartitionWriter dpw;
        JobId jobId = ctx.getJobletContext().getJobId();
        ResultPartitionManager resultPartitionManager = this;
        synchronized (resultPartitionManager) {
            dpw = new ResultPartitionWriter(ctx, this, jobId, rsId, asyncMode, metadata, partition, nPartitions, this.resultMemoryManager, this.fileFactory, maxReads);
            ResultSetMap rsIdMap = this.partitionResultStateMap.computeIfAbsent(jobId, k -> new ResultSetMap());
            ResultState[] resultStates = rsIdMap.createOrGetResultStates(rsId, nPartitions);
            resultStates[partition] = dpw.getResultState();
        }
        LOGGER.trace("Initialized partition writer: JobId: {}:partition: {}", (Object)jobId, (Object)partition);
        return dpw;
    }

    public void registerResultPartitionLocation(JobId jobId, ResultSetId rsId, int partition, int nPartitions, IResultMetadata metadata, boolean emptyResult) throws HyracksException {
        try {
            this.ncs.getClusterController(jobId.getCcId()).registerResultPartitionLocation(jobId, rsId, metadata, emptyResult, partition, nPartitions, this.ncs.getResultNetworkManager().getPublicNetworkAddress());
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public void reportPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) throws HyracksException {
        try {
            LOGGER.trace("Reporting partition write completion: JobId: {}:ResultSetId: {}:partition: {}", (Object)jobId, (Object)rsId, (Object)partition);
            this.ncs.getClusterController(jobId.getCcId()).reportResultPartitionWriteCompletion(jobId, rsId, partition);
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public void initializeResultPartitionReader(JobId jobId, ResultSetId resultSetId, int partition, IFrameWriter writer) throws HyracksException {
        ResultState resultState = this.getResultState(jobId, resultSetId, partition);
        ResultPartitionReader dpr = new ResultPartitionReader(this, this.resultMemoryManager, this.executor, resultState);
        dpr.writeTo(writer);
        LOGGER.trace("Initialized partition reader: JobId: {}:ResultSetId: {}:partition: {}", (Object)jobId, (Object)resultSetId, (Object)partition);
    }

    private synchronized ResultState getResultState(JobId jobId, ResultSetId resultSetId, int partition) throws HyracksException {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap == null) {
            throw new HyracksException("Unknown JobId " + jobId);
        }
        ResultState[] resultStates = rsIdMap.getResultStates(resultSetId);
        if (resultStates == null) {
            throw new HyracksException("Unknown JobId: " + jobId + " ResultSetId: " + resultSetId);
        }
        ResultState resultState = resultStates[partition];
        if (resultState == null) {
            throw new HyracksException("No ResultPartitionWriter for partition " + partition);
        }
        return resultState;
    }

    public synchronized void removePartition(JobId jobId, ResultSetId resultSetId, int partition) {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null && rsIdMap.removePartition(jobId, resultSetId, partition)) {
            this.partitionResultStateMap.remove(jobId);
        }
    }

    public synchronized void abortReader(JobId jobId) {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null) {
            rsIdMap.abortAll();
        }
    }

    public synchronized void close() {
        for (JobId jobId : this.getJobIds()) {
            this.deinit(jobId);
        }
        this.deallocatableRegistry.close();
    }

    public synchronized Set<JobId> getJobIds() {
        return this.partitionResultStateMap.keySet();
    }

    public synchronized ResultSetMap getState(JobId jobId) {
        return this.partitionResultStateMap.get(jobId);
    }

    public synchronized void sweep(JobId jobId) {
        this.deinit(jobId);
        this.partitionResultStateMap.remove(jobId);
    }

    private synchronized void deinit(JobId jobId) {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null) {
            rsIdMap.closeAndDeleteAll();
        }
    }
}

