/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.MemoryComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLSMMemoryComponent
extends AbstractLSMComponent
implements ILSMMemoryComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final AtomicBoolean allocated;
    private final IVirtualBufferCache vbc;
    private final AtomicBoolean isModified;
    private int writerCount;
    private int pendingFlushes = 0;
    private final MemoryComponentMetadata metadata;
    private ILSMComponentId componentId;

    public AbstractLSMMemoryComponent(AbstractLSMIndex lsmIndex, IVirtualBufferCache vbc, ILSMComponentFilter filter) {
        super(lsmIndex, filter);
        this.vbc = vbc;
        this.writerCount = 0;
        this.state = ILSMComponent.ComponentState.INACTIVE;
        this.isModified = new AtomicBoolean();
        this.allocated = new AtomicBoolean();
        this.metadata = new MemoryComponentMetadata();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void schedule(ILSMIOOperation.LSMIOOperationType ioOperationType) throws HyracksDataException {
        this.activate();
        if (ioOperationType != ILSMIOOperation.LSMIOOperationType.FLUSH) throw new UnsupportedOperationException("Unsupported operation " + ioOperationType);
        if (this.state == ILSMComponent.ComponentState.READABLE_WRITABLE || this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE) {
            if (this.writerCount != 0) {
                throw new IllegalStateException("Trying to schedule a flush when writerCount != 0");
            }
            this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING;
            return;
        } else {
            if (this.state != ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING && this.state != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE) throw new IllegalStateException("Trying to schedule a flush when the component state = " + this.state);
            ++this.pendingFlushes;
        }
    }

    private void activate() throws HyracksDataException {
        if (this.state == ILSMComponent.ComponentState.INACTIVE) {
            if (!this.allocated.get()) {
                this.doAllocate();
            }
            this.state = ILSMComponent.ComponentState.READABLE_WRITABLE;
            this.lsmIndex.getIOOperationCallback().recycled(this);
        }
    }

    @Override
    public boolean threadEnter(LSMOperationType opType, boolean isMutableComponent) throws HyracksDataException {
        this.activate();
        switch (opType) {
            case FORCE_MODIFICATION: {
                if (isMutableComponent) {
                    if (this.state == ILSMComponent.ComponentState.READABLE_WRITABLE || this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE) {
                        ++this.writerCount;
                        break;
                    }
                    return false;
                }
                if (this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE || this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING) {
                    ++this.readerCount;
                    break;
                }
                return false;
            }
            case MODIFICATION: {
                if (isMutableComponent) {
                    if (this.state == ILSMComponent.ComponentState.READABLE_WRITABLE && !this.vbc.isFull(this) && !this.vbc.isFull()) {
                        ++this.writerCount;
                        break;
                    }
                    return false;
                }
                if (this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE || this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING) {
                    ++this.readerCount;
                    break;
                }
                return false;
            }
            case SEARCH: {
                if (this.state == ILSMComponent.ComponentState.READABLE_WRITABLE || this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE || this.state == ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING) {
                    ++this.readerCount;
                    break;
                }
                return false;
            }
            case FLUSH: {
                if (this.state == ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE) {
                    return false;
                }
                if (this.state != ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING) {
                    throw new IllegalStateException("Trying to flush when component state = " + this.state);
                }
                if (this.writerCount != 0) {
                    throw new IllegalStateException("Trying to flush when writerCount = " + this.writerCount);
                }
                ++this.readerCount;
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + opType);
            }
        }
        return true;
    }

    @Override
    public boolean threadExit(LSMOperationType opType, boolean failedOperation, boolean isMutableComponent) throws HyracksDataException {
        boolean cleanup = false;
        switch (opType) {
            case FORCE_MODIFICATION: 
            case MODIFICATION: {
                if (isMutableComponent) {
                    --this.writerCount;
                    if (this.state != ILSMComponent.ComponentState.READABLE_WRITABLE || failedOperation || !this.vbc.isFull(this)) break;
                    this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
                    break;
                }
                --this.readerCount;
                if (this.state != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE || this.readerCount != 0) break;
                cleanup = true;
                break;
            }
            case SEARCH: {
                --this.readerCount;
                if (this.state != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE || this.readerCount != 0) break;
                cleanup = true;
                break;
            }
            case FLUSH: {
                if (this.state != ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING) {
                    throw new IllegalStateException("Flush sees an illegal LSM memory compoenent state: " + this.state);
                }
                --this.readerCount;
                if (failedOperation) break;
                this.state = ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE;
                if (this.readerCount != 0) break;
                cleanup = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + opType);
            }
        }
        if (this.readerCount <= -1 || this.writerCount <= -1) {
            throw new IllegalStateException("Invalid reader or writer count " + this.readerCount + " - " + this.writerCount);
        }
        return cleanup;
    }

    @Override
    public boolean isReadable() {
        return this.state != ILSMComponent.ComponentState.INACTIVE && this.state != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE;
    }

    @Override
    public void setUnwritable() {
        if (this.state != ILSMComponent.ComponentState.READABLE_WRITABLE) {
            throw new IllegalStateException("Attempt to set unwritable a component that is " + this.state);
        }
        this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
    }

    @Override
    public void setModified() {
        this.isModified.set(true);
    }

    @Override
    public boolean isModified() {
        return this.isModified.get();
    }

    @Override
    public final void reset() throws HyracksDataException {
        this.state = ILSMComponent.ComponentState.INACTIVE;
        this.isModified.set(false);
        this.metadata.reset();
        if (this.filter != null) {
            this.filter.reset();
        }
        this.lsmIndex.memoryComponentsReset();
        if (this.pendingFlushes > 0) {
            this.schedule(ILSMIOOperation.LSMIOOperationType.FLUSH);
            --this.pendingFlushes;
        }
    }

    @Override
    public void cleanup() throws HyracksDataException {
        if (this.allocated.get()) {
            this.getIndex().deactivate();
            this.getIndex().destroy();
            this.allocated.set(false);
        }
    }

    @Override
    public int getWriterCount() {
        return this.writerCount;
    }

    @Override
    public MemoryComponentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final void allocate() throws HyracksDataException {
        boolean allocated = false;
        this.vbc.open();
        this.vbc.register(this);
        try {
            this.doAllocate();
            allocated = true;
        }
        finally {
            if (!allocated) {
                this.getIndex().getBufferCache().close();
            }
        }
    }

    protected void doAllocate() throws HyracksDataException {
        boolean created = false;
        boolean activated = false;
        try {
            this.getIndex().create();
            created = true;
            this.getIndex().activate();
            activated = true;
            this.allocated.set(true);
        }
        finally {
            if (created && !activated) {
                this.getIndex().destroy();
            }
        }
    }

    @Override
    public final void deallocate() throws HyracksDataException {
        try {
            this.state = ILSMComponent.ComponentState.INACTIVE;
            this.doDeallocate();
            this.vbc.unregister(this);
        }
        finally {
            this.getIndex().getBufferCache().close();
        }
    }

    protected void doDeallocate() throws HyracksDataException {
        if (this.allocated.get()) {
            this.getIndex().deactivate();
            this.getIndex().destroy();
            this.allocated.set(false);
        }
        this.componentId = null;
    }

    @Override
    public void validate() throws HyracksDataException {
        this.getIndex().validate();
    }

    @Override
    public ILSMComponentId getId() {
        return this.componentId;
    }

    @Override
    public void resetId(ILSMComponentId componentId, boolean force) throws HyracksDataException {
        if (!force && this.componentId != null && this.componentId.compareTo(componentId) != ILSMComponentId.IdCompareResult.LESS_THAN) {
            throw new IllegalStateException(this + " receives illegal id. Old id " + this.componentId + ", new id " + componentId);
        }
        LOGGER.debug("component id of {} was reset from {} to {}", (Object)this.getIndex(), (Object)this.componentId, (Object)componentId);
        this.componentId = componentId;
        if (componentId != null) {
            LSMComponentIdUtils.persist(this.componentId, this.metadata);
        }
    }

    @Override
    public void flushed() throws HyracksDataException {
        this.vbc.flushed(this);
    }

    public String toString() {
        return "{\"class\":\"" + this.getClass().getSimpleName() + "\", \"state\":\"" + this.state + "\", \"writers\":" + this.writerCount + ", \"readers\":" + this.readerCount + ", \"pendingFlushes\":" + this.pendingFlushes + ", \"id\":\"" + this.componentId + "\", \"index\":" + this.getIndex() + "}";
    }
}

