/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMComponentFilter
implements ILSMComponentFilter {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final IBinaryComparatorFactory[] filterCmpFactories;
    private final ITreeIndexTupleWriter tupleWriter;
    private ITupleReference minTuple;
    private ITupleReference maxTuple;
    private byte[] minTupleBytes;
    private ByteBuffer minTupleBuf;
    private byte[] maxTupleBytes;
    private ByteBuffer maxTupleBuf;

    public LSMComponentFilter(ITreeIndexTupleWriter tupleWriter, IBinaryComparatorFactory[] filterCmpFactories) {
        this.filterCmpFactories = filterCmpFactories;
        this.tupleWriter = tupleWriter;
    }

    @Override
    public IBinaryComparatorFactory[] getFilterCmpFactories() {
        return this.filterCmpFactories;
    }

    @Override
    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.minTuple = null;
            this.maxTuple = null;
            this.minTupleBytes = null;
            this.maxTupleBytes = null;
            this.minTupleBuf = null;
            this.maxTupleBuf = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ITupleReference tuple, MultiComparator cmp, IExtendedModificationOperationCallback opCallback) throws HyracksDataException {
        this.lock.writeLock().lock();
        try {
            int numBytes;
            int c;
            int numBytes2;
            boolean logged = false;
            if (this.minTuple == null) {
                numBytes2 = this.tupleWriter.bytesRequired(tuple);
                this.minTupleBytes = new byte[numBytes2];
                opCallback.after(tuple);
                logged = true;
                this.tupleWriter.writeTuple(tuple, this.minTupleBytes, 0);
                this.minTupleBuf = ByteBuffer.wrap(this.minTupleBytes);
                this.minTuple = this.tupleWriter.createTupleReference();
                ((ITreeIndexTupleReference)this.minTuple).resetByTupleOffset(this.minTupleBuf.array(), 0);
            } else {
                c = cmp.compare(tuple, this.minTuple);
                if (c < 0) {
                    opCallback.after(tuple);
                    logged = true;
                    numBytes = this.tupleWriter.bytesRequired(tuple);
                    if (this.minTupleBytes.length < numBytes) {
                        this.minTupleBytes = new byte[numBytes];
                        this.tupleWriter.writeTuple(tuple, this.minTupleBytes, 0);
                        this.minTupleBuf = ByteBuffer.wrap(this.minTupleBytes);
                    } else {
                        this.tupleWriter.writeTuple(tuple, this.minTupleBytes, 0);
                    }
                    ((ITreeIndexTupleReference)this.minTuple).resetByTupleOffset(this.minTupleBuf.array(), 0);
                }
            }
            if (this.maxTuple == null) {
                numBytes2 = this.tupleWriter.bytesRequired(tuple);
                this.maxTupleBytes = new byte[numBytes2];
                if (!logged) {
                    opCallback.after(tuple);
                }
                this.tupleWriter.writeTuple(tuple, this.maxTupleBytes, 0);
                this.maxTupleBuf = ByteBuffer.wrap(this.maxTupleBytes);
                this.maxTuple = this.tupleWriter.createTupleReference();
                ((ITreeIndexTupleReference)this.maxTuple).resetByTupleOffset(this.maxTupleBuf.array(), 0);
            } else {
                c = cmp.compare(tuple, this.maxTuple);
                if (c > 0) {
                    if (!logged) {
                        opCallback.after(tuple);
                    }
                    if (this.maxTupleBytes.length < (numBytes = this.tupleWriter.bytesRequired(tuple))) {
                        this.maxTupleBytes = new byte[numBytes];
                        this.tupleWriter.writeTuple(tuple, this.maxTupleBytes, 0);
                        this.maxTupleBuf = ByteBuffer.wrap(this.maxTupleBytes);
                    } else {
                        this.tupleWriter.writeTuple(tuple, this.maxTupleBytes, 0);
                    }
                    ((ITreeIndexTupleReference)this.maxTuple).resetByTupleOffset(this.maxTupleBuf.array(), 0);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ITupleReference getMinTuple() {
        this.lock.readLock().lock();
        try {
            ITupleReference iTupleReference = this.minTuple;
            return iTupleReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ITupleReference getMaxTuple() {
        this.lock.readLock().lock();
        try {
            ITupleReference iTupleReference = this.maxTuple;
            return iTupleReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean satisfy(ITupleReference minTuple, ITupleReference maxTuple, MultiComparator filterCmp) throws HyracksDataException {
        this.lock.readLock().lock();
        try {
            int c;
            if (maxTuple != null && this.minTuple != null && (c = filterCmp.compare(maxTuple, this.minTuple)) < 0) {
                boolean bl = false;
                return bl;
            }
            if (minTuple != null && this.maxTuple != null && (c = filterCmp.compare(minTuple, this.maxTuple)) > 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

