/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOpenableDataWriter;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import org.apache.hyracks.dataflow.std.file.IRecordWriter;
import org.apache.hyracks.dataflow.std.util.DeserializedOperatorNodePushable;

public abstract class AbstractFileWriteOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    protected FileSplit[] splits;

    public FileSplit[] getSplits() {
        return this.splits;
    }

    public void setSplits(FileSplit[] splits) {
        this.splits = splits;
    }

    public AbstractFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits) {
        super(spec, 1, 0);
        this.splits = splits;
    }

    protected abstract IRecordWriter createRecordWriter(IIOManager var1, FileSplit var2, int var3) throws HyracksDataException;

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new DeserializedOperatorNodePushable(ctx, new FileWriteOperator(ctx.getIoManager(), partition), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
    }

    protected class FileWriteOperator
    implements IOpenableDataWriterOperator {
        private final IIOManager ioManager;
        private int index;
        private IRecordWriter writer;

        FileWriteOperator(IIOManager ioManager, int index) {
            this.ioManager = ioManager;
            this.index = index;
        }

        @Override
        public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
            throw new IllegalArgumentException();
        }

        public void open() throws HyracksDataException {
            FileSplit split = AbstractFileWriteOperatorDescriptor.this.splits[this.index];
            this.writer = AbstractFileWriteOperatorDescriptor.this.createRecordWriter(this.ioManager, split, this.index);
        }

        public void close() throws HyracksDataException {
            this.writer.close();
        }

        public void fail() throws HyracksDataException {
        }

        public void writeData(Object[] data) throws HyracksDataException {
            this.writer.write(data);
        }

        public void flush() throws HyracksDataException {
        }
    }
}

