/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayProcessEval;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

@MissingNullInOutFunction
public class ArraySortDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType inputListType;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArraySortDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENT_TYPE;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_SORT;
    }

    public void setImmutableStates(Object ... states) {
        this.inputListType = (IAType)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArraySortEval(args, ctx);
            }
        };
    }

    public class ArraySortEval
    extends AbstractArrayProcessEval {
        private final PriorityQueue<IPointable> sortedList;
        private IPointable item;
        private ArrayBackedValueStorage storage;

        ArraySortEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            super(args, ctx, ArraySortDescriptor.this.inputListType);
            BuiltinType itemType = ArraySortDescriptor.this.inputListType.getTypeTag().isListType() ? ((AbstractCollectionType)ArraySortDescriptor.this.inputListType).getItemType() : BuiltinType.ANY;
            this.sortedList = new PriorityQueue<IPointable>(new ArraySortComparator((IAType)itemType));
        }

        @Override
        protected void processList(ListAccessor listAccessor, IAsterixListBuilder listBuilder) throws IOException {
            this.sortedList.clear();
            this.item = this.pointableAllocator.allocateEmpty();
            this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
            for (int i = 0; i < listAccessor.size(); ++i) {
                boolean itemInStorage = listAccessor.getOrWriteItem(i, this.item, this.storage);
                this.sortedList.add(this.item);
                if (itemInStorage) {
                    this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
                }
                this.item = this.pointableAllocator.allocateEmpty();
            }
            while (!this.sortedList.isEmpty()) {
                listBuilder.addItem((IValueReference)this.sortedList.poll());
            }
        }
    }

    protected class ArraySortComparator
    implements Comparator<IPointable> {
        private final IBinaryComparator comp;

        ArraySortComparator(IAType itemType) {
            this.comp = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)itemType, (Object)itemType, true).createBinaryComparator();
        }

        @Override
        public int compare(IPointable val1, IPointable val2) {
            try {
                return this.comp.compare(val1.getByteArray(), val1.getStartOffset(), val1.getLength(), val2.getByteArray(), val2.getStartOffset(), val2.getLength());
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

