/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.servlet.DefaultFilterPipeline;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ManagedFilterPipeline;
import com.google.inject.servlet.ManagedServletPipeline;
import com.google.inject.servlet.RequestParameters;
import com.google.inject.servlet.RequestScoped;
import com.google.inject.servlet.ScopingOnly;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.servlet.SessionScoped;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

final class InternalServletModule
extends AbstractModule {
    InternalServletModule() {
    }

    protected void configure() {
        this.bindScope(RequestScoped.class, ServletScopes.REQUEST);
        this.bindScope(SessionScoped.class, ServletScopes.SESSION);
        this.bind(ServletRequest.class).to(HttpServletRequest.class);
        this.bind(ServletResponse.class).to(HttpServletResponse.class);
        this.requestStaticInjection(new Class[]{GuiceFilter.class});
        this.bind(ManagedFilterPipeline.class);
        this.bind(ManagedServletPipeline.class);
        this.bind(FilterPipeline.class).to(ManagedFilterPipeline.class).asEagerSingleton();
        this.bind(ServletContext.class).toProvider(BackwardsCompatibleServletContextProvider.class);
        this.bind(BackwardsCompatibleServletContextProvider.class);
    }

    @Provides
    @Singleton
    @ScopingOnly
    GuiceFilter provideScopingOnlyGuiceFilter() {
        return new GuiceFilter(new DefaultFilterPipeline());
    }

    @Provides
    @RequestScoped
    HttpServletRequest provideHttpServletRequest() {
        return GuiceFilter.getRequest(Key.get(HttpServletRequest.class));
    }

    @Provides
    @RequestScoped
    HttpServletResponse provideHttpServletResponse() {
        return GuiceFilter.getResponse(Key.get(HttpServletResponse.class));
    }

    @Provides
    HttpSession provideHttpSession() {
        return GuiceFilter.getRequest(Key.get(HttpSession.class)).getSession();
    }

    @Provides
    @RequestScoped
    @RequestParameters
    Map<String, String[]> provideRequestParameters(ServletRequest req) {
        return req.getParameterMap();
    }

    public boolean equals(Object o) {
        return o instanceof InternalServletModule;
    }

    public int hashCode() {
        return InternalServletModule.class.hashCode();
    }

    @Singleton
    static class BackwardsCompatibleServletContextProvider
    implements Provider<ServletContext> {
        private ServletContext injectedServletContext;

        @Inject
        BackwardsCompatibleServletContextProvider() {
        }

        void set(ServletContext injectedServletContext) {
            this.injectedServletContext = injectedServletContext;
        }

        public ServletContext get() {
            if (null != this.injectedServletContext) {
                return this.injectedServletContext;
            }
            Logger.getLogger(InternalServletModule.class.getName()).warning("You are attempting to use a deprecated API (specifically, attempting to @Inject ServletContext inside an eagerly created singleton. While we allow this for backwards compatibility, be warned that this MAY have unexpected behavior if you have more than one injector (with ServletModule) running in the same JVM. Please consult the Guice documentation at https://github.com/google/guice/wiki/Servlets for more information.");
            return GuiceFilter.getServletContext();
        }
    }
}

