/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.runtime.formats.NonTaggedDataFormat;

public class CreateDataverseStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final String format;
    private final boolean ifNotExists;

    public CreateDataverseStatement(Namespace namespace, String format, boolean ifNotExists) {
        this.namespace = Objects.requireNonNull(namespace);
        this.format = format == null ? NonTaggedDataFormat.class.getName() : format;
        this.ifNotExists = ifNotExists;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getDatabaseName() {
        return this.namespace.getDatabaseName();
    }

    public DataverseName getDataverseName() {
        return this.namespace.getDataverseName();
    }

    public String getFormat() {
        return this.format;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_DATAVERSE;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

