/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.adapter.factory;

import java.util.Map;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.input.filter.NoOpExternalFilterEvaluatorFactory;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public final class ExternalAdapterFactory
implements ITypedAdapterFactory {
    private static final long serialVersionUID = 2L;
    private final DataverseName libraryDataverse;
    private final String libraryName;
    private final String className;
    private final String libraryDatabase;
    private ARecordType outputType;
    private ARecordType metaType;
    private Map<String, String> configuration;
    private transient ICCServiceContext serviceContext;

    public ExternalAdapterFactory(String libraryDatabase, DataverseName libraryDataverse, String libraryName, String className) {
        this.libraryDatabase = libraryDatabase;
        this.libraryDataverse = libraryDataverse;
        this.libraryName = libraryName;
        this.className = className;
    }

    public void configure(ICCServiceContext serviceContext, Map<String, String> configuration, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) {
        this.serviceContext = serviceContext;
        this.configuration = configuration;
    }

    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        ICcApplicationContext appCtx = (ICcApplicationContext)this.serviceContext.getApplicationContext();
        return IExternalDataSourceFactory.getPartitionConstraints(appCtx, null, 1);
    }

    public IDataSourceAdapter createAdapter(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        INCServiceContext serviceCtx = ctx.getJobletContext().getServiceContext();
        INcApplicationContext appCtx = (INcApplicationContext)serviceCtx.getApplicationContext();
        ILibraryManager libraryManager = appCtx.getLibraryManager();
        ILibrary library = libraryManager.getLibrary(new Namespace(this.libraryDatabase, this.libraryDataverse), this.libraryName);
        if (ExternalFunctionLanguage.JAVA != library.getLanguage()) {
            throw new HyracksDataException("Unexpected library language: " + library.getLanguage());
        }
        ClassLoader cl = ((JavaLibrary)library).getClassLoader();
        try {
            ITypedAdapterFactory adapterFactory = (ITypedAdapterFactory)cl.loadClass(this.className).newInstance();
            adapterFactory.setOutputType(this.outputType);
            adapterFactory.setMetaType(this.metaType);
            adapterFactory.configure(null, this.configuration, ctx.getWarningCollector(), NoOpExternalFilterEvaluatorFactory.INSTANCE);
            return adapterFactory.createAdapter(ctx, partition);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | AlgebricksException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public void setOutputType(ARecordType outputType) {
        this.outputType = outputType;
    }

    @Override
    public ARecordType getOutputType() {
        return this.outputType;
    }

    @Override
    public void setMetaType(ARecordType metaType) {
        this.metaType = metaType;
    }

    @Override
    public ARecordType getMetaType() {
        return this.metaType;
    }

    public String getAlias() {
        return "external:" + this.className;
    }

    public String getLibraryDatabase() {
        return this.libraryDatabase;
    }

    public DataverseName getLibraryDataverse() {
        return this.libraryDataverse;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getClassName() {
        return this.className;
    }
}

