/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppenderAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.buffermanager.BufferManagerBackedVSizeFrame;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IObjectFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexFinalSearchResult;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListCursorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListMerger;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.DelimitedUTF8StringBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.TokenizerInfo;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.ObjectCache;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class AbstractTOccurrenceSearcher
implements IInvertedIndexSearcher {
    protected static final RecordDescriptor QUERY_TOKEN_REC_DESC = new RecordDescriptor(new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer()});
    protected final int OBJECT_CACHE_INIT_SIZE = 10;
    protected final int OBJECT_CACHE_EXPAND_SIZE = 10;
    protected final IHyracksTaskContext ctx;
    protected final InvertedListMerger invListMerger;
    protected final InvertedIndexFinalSearchResult finalSearchResult;
    protected final IInPlaceInvertedIndex invIndex;
    protected final MultiComparator invListCmp;
    protected final ArrayTupleBuilder queryTokenBuilder = new ArrayTupleBuilder(QUERY_TOKEN_REC_DESC.getFieldCount());
    protected final IFrame queryTokenFrame;
    protected final FrameTupleAppenderAccessor queryTokenAppender;
    protected final FrameTupleReference searchKey = new FrameTupleReference();
    protected int occurrenceThreshold;
    protected final IObjectFactory<IInvertedListCursor> invListCursorFactory;
    protected final ObjectCache<IInvertedListCursor> invListCursorCache;
    protected final ISimpleFrameBufferManager bufferManager;
    protected boolean isFinishedSearch;
    protected IInvertedListCursor singleInvListCursor;
    protected boolean isSingleInvertedList;
    protected ByteBuffer searchResultBuffer;
    protected int searchResultTupleIndex = 0;
    protected final IFrameTupleAccessor searchResultFta;
    protected IInvertedListTupleReference searchResultTuple;

    public AbstractTOccurrenceSearcher(IInPlaceInvertedIndex invIndex, IHyracksTaskContext ctx) throws HyracksDataException {
        this.invIndex = invIndex;
        this.ctx = ctx;
        if (ctx == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CONTINUE_TEXT_SEARCH_HYRACKS_TASK_IS_NULL, (Serializable[])new Serializable[0]);
        }
        this.bufferManager = (ISimpleFrameBufferManager)TaskUtil.get((String)"INVERTED_INDEX_SEARCH_FRAME_MANAGER", (IHyracksTaskContext)ctx);
        if (this.bufferManager == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CONTINUE_TEXT_SEARCH_BUFFER_MANAGER_IS_NULL, (Serializable[])new Serializable[0]);
        }
        this.finalSearchResult = new InvertedIndexFinalSearchResult(invIndex.getInvListTypeTraits(), ctx, this.bufferManager, invIndex.getNullTypeTraits(), invIndex.getNullIntrospector());
        this.invListMerger = new InvertedListMerger(ctx, invIndex, this.bufferManager);
        this.invListCmp = MultiComparator.create((IBinaryComparatorFactory[])invIndex.getInvListCmpFactories());
        this.invListCursorFactory = new InvertedListCursorFactory(invIndex, ctx);
        this.invListCursorCache = new ObjectCache<IInvertedListCursor>(this.invListCursorFactory, 10, 10);
        this.queryTokenFrame = new BufferManagerBackedVSizeFrame((IHyracksFrameMgrContext)ctx, this.bufferManager);
        if (this.queryTokenFrame.getBuffer() == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.NOT_ENOUGH_BUDGET_FOR_TEXTSEARCH, (Serializable[])new Serializable[]{this.getClass().getSimpleName()});
        }
        this.queryTokenAppender = new FrameTupleAppenderAccessor(QUERY_TOKEN_REC_DESC);
        this.queryTokenAppender.reset(this.queryTokenFrame, true);
        this.isSingleInvertedList = false;
        this.searchResultTuple = InvertedIndexUtils.createInvertedListTupleReference(invIndex.getInvListTypeTraits(), invIndex.getNullTypeTraits());
        this.searchResultFta = InvertedIndexUtils.createInvertedListFrameTupleAccessor(ctx.getInitialFrameSize(), invIndex.getInvListTypeTraits(), invIndex.getNullTypeTraits(), invIndex.getNullIntrospector());
    }

    protected void tokenizeQuery(InvertedIndexSearchPredicate searchPred) throws HyracksDataException {
        ITupleReference queryTuple = searchPred.getQueryTuple();
        int queryFieldIndex = searchPred.getQueryFieldIndex();
        IFullTextConfigEvaluator fullTextAnalyzer = searchPred.getFullTextConfigEvaluator();
        fullTextAnalyzer.setTokenizer(searchPred.getQueryTokenizer());
        boolean isFullTextSearchQuery = searchPred.getIsFullTextSearchQuery();
        TokenizerInfo.TokenizerType queryTokenizerType = fullTextAnalyzer.getTokenizer().getTokenizerType();
        int tokenCountInOneField = 0;
        this.queryTokenAppender.reset(this.queryTokenFrame, true);
        fullTextAnalyzer.reset(queryTuple.getFieldData(queryFieldIndex), queryTuple.getFieldStart(queryFieldIndex), queryTuple.getFieldLength(queryFieldIndex));
        while (fullTextAnalyzer.hasNext()) {
            fullTextAnalyzer.next();
            this.queryTokenBuilder.reset();
            ++tokenCountInOneField;
            try {
                IToken token = fullTextAnalyzer.getToken();
                if (isFullTextSearchQuery) {
                    if (queryTokenizerType == TokenizerInfo.TokenizerType.STRING && tokenCountInOneField > 1) {
                        throw HyracksDataException.create((ErrorCode)ErrorCode.FULLTEXT_PHRASE_FOUND, (Serializable[])new Serializable[0]);
                    }
                    if (queryTokenizerType == TokenizerInfo.TokenizerType.LIST) {
                        for (int j = 1; j < token.getTokenLength(); ++j) {
                            if (!DelimitedUTF8StringBinaryTokenizer.isSeparator((char)token.getData()[token.getStartOffset() + j])) continue;
                            throw HyracksDataException.create((ErrorCode)ErrorCode.FULLTEXT_PHRASE_FOUND, (Serializable[])new Serializable[0]);
                        }
                    }
                }
                token.serializeToken(this.queryTokenBuilder.getFieldData());
                this.queryTokenBuilder.addFieldEndOffset();
                this.queryTokenAppender.append(this.queryTokenBuilder.getFieldEndOffsets(), this.queryTokenBuilder.getByteArray(), 0, this.queryTokenBuilder.getSize());
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    public int getOccurrenceThreshold() {
        return this.occurrenceThreshold;
    }

    public void printNewResults(int maxResultBufIdx, List<ByteBuffer> buffer) {
        StringBuffer strBuffer = new StringBuffer();
        IFrameTupleAccessor resultFrameTupleAcc = this.finalSearchResult.getAccessor();
        for (int i = 0; i <= maxResultBufIdx; ++i) {
            ByteBuffer testBuf = buffer.get(i);
            resultFrameTupleAcc.reset(testBuf);
            for (int j = 0; j < resultFrameTupleAcc.getTupleCount(); ++j) {
                strBuffer.append(IntegerPointable.getInteger((byte[])resultFrameTupleAcc.getBuffer().array(), (int)resultFrameTupleAcc.getFieldStartOffset(j, 0)) + ",");
                strBuffer.append(IntegerPointable.getInteger((byte[])resultFrameTupleAcc.getBuffer().array(), (int)resultFrameTupleAcc.getFieldStartOffset(j, 1)) + " ");
            }
        }
        System.out.println(strBuffer.toString());
    }

    @Override
    public boolean hasNext() throws HyracksDataException {
        boolean moreToRead;
        while (!(moreToRead = this.hasMoreElement())) {
            this.resetResultSource();
            if (this.isFinishedSearch) {
                return false;
            }
            this.continueSearch();
        }
        return true;
    }

    @Override
    public void next() throws HyracksDataException {
        if (this.isSingleInvertedList) {
            this.singleInvListCursor.next();
        } else {
            this.searchResultTuple.reset(this.searchResultFta.getBuffer().array(), this.searchResultFta.getTupleStartOffset(this.searchResultTupleIndex));
            ++this.searchResultTupleIndex;
        }
    }

    private boolean hasMoreElement() throws HyracksDataException {
        if (this.isSingleInvertedList) {
            return this.singleInvListCursor.hasNext();
        }
        return this.searchResultTupleIndex < this.searchResultFta.getTupleCount();
    }

    private void resetResultSource() throws HyracksDataException {
        if (this.isSingleInvertedList) {
            this.isSingleInvertedList = false;
            try {
                this.singleInvListCursor.unloadPages();
            }
            finally {
                this.singleInvListCursor.close();
            }
            this.singleInvListCursor = null;
        } else {
            this.finalSearchResult.resetBuffer();
            this.searchResultTupleIndex = 0;
        }
    }

    @Override
    public void destroy() throws HyracksDataException {
        ((BufferManagerBackedVSizeFrame)this.queryTokenFrame).destroy();
        if (this.singleInvListCursor != null) {
            try {
                this.singleInvListCursor.unloadPages();
            }
            finally {
                this.singleInvListCursor.close();
            }
        }
        this.finalSearchResult.close();
        this.invListMerger.close();
    }

    @Override
    public ITupleReference getTuple() {
        if (this.isSingleInvertedList) {
            return this.singleInvListCursor.getTuple();
        }
        return this.searchResultTuple;
    }

    protected void prepareSearch() throws HyracksDataException {
        this.finalSearchResult.prepareIOBuffer();
        this.invListMerger.prepareMerge();
        ((BufferManagerBackedVSizeFrame)this.queryTokenFrame).acquireFrame();
        this.isFinishedSearch = false;
        this.isSingleInvertedList = false;
        this.searchResultFta.reset(this.finalSearchResult.getNextFrame());
        this.searchResultTupleIndex = 0;
        this.singleInvListCursor = null;
    }
}

