/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.transaction.management.service.transaction.AbstractTransactionContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.common.IModificationOperationCallback;

public class AtomicTransactionContext
extends AbstractTransactionContext {
    private final Map<Long, ILSMOperationTracker> opTrackers = new ConcurrentHashMap<Long, ILSMOperationTracker>();
    private final Map<Long, AtomicInteger> indexPendingOps = new ConcurrentHashMap<Long, AtomicInteger>();
    private final Map<Long, IModificationOperationCallback> callbacks = new ConcurrentHashMap<Long, IModificationOperationCallback>();
    protected final Set<ILSMOperationTracker> modifiedIndexes = Collections.synchronizedSet(new HashSet());

    public AtomicTransactionContext(TxnId txnId) {
        super(txnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(long resourceId, int partition, ILSMIndex index, IModificationOperationCallback callback, boolean primaryIndex) {
        super.register(resourceId, partition, index, callback, primaryIndex);
        Map<Long, ILSMOperationTracker> map = this.opTrackers;
        synchronized (map) {
            if (primaryIndex && !this.opTrackers.containsKey(resourceId)) {
                this.opTrackers.put(resourceId, index.getOperationTracker());
                this.callbacks.put(resourceId, callback);
                this.indexPendingOps.put(resourceId, new AtomicInteger(0));
            }
        }
    }

    public void notifyEntityCommitted(int partition) {
        throw new IllegalStateException("Unexpected entity commit in atomic transaction");
    }

    public void beforeOperation(long resourceId) {
        this.indexPendingOps.get(resourceId).incrementAndGet();
        this.modifiedIndexes.add(this.opTrackers.get(resourceId));
    }

    public void afterOperation(long resourceId) {
        this.indexPendingOps.get(resourceId).decrementAndGet();
    }

    @Override
    public void cleanup() {
        switch (this.getTxnState()) {
            case 1: 
            case 2: {
                for (Map.Entry<Long, ILSMOperationTracker> opTracker : this.opTrackers.entrySet()) {
                    try {
                        long resId = opTracker.getKey();
                        int idxPendingOps = this.indexPendingOps.get(resId).intValue();
                        for (int i = 0; i < idxPendingOps; ++i) {
                            opTracker.getValue().completeOperation(null, LSMOperationType.FORCE_MODIFICATION, null, this.callbacks.get(resId));
                        }
                    }
                    catch (HyracksDataException e) {
                        throw new ACIDException((Throwable)e);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("invalid state in txn clean up: " + this.getTxnState());
            }
        }
    }

    public int hashCode() {
        return Long.hashCode(this.txnId.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicTransactionContext that = (AtomicTransactionContext)o;
        return this.txnId.equals((Object)that.txnId);
    }

    public boolean hasWAL() {
        return true;
    }
}

