/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.asterix.api.http.server.ServletUtil;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.rebalance.NoOpDatasetRebalanceCallback;
import org.apache.asterix.utils.RebalanceUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RebalanceApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ICcApplicationContext appCtx;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Queue<Future<Void>> rebalanceTasks = new ArrayDeque<Future<Void>>();
    private final Queue<CountDownLatch> rebalanceFutureTerminated = new ArrayDeque<CountDownLatch>();

    public RebalanceApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void delete(IServletRequest request, IServletResponse response) {
        try {
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
            this.cancelRebalance();
            this.sendResponse(response, HttpResponseStatus.OK, "rebalance tasks are cancelled");
        }
        catch (Exception e) {
            this.sendResponse(response, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage(), e);
        }
    }

    protected void post(IServletRequest request, IServletResponse response) {
        try {
            Namespace namespace;
            try {
                namespace = ServletUtil.getNamespace((IApplicationContext)this.appCtx, request, "dataverseName");
            }
            catch (AlgebricksException e) {
                this.sendResponse(response, HttpResponseStatus.BAD_REQUEST, e.getMessage());
                return;
            }
            String datasetName = request.getParameter((CharSequence)"datasetName");
            LinkedHashSet<String> targetNodes = new LinkedHashSet<String>(request.getParameterValues((CharSequence)"targetNode"));
            boolean forceRebalance = true;
            String force = request.getParameter((CharSequence)"force");
            if (force != null) {
                forceRebalance = Boolean.parseBoolean(force);
            }
            if (targetNodes.isEmpty()) {
                this.sendResponse(response, HttpResponseStatus.BAD_REQUEST, "at least one targetNode must be specified");
                return;
            }
            if (namespace == null && datasetName != null) {
                this.sendResponse(response, HttpResponseStatus.BAD_REQUEST, "to rebalance a particular " + IdentifierUtil.dataset() + ", the parameter dataverseName must be given");
                return;
            }
            DataverseName dataverseName = null;
            String databaseName = null;
            if (namespace != null) {
                dataverseName = namespace.getDataverseName();
                databaseName = namespace.getDatabaseName();
            }
            if (MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dataverseName)) {
                this.sendResponse(response, HttpResponseStatus.BAD_REQUEST, "cannot rebalance a metadata " + IdentifierUtil.dataset());
                return;
            }
            CountDownLatch terminated = this.scheduleRebalance(databaseName, dataverseName, datasetName, targetNodes, response, forceRebalance);
            terminated.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.sendResponse(response, HttpResponseStatus.INTERNAL_SERVER_ERROR, "the rebalance service is interrupted", e);
        }
    }

    private synchronized void cancelRebalance() throws InterruptedException {
        for (Future future : this.rebalanceTasks) {
            future.cancel(true);
        }
    }

    private synchronized void removeTermintedTask() {
        this.rebalanceTasks.remove();
        this.rebalanceFutureTerminated.remove();
    }

    private synchronized CountDownLatch scheduleRebalance(String database, DataverseName dataverseName, String datasetName, Set<String> targetNodes, IServletResponse response, boolean force) {
        CountDownLatch terminated = new CountDownLatch(1);
        Future<Void> task = this.executor.submit(() -> this.doRebalance(database, dataverseName, datasetName, targetNodes, response, terminated, force));
        this.rebalanceTasks.add(task);
        this.rebalanceFutureTerminated.add(terminated);
        return terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void doRebalance(String database, DataverseName dataverseName, String datasetName, Set<String> targetNodes, IServletResponse response, CountDownLatch terminated, boolean force) {
        try {
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (Charset)StandardCharsets.UTF_8);
            if (datasetName == null) {
                Iterable<Dataset> datasets = dataverseName == null ? this.getAllDatasetsForRebalance() : this.getAllDatasetsForRebalance(database, dataverseName);
                for (Dataset dataset : datasets) {
                    this.rebalanceDataset(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), targetNodes, force);
                }
            } else {
                this.rebalanceDataset(database, dataverseName, datasetName, targetNodes, force);
            }
            this.sendResponse(response, HttpResponseStatus.OK, "successful");
        }
        catch (InterruptedException e) {
            this.sendResponse(response, HttpResponseStatus.INTERNAL_SERVER_ERROR, "the rebalance task is cancelled by a user", e);
        }
        catch (Exception e) {
            this.sendResponse(response, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.toString(), e);
        }
        finally {
            this.removeTermintedTask();
            terminated.countDown();
        }
        return null;
    }

    private Iterable<Dataset> getAllDatasetsForRebalance(String database, DataverseName dataverseName) throws Exception {
        Iterable<Dataset> datasets;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        try {
            datasets = this.getDatasetsInDataverseForRebalance(database, dataverseName, mdTxnCtx);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            throw e;
        }
        return datasets;
    }

    private Iterable<Dataset> getAllDatasetsForRebalance() throws Exception {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        try {
            List dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
            for (Dataverse dv : dataverses) {
                CollectionUtils.addAll(datasets, this.getDatasetsInDataverseForRebalance(dv.getDatabaseName(), dv.getDataverseName(), mdTxnCtx));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            throw e;
        }
        return datasets;
    }

    private Iterable<Dataset> getDatasetsInDataverseForRebalance(String database, DataverseName dvName, MetadataTransactionContext mdTxnCtx) throws Exception {
        return MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dvName) ? Collections.emptyList() : IterableUtils.filteredIterable((Iterable)MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, database, dvName), DatasetUtil::isNotView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebalanceDataset(String database, DataverseName dataverseName, String datasetName, Set<String> targetNodes, boolean force) throws Exception {
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        MetadataProvider metadataProvider = MetadataProvider.createWithDefaultNamespace((ICcApplicationContext)this.appCtx);
        try {
            ActiveNotificationHandler activeNotificationHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            activeNotificationHandler.suspend(metadataProvider, "rebalance api");
            try {
                IMetadataLockManager lockManager = this.appCtx.getMetadataLockManager();
                lockManager.acquireDatasetExclusiveModificationLock(metadataProvider.getLocks(), database, dataverseName, datasetName);
                RebalanceUtil.rebalance(database, dataverseName, datasetName, targetNodes, metadataProvider, hcc, NoOpDatasetRebalanceCallback.INSTANCE, force);
            }
            finally {
                activeNotificationHandler.resume(metadataProvider);
            }
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void sendResponse(IServletResponse response, HttpResponseStatus status, String message, Exception e) {
        if (status != HttpResponseStatus.OK) {
            if (e != null) {
                LOGGER.log(Level.WARN, message, (Throwable)e);
            } else {
                LOGGER.log(Level.WARN, message);
            }
        }
        PrintWriter out = response.writer();
        ObjectNode jsonResponse = OBJECT_MAPPER.createObjectNode();
        jsonResponse.put("results", message);
        response.setStatus(status);
        out.write(jsonResponse.toString());
    }

    private void sendResponse(IServletResponse response, HttpResponseStatus status, String message) {
        this.sendResponse(response, status, message, null);
    }
}

