/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import org.apache.asterix.column.assembler.AbstractValueAssembler;
import org.apache.asterix.column.assembler.ArrayValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ArrayWithUnionValueAssembler
extends ArrayValueAssembler {
    private final int numberOfUnionChildren;
    private int numberOfAddedValues;
    private boolean nonMissingValueAdded;

    ArrayWithUnionValueAssembler(int level, AssemblerInfo info, int firstValueIndex, AbstractSchemaNode itemNode) {
        super(level, info, firstValueIndex);
        this.numberOfUnionChildren = ((UnionSchemaNode)itemNode).getChildren().size();
    }

    @Override
    void reset() {
        this.numberOfAddedValues = 0;
        this.nonMissingValueAdded = false;
        super.reset();
    }

    @Override
    void addValue(AbstractValueAssembler value) throws HyracksDataException {
        this.nonMissingValueAdded = true;
        ++this.numberOfAddedValues;
        super.addValue(value);
    }

    @Override
    void addNull(AbstractValueAssembler value) throws HyracksDataException {
        this.nonMissingValueAdded = true;
        ++this.numberOfAddedValues;
        super.addNull(value);
    }

    @Override
    void addMissing() throws HyracksDataException {
        ++this.numberOfAddedValues;
        if (this.nonMissingValueAdded && this.numberOfAddedValues >= this.numberOfUnionChildren) {
            this.nonMissingValueAdded = false;
            this.numberOfAddedValues %= this.numberOfUnionChildren;
        } else if (this.numberOfAddedValues == this.numberOfUnionChildren) {
            super.addMissing();
            this.numberOfAddedValues = 0;
        }
    }
}

