/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema.collection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.asterix.column.metadata.PathInfoSerializer;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.collection.ArraySchemaNode;
import org.apache.asterix.column.metadata.schema.collection.MultisetSchemaNode;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractCollectionSchemaNode
extends AbstractSchemaNestedNode {
    private AbstractSchemaNode item;

    AbstractCollectionSchemaNode() {
        this.item = null;
    }

    AbstractCollectionSchemaNode(DataInput input, Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels) throws IOException {
        if (definitionLevels != null) {
            definitionLevels.put(this, new RunLengthIntArray());
        }
        this.item = AbstractSchemaNode.deserialize(input, definitionLevels);
    }

    public final AbstractSchemaNode getOrCreateItem(ATypeTag childTypeTag, FlushColumnMetadata columnMetadata) throws HyracksDataException {
        AbstractSchemaNode newItem = columnMetadata.getOrCreateChild(this.item, childTypeTag);
        if (newItem != this.item) {
            this.item = newItem;
        }
        return this.item;
    }

    public final AbstractSchemaNode getItemNode() {
        return this.item;
    }

    public final void setItemNode(AbstractSchemaNode item) {
        this.item = item;
    }

    @Override
    public final <R, T> R accept(ISchemaNodeVisitor<R, T> visitor, T arg) throws HyracksDataException {
        return visitor.visit(this, arg);
    }

    @Override
    public final boolean isObjectOrCollection() {
        return true;
    }

    @Override
    public final boolean isCollection() {
        return true;
    }

    @Override
    public final void serialize(DataOutput output, PathInfoSerializer pathInfoSerializer) throws IOException {
        output.write(this.getTypeTag().serialize());
        pathInfoSerializer.enter(this);
        this.item.serialize(output, pathInfoSerializer);
        pathInfoSerializer.exit(this);
    }

    public static AbstractCollectionSchemaNode create(ATypeTag typeTag) {
        if (typeTag == ATypeTag.ARRAY) {
            return new ArraySchemaNode();
        }
        return new MultisetSchemaNode();
    }
}

