/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.tahu.TahuHostComponent;

/**
 * Sparkplug B Host Application support over MQTT using Eclipse Tahu
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface TahuHostComponentBuilderFactory {

    /**
     * Tahu Host Application (camel-tahu)
     * Sparkplug B Host Application support over MQTT using Eclipse Tahu
     * 
     * Category: messaging,iot,monitoring
     * Since: 4.8
     * Maven coordinates: org.apache.camel:camel-tahu
     * 
     * @return the dsl builder
     */
    static TahuHostComponentBuilder tahuHost() {
        return new TahuHostComponentBuilderImpl();
    }

    /**
     * Builder for the Tahu Host Application component.
     */
    interface TahuHostComponentBuilder extends ComponentBuilder<TahuHostComponent> {
    
        
        /**
         * MQTT client ID length check enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param checkClientIdLength the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder checkClientIdLength(boolean checkClientIdLength) {
            doSetProperty("checkClientIdLength", checkClientIdLength);
            return this;
        }
    
        /**
         * MQTT client ID to use for all server definitions, rather than
         * specifying the same one for each. Note that if neither the 'clientId'
         * parameter nor an 'MqttClientId' are defined for an MQTT Server, a
         * random MQTT Client ID will be generated automatically, prefaced with
         * 'Camel'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
    
        
        /**
         * MQTT connection keep alive timeout, in seconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder keepAliveTimeout(int keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
    
        
        /**
         * Delay before recurring node rebirth messages will be sent.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param rebirthDebounceDelay the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder rebirthDebounceDelay(long rebirthDebounceDelay) {
            doSetProperty("rebirthDebounceDelay", rebirthDebounceDelay);
            return this;
        }
    
        /**
         * MQTT server definitions, given with the following syntax in a
         * comma-separated list:
         * MqttServerName:(MqttClientId:)(tcp/ssl)://hostname(:port),...
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder servers(java.lang.String servers) {
            doSetProperty("servers", servers);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * To use a shared Tahu configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.tahu.TahuConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder configuration(org.apache.camel.component.tahu.TahuConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * Password for MQTT server authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
    
        /**
         * SSL configuration for MQTT server connections.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    
        
        /**
         * Enable/disable global SSL context parameters use.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useGlobalSslContextParameters the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    
        /**
         * Username for MQTT server authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default TahuHostComponentBuilder username(java.lang.String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    class TahuHostComponentBuilderImpl
            extends AbstractComponentBuilder<TahuHostComponent>
            implements TahuHostComponentBuilder {
        @Override
        protected TahuHostComponent buildConcreteComponent() {
            return new TahuHostComponent();
        }
        private org.apache.camel.component.tahu.TahuConfiguration getOrCreateConfiguration(TahuHostComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.tahu.TahuConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "checkClientIdLength": getOrCreateConfiguration((TahuHostComponent) component).setCheckClientIdLength((boolean) value); return true;
            case "clientId": getOrCreateConfiguration((TahuHostComponent) component).setClientId((java.lang.String) value); return true;
            case "keepAliveTimeout": getOrCreateConfiguration((TahuHostComponent) component).setKeepAliveTimeout((int) value); return true;
            case "rebirthDebounceDelay": getOrCreateConfiguration((TahuHostComponent) component).setRebirthDebounceDelay((long) value); return true;
            case "servers": getOrCreateConfiguration((TahuHostComponent) component).setServers((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((TahuHostComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "autowiredEnabled": ((TahuHostComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "configuration": ((TahuHostComponent) component).setConfiguration((org.apache.camel.component.tahu.TahuConfiguration) value); return true;
            case "password": getOrCreateConfiguration((TahuHostComponent) component).setPassword((java.lang.String) value); return true;
            case "sslContextParameters": getOrCreateConfiguration((TahuHostComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((TahuHostComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            case "username": getOrCreateConfiguration((TahuHostComponent) component).setUsername((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}