/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Communicate with MQTT message brokers using Eclipse Paho MQTT v5 Client.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface PahoMqtt5EndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Paho MQTT 5 component.
     */
    public interface PahoMqtt5EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedPahoMqtt5EndpointConsumerBuilder advanced() {
            return (AdvancedPahoMqtt5EndpointConsumerBuilder) this;
        }
        /**
         * Sets whether the client will automatically attempt to reconnect to
         * the server if the connection is lost. If set to false, the client
         * will not attempt to automatically reconnect to the server in the
         * event that the connection is lost. If set to true, in the event that
         * the connection is lost, the client will attempt to reconnect to the
         * server. It will initially wait 1 second before it attempts to
         * reconnect, for every failed reconnect attempt, the delay will double
         * until it is at 2 minutes at which point the delay will stay at 2
         * minutes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticReconnect the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder automaticReconnect(boolean automaticReconnect) {
            doSetProperty("automaticReconnect", automaticReconnect);
            return this;
        }
        /**
         * Sets whether the client will automatically attempt to reconnect to
         * the server if the connection is lost. If set to false, the client
         * will not attempt to automatically reconnect to the server in the
         * event that the connection is lost. If set to true, in the event that
         * the connection is lost, the client will attempt to reconnect to the
         * server. It will initially wait 1 second before it attempts to
         * reconnect, for every failed reconnect attempt, the delay will double
         * until it is at 2 minutes at which point the delay will stay at 2
         * minutes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticReconnect the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder automaticReconnect(String automaticReconnect) {
            doSetProperty("automaticReconnect", automaticReconnect);
            return this;
        }
        /**
         * The URL of the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: tcp://localhost:1883
         * Group: common
         * 
         * @param brokerUrl the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder brokerUrl(String brokerUrl) {
            doSetProperty("brokerUrl", brokerUrl);
            return this;
        }
        /**
         * Sets whether the client and server should remember state across
         * restarts and reconnects. If set to false both the client and server
         * will maintain state across restarts of the client, the server and the
         * connection. As state is maintained: Message delivery will be reliable
         * meeting the specified QOS even if the client, server or connection
         * are restarted. The server will treat a subscription as durable. If
         * set to true the client and server will not maintain state across
         * restarts of the client, the server or the connection. This means
         * Message delivery to the specified QOS cannot be maintained if the
         * client, server or connection are restarted The server will treat a
         * subscription as non-durable.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param cleanStart the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder cleanStart(boolean cleanStart) {
            doSetProperty("cleanStart", cleanStart);
            return this;
        }
        /**
         * Sets whether the client and server should remember state across
         * restarts and reconnects. If set to false both the client and server
         * will maintain state across restarts of the client, the server and the
         * connection. As state is maintained: Message delivery will be reliable
         * meeting the specified QOS even if the client, server or connection
         * are restarted. The server will treat a subscription as durable. If
         * set to true the client and server will not maintain state across
         * restarts of the client, the server or the connection. This means
         * Message delivery to the specified QOS cannot be maintained if the
         * client, server or connection are restarted The server will treat a
         * subscription as non-durable.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param cleanStart the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder cleanStart(String cleanStart) {
            doSetProperty("cleanStart", cleanStart);
            return this;
        }
        /**
         * MQTT client identifier. The identifier must be unique.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Sets the connection timeout value. This value, measured in seconds,
         * defines the maximum time interval the client will wait for the
         * network connection to the MQTT server to be established. The default
         * timeout is 30 seconds. A value of 0 disables timeout processing
         * meaning the client will wait until the network connection is made
         * successfully or fails.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Sets the connection timeout value. This value, measured in seconds,
         * defines the maximum time interval the client will wait for the
         * network connection to the MQTT server to be established. The default
         * timeout is 30 seconds. A value of 0 disables timeout processing
         * meaning the client will wait until the network connection is made
         * successfully or fails.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Base directory used by file persistence. Will by default use user
         * directory.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param filePersistenceDirectory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder filePersistenceDirectory(String filePersistenceDirectory) {
            doSetProperty("filePersistenceDirectory", filePersistenceDirectory);
            return this;
        }
        /**
         * Sets the keep alive interval. This value, measured in seconds,
         * defines the maximum time interval between messages sent or received.
         * It enables the client to detect if the server is no longer available,
         * without having to wait for the TCP/IP timeout. The client will ensure
         * that at least one message travels across the network within each keep
         * alive period. In the absence of a data-related message during the
         * time period, the client sends a very small ping message, which the
         * server will acknowledge. A value of 0 disables keepalive processing
         * in the client. The default value is 60 seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param keepAliveInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder keepAliveInterval(int keepAliveInterval) {
            doSetProperty("keepAliveInterval", keepAliveInterval);
            return this;
        }
        /**
         * Sets the keep alive interval. This value, measured in seconds,
         * defines the maximum time interval between messages sent or received.
         * It enables the client to detect if the server is no longer available,
         * without having to wait for the TCP/IP timeout. The client will ensure
         * that at least one message travels across the network within each keep
         * alive period. In the absence of a data-related message during the
         * time period, the client sends a very small ping message, which the
         * server will acknowledge. A value of 0 disables keepalive processing
         * in the client. The default value is 60 seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param keepAliveInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder keepAliveInterval(String keepAliveInterval) {
            doSetProperty("keepAliveInterval", keepAliveInterval);
            return this;
        }
        /**
         * Get the maximum time (in millis) to wait between reconnects.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 128000
         * Group: common
         * 
         * @param maxReconnectDelay the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder maxReconnectDelay(int maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Get the maximum time (in millis) to wait between reconnects.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 128000
         * Group: common
         * 
         * @param maxReconnectDelay the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder maxReconnectDelay(String maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Client persistence to be used - memory or file.
         * 
         * The option is a:
         * <code>org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence</code> type.
         * 
         * Default: MEMORY
         * Group: common
         * 
         * @param persistence the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder persistence(org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence persistence) {
            doSetProperty("persistence", persistence);
            return this;
        }
        /**
         * Client persistence to be used - memory or file.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence</code> type.
         * 
         * Default: MEMORY
         * Group: common
         * 
         * @param persistence the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder persistence(String persistence) {
            doSetProperty("persistence", persistence);
            return this;
        }
        /**
         * Client quality of service level (0-2).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param qos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder qos(int qos) {
            doSetProperty("qos", qos);
            return this;
        }
        /**
         * Client quality of service level (0-2).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param qos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder qos(String qos) {
            doSetProperty("qos", qos);
            return this;
        }
        /**
         * Sets the Receive Maximum. This value represents the limit of QoS 1
         * and QoS 2 publications that the client is willing to process
         * concurrently. There is no mechanism to limit the number of QoS 0
         * publications that the Server might try to send. The default value is
         * 65535.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 65535
         * Group: common
         * 
         * @param receiveMaximum the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder receiveMaximum(int receiveMaximum) {
            doSetProperty("receiveMaximum", receiveMaximum);
            return this;
        }
        /**
         * Sets the Receive Maximum. This value represents the limit of QoS 1
         * and QoS 2 publications that the client is willing to process
         * concurrently. There is no mechanism to limit the number of QoS 0
         * publications that the Server might try to send. The default value is
         * 65535.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 65535
         * Group: common
         * 
         * @param receiveMaximum the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder receiveMaximum(String receiveMaximum) {
            doSetProperty("receiveMaximum", receiveMaximum);
            return this;
        }
        /**
         * Retain option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param retained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder retained(boolean retained) {
            doSetProperty("retained", retained);
            return this;
        }
        /**
         * Retain option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param retained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder retained(String retained) {
            doSetProperty("retained", retained);
            return this;
        }
        /**
         * Set a list of one or more serverURIs the client may connect to.
         * Multiple servers can be separated by comma. Each serverURI specifies
         * the address of a server that the client may connect to. Two types of
         * connection are supported tcp:// for a TCP connection and ssl:// for a
         * TCP connection secured by SSL/TLS. For example: tcp://localhost:1883
         * ssl://localhost:8883 If the port is not specified, it will default to
         * 1883 for tcp:// URIs, and 8883 for ssl:// URIs. If serverURIs is set
         * then it overrides the serverURI parameter passed in on the
         * constructor of the MQTT client. When an attempt to connect is
         * initiated the client will start with the first serverURI in the list
         * and work through the list until a connection is established with a
         * server. If a connection cannot be made to any of the servers then the
         * connect attempt fails. Specifying a list of servers that a client may
         * connect to has several uses: High Availability and reliable message
         * delivery Some MQTT servers support a high availability feature where
         * two or more equal MQTT servers share state. An MQTT client can
         * connect to any of the equal servers and be assured that messages are
         * reliably delivered and durable subscriptions are maintained no matter
         * which server the client connects to. The cleansession flag must be
         * set to false if durable subscriptions and/or reliable message
         * delivery is required. Hunt List A set of servers may be specified
         * that are not equal (as in the high availability option). As no state
         * is shared across the servers reliable message delivery and durable
         * subscriptions are not valid. The cleansession flag must be set to
         * true if the hunt list mode is used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serverURIs the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder serverURIs(String serverURIs) {
            doSetProperty("serverURIs", serverURIs);
            return this;
        }
        /**
         * Sets the Session Expiry Interval. This value, measured in seconds,
         * defines the maximum time that the broker will maintain the session
         * for once the client disconnects. Clients should only connect with a
         * long Session Expiry interval if they intend to connect to the server
         * at some later point in time. By default this value is -1 and so will
         * not be sent, in this case, the session will not expire. If a 0 is
         * sent, the session will end immediately once the Network Connection is
         * closed. When the client has determined that it has no longer any use
         * for the session, it should disconnect with a Session Expiry Interval
         * set to 0.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param sessionExpiryInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder sessionExpiryInterval(long sessionExpiryInterval) {
            doSetProperty("sessionExpiryInterval", sessionExpiryInterval);
            return this;
        }
        /**
         * Sets the Session Expiry Interval. This value, measured in seconds,
         * defines the maximum time that the broker will maintain the session
         * for once the client disconnects. Clients should only connect with a
         * long Session Expiry interval if they intend to connect to the server
         * at some later point in time. By default this value is -1 and so will
         * not be sent, in this case, the session will not expire. If a 0 is
         * sent, the session will end immediately once the Network Connection is
         * closed. When the client has determined that it has no longer any use
         * for the session, it should disconnect with a Session Expiry Interval
         * set to 0.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param sessionExpiryInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder sessionExpiryInterval(String sessionExpiryInterval) {
            doSetProperty("sessionExpiryInterval", sessionExpiryInterval);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The MQTT properties set for the message.
         * 
         * The option is a:
         * <code>org.eclipse.paho.mqttv5.common.packet.MqttProperties</code>
         * type.
         * 
         * Group: common
         * 
         * @param willMqttProperties the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willMqttProperties(org.eclipse.paho.mqttv5.common.packet.MqttProperties willMqttProperties) {
            doSetProperty("willMqttProperties", willMqttProperties);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The MQTT properties set for the message.
         * 
         * The option will be converted to a
         * <code>org.eclipse.paho.mqttv5.common.packet.MqttProperties</code>
         * type.
         * 
         * Group: common
         * 
         * @param willMqttProperties the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willMqttProperties(String willMqttProperties) {
            doSetProperty("willMqttProperties", willMqttProperties);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The byte payload for the message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param willPayload the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willPayload(String willPayload) {
            doSetProperty("willPayload", willPayload);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The quality of service to publish the message at
         * (0, 1 or 2).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param willQos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willQos(int willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The quality of service to publish the message at
         * (0, 1 or 2).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param willQos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willQos(String willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. Whether or not the message should be retained.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param willRetained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willRetained(boolean willRetained) {
            doSetProperty("willRetained", willRetained);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. Whether or not the message should be retained.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param willRetained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willRetained(String willRetained) {
            doSetProperty("willRetained", willRetained);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The topic to publish to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param willTopic the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder willTopic(String willTopic) {
            doSetProperty("willTopic", willTopic);
            return this;
        }
        /**
         * Whether SSL HostnameVerifier is enabled or not. The default value is
         * true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         * 
         * @param httpsHostnameVerificationEnabled the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder httpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
            doSetProperty("httpsHostnameVerificationEnabled", httpsHostnameVerificationEnabled);
            return this;
        }
        /**
         * Whether SSL HostnameVerifier is enabled or not. The default value is
         * true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         * 
         * @param httpsHostnameVerificationEnabled the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder httpsHostnameVerificationEnabled(String httpsHostnameVerificationEnabled) {
            doSetProperty("httpsHostnameVerificationEnabled", httpsHostnameVerificationEnabled);
            return this;
        }
        /**
         * Password to be used for authentication against the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the SocketFactory to use. This allows an application to apply
         * its own policies around the creation of network sockets. If using an
         * SSL connection, an SSLSocketFactory can be used to supply
         * application-specific security settings.
         * 
         * The option is a: <code>javax.net.SocketFactory</code> type.
         * 
         * Group: security
         * 
         * @param socketFactory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder socketFactory(javax.net.SocketFactory socketFactory) {
            doSetProperty("socketFactory", socketFactory);
            return this;
        }
        /**
         * Sets the SocketFactory to use. This allows an application to apply
         * its own policies around the creation of network sockets. If using an
         * SSL connection, an SSLSocketFactory can be used to supply
         * application-specific security settings.
         * 
         * The option will be converted to a
         * <code>javax.net.SocketFactory</code> type.
         * 
         * Group: security
         * 
         * @param socketFactory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder socketFactory(String socketFactory) {
            doSetProperty("socketFactory", socketFactory);
            return this;
        }
        /**
         * Sets the SSL properties for the connection. Note that these
         * properties are only valid if an implementation of the Java Secure
         * Socket Extensions (JSSE) is available. These properties are not used
         * if a custom SocketFactory has been set. The following properties can
         * be used: com.ibm.ssl.protocol One of: SSL, SSLv3, TLS, TLSv1,
         * SSL_TLS. com.ibm.ssl.contextProvider Underlying JSSE provider. For
         * example IBMJSSE2 or SunJSSE com.ibm.ssl.keyStore The name of the file
         * that contains the KeyStore object that you want the KeyManager to
         * use. For example /mydir/etc/key.p12 com.ibm.ssl.keyStorePassword The
         * password for the KeyStore object that you want the KeyManager to use.
         * The password can either be in plain-text, or may be obfuscated using
         * the static method: com.ibm.micro.security.Password.obfuscate(char
         * password). This obfuscates the password using a simple and insecure
         * XOR and Base64 encoding mechanism. Note that this is only a simple
         * scrambler to obfuscate clear-text passwords. com.ibm.ssl.keyStoreType
         * Type of key store, for example PKCS12, JKS, or JCEKS.
         * com.ibm.ssl.keyStoreProvider Key store provider, for example IBMJCE
         * or IBMJCEFIPS. com.ibm.ssl.trustStore The name of the file that
         * contains the KeyStore object that you want the TrustManager to use.
         * com.ibm.ssl.trustStorePassword The password for the TrustStore object
         * that you want the TrustManager to use. The password can either be in
         * plain-text, or may be obfuscated using the static method:
         * com.ibm.micro.security.Password.obfuscate(char password). This
         * obfuscates the password using a simple and insecure XOR and Base64
         * encoding mechanism. Note that this is only a simple scrambler to
         * obfuscate clear-text passwords. com.ibm.ssl.trustStoreType The type
         * of KeyStore object that you want the default TrustManager to use.
         * Same possible values as keyStoreType. com.ibm.ssl.trustStoreProvider
         * Trust store provider, for example IBMJCE or IBMJCEFIPS.
         * com.ibm.ssl.enabledCipherSuites A list of which ciphers are enabled.
         * Values are dependent on the provider, for example:
         * SSL_RSA_WITH_AES_128_CBC_SHA;SSL_RSA_WITH_3DES_EDE_CBC_SHA.
         * com.ibm.ssl.keyManager Sets the algorithm that will be used to
         * instantiate a KeyManagerFactory object instead of using the default
         * algorithm available in the platform. Example values: IbmX509 or
         * IBMJ9X509. com.ibm.ssl.trustManager Sets the algorithm that will be
         * used to instantiate a TrustManagerFactory object instead of using the
         * default algorithm available in the platform. Example values: PKIX or
         * IBMJ9X509.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: security
         * 
         * @param sslClientProps the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder sslClientProps(Properties sslClientProps) {
            doSetProperty("sslClientProps", sslClientProps);
            return this;
        }
        /**
         * Sets the SSL properties for the connection. Note that these
         * properties are only valid if an implementation of the Java Secure
         * Socket Extensions (JSSE) is available. These properties are not used
         * if a custom SocketFactory has been set. The following properties can
         * be used: com.ibm.ssl.protocol One of: SSL, SSLv3, TLS, TLSv1,
         * SSL_TLS. com.ibm.ssl.contextProvider Underlying JSSE provider. For
         * example IBMJSSE2 or SunJSSE com.ibm.ssl.keyStore The name of the file
         * that contains the KeyStore object that you want the KeyManager to
         * use. For example /mydir/etc/key.p12 com.ibm.ssl.keyStorePassword The
         * password for the KeyStore object that you want the KeyManager to use.
         * The password can either be in plain-text, or may be obfuscated using
         * the static method: com.ibm.micro.security.Password.obfuscate(char
         * password). This obfuscates the password using a simple and insecure
         * XOR and Base64 encoding mechanism. Note that this is only a simple
         * scrambler to obfuscate clear-text passwords. com.ibm.ssl.keyStoreType
         * Type of key store, for example PKCS12, JKS, or JCEKS.
         * com.ibm.ssl.keyStoreProvider Key store provider, for example IBMJCE
         * or IBMJCEFIPS. com.ibm.ssl.trustStore The name of the file that
         * contains the KeyStore object that you want the TrustManager to use.
         * com.ibm.ssl.trustStorePassword The password for the TrustStore object
         * that you want the TrustManager to use. The password can either be in
         * plain-text, or may be obfuscated using the static method:
         * com.ibm.micro.security.Password.obfuscate(char password). This
         * obfuscates the password using a simple and insecure XOR and Base64
         * encoding mechanism. Note that this is only a simple scrambler to
         * obfuscate clear-text passwords. com.ibm.ssl.trustStoreType The type
         * of KeyStore object that you want the default TrustManager to use.
         * Same possible values as keyStoreType. com.ibm.ssl.trustStoreProvider
         * Trust store provider, for example IBMJCE or IBMJCEFIPS.
         * com.ibm.ssl.enabledCipherSuites A list of which ciphers are enabled.
         * Values are dependent on the provider, for example:
         * SSL_RSA_WITH_AES_128_CBC_SHA;SSL_RSA_WITH_3DES_EDE_CBC_SHA.
         * com.ibm.ssl.keyManager Sets the algorithm that will be used to
         * instantiate a KeyManagerFactory object instead of using the default
         * algorithm available in the platform. Example values: IbmX509 or
         * IBMJ9X509. com.ibm.ssl.trustManager Sets the algorithm that will be
         * used to instantiate a TrustManagerFactory object instead of using the
         * default algorithm available in the platform. Example values: PKIX or
         * IBMJ9X509.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: security
         * 
         * @param sslClientProps the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder sslClientProps(String sslClientProps) {
            doSetProperty("sslClientProps", sslClientProps);
            return this;
        }
        /**
         * Sets the HostnameVerifier for the SSL connection. Note that it will
         * be used after handshake on a connection and you should do actions by
         * yourself when hostname is verified error. There is no default
         * HostnameVerifier.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param sslHostnameVerifier the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder sslHostnameVerifier(javax.net.ssl.HostnameVerifier sslHostnameVerifier) {
            doSetProperty("sslHostnameVerifier", sslHostnameVerifier);
            return this;
        }
        /**
         * Sets the HostnameVerifier for the SSL connection. Note that it will
         * be used after handshake on a connection and you should do actions by
         * yourself when hostname is verified error. There is no default
         * HostnameVerifier.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param sslHostnameVerifier the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder sslHostnameVerifier(String sslHostnameVerifier) {
            doSetProperty("sslHostnameVerifier", sslHostnameVerifier);
            return this;
        }
        /**
         * Username to be used for authentication against the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Paho MQTT 5 component.
     */
    public interface AdvancedPahoMqtt5EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default PahoMqtt5EndpointConsumerBuilder basic() {
            return (PahoMqtt5EndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To use an existing mqtt client.
         * 
         * The option is a:
         * <code>org.eclipse.paho.mqttv5.client.MqttClient</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder client(org.eclipse.paho.mqttv5.client.MqttClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use an existing mqtt client.
         * 
         * The option will be converted to a
         * <code>org.eclipse.paho.mqttv5.client.MqttClient</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * Sets the Custom WebSocket Headers for the WebSocket Connection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param customWebSocketHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder customWebSocketHeaders(Map<java.lang.String, java.lang.String> customWebSocketHeaders) {
            doSetProperty("customWebSocketHeaders", customWebSocketHeaders);
            return this;
        }
        /**
         * Sets the Custom WebSocket Headers for the WebSocket Connection.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param customWebSocketHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder customWebSocketHeaders(String customWebSocketHeaders) {
            doSetProperty("customWebSocketHeaders", customWebSocketHeaders);
            return this;
        }
        /**
         * Set the time in seconds that the executor service should wait when
         * terminating before forcefully terminating. It is not recommended to
         * change this value unless you are absolutely sure that you need to.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param executorServiceTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder executorServiceTimeout(int executorServiceTimeout) {
            doSetProperty("executorServiceTimeout", executorServiceTimeout);
            return this;
        }
        /**
         * Set the time in seconds that the executor service should wait when
         * terminating before forcefully terminating. It is not recommended to
         * change this value unless you are absolutely sure that you need to.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param executorServiceTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointConsumerBuilder executorServiceTimeout(String executorServiceTimeout) {
            doSetProperty("executorServiceTimeout", executorServiceTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Paho MQTT 5 component.
     */
    public interface PahoMqtt5EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedPahoMqtt5EndpointProducerBuilder advanced() {
            return (AdvancedPahoMqtt5EndpointProducerBuilder) this;
        }

        /**
         * Sets whether the client will automatically attempt to reconnect to
         * the server if the connection is lost. If set to false, the client
         * will not attempt to automatically reconnect to the server in the
         * event that the connection is lost. If set to true, in the event that
         * the connection is lost, the client will attempt to reconnect to the
         * server. It will initially wait 1 second before it attempts to
         * reconnect, for every failed reconnect attempt, the delay will double
         * until it is at 2 minutes at which point the delay will stay at 2
         * minutes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticReconnect the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder automaticReconnect(boolean automaticReconnect) {
            doSetProperty("automaticReconnect", automaticReconnect);
            return this;
        }
        /**
         * Sets whether the client will automatically attempt to reconnect to
         * the server if the connection is lost. If set to false, the client
         * will not attempt to automatically reconnect to the server in the
         * event that the connection is lost. If set to true, in the event that
         * the connection is lost, the client will attempt to reconnect to the
         * server. It will initially wait 1 second before it attempts to
         * reconnect, for every failed reconnect attempt, the delay will double
         * until it is at 2 minutes at which point the delay will stay at 2
         * minutes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticReconnect the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder automaticReconnect(String automaticReconnect) {
            doSetProperty("automaticReconnect", automaticReconnect);
            return this;
        }
        /**
         * The URL of the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: tcp://localhost:1883
         * Group: common
         * 
         * @param brokerUrl the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder brokerUrl(String brokerUrl) {
            doSetProperty("brokerUrl", brokerUrl);
            return this;
        }
        /**
         * Sets whether the client and server should remember state across
         * restarts and reconnects. If set to false both the client and server
         * will maintain state across restarts of the client, the server and the
         * connection. As state is maintained: Message delivery will be reliable
         * meeting the specified QOS even if the client, server or connection
         * are restarted. The server will treat a subscription as durable. If
         * set to true the client and server will not maintain state across
         * restarts of the client, the server or the connection. This means
         * Message delivery to the specified QOS cannot be maintained if the
         * client, server or connection are restarted The server will treat a
         * subscription as non-durable.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param cleanStart the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder cleanStart(boolean cleanStart) {
            doSetProperty("cleanStart", cleanStart);
            return this;
        }
        /**
         * Sets whether the client and server should remember state across
         * restarts and reconnects. If set to false both the client and server
         * will maintain state across restarts of the client, the server and the
         * connection. As state is maintained: Message delivery will be reliable
         * meeting the specified QOS even if the client, server or connection
         * are restarted. The server will treat a subscription as durable. If
         * set to true the client and server will not maintain state across
         * restarts of the client, the server or the connection. This means
         * Message delivery to the specified QOS cannot be maintained if the
         * client, server or connection are restarted The server will treat a
         * subscription as non-durable.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param cleanStart the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder cleanStart(String cleanStart) {
            doSetProperty("cleanStart", cleanStart);
            return this;
        }
        /**
         * MQTT client identifier. The identifier must be unique.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Sets the connection timeout value. This value, measured in seconds,
         * defines the maximum time interval the client will wait for the
         * network connection to the MQTT server to be established. The default
         * timeout is 30 seconds. A value of 0 disables timeout processing
         * meaning the client will wait until the network connection is made
         * successfully or fails.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Sets the connection timeout value. This value, measured in seconds,
         * defines the maximum time interval the client will wait for the
         * network connection to the MQTT server to be established. The default
         * timeout is 30 seconds. A value of 0 disables timeout processing
         * meaning the client will wait until the network connection is made
         * successfully or fails.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Base directory used by file persistence. Will by default use user
         * directory.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param filePersistenceDirectory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder filePersistenceDirectory(String filePersistenceDirectory) {
            doSetProperty("filePersistenceDirectory", filePersistenceDirectory);
            return this;
        }
        /**
         * Sets the keep alive interval. This value, measured in seconds,
         * defines the maximum time interval between messages sent or received.
         * It enables the client to detect if the server is no longer available,
         * without having to wait for the TCP/IP timeout. The client will ensure
         * that at least one message travels across the network within each keep
         * alive period. In the absence of a data-related message during the
         * time period, the client sends a very small ping message, which the
         * server will acknowledge. A value of 0 disables keepalive processing
         * in the client. The default value is 60 seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param keepAliveInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder keepAliveInterval(int keepAliveInterval) {
            doSetProperty("keepAliveInterval", keepAliveInterval);
            return this;
        }
        /**
         * Sets the keep alive interval. This value, measured in seconds,
         * defines the maximum time interval between messages sent or received.
         * It enables the client to detect if the server is no longer available,
         * without having to wait for the TCP/IP timeout. The client will ensure
         * that at least one message travels across the network within each keep
         * alive period. In the absence of a data-related message during the
         * time period, the client sends a very small ping message, which the
         * server will acknowledge. A value of 0 disables keepalive processing
         * in the client. The default value is 60 seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param keepAliveInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder keepAliveInterval(String keepAliveInterval) {
            doSetProperty("keepAliveInterval", keepAliveInterval);
            return this;
        }
        /**
         * Get the maximum time (in millis) to wait between reconnects.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 128000
         * Group: common
         * 
         * @param maxReconnectDelay the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder maxReconnectDelay(int maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Get the maximum time (in millis) to wait between reconnects.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 128000
         * Group: common
         * 
         * @param maxReconnectDelay the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder maxReconnectDelay(String maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Client persistence to be used - memory or file.
         * 
         * The option is a:
         * <code>org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence</code> type.
         * 
         * Default: MEMORY
         * Group: common
         * 
         * @param persistence the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder persistence(org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence persistence) {
            doSetProperty("persistence", persistence);
            return this;
        }
        /**
         * Client persistence to be used - memory or file.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence</code> type.
         * 
         * Default: MEMORY
         * Group: common
         * 
         * @param persistence the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder persistence(String persistence) {
            doSetProperty("persistence", persistence);
            return this;
        }
        /**
         * Client quality of service level (0-2).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param qos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder qos(int qos) {
            doSetProperty("qos", qos);
            return this;
        }
        /**
         * Client quality of service level (0-2).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param qos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder qos(String qos) {
            doSetProperty("qos", qos);
            return this;
        }
        /**
         * Sets the Receive Maximum. This value represents the limit of QoS 1
         * and QoS 2 publications that the client is willing to process
         * concurrently. There is no mechanism to limit the number of QoS 0
         * publications that the Server might try to send. The default value is
         * 65535.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 65535
         * Group: common
         * 
         * @param receiveMaximum the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder receiveMaximum(int receiveMaximum) {
            doSetProperty("receiveMaximum", receiveMaximum);
            return this;
        }
        /**
         * Sets the Receive Maximum. This value represents the limit of QoS 1
         * and QoS 2 publications that the client is willing to process
         * concurrently. There is no mechanism to limit the number of QoS 0
         * publications that the Server might try to send. The default value is
         * 65535.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 65535
         * Group: common
         * 
         * @param receiveMaximum the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder receiveMaximum(String receiveMaximum) {
            doSetProperty("receiveMaximum", receiveMaximum);
            return this;
        }
        /**
         * Retain option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param retained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder retained(boolean retained) {
            doSetProperty("retained", retained);
            return this;
        }
        /**
         * Retain option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param retained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder retained(String retained) {
            doSetProperty("retained", retained);
            return this;
        }
        /**
         * Set a list of one or more serverURIs the client may connect to.
         * Multiple servers can be separated by comma. Each serverURI specifies
         * the address of a server that the client may connect to. Two types of
         * connection are supported tcp:// for a TCP connection and ssl:// for a
         * TCP connection secured by SSL/TLS. For example: tcp://localhost:1883
         * ssl://localhost:8883 If the port is not specified, it will default to
         * 1883 for tcp:// URIs, and 8883 for ssl:// URIs. If serverURIs is set
         * then it overrides the serverURI parameter passed in on the
         * constructor of the MQTT client. When an attempt to connect is
         * initiated the client will start with the first serverURI in the list
         * and work through the list until a connection is established with a
         * server. If a connection cannot be made to any of the servers then the
         * connect attempt fails. Specifying a list of servers that a client may
         * connect to has several uses: High Availability and reliable message
         * delivery Some MQTT servers support a high availability feature where
         * two or more equal MQTT servers share state. An MQTT client can
         * connect to any of the equal servers and be assured that messages are
         * reliably delivered and durable subscriptions are maintained no matter
         * which server the client connects to. The cleansession flag must be
         * set to false if durable subscriptions and/or reliable message
         * delivery is required. Hunt List A set of servers may be specified
         * that are not equal (as in the high availability option). As no state
         * is shared across the servers reliable message delivery and durable
         * subscriptions are not valid. The cleansession flag must be set to
         * true if the hunt list mode is used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serverURIs the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder serverURIs(String serverURIs) {
            doSetProperty("serverURIs", serverURIs);
            return this;
        }
        /**
         * Sets the Session Expiry Interval. This value, measured in seconds,
         * defines the maximum time that the broker will maintain the session
         * for once the client disconnects. Clients should only connect with a
         * long Session Expiry interval if they intend to connect to the server
         * at some later point in time. By default this value is -1 and so will
         * not be sent, in this case, the session will not expire. If a 0 is
         * sent, the session will end immediately once the Network Connection is
         * closed. When the client has determined that it has no longer any use
         * for the session, it should disconnect with a Session Expiry Interval
         * set to 0.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param sessionExpiryInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder sessionExpiryInterval(long sessionExpiryInterval) {
            doSetProperty("sessionExpiryInterval", sessionExpiryInterval);
            return this;
        }
        /**
         * Sets the Session Expiry Interval. This value, measured in seconds,
         * defines the maximum time that the broker will maintain the session
         * for once the client disconnects. Clients should only connect with a
         * long Session Expiry interval if they intend to connect to the server
         * at some later point in time. By default this value is -1 and so will
         * not be sent, in this case, the session will not expire. If a 0 is
         * sent, the session will end immediately once the Network Connection is
         * closed. When the client has determined that it has no longer any use
         * for the session, it should disconnect with a Session Expiry Interval
         * set to 0.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param sessionExpiryInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder sessionExpiryInterval(String sessionExpiryInterval) {
            doSetProperty("sessionExpiryInterval", sessionExpiryInterval);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The MQTT properties set for the message.
         * 
         * The option is a:
         * <code>org.eclipse.paho.mqttv5.common.packet.MqttProperties</code>
         * type.
         * 
         * Group: common
         * 
         * @param willMqttProperties the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willMqttProperties(org.eclipse.paho.mqttv5.common.packet.MqttProperties willMqttProperties) {
            doSetProperty("willMqttProperties", willMqttProperties);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The MQTT properties set for the message.
         * 
         * The option will be converted to a
         * <code>org.eclipse.paho.mqttv5.common.packet.MqttProperties</code>
         * type.
         * 
         * Group: common
         * 
         * @param willMqttProperties the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willMqttProperties(String willMqttProperties) {
            doSetProperty("willMqttProperties", willMqttProperties);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The byte payload for the message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param willPayload the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willPayload(String willPayload) {
            doSetProperty("willPayload", willPayload);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The quality of service to publish the message at
         * (0, 1 or 2).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param willQos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willQos(int willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The quality of service to publish the message at
         * (0, 1 or 2).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param willQos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willQos(String willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. Whether or not the message should be retained.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param willRetained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willRetained(boolean willRetained) {
            doSetProperty("willRetained", willRetained);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. Whether or not the message should be retained.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param willRetained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willRetained(String willRetained) {
            doSetProperty("willRetained", willRetained);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The topic to publish to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param willTopic the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder willTopic(String willTopic) {
            doSetProperty("willTopic", willTopic);
            return this;
        }
        /**
         * Whether SSL HostnameVerifier is enabled or not. The default value is
         * true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         * 
         * @param httpsHostnameVerificationEnabled the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder httpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
            doSetProperty("httpsHostnameVerificationEnabled", httpsHostnameVerificationEnabled);
            return this;
        }
        /**
         * Whether SSL HostnameVerifier is enabled or not. The default value is
         * true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         * 
         * @param httpsHostnameVerificationEnabled the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder httpsHostnameVerificationEnabled(String httpsHostnameVerificationEnabled) {
            doSetProperty("httpsHostnameVerificationEnabled", httpsHostnameVerificationEnabled);
            return this;
        }
        /**
         * Password to be used for authentication against the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the SocketFactory to use. This allows an application to apply
         * its own policies around the creation of network sockets. If using an
         * SSL connection, an SSLSocketFactory can be used to supply
         * application-specific security settings.
         * 
         * The option is a: <code>javax.net.SocketFactory</code> type.
         * 
         * Group: security
         * 
         * @param socketFactory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder socketFactory(javax.net.SocketFactory socketFactory) {
            doSetProperty("socketFactory", socketFactory);
            return this;
        }
        /**
         * Sets the SocketFactory to use. This allows an application to apply
         * its own policies around the creation of network sockets. If using an
         * SSL connection, an SSLSocketFactory can be used to supply
         * application-specific security settings.
         * 
         * The option will be converted to a
         * <code>javax.net.SocketFactory</code> type.
         * 
         * Group: security
         * 
         * @param socketFactory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder socketFactory(String socketFactory) {
            doSetProperty("socketFactory", socketFactory);
            return this;
        }
        /**
         * Sets the SSL properties for the connection. Note that these
         * properties are only valid if an implementation of the Java Secure
         * Socket Extensions (JSSE) is available. These properties are not used
         * if a custom SocketFactory has been set. The following properties can
         * be used: com.ibm.ssl.protocol One of: SSL, SSLv3, TLS, TLSv1,
         * SSL_TLS. com.ibm.ssl.contextProvider Underlying JSSE provider. For
         * example IBMJSSE2 or SunJSSE com.ibm.ssl.keyStore The name of the file
         * that contains the KeyStore object that you want the KeyManager to
         * use. For example /mydir/etc/key.p12 com.ibm.ssl.keyStorePassword The
         * password for the KeyStore object that you want the KeyManager to use.
         * The password can either be in plain-text, or may be obfuscated using
         * the static method: com.ibm.micro.security.Password.obfuscate(char
         * password). This obfuscates the password using a simple and insecure
         * XOR and Base64 encoding mechanism. Note that this is only a simple
         * scrambler to obfuscate clear-text passwords. com.ibm.ssl.keyStoreType
         * Type of key store, for example PKCS12, JKS, or JCEKS.
         * com.ibm.ssl.keyStoreProvider Key store provider, for example IBMJCE
         * or IBMJCEFIPS. com.ibm.ssl.trustStore The name of the file that
         * contains the KeyStore object that you want the TrustManager to use.
         * com.ibm.ssl.trustStorePassword The password for the TrustStore object
         * that you want the TrustManager to use. The password can either be in
         * plain-text, or may be obfuscated using the static method:
         * com.ibm.micro.security.Password.obfuscate(char password). This
         * obfuscates the password using a simple and insecure XOR and Base64
         * encoding mechanism. Note that this is only a simple scrambler to
         * obfuscate clear-text passwords. com.ibm.ssl.trustStoreType The type
         * of KeyStore object that you want the default TrustManager to use.
         * Same possible values as keyStoreType. com.ibm.ssl.trustStoreProvider
         * Trust store provider, for example IBMJCE or IBMJCEFIPS.
         * com.ibm.ssl.enabledCipherSuites A list of which ciphers are enabled.
         * Values are dependent on the provider, for example:
         * SSL_RSA_WITH_AES_128_CBC_SHA;SSL_RSA_WITH_3DES_EDE_CBC_SHA.
         * com.ibm.ssl.keyManager Sets the algorithm that will be used to
         * instantiate a KeyManagerFactory object instead of using the default
         * algorithm available in the platform. Example values: IbmX509 or
         * IBMJ9X509. com.ibm.ssl.trustManager Sets the algorithm that will be
         * used to instantiate a TrustManagerFactory object instead of using the
         * default algorithm available in the platform. Example values: PKIX or
         * IBMJ9X509.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: security
         * 
         * @param sslClientProps the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder sslClientProps(Properties sslClientProps) {
            doSetProperty("sslClientProps", sslClientProps);
            return this;
        }
        /**
         * Sets the SSL properties for the connection. Note that these
         * properties are only valid if an implementation of the Java Secure
         * Socket Extensions (JSSE) is available. These properties are not used
         * if a custom SocketFactory has been set. The following properties can
         * be used: com.ibm.ssl.protocol One of: SSL, SSLv3, TLS, TLSv1,
         * SSL_TLS. com.ibm.ssl.contextProvider Underlying JSSE provider. For
         * example IBMJSSE2 or SunJSSE com.ibm.ssl.keyStore The name of the file
         * that contains the KeyStore object that you want the KeyManager to
         * use. For example /mydir/etc/key.p12 com.ibm.ssl.keyStorePassword The
         * password for the KeyStore object that you want the KeyManager to use.
         * The password can either be in plain-text, or may be obfuscated using
         * the static method: com.ibm.micro.security.Password.obfuscate(char
         * password). This obfuscates the password using a simple and insecure
         * XOR and Base64 encoding mechanism. Note that this is only a simple
         * scrambler to obfuscate clear-text passwords. com.ibm.ssl.keyStoreType
         * Type of key store, for example PKCS12, JKS, or JCEKS.
         * com.ibm.ssl.keyStoreProvider Key store provider, for example IBMJCE
         * or IBMJCEFIPS. com.ibm.ssl.trustStore The name of the file that
         * contains the KeyStore object that you want the TrustManager to use.
         * com.ibm.ssl.trustStorePassword The password for the TrustStore object
         * that you want the TrustManager to use. The password can either be in
         * plain-text, or may be obfuscated using the static method:
         * com.ibm.micro.security.Password.obfuscate(char password). This
         * obfuscates the password using a simple and insecure XOR and Base64
         * encoding mechanism. Note that this is only a simple scrambler to
         * obfuscate clear-text passwords. com.ibm.ssl.trustStoreType The type
         * of KeyStore object that you want the default TrustManager to use.
         * Same possible values as keyStoreType. com.ibm.ssl.trustStoreProvider
         * Trust store provider, for example IBMJCE or IBMJCEFIPS.
         * com.ibm.ssl.enabledCipherSuites A list of which ciphers are enabled.
         * Values are dependent on the provider, for example:
         * SSL_RSA_WITH_AES_128_CBC_SHA;SSL_RSA_WITH_3DES_EDE_CBC_SHA.
         * com.ibm.ssl.keyManager Sets the algorithm that will be used to
         * instantiate a KeyManagerFactory object instead of using the default
         * algorithm available in the platform. Example values: IbmX509 or
         * IBMJ9X509. com.ibm.ssl.trustManager Sets the algorithm that will be
         * used to instantiate a TrustManagerFactory object instead of using the
         * default algorithm available in the platform. Example values: PKIX or
         * IBMJ9X509.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: security
         * 
         * @param sslClientProps the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder sslClientProps(String sslClientProps) {
            doSetProperty("sslClientProps", sslClientProps);
            return this;
        }
        /**
         * Sets the HostnameVerifier for the SSL connection. Note that it will
         * be used after handshake on a connection and you should do actions by
         * yourself when hostname is verified error. There is no default
         * HostnameVerifier.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param sslHostnameVerifier the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder sslHostnameVerifier(javax.net.ssl.HostnameVerifier sslHostnameVerifier) {
            doSetProperty("sslHostnameVerifier", sslHostnameVerifier);
            return this;
        }
        /**
         * Sets the HostnameVerifier for the SSL connection. Note that it will
         * be used after handshake on a connection and you should do actions by
         * yourself when hostname is verified error. There is no default
         * HostnameVerifier.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param sslHostnameVerifier the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder sslHostnameVerifier(String sslHostnameVerifier) {
            doSetProperty("sslHostnameVerifier", sslHostnameVerifier);
            return this;
        }
        /**
         * Username to be used for authentication against the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Paho MQTT 5 component.
     */
    public interface AdvancedPahoMqtt5EndpointProducerBuilder extends EndpointProducerBuilder {
        default PahoMqtt5EndpointProducerBuilder basic() {
            return (PahoMqtt5EndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use an existing mqtt client.
         * 
         * The option is a:
         * <code>org.eclipse.paho.mqttv5.client.MqttClient</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder client(org.eclipse.paho.mqttv5.client.MqttClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use an existing mqtt client.
         * 
         * The option will be converted to a
         * <code>org.eclipse.paho.mqttv5.client.MqttClient</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * Sets the Custom WebSocket Headers for the WebSocket Connection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param customWebSocketHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder customWebSocketHeaders(Map<java.lang.String, java.lang.String> customWebSocketHeaders) {
            doSetProperty("customWebSocketHeaders", customWebSocketHeaders);
            return this;
        }
        /**
         * Sets the Custom WebSocket Headers for the WebSocket Connection.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param customWebSocketHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder customWebSocketHeaders(String customWebSocketHeaders) {
            doSetProperty("customWebSocketHeaders", customWebSocketHeaders);
            return this;
        }
        /**
         * Set the time in seconds that the executor service should wait when
         * terminating before forcefully terminating. It is not recommended to
         * change this value unless you are absolutely sure that you need to.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param executorServiceTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder executorServiceTimeout(int executorServiceTimeout) {
            doSetProperty("executorServiceTimeout", executorServiceTimeout);
            return this;
        }
        /**
         * Set the time in seconds that the executor service should wait when
         * terminating before forcefully terminating. It is not recommended to
         * change this value unless you are absolutely sure that you need to.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param executorServiceTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointProducerBuilder executorServiceTimeout(String executorServiceTimeout) {
            doSetProperty("executorServiceTimeout", executorServiceTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Paho MQTT 5 component.
     */
    public interface PahoMqtt5EndpointBuilder
            extends
                PahoMqtt5EndpointConsumerBuilder,
                PahoMqtt5EndpointProducerBuilder {
        default AdvancedPahoMqtt5EndpointBuilder advanced() {
            return (AdvancedPahoMqtt5EndpointBuilder) this;
        }

        /**
         * Sets whether the client will automatically attempt to reconnect to
         * the server if the connection is lost. If set to false, the client
         * will not attempt to automatically reconnect to the server in the
         * event that the connection is lost. If set to true, in the event that
         * the connection is lost, the client will attempt to reconnect to the
         * server. It will initially wait 1 second before it attempts to
         * reconnect, for every failed reconnect attempt, the delay will double
         * until it is at 2 minutes at which point the delay will stay at 2
         * minutes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticReconnect the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder automaticReconnect(boolean automaticReconnect) {
            doSetProperty("automaticReconnect", automaticReconnect);
            return this;
        }
        /**
         * Sets whether the client will automatically attempt to reconnect to
         * the server if the connection is lost. If set to false, the client
         * will not attempt to automatically reconnect to the server in the
         * event that the connection is lost. If set to true, in the event that
         * the connection is lost, the client will attempt to reconnect to the
         * server. It will initially wait 1 second before it attempts to
         * reconnect, for every failed reconnect attempt, the delay will double
         * until it is at 2 minutes at which point the delay will stay at 2
         * minutes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticReconnect the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder automaticReconnect(String automaticReconnect) {
            doSetProperty("automaticReconnect", automaticReconnect);
            return this;
        }
        /**
         * The URL of the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: tcp://localhost:1883
         * Group: common
         * 
         * @param brokerUrl the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder brokerUrl(String brokerUrl) {
            doSetProperty("brokerUrl", brokerUrl);
            return this;
        }
        /**
         * Sets whether the client and server should remember state across
         * restarts and reconnects. If set to false both the client and server
         * will maintain state across restarts of the client, the server and the
         * connection. As state is maintained: Message delivery will be reliable
         * meeting the specified QOS even if the client, server or connection
         * are restarted. The server will treat a subscription as durable. If
         * set to true the client and server will not maintain state across
         * restarts of the client, the server or the connection. This means
         * Message delivery to the specified QOS cannot be maintained if the
         * client, server or connection are restarted The server will treat a
         * subscription as non-durable.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param cleanStart the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder cleanStart(boolean cleanStart) {
            doSetProperty("cleanStart", cleanStart);
            return this;
        }
        /**
         * Sets whether the client and server should remember state across
         * restarts and reconnects. If set to false both the client and server
         * will maintain state across restarts of the client, the server and the
         * connection. As state is maintained: Message delivery will be reliable
         * meeting the specified QOS even if the client, server or connection
         * are restarted. The server will treat a subscription as durable. If
         * set to true the client and server will not maintain state across
         * restarts of the client, the server or the connection. This means
         * Message delivery to the specified QOS cannot be maintained if the
         * client, server or connection are restarted The server will treat a
         * subscription as non-durable.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param cleanStart the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder cleanStart(String cleanStart) {
            doSetProperty("cleanStart", cleanStart);
            return this;
        }
        /**
         * MQTT client identifier. The identifier must be unique.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Sets the connection timeout value. This value, measured in seconds,
         * defines the maximum time interval the client will wait for the
         * network connection to the MQTT server to be established. The default
         * timeout is 30 seconds. A value of 0 disables timeout processing
         * meaning the client will wait until the network connection is made
         * successfully or fails.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Sets the connection timeout value. This value, measured in seconds,
         * defines the maximum time interval the client will wait for the
         * network connection to the MQTT server to be established. The default
         * timeout is 30 seconds. A value of 0 disables timeout processing
         * meaning the client will wait until the network connection is made
         * successfully or fails.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Base directory used by file persistence. Will by default use user
         * directory.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param filePersistenceDirectory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder filePersistenceDirectory(String filePersistenceDirectory) {
            doSetProperty("filePersistenceDirectory", filePersistenceDirectory);
            return this;
        }
        /**
         * Sets the keep alive interval. This value, measured in seconds,
         * defines the maximum time interval between messages sent or received.
         * It enables the client to detect if the server is no longer available,
         * without having to wait for the TCP/IP timeout. The client will ensure
         * that at least one message travels across the network within each keep
         * alive period. In the absence of a data-related message during the
         * time period, the client sends a very small ping message, which the
         * server will acknowledge. A value of 0 disables keepalive processing
         * in the client. The default value is 60 seconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param keepAliveInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder keepAliveInterval(int keepAliveInterval) {
            doSetProperty("keepAliveInterval", keepAliveInterval);
            return this;
        }
        /**
         * Sets the keep alive interval. This value, measured in seconds,
         * defines the maximum time interval between messages sent or received.
         * It enables the client to detect if the server is no longer available,
         * without having to wait for the TCP/IP timeout. The client will ensure
         * that at least one message travels across the network within each keep
         * alive period. In the absence of a data-related message during the
         * time period, the client sends a very small ping message, which the
         * server will acknowledge. A value of 0 disables keepalive processing
         * in the client. The default value is 60 seconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param keepAliveInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder keepAliveInterval(String keepAliveInterval) {
            doSetProperty("keepAliveInterval", keepAliveInterval);
            return this;
        }
        /**
         * Get the maximum time (in millis) to wait between reconnects.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 128000
         * Group: common
         * 
         * @param maxReconnectDelay the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder maxReconnectDelay(int maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Get the maximum time (in millis) to wait between reconnects.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 128000
         * Group: common
         * 
         * @param maxReconnectDelay the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder maxReconnectDelay(String maxReconnectDelay) {
            doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }
        /**
         * Client persistence to be used - memory or file.
         * 
         * The option is a:
         * <code>org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence</code> type.
         * 
         * Default: MEMORY
         * Group: common
         * 
         * @param persistence the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder persistence(org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence persistence) {
            doSetProperty("persistence", persistence);
            return this;
        }
        /**
         * Client persistence to be used - memory or file.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.paho.mqtt5.PahoMqtt5Persistence</code> type.
         * 
         * Default: MEMORY
         * Group: common
         * 
         * @param persistence the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder persistence(String persistence) {
            doSetProperty("persistence", persistence);
            return this;
        }
        /**
         * Client quality of service level (0-2).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param qos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder qos(int qos) {
            doSetProperty("qos", qos);
            return this;
        }
        /**
         * Client quality of service level (0-2).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param qos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder qos(String qos) {
            doSetProperty("qos", qos);
            return this;
        }
        /**
         * Sets the Receive Maximum. This value represents the limit of QoS 1
         * and QoS 2 publications that the client is willing to process
         * concurrently. There is no mechanism to limit the number of QoS 0
         * publications that the Server might try to send. The default value is
         * 65535.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 65535
         * Group: common
         * 
         * @param receiveMaximum the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder receiveMaximum(int receiveMaximum) {
            doSetProperty("receiveMaximum", receiveMaximum);
            return this;
        }
        /**
         * Sets the Receive Maximum. This value represents the limit of QoS 1
         * and QoS 2 publications that the client is willing to process
         * concurrently. There is no mechanism to limit the number of QoS 0
         * publications that the Server might try to send. The default value is
         * 65535.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 65535
         * Group: common
         * 
         * @param receiveMaximum the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder receiveMaximum(String receiveMaximum) {
            doSetProperty("receiveMaximum", receiveMaximum);
            return this;
        }
        /**
         * Retain option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param retained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder retained(boolean retained) {
            doSetProperty("retained", retained);
            return this;
        }
        /**
         * Retain option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param retained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder retained(String retained) {
            doSetProperty("retained", retained);
            return this;
        }
        /**
         * Set a list of one or more serverURIs the client may connect to.
         * Multiple servers can be separated by comma. Each serverURI specifies
         * the address of a server that the client may connect to. Two types of
         * connection are supported tcp:// for a TCP connection and ssl:// for a
         * TCP connection secured by SSL/TLS. For example: tcp://localhost:1883
         * ssl://localhost:8883 If the port is not specified, it will default to
         * 1883 for tcp:// URIs, and 8883 for ssl:// URIs. If serverURIs is set
         * then it overrides the serverURI parameter passed in on the
         * constructor of the MQTT client. When an attempt to connect is
         * initiated the client will start with the first serverURI in the list
         * and work through the list until a connection is established with a
         * server. If a connection cannot be made to any of the servers then the
         * connect attempt fails. Specifying a list of servers that a client may
         * connect to has several uses: High Availability and reliable message
         * delivery Some MQTT servers support a high availability feature where
         * two or more equal MQTT servers share state. An MQTT client can
         * connect to any of the equal servers and be assured that messages are
         * reliably delivered and durable subscriptions are maintained no matter
         * which server the client connects to. The cleansession flag must be
         * set to false if durable subscriptions and/or reliable message
         * delivery is required. Hunt List A set of servers may be specified
         * that are not equal (as in the high availability option). As no state
         * is shared across the servers reliable message delivery and durable
         * subscriptions are not valid. The cleansession flag must be set to
         * true if the hunt list mode is used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serverURIs the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder serverURIs(String serverURIs) {
            doSetProperty("serverURIs", serverURIs);
            return this;
        }
        /**
         * Sets the Session Expiry Interval. This value, measured in seconds,
         * defines the maximum time that the broker will maintain the session
         * for once the client disconnects. Clients should only connect with a
         * long Session Expiry interval if they intend to connect to the server
         * at some later point in time. By default this value is -1 and so will
         * not be sent, in this case, the session will not expire. If a 0 is
         * sent, the session will end immediately once the Network Connection is
         * closed. When the client has determined that it has no longer any use
         * for the session, it should disconnect with a Session Expiry Interval
         * set to 0.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param sessionExpiryInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder sessionExpiryInterval(long sessionExpiryInterval) {
            doSetProperty("sessionExpiryInterval", sessionExpiryInterval);
            return this;
        }
        /**
         * Sets the Session Expiry Interval. This value, measured in seconds,
         * defines the maximum time that the broker will maintain the session
         * for once the client disconnects. Clients should only connect with a
         * long Session Expiry interval if they intend to connect to the server
         * at some later point in time. By default this value is -1 and so will
         * not be sent, in this case, the session will not expire. If a 0 is
         * sent, the session will end immediately once the Network Connection is
         * closed. When the client has determined that it has no longer any use
         * for the session, it should disconnect with a Session Expiry Interval
         * set to 0.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param sessionExpiryInterval the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder sessionExpiryInterval(String sessionExpiryInterval) {
            doSetProperty("sessionExpiryInterval", sessionExpiryInterval);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The MQTT properties set for the message.
         * 
         * The option is a:
         * <code>org.eclipse.paho.mqttv5.common.packet.MqttProperties</code>
         * type.
         * 
         * Group: common
         * 
         * @param willMqttProperties the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willMqttProperties(org.eclipse.paho.mqttv5.common.packet.MqttProperties willMqttProperties) {
            doSetProperty("willMqttProperties", willMqttProperties);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The MQTT properties set for the message.
         * 
         * The option will be converted to a
         * <code>org.eclipse.paho.mqttv5.common.packet.MqttProperties</code>
         * type.
         * 
         * Group: common
         * 
         * @param willMqttProperties the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willMqttProperties(String willMqttProperties) {
            doSetProperty("willMqttProperties", willMqttProperties);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The byte payload for the message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param willPayload the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willPayload(String willPayload) {
            doSetProperty("willPayload", willPayload);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The quality of service to publish the message at
         * (0, 1 or 2).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param willQos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willQos(int willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The quality of service to publish the message at
         * (0, 1 or 2).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param willQos the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willQos(String willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. Whether or not the message should be retained.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param willRetained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willRetained(boolean willRetained) {
            doSetProperty("willRetained", willRetained);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. Whether or not the message should be retained.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param willRetained the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willRetained(String willRetained) {
            doSetProperty("willRetained", willRetained);
            return this;
        }
        /**
         * Sets the Last Will and Testament (LWT) for the connection. In the
         * event that this client unexpectedly loses its connection to the
         * server, the server will publish a message to itself using the
         * supplied details. The topic to publish to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param willTopic the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder willTopic(String willTopic) {
            doSetProperty("willTopic", willTopic);
            return this;
        }
        /**
         * Whether SSL HostnameVerifier is enabled or not. The default value is
         * true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         * 
         * @param httpsHostnameVerificationEnabled the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder httpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
            doSetProperty("httpsHostnameVerificationEnabled", httpsHostnameVerificationEnabled);
            return this;
        }
        /**
         * Whether SSL HostnameVerifier is enabled or not. The default value is
         * true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         * 
         * @param httpsHostnameVerificationEnabled the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder httpsHostnameVerificationEnabled(String httpsHostnameVerificationEnabled) {
            doSetProperty("httpsHostnameVerificationEnabled", httpsHostnameVerificationEnabled);
            return this;
        }
        /**
         * Password to be used for authentication against the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the SocketFactory to use. This allows an application to apply
         * its own policies around the creation of network sockets. If using an
         * SSL connection, an SSLSocketFactory can be used to supply
         * application-specific security settings.
         * 
         * The option is a: <code>javax.net.SocketFactory</code> type.
         * 
         * Group: security
         * 
         * @param socketFactory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder socketFactory(javax.net.SocketFactory socketFactory) {
            doSetProperty("socketFactory", socketFactory);
            return this;
        }
        /**
         * Sets the SocketFactory to use. This allows an application to apply
         * its own policies around the creation of network sockets. If using an
         * SSL connection, an SSLSocketFactory can be used to supply
         * application-specific security settings.
         * 
         * The option will be converted to a
         * <code>javax.net.SocketFactory</code> type.
         * 
         * Group: security
         * 
         * @param socketFactory the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder socketFactory(String socketFactory) {
            doSetProperty("socketFactory", socketFactory);
            return this;
        }
        /**
         * Sets the SSL properties for the connection. Note that these
         * properties are only valid if an implementation of the Java Secure
         * Socket Extensions (JSSE) is available. These properties are not used
         * if a custom SocketFactory has been set. The following properties can
         * be used: com.ibm.ssl.protocol One of: SSL, SSLv3, TLS, TLSv1,
         * SSL_TLS. com.ibm.ssl.contextProvider Underlying JSSE provider. For
         * example IBMJSSE2 or SunJSSE com.ibm.ssl.keyStore The name of the file
         * that contains the KeyStore object that you want the KeyManager to
         * use. For example /mydir/etc/key.p12 com.ibm.ssl.keyStorePassword The
         * password for the KeyStore object that you want the KeyManager to use.
         * The password can either be in plain-text, or may be obfuscated using
         * the static method: com.ibm.micro.security.Password.obfuscate(char
         * password). This obfuscates the password using a simple and insecure
         * XOR and Base64 encoding mechanism. Note that this is only a simple
         * scrambler to obfuscate clear-text passwords. com.ibm.ssl.keyStoreType
         * Type of key store, for example PKCS12, JKS, or JCEKS.
         * com.ibm.ssl.keyStoreProvider Key store provider, for example IBMJCE
         * or IBMJCEFIPS. com.ibm.ssl.trustStore The name of the file that
         * contains the KeyStore object that you want the TrustManager to use.
         * com.ibm.ssl.trustStorePassword The password for the TrustStore object
         * that you want the TrustManager to use. The password can either be in
         * plain-text, or may be obfuscated using the static method:
         * com.ibm.micro.security.Password.obfuscate(char password). This
         * obfuscates the password using a simple and insecure XOR and Base64
         * encoding mechanism. Note that this is only a simple scrambler to
         * obfuscate clear-text passwords. com.ibm.ssl.trustStoreType The type
         * of KeyStore object that you want the default TrustManager to use.
         * Same possible values as keyStoreType. com.ibm.ssl.trustStoreProvider
         * Trust store provider, for example IBMJCE or IBMJCEFIPS.
         * com.ibm.ssl.enabledCipherSuites A list of which ciphers are enabled.
         * Values are dependent on the provider, for example:
         * SSL_RSA_WITH_AES_128_CBC_SHA;SSL_RSA_WITH_3DES_EDE_CBC_SHA.
         * com.ibm.ssl.keyManager Sets the algorithm that will be used to
         * instantiate a KeyManagerFactory object instead of using the default
         * algorithm available in the platform. Example values: IbmX509 or
         * IBMJ9X509. com.ibm.ssl.trustManager Sets the algorithm that will be
         * used to instantiate a TrustManagerFactory object instead of using the
         * default algorithm available in the platform. Example values: PKIX or
         * IBMJ9X509.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: security
         * 
         * @param sslClientProps the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder sslClientProps(Properties sslClientProps) {
            doSetProperty("sslClientProps", sslClientProps);
            return this;
        }
        /**
         * Sets the SSL properties for the connection. Note that these
         * properties are only valid if an implementation of the Java Secure
         * Socket Extensions (JSSE) is available. These properties are not used
         * if a custom SocketFactory has been set. The following properties can
         * be used: com.ibm.ssl.protocol One of: SSL, SSLv3, TLS, TLSv1,
         * SSL_TLS. com.ibm.ssl.contextProvider Underlying JSSE provider. For
         * example IBMJSSE2 or SunJSSE com.ibm.ssl.keyStore The name of the file
         * that contains the KeyStore object that you want the KeyManager to
         * use. For example /mydir/etc/key.p12 com.ibm.ssl.keyStorePassword The
         * password for the KeyStore object that you want the KeyManager to use.
         * The password can either be in plain-text, or may be obfuscated using
         * the static method: com.ibm.micro.security.Password.obfuscate(char
         * password). This obfuscates the password using a simple and insecure
         * XOR and Base64 encoding mechanism. Note that this is only a simple
         * scrambler to obfuscate clear-text passwords. com.ibm.ssl.keyStoreType
         * Type of key store, for example PKCS12, JKS, or JCEKS.
         * com.ibm.ssl.keyStoreProvider Key store provider, for example IBMJCE
         * or IBMJCEFIPS. com.ibm.ssl.trustStore The name of the file that
         * contains the KeyStore object that you want the TrustManager to use.
         * com.ibm.ssl.trustStorePassword The password for the TrustStore object
         * that you want the TrustManager to use. The password can either be in
         * plain-text, or may be obfuscated using the static method:
         * com.ibm.micro.security.Password.obfuscate(char password). This
         * obfuscates the password using a simple and insecure XOR and Base64
         * encoding mechanism. Note that this is only a simple scrambler to
         * obfuscate clear-text passwords. com.ibm.ssl.trustStoreType The type
         * of KeyStore object that you want the default TrustManager to use.
         * Same possible values as keyStoreType. com.ibm.ssl.trustStoreProvider
         * Trust store provider, for example IBMJCE or IBMJCEFIPS.
         * com.ibm.ssl.enabledCipherSuites A list of which ciphers are enabled.
         * Values are dependent on the provider, for example:
         * SSL_RSA_WITH_AES_128_CBC_SHA;SSL_RSA_WITH_3DES_EDE_CBC_SHA.
         * com.ibm.ssl.keyManager Sets the algorithm that will be used to
         * instantiate a KeyManagerFactory object instead of using the default
         * algorithm available in the platform. Example values: IbmX509 or
         * IBMJ9X509. com.ibm.ssl.trustManager Sets the algorithm that will be
         * used to instantiate a TrustManagerFactory object instead of using the
         * default algorithm available in the platform. Example values: PKIX or
         * IBMJ9X509.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: security
         * 
         * @param sslClientProps the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder sslClientProps(String sslClientProps) {
            doSetProperty("sslClientProps", sslClientProps);
            return this;
        }
        /**
         * Sets the HostnameVerifier for the SSL connection. Note that it will
         * be used after handshake on a connection and you should do actions by
         * yourself when hostname is verified error. There is no default
         * HostnameVerifier.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param sslHostnameVerifier the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder sslHostnameVerifier(javax.net.ssl.HostnameVerifier sslHostnameVerifier) {
            doSetProperty("sslHostnameVerifier", sslHostnameVerifier);
            return this;
        }
        /**
         * Sets the HostnameVerifier for the SSL connection. Note that it will
         * be used after handshake on a connection and you should do actions by
         * yourself when hostname is verified error. There is no default
         * HostnameVerifier.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: security
         * 
         * @param sslHostnameVerifier the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder sslHostnameVerifier(String sslHostnameVerifier) {
            doSetProperty("sslHostnameVerifier", sslHostnameVerifier);
            return this;
        }
        /**
         * Username to be used for authentication against the MQTT broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Paho MQTT 5 component.
     */
    public interface AdvancedPahoMqtt5EndpointBuilder
            extends
                AdvancedPahoMqtt5EndpointConsumerBuilder,
                AdvancedPahoMqtt5EndpointProducerBuilder {
        default PahoMqtt5EndpointBuilder basic() {
            return (PahoMqtt5EndpointBuilder) this;
        }

        /**
         * To use an existing mqtt client.
         * 
         * The option is a:
         * <code>org.eclipse.paho.mqttv5.client.MqttClient</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointBuilder client(org.eclipse.paho.mqttv5.client.MqttClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use an existing mqtt client.
         * 
         * The option will be converted to a
         * <code>org.eclipse.paho.mqttv5.client.MqttClient</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * Sets the Custom WebSocket Headers for the WebSocket Connection.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param customWebSocketHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointBuilder customWebSocketHeaders(Map<java.lang.String, java.lang.String> customWebSocketHeaders) {
            doSetProperty("customWebSocketHeaders", customWebSocketHeaders);
            return this;
        }
        /**
         * Sets the Custom WebSocket Headers for the WebSocket Connection.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param customWebSocketHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointBuilder customWebSocketHeaders(String customWebSocketHeaders) {
            doSetProperty("customWebSocketHeaders", customWebSocketHeaders);
            return this;
        }
        /**
         * Set the time in seconds that the executor service should wait when
         * terminating before forcefully terminating. It is not recommended to
         * change this value unless you are absolutely sure that you need to.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param executorServiceTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointBuilder executorServiceTimeout(int executorServiceTimeout) {
            doSetProperty("executorServiceTimeout", executorServiceTimeout);
            return this;
        }
        /**
         * Set the time in seconds that the executor service should wait when
         * terminating before forcefully terminating. It is not recommended to
         * change this value unless you are absolutely sure that you need to.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param executorServiceTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedPahoMqtt5EndpointBuilder executorServiceTimeout(String executorServiceTimeout) {
            doSetProperty("executorServiceTimeout", executorServiceTimeout);
            return this;
        }
    }

    public interface PahoMqtt5Builders {
        /**
         * Paho MQTT 5 (camel-paho-mqtt5)
         * Communicate with MQTT message brokers using Eclipse Paho MQTT v5
         * Client.
         * 
         * Category: messaging,iot
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-paho-mqtt5
         * 
         * @return the dsl builder for the headers' name.
         */
        default PahoMqtt5HeaderNameBuilder pahoMqtt5() {
            return PahoMqtt5HeaderNameBuilder.INSTANCE;
        }
        /**
         * Paho MQTT 5 (camel-paho-mqtt5)
         * Communicate with MQTT message brokers using Eclipse Paho MQTT v5
         * Client.
         * 
         * Category: messaging,iot
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-paho-mqtt5
         * 
         * Syntax: <code>paho-mqtt5:topic</code>
         * 
         * Path parameter: topic (required)
         * Name of the topic
         * 
         * @param path topic
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder pahoMqtt5(String path) {
            return PahoMqtt5EndpointBuilderFactory.endpointBuilder("paho-mqtt5", path);
        }
        /**
         * Paho MQTT 5 (camel-paho-mqtt5)
         * Communicate with MQTT message brokers using Eclipse Paho MQTT v5
         * Client.
         * 
         * Category: messaging,iot
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-paho-mqtt5
         * 
         * Syntax: <code>paho-mqtt5:topic</code>
         * 
         * Path parameter: topic (required)
         * Name of the topic
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topic
         * @return the dsl builder
         */
        default PahoMqtt5EndpointBuilder pahoMqtt5(String componentName, String path) {
            return PahoMqtt5EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Paho MQTT 5 component.
     */
    public static class PahoMqtt5HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final PahoMqtt5HeaderNameBuilder INSTANCE = new PahoMqtt5HeaderNameBuilder();

        /**
         * The name of the topic.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MqttTopic}.
         */
        public String mqttTopic() {
            return "CamelMqttTopic";
        }
        /**
         * The quality of service of the incoming message.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MqttQoS}.
         */
        public String mqttQoS() {
            return "CamelMqttQoS";
        }
        /**
         * The client quality of service level (0-2).
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PahoMqtt5Qos}.
         */
        public String pahoMqtt5Qos() {
            return "CamelPahoMqtt5Qos";
        }
        /**
         * Retain option.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PahoMqtt5Retained}.
         */
        public String pahoMqtt5Retained() {
            return "CamelPahoMqtt5Retained";
        }
        /**
         * The name of topic to override and send to instead of topic specified
         * on endpoint.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PahoMqtt5OverrideTopic}.
         */
        public String pahoMqtt5OverrideTopic() {
            return "CamelPahoMqtt5OverrideTopic";
        }
        /**
         * Consumer: The properties set on the incoming message. Producer: The
         * properties to be set on the outgoing message.
         * 
         * The option is a: {@code
         * org.eclipse.paho.mqttv5.common.packet.MqttProperties} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PahoMqtt5MsgProperties}.
         */
        public String pahoMqtt5MsgProperties() {
            return "CamelPahoMqtt5MsgProperties";
        }
    }
    static PahoMqtt5EndpointBuilder endpointBuilder(String componentName, String path) {
        class PahoMqtt5EndpointBuilderImpl extends AbstractEndpointBuilder implements PahoMqtt5EndpointBuilder, AdvancedPahoMqtt5EndpointBuilder {
            public PahoMqtt5EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new PahoMqtt5EndpointBuilderImpl(path);
    }
}