/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;
import org.apache.commons.numbers.core.Precision;

public class Neuron {
    private final long identifier;
    private final int size;
    private final AtomicReference<double[]> features;
    private final AtomicLong numberOfAttemptedUpdates = new AtomicLong(0L);
    private final AtomicLong numberOfSuccessfulUpdates = new AtomicLong(0L);

    Neuron(long identifier, double[] features) {
        this.identifier = identifier;
        this.size = features.length;
        this.features = new AtomicReference<double[]>((double[])features.clone());
    }

    public synchronized Neuron copy() {
        Neuron copy = new Neuron(this.getIdentifier(), this.getFeatures());
        copy.numberOfAttemptedUpdates.set(this.numberOfAttemptedUpdates.get());
        copy.numberOfSuccessfulUpdates.set(this.numberOfSuccessfulUpdates.get());
        return copy;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public int getSize() {
        return this.size;
    }

    public double[] getFeatures() {
        return (double[])this.features.get().clone();
    }

    public boolean compareAndSetFeatures(double[] expect, double[] update) {
        if (update.length != this.size) {
            throw new NeuralNetException("Size mismatch: {0} != {1}", update.length, this.size);
        }
        double[] current = this.features.get();
        if (!this.containSameValues(current, expect)) {
            return false;
        }
        this.numberOfAttemptedUpdates.incrementAndGet();
        if (this.features.compareAndSet(current, (double[])update.clone())) {
            this.numberOfSuccessfulUpdates.incrementAndGet();
            return true;
        }
        return false;
    }

    public long getNumberOfAttemptedUpdates() {
        return this.numberOfAttemptedUpdates.get();
    }

    public long getNumberOfSuccessfulUpdates() {
        return this.numberOfSuccessfulUpdates.get();
    }

    private boolean containSameValues(double[] current, double[] expect) {
        if (expect.length != this.size) {
            throw new NeuralNetException("Size mismatch: {0} != {1}", expect.length, this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            if (Precision.equals((double)current[i], (double)expect[i])) continue;
            return false;
        }
        return true;
    }
}

