/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.filters.bloomfilter.BitArray;
import org.apache.datasketches.filters.bloomfilter.DirectBitArray;
import org.apache.datasketches.filters.bloomfilter.HeapBitArray;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectBitArrayTest {
    private static WritableMemory bitArrayToWritableMemory(HeapBitArray ba) {
        int numBytes = (int)ba.getSerializedSizeBytes();
        byte[] bytes = new byte[numBytes];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        ba.writeToBuffer(wmem.asWritableBuffer());
        return wmem;
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void writableWrapEmptyBitArrayTest() {
        HeapBitArray hba = new HeapBitArray(119L);
        Assert.assertTrue((boolean)hba.isEmpty());
        WritableMemory mem = DirectBitArrayTest.bitArrayToWritableMemory(hba);
        DirectBitArray.writableWrap((WritableMemory)mem, (boolean)hba.isEmpty());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void createNegativeSizeBitArrayTest() {
        byte[] bytes = new byte[32];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        wmem.putInt(0L, -1);
        DirectBitArray.writableWrap((WritableMemory)wmem, (boolean)true);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void tooSmallCapacityTest() {
        byte[] bytes = new byte[32];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        wmem.putInt(0L, 1024);
        wmem.putLong(8L, 201L);
        DirectBitArray.writableWrap((WritableMemory)wmem, (boolean)false);
    }

    @Test
    public void initializeTooSmallTest() {
        byte[] bytes = new byte[128];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        Assert.assertThrows(SketchesArgumentException.class, () -> DirectBitArray.initialize((long)8320L, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> DirectBitArray.initialize((long)-5L, (WritableMemory)wmem));
    }

    @Test
    public void basicInitializeOperationsTest() {
        byte[] bytes = new byte[56];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        DirectBitArray dba = DirectBitArray.initialize((long)192L, (WritableMemory)wmem);
        Assert.assertTrue((boolean)dba.isEmpty());
        Assert.assertTrue((boolean)dba.hasMemory());
        Assert.assertFalse((boolean)dba.isReadOnly());
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)0L);
        Assert.assertFalse((boolean)dba.getAndSetBit(13L));
        Assert.assertTrue((boolean)dba.getBit(13L));
        dba.setBit(17L);
        Assert.assertTrue((boolean)dba.getAndSetBit(17L));
        Assert.assertEquals((int)dba.getArrayLength(), (int)3);
        Assert.assertFalse((boolean)dba.isEmpty());
        Assert.assertFalse((boolean)dba.getBit(183L));
        Assert.assertTrue((boolean)dba.isDirty());
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)2L);
        Assert.assertFalse((boolean)dba.isDirty());
        dba.reset();
        Assert.assertTrue((boolean)dba.isEmpty());
        Assert.assertTrue((boolean)dba.hasMemory());
        Assert.assertFalse((boolean)dba.isReadOnly());
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)0L);
    }

    @Test
    public void basicWritableWrapTest() {
        HeapBitArray hba = new HeapBitArray(128L);
        Assert.assertFalse((boolean)hba.getAndSetBit(1L));
        Assert.assertFalse((boolean)hba.getAndSetBit(2L));
        for (int i = 4; i < 64; i <<= 1) {
            hba.getAndSetBit((long)(64 + i));
        }
        Assert.assertEquals((long)hba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)hba.getBit(68L));
        Assert.assertFalse((boolean)hba.isEmpty());
        WritableMemory mem = DirectBitArrayTest.bitArrayToWritableMemory(hba);
        DirectBitArray dba = DirectBitArray.writableWrap((WritableMemory)mem, (boolean)hba.isEmpty());
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)dba.getBit(68L));
        Assert.assertFalse((boolean)dba.isEmpty());
        Assert.assertFalse((boolean)dba.isDirty());
        Assert.assertTrue((boolean)dba.hasMemory());
        Assert.assertFalse((boolean)dba.isDirect());
        Assert.assertFalse((boolean)dba.isReadOnly());
        Assert.assertFalse((boolean)dba.getAndSetBit(75L));
        dba.setBit(100L);
        Assert.assertTrue((boolean)dba.getAndSetBit(100L));
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)8L);
    }

    @Test
    public void countWritableWrappedBitsWhenDirty() {
        HeapBitArray hba = new HeapBitArray(128L);
        Assert.assertFalse((boolean)hba.getAndSetBit(1L));
        Assert.assertFalse((boolean)hba.getAndSetBit(2L));
        for (int i = 4; i < 64; i <<= 1) {
            hba.setBit((long)(64 + i));
        }
        Assert.assertEquals((long)hba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)hba.getBit(68L));
        Assert.assertFalse((boolean)hba.isEmpty());
        WritableMemory mem = DirectBitArrayTest.bitArrayToWritableMemory(hba);
        DirectBitArray dba = DirectBitArray.writableWrap((WritableMemory)mem, (boolean)hba.isEmpty());
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)6L);
        Assert.assertTrue((boolean)dba.getBit(68L));
        Assert.assertFalse((boolean)dba.isEmpty());
        Assert.assertFalse((boolean)dba.isDirty());
        dba.setBit(102L);
        Assert.assertTrue((boolean)dba.isDirty());
    }

    @Test
    public void bitAddresOutOfBoundsNonEmptyTest() {
        int numBits = 1024;
        byte[] bytes = new byte[144];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        DirectBitArray dba = DirectBitArray.initialize((long)1024L, (WritableMemory)wmem);
        for (int i = 0; i < 1024; i += 128) {
            dba.getAndSetBit((long)i);
        }
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> dba.getBit(-10L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> dba.getBit(2048L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> dba.setBit(-20L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> dba.setBit(4096L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> dba.getAndSetBit(-30L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> dba.getAndSetBit(8192L));
    }

    @Test
    public void inversionTest() {
        int numBits = 1024;
        byte[] bytes = new byte[1152];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bytes);
        DirectBitArray dba = DirectBitArray.initialize((long)1024L, (WritableMemory)wmem);
        for (int i = 0; i < 1024; i += 128) {
            dba.getAndSetBit((long)i);
        }
        Assert.assertTrue((boolean)dba.getBit(0L));
        long numSet = dba.getNumBitsSet();
        dba.invert();
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)(1024L - numSet));
        Assert.assertFalse((boolean)dba.getBit(0L));
        dba.setBit(0L);
        dba.invert();
        Assert.assertEquals((long)dba.getNumBitsSet(), (long)(numSet - 1L));
        Assert.assertFalse((boolean)dba.getBit(0L));
    }

    @Test
    public void invalidUnionIntersectionTest() {
        HeapBitArray hba = new HeapBitArray(128L);
        hba.setBit(0L);
        WritableMemory wmem = DirectBitArrayTest.bitArrayToWritableMemory(hba);
        DirectBitArray dba = DirectBitArray.writableWrap((WritableMemory)wmem, (boolean)false);
        Assert.assertThrows(SketchesArgumentException.class, () -> dba.union((BitArray)new HeapBitArray(64L)));
        Assert.assertThrows(SketchesArgumentException.class, () -> dba.intersect((BitArray)new HeapBitArray(512L)));
    }

    @Test
    public void validUnionAndIntersectionTest() {
        long numBits = 64L;
        int sizeBytes = (int)BitArray.getSerializedSizeBytes((long)64L);
        DirectBitArray ba1 = DirectBitArray.initialize((long)64L, (WritableMemory)WritableMemory.allocate((int)sizeBytes));
        DirectBitArray ba2 = DirectBitArray.initialize((long)64L, (WritableMemory)WritableMemory.allocate((int)sizeBytes));
        DirectBitArray ba3 = DirectBitArray.initialize((long)64L, (WritableMemory)WritableMemory.allocate((int)sizeBytes));
        int n = 10;
        for (int i = 0; i < 10; ++i) {
            ba1.getAndSetBit((long)i);
            ba2.getAndSetBit((long)(i + 5));
            ba3.getAndSetBit((long)(2 * i));
        }
        Assert.assertEquals((long)ba1.getNumBitsSet(), (long)10L);
        Assert.assertEquals((long)ba2.getNumBitsSet(), (long)10L);
        Assert.assertEquals((long)ba3.getNumBitsSet(), (long)10L);
        ba1.intersect((BitArray)ba2);
        Assert.assertEquals((long)ba1.getNumBitsSet(), (long)5L);
        ba3.union((BitArray)ba2);
        Assert.assertEquals((long)ba3.getNumBitsSet(), (long)15L);
    }
}

