/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdoubleUnionTest {
    private final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;

    @Test
    public void unionEmptySampling() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.01f).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Union union = new Union((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        union.union((Sketch)sketch);
        CompactSketch result = union.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
    }

    @Test
    public void unionExactMode() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(1L, (Object)1.0);
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch2.update(2L, (Object)1.0);
        sketch2.update(2L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        Union union = new Union((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        union.union((Sketch)sketch1);
        union.union((Sketch)sketch2);
        CompactSketch result = union.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)3.0);
        TupleSketchIterator it = result.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
        Assert.assertFalse((boolean)it.next());
        union.reset();
        result = union.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)result.getTheta(), (double)1.0);
    }

    @Test
    public void unionEstimationMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        key -= 4096;
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Union union = new Union(4096, (SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        union.union((Sketch)sketch1);
        union.union((Sketch)sketch2);
        CompactSketch result = union.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
    }

    @Test
    public void unionMixedMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        key -= 500;
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.2f).build();
        for (int i = 0; i < 20000; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Union union = new Union(4096, (SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        union.union((Sketch)sketch1);
        union.union((Sketch)sketch2);
        CompactSketch result = union.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)20500.0, (double)205.0);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
    }

    @Test
    public void checkUnionUpdateWithTheta() {
        Union union = new Union((SummarySetOperations)new DoubleSummarySetOperations(this.mode, this.mode));
        UpdateSketch usk = null;
        DoubleSummary dsum = null;
        try {
            union.union(usk, dsum);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        usk = new UpdateSketchBuilder().build();
        try {
            union.union((org.apache.datasketches.theta.Sketch)usk, dsum);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        dsum = new DoubleSummaryFactory(this.mode).newSummary();
        for (int i = 0; i < 10; ++i) {
            usk.update((long)i);
        }
        union.union((org.apache.datasketches.theta.Sketch)usk, (Summary)dsum);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)10.0);
    }
}

