/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hll.CouponMapping;
import org.apache.datasketches.hll.CubicInterpolation;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TablesTest {
    @Test
    public void checkInterpolationExceptions() {
        try {
            CubicInterpolation.usingXAndYTables((double[])CouponMapping.xArr, (double[])CouponMapping.yArr, (double)-1.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            CubicInterpolation.usingXAndYTables((double[])CouponMapping.xArr, (double[])CouponMapping.yArr, (double)1.1E7);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCornerCases() {
        int len = CouponMapping.xArr.length;
        double x = CouponMapping.xArr[len - 1];
        double y = CubicInterpolation.usingXAndYTables((double[])CouponMapping.xArr, (double[])CouponMapping.yArr, (double)x);
        double yExp = CouponMapping.yArr[len - 1];
        Assert.assertEquals((double)y, (double)yExp, (double)0.0);
    }

    @Test
    public void printlnTest() {
        TablesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

