/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;
import org.apache.datasketches.quantiles.QuantilesItemsUnion;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.ItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.LongsAsOrderableStrings;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIteratorAPI;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ItemsSketchTest {
    private static final boolean enablePrinting = false;

    @BeforeMethod
    public void setUp() {
        QuantilesItemsSketch.rand.setSeed(32749L);
    }

    @Test
    public void empty() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)128, Comparator.naturalOrder());
        Assert.assertNotNull((Object)sketch);
        sketch.update(null);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)byteArr.length, (int)8);
        try {
            sketch.getPMF((Object[])new String[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF((Object[])new String[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getRank((Object)"a");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void oneItem() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)128, Comparator.naturalOrder());
        sketch.update((Object)"a");
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((String)((String)sketch.getMinItem()), (String)"a");
        Assert.assertEquals((String)((String)sketch.getMaxItem()), (String)"a");
        Assert.assertEquals((String)((String)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE)), (String)"a");
        Assert.assertEquals((double)sketch.getRank((Object)"a", QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        double[] pmf = sketch.getPMF((Object[])new String[0], QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)pmf.length, (int)1);
        Assert.assertEquals((double)pmf[0], (double)1.0);
        pmf = sketch.getPMF((Object[])new String[]{"a"}, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.0);
        Assert.assertEquals((double)pmf[1], (double)1.0);
        double[] cdf = sketch.getCDF((Object[])new String[0], QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)cdf.length, (int)1);
        Assert.assertEquals((double)cdf[0], (double)1.0);
        cdf = sketch.getCDF((Object[])new String[]{"a"}, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((int)cdf.length, (int)2);
        Assert.assertEquals((double)cdf[0], (double)0.0);
        Assert.assertEquals((double)cdf[1], (double)1.0);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void tenItems() {
        int i;
        int i2;
        int i3;
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, (int)128, Comparator.naturalOrder());
        for (i3 = 1; i3 <= 10; ++i3) {
            sketch.update((Object)i3);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isReadOnly());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i3 = 1; i3 <= 10; ++i3) {
            Assert.assertEquals((double)sketch.getRank((Object)i3), (double)((double)i3 / 10.0));
            Assert.assertEquals((double)sketch.getRank((Object)i3, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i3 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((Object)i3, QuantileSearchCriteria.INCLUSIVE), (double)((double)i3 / 10.0));
        }
        Object[] qArr = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        double[] rOut = sketch.getRanks(qArr);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)(i2 + 1) / 10.0));
        }
        rOut = sketch.getRanks(qArr, QuantileSearchCriteria.EXCLUSIVE);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)i2 / 10.0));
        }
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE)), (int)1);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.1, QuantileSearchCriteria.EXCLUSIVE)), (int)2);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.2, QuantileSearchCriteria.EXCLUSIVE)), (int)3);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.3, QuantileSearchCriteria.EXCLUSIVE)), (int)4);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.4, QuantileSearchCriteria.EXCLUSIVE)), (int)5);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE)), (int)6);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.6, QuantileSearchCriteria.EXCLUSIVE)), (int)7);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.7, QuantileSearchCriteria.EXCLUSIVE)), (int)8);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.8, QuantileSearchCriteria.EXCLUSIVE)), (int)9);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.9, QuantileSearchCriteria.EXCLUSIVE)), (int)10);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE)), (int)10);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.0, QuantileSearchCriteria.INCLUSIVE)), (int)1);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.1, QuantileSearchCriteria.INCLUSIVE)), (int)1);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.2, QuantileSearchCriteria.INCLUSIVE)), (int)2);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.3, QuantileSearchCriteria.INCLUSIVE)), (int)3);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.4, QuantileSearchCriteria.INCLUSIVE)), (int)4);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE)), (int)5);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.6, QuantileSearchCriteria.INCLUSIVE)), (int)6);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.7, QuantileSearchCriteria.INCLUSIVE)), (int)7);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.8, QuantileSearchCriteria.INCLUSIVE)), (int)8);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(0.9, QuantileSearchCriteria.INCLUSIVE)), (int)9);
        Assert.assertEquals((Integer)((Integer)sketch.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE)), (int)10);
        Integer[] quantiles = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((Integer)((Integer)sketch.getQuantile((double)i / 10.0)), (Integer)quantiles[i]);
        }
        quantiles = (Integer[])sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((Integer)((Integer)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE)), (Integer)quantiles[i]);
        }
    }

    @Test
    public void estimation() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, (int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 1000; ++i) {
            sketch.update((Object)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000L);
        Assert.assertTrue((sketch.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Integer)((Integer)sketch.getMinItem()), (Integer)1);
        Assert.assertEquals((Integer)((Integer)sketch.getMaxItem()), (Integer)1000);
        Assert.assertEquals((float)((Integer)sketch.getQuantile(0.5)).intValue(), (float)500.0f, (float)17.0f);
        double[] normRanks = new double[]{0.0, 0.5, 1.0};
        Integer[] quantiles = (Integer[])sketch.getQuantiles(normRanks);
        Assert.assertEquals((float)quantiles[1].intValue(), (float)500.0f, (float)17.0f);
        double[] normRanks2 = new double[]{0.25, 0.5, 0.75};
        Integer[] quantiles2 = (Integer[])sketch.getQuantiles(normRanks2);
        Assert.assertEquals((float)quantiles2[0].intValue(), (float)250.0f, (float)17.0f);
        Assert.assertEquals((float)quantiles2[1].intValue(), (float)500.0f, (float)17.0f);
        Assert.assertEquals((float)quantiles2[2].intValue(), (float)750.0f, (float)17.0f);
        double normErr = sketch.getNormalizedRankError(true);
        Assert.assertEquals((double)normErr, (double)0.0172, (double)0.001);
        ItemsSketchTest.println("" + normErr);
        double[] pmf = sketch.getPMF((Object[])new Integer[0]);
        Assert.assertEquals((int)pmf.length, (int)1);
        Assert.assertEquals((double)pmf[0], (double)1.0);
        pmf = sketch.getPMF((Object[])new Integer[]{500});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.05);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.05);
        Object[] intArr = new Integer[50];
        for (int i = 0; i < 50; ++i) {
            intArr[i] = 20 * i + 10;
        }
        double[] pmf2 = sketch.getPMF(intArr);
        Assert.assertEquals((int)pmf2.length, (int)51);
        double[] cdf = sketch.getCDF((Object[])new Integer[0]);
        Assert.assertEquals((int)cdf.length, (int)1);
        Assert.assertEquals((double)cdf[0], (double)1.0);
        cdf = sketch.getCDF((Object[])new Integer[]{500});
        Assert.assertEquals((int)cdf.length, (int)2);
        Assert.assertEquals((double)cdf[0], (double)0.5, (double)0.05);
        Assert.assertEquals((double)cdf[1], (double)1.0, (double)0.05);
        Assert.assertEquals((double)sketch.getRank((Object)500), (double)0.5, (double)0.01);
    }

    @Test
    public void serializeDeserializeLong() {
        QuantilesItemsSketch sketch1 = QuantilesItemsSketch.getInstance(Long.class, (int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        QuantilesItemsSketch sketch2 = QuantilesItemsSketch.heapify(Long.class, (MemorySegment)MemorySegment.ofArray(bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Long)((Long)sketch2.getMinItem()), (Long)1L);
        Assert.assertEquals((Long)((Long)sketch2.getMaxItem()), (Long)1000L);
        Assert.assertEquals((float)((Long)sketch2.getQuantile(0.5)).longValue(), (float)500.0f, (float)17.0f);
    }

    @Test
    public void serializeDeserializeDouble() {
        QuantilesItemsSketch sketch1 = QuantilesItemsSketch.getInstance(Double.class, (int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        ArrayOfDoublesSerDe serDe = new ArrayOfDoublesSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        QuantilesItemsSketch sketch2 = QuantilesItemsSketch.heapify(Double.class, (MemorySegment)MemorySegment.ofArray(bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Double)((Double)sketch2.getMinItem()), (Double)1.0);
        Assert.assertEquals((Double)((Double)sketch2.getMaxItem()), (Double)1000.0);
        Assert.assertEquals((double)((Double)sketch2.getQuantile(0.5)), (double)500.0, (double)17.0);
    }

    @Test
    public void serializeDeserializeString() {
        Comparator<String> numericOrder = new Comparator<String>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(String s1, String s2) {
                Integer i1 = Integer.parseInt(s1, 2);
                Integer i2 = Integer.parseInt(s2, 2);
                return i1.compareTo(i2);
            }
        };
        QuantilesItemsSketch sketch1 = QuantilesItemsSketch.getInstance(String.class, (int)128, (Comparator)numericOrder);
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)Integer.toBinaryString(i << 10));
        }
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        QuantilesItemsSketch sketch2 = QuantilesItemsSketch.heapify(String.class, (MemorySegment)MemorySegment.ofArray(bytes), (Comparator)numericOrder, (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)Integer.toBinaryString(i << 10));
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)sketch2.getMinItem()), (String)Integer.toBinaryString(1024));
        Assert.assertEquals((String)((String)sketch2.getMaxItem()), (String)Integer.toBinaryString(1024000));
        Assert.assertEquals((float)(Integer.parseInt((String)sketch2.getQuantile(0.5), 2) >> 10), (float)500.0f, (float)17.0f);
    }

    @Test
    public void toStringCrudeCheck() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, Comparator.naturalOrder());
        String brief = sketch.toString();
        String full = sketch.toString(true, true);
        String part = sketch.toString(false, true);
        sketch.update((Object)"a");
        brief = sketch.toString();
        full = sketch.toString(true, true);
        part = sketch.toString(false, true);
        Assert.assertTrue((brief.length() < full.length() ? 1 : 0) != 0);
        Assert.assertTrue((part.length() < full.length() ? 1 : 0) != 0);
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)serDe);
        QuantilesItemsSketch.toString((byte[])bytes);
        QuantilesItemsSketch.toString((MemorySegment)MemorySegment.ofArray(bytes));
    }

    @Test
    public void toStringBiggerCheck() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        String bigger = sketch.toString();
        String full = sketch.toString(true, true);
        Assert.assertTrue((bigger.length() < full.length() ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkDownsampleException() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        sketch.downSample(32);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void negativeQuantileMustThrow() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        sketch.update((Object)"ABC");
        sketch.getQuantile(-0.1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceExcep1() {
        MemorySegment seg = MemorySegment.ofArray(new byte[4]);
        QuantilesItemsSketch.heapify(String.class, (MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceExcep2() {
        MemorySegment seg = MemorySegment.ofArray(new byte[8]);
        QuantilesItemsSketch.heapify(String.class, (MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkGoodSerDeId() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, Comparator.naturalOrder());
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        QuantilesItemsSketch.heapify(String.class, (MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkDownsample() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        QuantilesItemsSketch out = sketch.downSample(8);
        Assert.assertEquals((int)out.getK(), (int)8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void unorderedSplitPoints() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{2, 1});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nonUniqueSplitPoints() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{1, 1});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nullInSplitPoints() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{1, null});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void compactNotSupported() {
        ArrayOfDoublesSerDe serDe = new ArrayOfDoublesSerDe();
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Double.class, Comparator.naturalOrder());
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)serDe);
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        Util.clearBits((MemorySegment)seg, (long)3L, (byte)8);
        ItemsSketchTest.println(PreambleUtil.toString((MemorySegment)seg, (boolean)false));
        QuantilesItemsSketch.heapify(Double.class, (MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
    }

    @Test
    public void checkPutMemory() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        byte[] byteArr = new byte[200];
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        sketch.putIntoMemorySegment(seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPutMemoryException() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        byte[] byteArr = new byte[100];
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        sketch.putIntoMemorySegment(seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkPMFonEmpty() {
        QuantilesItemsSketch<String> iss = ItemsSketchTest.buildStringIS(32, 32);
        double[] ranks = new double[]{};
        String[] qOut = (String[])iss.getQuantiles(ranks);
        ItemsSketchTest.println("qOut: " + qOut.length);
        Assert.assertEquals((int)qOut.length, (int)0);
        double[] cdfOut = iss.getCDF((Object[])new String[0]);
        ItemsSketchTest.println("cdfOut: " + cdfOut.length);
        Assert.assertEquals((double)cdfOut[0], (double)1.0, (double)0.0);
    }

    @Test
    public void checkToFromByteArray() {
        ItemsSketchTest.checkToFromByteArray2(128, 1300);
        ItemsSketchTest.checkToFromByteArray2(4, 7);
        ItemsSketchTest.checkToFromByteArray2(4, 8);
        ItemsSketchTest.checkToFromByteArray2(4, 9);
    }

    @Test
    public void getRankAndGetCdfConsistency() {
        int i;
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        int n = 1000000;
        Object[] values = new Integer[1000000];
        for (int i2 = 0; i2 < 1000000; ++i2) {
            sketch.update((Object)i2);
            values[i2] = i2;
        }
        double[] ranks = sketch.getCDF(values);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
        ranks = sketch.getCDF(values, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void getRankAndGetCdfConsistencyReverseComparator() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, Comparator.naturalOrder().reversed());
        int n = 1000000;
        Object[] values = new Integer[1000000];
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((Object)i);
            values[i] = i;
        }
        Arrays.sort(values, sketch.getComparator());
        double[] ranks = sketch.getCDF(values);
        for (int i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void checkBounds() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Double.class, Comparator.naturalOrder());
        for (int i = 0; i < 1000; ++i) {
            sketch.update((Object)i);
        }
        double eps = sketch.getNormalizedRankError(false);
        double est = (Double)sketch.getQuantile(0.5);
        double ub = (Double)sketch.getQuantileUpperBound(0.5);
        double lb = (Double)sketch.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)((Double)sketch.getQuantile(0.5 + eps)));
        Assert.assertEquals((double)lb, (double)((Double)sketch.getQuantile(0.5 - eps)));
        ItemsSketchTest.println("Ext     : " + est);
        ItemsSketchTest.println("UB      : " + ub);
        ItemsSketchTest.println("LB      : " + lb);
    }

    @Test
    public void checkGetKFromEqs() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Double.class, Comparator.naturalOrder());
        int k = sketch.getK();
        double eps = QuantilesItemsSketch.getNormalizedRankError((int)k, (boolean)false);
        double epsPmf = QuantilesItemsSketch.getNormalizedRankError((int)k, (boolean)true);
        int kEps = QuantilesItemsSketch.getKFromEpsilon((double)eps, (boolean)false);
        int kEpsPmf = QuantilesItemsSketch.getKFromEpsilon((double)epsPmf, (boolean)true);
        Assert.assertEquals((int)kEps, (int)k);
        Assert.assertEquals((int)kEpsPmf, (int)k);
    }

    private static void checkToFromByteArray2(int k, int n) {
        double f;
        QuantilesItemsSketch<String> is = ItemsSketchTest.buildStringIS(k, n);
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] byteArr = is.toByteArray(true, (ArrayOfItemsSerDe)serDe);
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        QuantilesItemsSketch is2 = QuantilesItemsSketch.heapify(String.class, (MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((String)((String)is.getQuantile(f)), (String)((String)is2.getQuantile(f)));
        }
        byteArr = is.toByteArray(false, (ArrayOfItemsSerDe)serDe);
        seg = MemorySegment.ofArray(byteArr);
        is2 = QuantilesItemsSketch.heapify(String.class, (MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((String)((String)is.getQuantile(f)), (String)((String)is2.getQuantile(f)));
        }
    }

    static QuantilesItemsSketch<String> buildStringIS(int k, int n) {
        return ItemsSketchTest.buildStringIS(k, n, 0);
    }

    static QuantilesItemsSketch<String> buildStringIS(int k, int n, int start) {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(String.class, (int)k, Comparator.naturalOrder());
        for (int i = 0; i < n; ++i) {
            sketch.update((Object)Integer.toString(i + start));
        }
        return sketch;
    }

    @Test
    public void sortedView() {
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Integer.class, Comparator.naturalOrder());
        sketch.update((Object)3);
        sketch.update((Object)1);
        sketch.update((Object)2);
        ItemsSketchSortedView view = sketch.getSortedView();
        GenericSortedViewIterator it = view.iterator();
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((Integer)((Integer)it.getQuantile()), (int)1);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((Integer)((Integer)it.getQuantile()), (int)2);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((Integer)((Integer)it.getQuantile()), (int)3);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)3L);
        Assert.assertEquals((boolean)it.next(), (boolean)false);
    }

    @Test
    public void checkIssue484() {
        Boolean[] items = new Boolean[]{true, false, true, false, true, false, true, false, true, false};
        QuantilesItemsSketch sketch = QuantilesItemsSketch.getInstance(Boolean.class, Boolean::compareTo);
        for (int i = 0; i < items.length; ++i) {
            sketch.update((Object)items[i]);
        }
        byte[] serialized = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        QuantilesItemsSketch deserialized = QuantilesItemsSketch.heapify(Boolean.class, (MemorySegment)MemorySegment.ofArray(serialized), Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        ItemsSketchTest.checkSketchesEqual(sketch, deserialized);
    }

    private static <T> void checkSketchesEqual(QuantilesItemsSketch<T> expected, QuantilesItemsSketch<T> actual) {
        ItemsSketchSortedView expSV = expected.getSortedView();
        ItemsSketchSortedView actSV = actual.getSortedView();
        int N = (int)actSV.getN();
        long[] expCumWts = expSV.getCumulativeWeights();
        Object[] expItemsArr = (Boolean[])expSV.getQuantiles();
        long[] actCumWts = actSV.getCumulativeWeights();
        Object[] actItemsArr = (Boolean[])actSV.getQuantiles();
        ItemsSketchTest.printf("%3s %8s %8s\n", "i", "Actual", "Expected");
        for (int i = 0; i < N; ++i) {
            ItemsSketchTest.printf("%3d %8s %8s\n", i, ((Boolean)actItemsArr[i]).toString(), ((Boolean)expItemsArr[i]).toString());
        }
        Assert.assertEquals((long[])actCumWts, (long[])expCumWts);
        Assert.assertEquals((Object[])actItemsArr, (Object[])expItemsArr);
    }

    @Test
    public void checkL0SortDuringMergeIssue527() throws NumberFormatException {
        Random rand = new Random();
        QuantilesItemsSketch sk1 = QuantilesItemsSketch.getInstance(String.class, (int)8, Comparator.reverseOrder());
        QuantilesItemsSketch sk2 = QuantilesItemsSketch.getInstance(String.class, (int)8, Comparator.reverseOrder());
        int n = 24;
        for (int i = 1; i <= 24; ++i) {
            int j = rand.nextInt(24) + 1;
            sk1.update((Object)LongsAsOrderableStrings.getString(j, 3));
            sk2.update((Object)LongsAsOrderableStrings.getString(j + 100, 3));
        }
        int k = 8;
        QuantilesItemsUnion union = QuantilesItemsUnion.getInstance(String.class, (int)8, Comparator.reverseOrder());
        union.union(sk1);
        union.union(sk2);
        QuantilesItemsSketch sk3 = union.getResult();
        ItemsSketchTest.println(sk3.toString(true, true));
        QuantilesGenericSketchIteratorAPI itr = sk3.iterator();
        itr.next();
        int prev = Integer.parseInt(((String)itr.getQuantile()).trim());
        for (int i = 1; i < 16; ++i) {
            if (!itr.next()) continue;
            int v = Integer.parseInt(((String)itr.getQuantile()).trim());
            if (i == 8) {
                prev = Integer.parseInt(((String)itr.getQuantile()).trim());
                continue;
            }
            Assert.assertTrue((v <= prev ? 1 : 0) != 0);
            prev = v;
        }
    }

    @Test
    public void printlnTest() {
        ItemsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

