-- Licensed to the Apache Software Foundation (ASF) under one or more
-- contributor license agreements.  See the NOTICE file distributed with
-- this work for additional information regarding copyright ownership.
-- The ASF licenses this file to You under the Apache License, Version 2.0
-- (the "License"); you may not use this file except in compliance with
-- the License.  You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

-- SchemaType: application identity

-- connect 'jdbc:derby:jdotckdb;create=true' user 'tckuser' password 'tckuser';

CREATE SCHEMA applicationidentity0;
SET SCHEMA applicationidentity0;

-------------------------
-- newInstance
-------------------------
DROP TABLE address;

CREATE TABLE address (
    ADDRID INTEGER,
    STREET VARCHAR(64),
    CITY VARCHAR(64),
    STATE CHAR(2),
    ZIPCODE CHAR(5),
    COUNTRY VARCHAR(64),
    CONSTRAINT ADDR_PK PRIMARY KEY (ADDRID)
);

-------------------------
-- order
-------------------------
DROP TABLE Item;
DROP TABLE Orders;

CREATE TABLE Orders (
    ID BIGINT NOT NULL,
    CUSTOMERID BIGINT,
    CONSTRAINT ORDER_CONST PRIMARY KEY (ID)
);

CREATE TABLE Item (
    ID BIGINT NOT NULL,
    ORDERID BIGINT,
    DESCRIPTION VARCHAR(64),
    QUANTITY INT,
    CONSTRAINT ITEM_ORDER_FK FOREIGN KEY (ORDERID) REFERENCES Orders(ID),
    CONSTRAINT ITEM_CONST PRIMARY KEY (ID, ORDERID)
);

-------------------------
-- mylib
-------------------------

DROP TABLE PCRect;
DROP TABLE PCPoint;
DROP TABLE VersionedPCPoint;
DROP TABLE PCPoint2;
DROP TABLE PrimitiveTypes;
DROP TABLE PCClass;

CREATE TABLE PCPoint (
    ID BIGINT NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_CONST PRIMARY KEY (ID)
);

CREATE TABLE VersionedPCPoint (
    ID BIGINT,
    X INTEGER NOT NULL,
    Y INTEGER,
    VERSION INTEGER,
    CONSTRAINT VERSIONED_PCPNT_CONST PRIMARY KEY (ID)
);

CREATE TABLE PCPoint2 (
    ID BIGINT NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT2_CONST PRIMARY KEY (ID)
);

CREATE TABLE PCRect (
    ID BIGINT NOT NULL,
    UPPER_LEFT BIGINT REFERENCES PCPoint NOT NULL,
    LOWER_RIGHT BIGINT REFERENCES PCPoint NOT NULL,
    CONSTRAINT PCRCT_CONST PRIMARY KEY (ID)
);

CREATE TABLE PrimitiveTypes (
    ID BIGINT NOT NULL,
    booleanNotNull CHAR(1) NOT NULL CHECK (booleanNotNull IN ('Y','N')),
    booleanNull CHAR(1) CHECK (booleanNull IN ('Y','N')),
    byteNotNull SMALLINT NOT NULL,
    byteNull SMALLINT,
    shortNotNull SMALLINT NOT NULL,
    shortNull SMALLINT,
    intNotNull INTEGER NOT NULL,
    intNull INTEGER,
    longNotNull INTEGER NOT NULL,
    longNull INTEGER,
    floatNotNull REAL NOT NULL,
    floatNull REAL,
    doubleNotNull DOUBLE NOT NULL,
    doubleNull DOUBLE,
    charNotNull CHAR NOT NULL,
    charNull CHAR,
    dateNull TIMESTAMP,
    stringNull VARCHAR (256),
    bigDecimal DECIMAL,
    bigInteger INTEGER,
    PrimitiveTypes INTEGER,
    CONSTRAINT PT_CONST PRIMARY KEY (ID)
);

CREATE TABLE PCClass (
    ID BIGINT NOT NULL,
    NUMBER1 INTEGER,
    NUMBER2 INTEGER,
    CONSTRAINT PCCLASS_CONST PRIMARY KEY (ID)
);

-------------------------
-- converter
-------------------------

DROP TABLE PCPointConv;
DROP TABLE PCRectConv;

CREATE TABLE PCRectConv (
    ID BIGINT NOT NULL,
    UPPER_LEFT VARCHAR(30),
    LOWER_RIGHT VARCHAR(30),
    CONSTRAINT PCRCTCNV_CONST PRIMARY KEY (ID)
);

CREATE TABLE PCPointConv (
    ID BIGINT NOT NULL,
    X VARCHAR(30),
    Y VARCHAR(30),
    CONSTRAINT PCPNTCNV_CONST PRIMARY KEY (ID)
);

-------------------------
-- query
-------------------------

DROP TABLE JDOQLKeywordsAsFieldNames;
DROP TABLE NoExtent;
DROP TABLE TimeSample;
DROP TABLE OptionalSample;
DROP TABLE MathSample;

CREATE TABLE JDOQLKeywordsAsFieldNames (
    ID VARCHAR(64) NOT NULL,
    CONSTRAINT KEYWORDS_PK PRIMARY KEY (ID)
);

CREATE TABLE NoExtent (
    ID INTEGER NOT NULL,
    CONSTRAINT NOEXTENT_PK PRIMARY KEY (ID)
);

CREATE TABLE TimeSample (
    ID INTEGER NOT NULL,
    TIME TIME,
    CONSTRAINT TIMESAMPLE_PK PRIMARY KEY (ID)
);

CREATE TABLE LocalDateSample (
    ID INTEGER NOT NULL,
    LOCAL_DATE DATE,
    CONSTRAINT LOCALDATESAMPLE_PK PRIMARY KEY (ID)
);

CREATE TABLE LocalDateTimeSample (
    ID INTEGER NOT NULL,
    LOCAL_DATE_TIME TIMESTAMP,
    CONSTRAINT LOCALDATETIMESAMPLE_PK PRIMARY KEY (ID)
);

CREATE TABLE LocalTimeSample (
    ID INTEGER NOT NULL,
    LOCAL_TIME TIME,
    CONSTRAINT LOCALTIMESAMPLE_PK PRIMARY KEY (ID)
);

CREATE TABLE OptionalSample (
    ID INTEGER NOT NULL,
	OPTIONAL_PC INTEGER REFERENCES OptionalSample ON DELETE NO ACTION,
	OPTIONAL_DATE DATE,
	OPTIONAL_INTEGER INTEGER,
	OPTIONAL_STRING VARCHAR(255),
    CONSTRAINT OPTIONALSAMPLE_PK PRIMARY KEY (ID)
);

CREATE TABLE MathSample (
    ID INTEGER NOT NULL,
    ANGLE DECIMAL(18,8),
    TRIG_VALUE DECIMAL(12,8),
    DOUBLE_VALUE DECIMAL(12,8),
    FLOAT_VALUE DECIMAL(12,8),
    INT_VALUE INTEGER,
    CONSTRAINT MATHSAMPLE_PK PRIMARY KEY (ID)
);

-------------------------
-- singlefieldidentity
-------------------------

DROP TABLE PCPointSingleFieldByte;
DROP TABLE PCPointSingleFieldChar;
DROP TABLE PCPointSingleFieldInteger;
DROP TABLE PCPointSingleFieldLong;
DROP TABLE PCPointSingleFieldShort;
DROP TABLE PCPointSingleFieldString;
DROP TABLE PCPointSingleFieldDate;

CREATE TABLE PCPointSingleFieldByte (
    ID DECIMAL(3) NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_SFB_PK PRIMARY KEY (ID)
);

CREATE TABLE PCPointSingleFieldChar (
    ID INTEGER NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_SFC_PK PRIMARY KEY (ID)
);

CREATE TABLE PCPointSingleFieldInteger (
    ID INTEGER NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_SFI_PK PRIMARY KEY (ID)
);

CREATE TABLE PCPointSingleFieldLong (
    ID BIGINT NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_SFL_PK PRIMARY KEY (ID)
);

CREATE TABLE PCPointSingleFieldShort (
    ID SMALLINT NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_SFS_PK PRIMARY KEY (ID)
);

CREATE TABLE PCPointSingleFieldString (
    ID VARCHAR(100) NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_SFSTR_PK PRIMARY KEY (ID)
);

CREATE TABLE PCPointSingleFieldDate (
    ID DATE NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER,
    CONSTRAINT PCPNT_SFD_PK PRIMARY KEY (ID)
);

-------------------------
-- company
-------------------------

ALTER TABLE departments DROP CONSTRAINT EMP_MO_FK;
ALTER TABLE departments DROP CONSTRAINT DEPTS_COMP_FK;
ALTER TABLE project_reviewer DROP CONSTRAINT PR_PROJ_FK;
ALTER TABLE project_reviewer DROP CONSTRAINT PR_REV_FK;
ALTER TABLE persons DROP CONSTRAINT PERS_DEPT_FK;
ALTER TABLE persons DROP CONSTRAINT PERS_FUNDDEPT_FK;
ALTER TABLE persons DROP CONSTRAINT PERS_MANAGER_FK;
ALTER TABLE persons DROP CONSTRAINT PERS_MENTOR_FK;
ALTER TABLE persons DROP CONSTRAINT PERS_HRADVISOR_FK;
ALTER TABLE insuranceplans DROP CONSTRAINT INS_EMP_FK;
DROP TABLE insuranceplans;
DROP TABLE project_reviewer;
DROP TABLE project_member;
DROP TABLE project_member_jpa;
DROP TABLE employee_phoneno_type;
DROP TABLE persons;
DROP TABLE projects;
DROP TABLE departments;
DROP TABLE companies;
DROP TABLE meetingrooms;
DROP TABLE department_rooms;

CREATE TABLE companies (
    ID INTEGER NOT NULL,
    NAME VARCHAR(32) NOT NULL,
    FOUNDEDDATE DATE NOT NULL,
    ADDRID INTEGER,
    STREET VARCHAR(64),
    CITY VARCHAR(64),
    STATE CHAR(2),
    ZIPCODE CHAR(5),
    COUNTRY VARCHAR(64),
    DISCRIMINATOR VARCHAR(255),
    CONSTRAINT COMPS_PK PRIMARY KEY (ID)
);

CREATE TABLE departments (
    ID INTEGER NOT NULL,
    NAME VARCHAR(32) NOT NULL,
    EMP_OF_THE_MONTH INTEGER,
    COMPANYID INTEGER,
    DISCRIMINATOR VARCHAR(255),
    CONSTRAINT DEPTS_COMP_FK FOREIGN KEY (COMPANYID) REFERENCES companies,
    CONSTRAINT DEPTS_PK PRIMARY KEY (ID)
);

CREATE TABLE department_rooms (
    DEPTID INTEGER NOT NULL,
    ROOMID INTEGER NOT NULL,
    ROOM_ORDER INTEGER NOT NULL
);

CREATE TABLE meetingrooms (
    ID INTEGER NOT NULL,
    NAME VARCHAR(32) NOT NULL,
    DISCRIMINATOR VARCHAR(255),
    CONSTRAINT ROOMS_PK PRIMARY KEY (ID)
);

CREATE TABLE persons (
    PERSONID INTEGER NOT NULL,
    FIRSTNAME VARCHAR(32) NOT NULL,
    LASTNAME VARCHAR(32) NOT NULL,
    MIDDLENAME VARCHAR(32),
    BIRTHDATE DATE NOT NULL,
    ADDRID INTEGER,
    STREET VARCHAR(64),
    CITY VARCHAR(64),
    STATE CHAR(2),
    ZIPCODE CHAR(5),
    COUNTRY VARCHAR(64),
    HIREDATE DATE,
    WEEKLYHOURS REAL,
    DEPARTMENT INTEGER,
    FUNDINGDEPT INTEGER,
    MANAGER INTEGER,
    MENTOR INTEGER,
    HRADVISOR INTEGER,
    SALARY REAL,
    WAGE REAL,
    DISCRIMINATOR varchar(255) NOT NULL,
    CONSTRAINT PERS_DEPT_FK FOREIGN KEY (DEPARTMENT) REFERENCES departments,
    CONSTRAINT PERS_FUNDDEPT_FK FOREIGN KEY (FUNDINGDEPT) REFERENCES departments,
    CONSTRAINT PERS_MANAGER_FK FOREIGN KEY (MANAGER) REFERENCES persons,
    CONSTRAINT PERS_MENTOR_FK FOREIGN KEY (MENTOR) REFERENCES persons,
    CONSTRAINT PERS_HRADVISOR_FK FOREIGN KEY (HRADVISOR) REFERENCES persons,
    CONSTRAINT EMPS_PK PRIMARY KEY (PERSONID)
);

CREATE TABLE insuranceplans (
    INSID INTEGER NOT NULL,
    CARRIER VARCHAR(64) NOT NULL,
    LIFETIME_ORTHO_BENEFIT DECIMAL(22,3),
    PLANTYPE VARCHAR(8),
    DISCRIMINATOR varchar(255) NOT NULL,
    EMPLOYEE INTEGER,
    CONSTRAINT INS_EMP_FK FOREIGN KEY (EMPLOYEE) REFERENCES persons,
    CONSTRAINT INS_PK PRIMARY KEY (INSID)
);

CREATE TABLE projects (
    PROJID INTEGER NOT NULL,
    NAME VARCHAR(32) NOT NULL,
    BUDGET DECIMAL(11,2) NOT NULL,
    DISCRIMINATOR VARCHAR(255),
    CONSTRAINT PROJS_PK PRIMARY KEY (PROJID)
);

CREATE TABLE project_reviewer (
    PROJID INTEGER NOT NULL,
    REVIEWER INTEGER NOT NULL
);

CREATE TABLE project_member (
    PROJID INTEGER REFERENCES projects NOT NULL,
    MEMBER INTEGER REFERENCES persons NOT NULL
);

CREATE TABLE project_member_jpa (
    PROJID INTEGER REFERENCES projects NOT NULL,
    MEMBER_JPA INTEGER REFERENCES persons NOT NULL
);

CREATE TABLE employee_phoneno_type (
    EMPID INTEGER REFERENCES persons NOT NULL,
    PHONENO VARCHAR(16) NOT NULL,
    TYPE VARCHAR(16) NOT NULL
);

ALTER TABLE project_reviewer 
    ADD CONSTRAINT PR_PROJ_FK FOREIGN KEY
        (PROJID) REFERENCES projects(PROJID);

ALTER TABLE project_reviewer 
    ADD CONSTRAINT PR_REV_FK FOREIGN KEY
        (REVIEWER) REFERENCES persons(PERSONID);

ALTER TABLE departments 
    ADD CONSTRAINT EMP_MO_FK FOREIGN KEY
        (EMP_OF_THE_MONTH) REFERENCES persons(PERSONID) ON DELETE SET NULL;

-------------------------
--fieldtypes
-------------------------
DROP TABLE ARRAY_OF_OBJECT0;
DROP TABLE ARRAY_OF_OBJECT1;
DROP TABLE ARRAY_OF_SIMPLE_CLASS2;
DROP TABLE ARRAY_OF_SIMPLE_CLASS3;
DROP TABLE ARRAY_OF_SIMPLE_INTERFACE4;
DROP TABLE ARRAY_OF_SIMPLE_INTERFACE5;
DROP TABLE ARRAY_OF_STRING7;
DROP TABLE ARRAY_OF_DATE9;
DROP TABLE ARRAY_OF_LOCALE11;
DROP TABLE ARRAY_OF_BIG_DECIMAL13;
DROP TABLE ARRAY_OF_BIG_INTEGER15;
DROP TABLE ARRAY_OF_BYTE17;
DROP TABLE ARRAY_OF_DOUBLE19;
DROP TABLE ARRAY_OF_FLOAT21;
DROP TABLE ARRAY_OF_INTEGER23;
DROP TABLE ARRAY_OF_LONG25;
DROP TABLE ARRAY_OF_SHORT27;
DROP TABLE ARRAY_OF_SIMPLEENUM29;
DROP TABLE ARRAY_OF_SIMPLEENUM30;
DROP TABLE ARRAY_COLLECTIONS;

DROP TABLE ARRAYLIST_OF_OBJECT0;
DROP TABLE ARRAYLIST_OF_OBJECT1;
DROP TABLE ARRAYLIST_OF_OBJECT2;
DROP TABLE ARRAYLIST_OF_SIMPLE_CLASS3;
DROP TABLE ARRAYLIST_OF_SIMPLE_CLASS4;
DROP TABLE ARRAYLIST_OF_SIMPLE_CLASS5;
DROP TABLE ARRAYLIST_OF_SIMPLE_INTERFACE6;
DROP TABLE ARRAYLIST_OF_SIMPLE_INTERFACE7;
DROP TABLE ARRAYLIST_OF_SIMPLE_INTERFACE8;
DROP TABLE ARRAYLIST_OF_STRING9;
DROP TABLE ARRAYLIST_OF_STRING11;
DROP TABLE ARRAYLIST_OF_DATE12;
DROP TABLE ARRAYLIST_OF_DATE14;
DROP TABLE ARRAYLIST_OF_LOCALE15;
DROP TABLE ARRAYLIST_OF_LOCALE17;
DROP TABLE ARRAYLIST_OF_BIG_DECIMAL18;
DROP TABLE ARRAYLIST_OF_BIG_DECIMAL20;
DROP TABLE ARRAYLIST_OF_BIG_INTEGER21;
DROP TABLE ARRAYLIST_OF_BIG_INTEGER23;
DROP TABLE ARRAYLIST_OF_BYTE24;
DROP TABLE ARRAYLIST_OF_BYTE26;
DROP TABLE ARRAYLIST_OF_DOUBLE27;
DROP TABLE ARRAYLIST_OF_DOUBLE29;
DROP TABLE ARRAYLIST_OF_FLOAT30;
DROP TABLE ARRAYLIST_OF_FLOAT32;
DROP TABLE ARRAYLIST_OF_INTEGER33;
DROP TABLE ARRAYLIST_OF_INTEGER35;
DROP TABLE ARRAYLIST_OF_LONG36;
DROP TABLE ARRAYLIST_OF_LONG38;
DROP TABLE ARRAYLIST_OF_SHORT39;
DROP TABLE ARRAYLIST_OF_SHORT41;
DROP TABLE ARRAYLIST_OF_SIMPLEENUM42;
DROP TABLE ARRAYLIST_OF_SIMPLEENUM44;
DROP TABLE ARRAYLIST_OF_SIMPLEENUM45;
DROP TABLE ARRAYLIST_OF_SIMPLEENUM46;
DROP TABLE ARRAYLIST_COLLECTIONS;

DROP TABLE COLLECTION_OF_OBJECT0;
DROP TABLE COLLECTION_OF_OBJECT1;
DROP TABLE COLLECTION_OF_OBJECT2;
DROP TABLE COLLECTION_OF_SIMPLE_CLASS3;
DROP TABLE COLLECTION_OF_SIMPLE_CLASS4;
DROP TABLE COLLECTION_OF_SIMPLE_CLASS5;
DROP TABLE COLLECTION_OF_SIMPLE_INTERFACE6;
DROP TABLE COLLECTION_OF_SIMPLE_INTERFACE7;
DROP TABLE COLLECTION_OF_SIMPLE_INTERFACE8;
DROP TABLE COLLECTION_OF_STRING9;
DROP TABLE COLLECTION_OF_STRING10;
DROP TABLE COLLECTION_OF_DATE12;
DROP TABLE COLLECTION_OF_DATE13;
DROP TABLE COLLECTION_OF_LOCALE15;
DROP TABLE COLLECTION_OF_LOCALE16;
DROP TABLE COLLECTION_OF_BIG_DECIMAL18;
DROP TABLE COLLECTION_OF_BIG_DECIMAL19;
DROP TABLE COLLECTION_OF_BIG_INTEGER21;
DROP TABLE COLLECTION_OF_BIG_INTEGER22;
DROP TABLE COLLECTION_OF_BYTE24;
DROP TABLE COLLECTION_OF_BYTE25;
DROP TABLE COLLECTION_OF_DOUBLE27;
DROP TABLE COLLECTION_OF_DOUBLE28;
DROP TABLE COLLECTION_OF_FLOAT30;
DROP TABLE COLLECTION_OF_FLOAT31;
DROP TABLE COLLECTION_OF_INTEGER33;
DROP TABLE COLLECTION_OF_INTEGER34;
DROP TABLE COLLECTION_OF_LONG36;
DROP TABLE COLLECTION_OF_LONG37;
DROP TABLE COLLECTION_OF_SHORT39;
DROP TABLE COLLECTION_OF_SHORT40;
DROP TABLE COLLECTION_COLLECTIONS;

DROP TABLE LIST_OF_OBJECT0;
DROP TABLE LIST_OF_OBJECT1;
DROP TABLE LIST_OF_OBJECT2;
DROP TABLE LIST_OF_SIMPLE_CLASS3;
DROP TABLE LIST_OF_SIMPLE_CLASS4;
DROP TABLE LIST_OF_SIMPLE_CLASS5;
DROP TABLE LIST_OF_SIMPLE_INTERFACE6;
DROP TABLE LIST_OF_SIMPLE_INTERFACE7;
DROP TABLE LIST_OF_SIMPLE_INTERFACE8;
DROP TABLE LIST_OF_STRING9;
DROP TABLE LIST_OF_STRING10;
DROP TABLE LIST_OF_DATE12;
DROP TABLE LIST_OF_DATE13;
DROP TABLE LIST_OF_LOCALE15;
DROP TABLE LIST_OF_LOCALE16;
DROP TABLE LIST_OF_BIG_DECIMAL18;
DROP TABLE LIST_OF_BIG_DECIMAL19;
DROP TABLE LIST_OF_BIG_INTEGER21;
DROP TABLE LIST_OF_BIG_INTEGER22;
DROP TABLE LIST_OF_BYTE24;
DROP TABLE LIST_OF_BYTE25;
DROP TABLE LIST_OF_DOUBLE27;
DROP TABLE LIST_OF_DOUBLE28;
DROP TABLE LIST_OF_FLOAT30;
DROP TABLE LIST_OF_FLOAT31;
DROP TABLE LIST_OF_INTEGER33;
DROP TABLE LIST_OF_INTEGER34;
DROP TABLE LIST_OF_LONG36;
DROP TABLE LIST_OF_LONG37;
DROP TABLE LIST_OF_SHORT39;
DROP TABLE LIST_OF_SHORT40;
DROP TABLE LIST_COLLECTIONS;

DROP TABLE LINKEDLIST_OF_OBJECT0;
DROP TABLE LINKEDLIST_OF_OBJECT1;
DROP TABLE LINKEDLIST_OF_OBJECT2;
DROP TABLE LINKEDLIST_OF_SIMPLE_CLASS3;
DROP TABLE LINKEDLIST_OF_SIMPLE_CLASS4;
DROP TABLE LINKEDLIST_OF_SIMPLE_CLASS5;
DROP TABLE LINKEDLIST_OF_SIMPLE_INTERFACE6;
DROP TABLE LINKEDLIST_OF_SIMPLE_INTERFACE7;
DROP TABLE LINKEDLIST_OF_SIMPLE_INTERFACE8;
DROP TABLE LINKEDLIST_OF_STRING9;
DROP TABLE LINKEDLIST_OF_STRING10;
DROP TABLE LINKEDLIST_OF_DATE12;
DROP TABLE LINKEDLIST_OF_DATE13;
DROP TABLE LINKEDLIST_OF_LOCALE15;
DROP TABLE LINKEDLIST_OF_LOCALE16;
DROP TABLE LINKEDLIST_OF_BIG_DECIMAL18;
DROP TABLE LINKEDLIST_OF_BIG_DECIMAL19;
DROP TABLE LINKEDLIST_OF_BIG_INTEGER21;
DROP TABLE LINKEDLIST_OF_BIG_INTEGER22;
DROP TABLE LINKEDLIST_OF_BYTE24;
DROP TABLE LINKEDLIST_OF_BYTE25;
DROP TABLE LINKEDLIST_OF_DOUBLE27;
DROP TABLE LINKEDLIST_OF_DOUBLE28;
DROP TABLE LINKEDLIST_OF_FLOAT30;
DROP TABLE LINKEDLIST_OF_FLOAT31;
DROP TABLE LINKEDLIST_OF_INTEGER33;
DROP TABLE LINKEDLIST_OF_INTEGER34;
DROP TABLE LINKEDLIST_OF_LONG36;
DROP TABLE LINKEDLIST_OF_LONG37;
DROP TABLE LINKEDLIST_OF_SHORT39;
DROP TABLE LINKEDLIST_OF_SHORT40;
DROP TABLE LINKEDLIST_COLLECTIONS;

DROP TABLE VECTOR_OF_OBJECT0;
DROP TABLE VECTOR_OF_OBJECT1;
DROP TABLE VECTOR_OF_OBJECT2;
DROP TABLE VECTOR_OF_SIMPLE_CLASS3;
DROP TABLE VECTOR_OF_SIMPLE_CLASS4;
DROP TABLE VECTOR_OF_SIMPLE_CLASS5;
DROP TABLE VECTOR_OF_SIMPLE_INTERFACE6;
DROP TABLE VECTOR_OF_SIMPLE_INTERFACE7;
DROP TABLE VECTOR_OF_SIMPLE_INTERFACE8;
DROP TABLE VECTOR_OF_STRING9;
DROP TABLE VECTOR_OF_STRING10;
DROP TABLE VECTOR_OF_DATE12;
DROP TABLE VECTOR_OF_DATE13;
DROP TABLE VECTOR_OF_LOCALE15;
DROP TABLE VECTOR_OF_LOCALE16;
DROP TABLE VECTOR_OF_BIG_DECIMAL18;
DROP TABLE VECTOR_OF_BIG_DECIMAL19;
DROP TABLE VECTOR_OF_BIG_INTEGER21;
DROP TABLE VECTOR_OF_BIG_INTEGER22;
DROP TABLE VECTOR_OF_BYTE24;
DROP TABLE VECTOR_OF_BYTE25;
DROP TABLE VECTOR_OF_DOUBLE27;
DROP TABLE VECTOR_OF_DOUBLE28;
DROP TABLE VECTOR_OF_FLOAT30;
DROP TABLE VECTOR_OF_FLOAT31;
DROP TABLE VECTOR_OF_INTEGER33;
DROP TABLE VECTOR_OF_INTEGER34;
DROP TABLE VECTOR_OF_LONG36;
DROP TABLE VECTOR_OF_LONG37;
DROP TABLE VECTOR_OF_SHORT39;
DROP TABLE VECTOR_OF_SHORT40;
DROP TABLE VECTOR_COLLECTIONS;

DROP TABLE SET_OF_OBJECT0;
DROP TABLE SET_OF_OBJECT1;
DROP TABLE SET_OF_SIMPLE_CLASS3;
DROP TABLE SET_OF_SIMPLE_CLASS4;
DROP TABLE SET_OF_SIMPLE_INTERFACE6;
DROP TABLE SET_OF_SIMPLE_INTERFACE7;
DROP TABLE SET_OF_STRING9;
DROP TABLE SET_OF_STRING10;
DROP TABLE SET_OF_DATE12;
DROP TABLE SET_OF_DATE13;
DROP TABLE SET_OF_LOCALE15;
DROP TABLE SET_OF_LOCALE16;
DROP TABLE SET_OF_BIG_DECIMAL18;
DROP TABLE SET_OF_BIG_DECIMAL19;
DROP TABLE SET_OF_BIG_INTEGER21;
DROP TABLE SET_OF_BIG_INTEGER22;
DROP TABLE SET_OF_BYTE24;
DROP TABLE SET_OF_BYTE25;
DROP TABLE SET_OF_DOUBLE27;
DROP TABLE SET_OF_DOUBLE28;
DROP TABLE SET_OF_FLOAT30;
DROP TABLE SET_OF_FLOAT31;
DROP TABLE SET_OF_INTEGER33;
DROP TABLE SET_OF_INTEGER34;
DROP TABLE SET_OF_LONG36;
DROP TABLE SET_OF_LONG37;
DROP TABLE SET_OF_SHORT39;
DROP TABLE SET_OF_SHORT40;
DROP TABLE SET_COLLECTIONS;

DROP TABLE HASHSET_OF_OBJECT0;
DROP TABLE HASHSET_OF_OBJECT1;
DROP TABLE HASHSET_OF_SIMPLE_CLASS3;
DROP TABLE HASHSET_OF_SIMPLE_CLASS4;
DROP TABLE HASHSET_OF_SIMPLE_INTERFACE6;
DROP TABLE HASHSET_OF_SIMPLE_INTERFACE7;
DROP TABLE HASHSET_OF_STRING9;
DROP TABLE HASHSET_OF_STRING10;
DROP TABLE HASHSET_OF_DATE12;
DROP TABLE HASHSET_OF_DATE13;
DROP TABLE HASHSET_OF_LOCALE15;
DROP TABLE HASHSET_OF_LOCALE16;
DROP TABLE HASHSET_OF_BIG_DECIMAL18;
DROP TABLE HASHSET_OF_BIG_DECIMAL19;
DROP TABLE HASHSET_OF_BIG_INTEGER21;
DROP TABLE HASHSET_OF_BIG_INTEGER22;
DROP TABLE HASHSET_OF_BYTE24;
DROP TABLE HASHSET_OF_BYTE25;
DROP TABLE HASHSET_OF_DOUBLE27;
DROP TABLE HASHSET_OF_DOUBLE28;
DROP TABLE HASHSET_OF_FLOAT30;
DROP TABLE HASHSET_OF_FLOAT31;
DROP TABLE HASHSET_OF_INTEGER33;
DROP TABLE HASHSET_OF_INTEGER34;
DROP TABLE HASHSET_OF_LONG36;
DROP TABLE HASHSET_OF_LONG37;
DROP TABLE HASHSET_OF_SHORT39;
DROP TABLE HASHSET_OF_SHORT40;
DROP TABLE HASHSET_COLLECTIONS;

DROP TABLE TREESET_OF_OBJECT0;
DROP TABLE TREESET_OF_OBJECT1;
DROP TABLE TREESET_OF_OBJECT2;
DROP TABLE TREESET_OF_SIMPLE_CLASS3;
DROP TABLE TREESET_OF_SIMPLE_CLASS4;
DROP TABLE TREESET_OF_SIMPLE_CLASS5;
DROP TABLE TREESET_OF_SIMPLE_INTERFACE6;
DROP TABLE TREESET_OF_SIMPLE_INTERFACE7;
DROP TABLE TREESET_OF_SIMPLE_INTERFACE8;
DROP TABLE TREESET_OF_STRING9;
DROP TABLE TREESET_OF_STRING11;
DROP TABLE TREESET_OF_DATE12;
DROP TABLE TREESET_OF_DATE14;
DROP TABLE TREESET_OF_BIG_DECIMAL15;
DROP TABLE TREESET_OF_BIG_DECIMAL17;
DROP TABLE TREESET_OF_BIG_INTEGER18;
DROP TABLE TREESET_OF_BIG_INTEGER20;
DROP TABLE TREESET_OF_BYTE21;
DROP TABLE TREESET_OF_BYTE23;
DROP TABLE TREESET_OF_DOUBLE24;
DROP TABLE TREESET_OF_DOUBLE26;
DROP TABLE TREESET_OF_FLOAT27;
DROP TABLE TREESET_OF_FLOAT29;
DROP TABLE TREESET_OF_INTEGER30;
DROP TABLE TREESET_OF_INTEGER32;
DROP TABLE TREESET_OF_LONG33;
DROP TABLE TREESET_OF_LONG35;
DROP TABLE TREESET_OF_SHORT36;
DROP TABLE TREESET_OF_SHORT38;
DROP TABLE TREESET_COLLECTIONS;

DROP TABLE MAP_OF_STRING_OBJECT0;
DROP TABLE MAP_OF_STRING_OBJECT1;
DROP TABLE MAP_OF_STRING_OBJECT2;
DROP TABLE MAP_OF_STRING_SIMPLE_CLASS3;
DROP TABLE MAP_OF_STRING_SIMPLE_CLASS4;
DROP TABLE MAP_OF_STRING_SIMPLE_CLASS5;
DROP TABLE MAP_OF_STRING_SIMPLE_INTERFACE6;
DROP TABLE MAP_OF_STRING_SIMPLE_INTERFACE7;
DROP TABLE MAP_OF_STRING_SIMPLE_INTERFACE8;
DROP TABLE MAP_OF_STRING_STRING9;
DROP TABLE MAP_OF_STRING_STRING10;
DROP TABLE MAP_OF_STRING_STRING11;
DROP TABLE MAP_OF_STRING_DATE12;
DROP TABLE MAP_OF_STRING_DATE13;
DROP TABLE MAP_OF_STRING_DATE14;
DROP TABLE MAP_OF_STRING_LOCALE15;
DROP TABLE MAP_OF_STRING_LOCALE16;
DROP TABLE MAP_OF_STRING_LOCALE17;
DROP TABLE MAP_OF_STRING_BIG_DECIMAL18;
DROP TABLE MAP_OF_STRING_BIG_DECIMAL19;
DROP TABLE MAP_OF_STRING_BIG_DECIMAL20;
DROP TABLE MAP_OF_STRING_BIG_INTEGER21;
DROP TABLE MAP_OF_STRING_BIG_INTEGER22;
DROP TABLE MAP_OF_STRING_BIG_INTEGER23;
DROP TABLE MAP_OF_STRING_BYTE24;
DROP TABLE MAP_OF_STRING_BYTE25;
DROP TABLE MAP_OF_STRING_BYTE26;
DROP TABLE MAP_OF_STRING_DOUBLE27;
DROP TABLE MAP_OF_STRING_DOUBLE28;
DROP TABLE MAP_OF_STRING_DOUBLE29;
DROP TABLE MAP_OF_STRING_FLOAT30;
DROP TABLE MAP_OF_STRING_FLOAT31;
DROP TABLE MAP_OF_STRING_FLOAT32;
DROP TABLE MAP_OF_STRING_INTEGER33;
DROP TABLE MAP_OF_STRING_INTEGER34;
DROP TABLE MAP_OF_STRING_INTEGER35;
DROP TABLE MAP_OF_STRING_LONG36;
DROP TABLE MAP_OF_STRING_LONG37;
DROP TABLE MAP_OF_STRING_LONG38;
DROP TABLE MAP_OF_STRING_SHORT39;
DROP TABLE MAP_OF_STRING_SHORT40;
DROP TABLE MAP_OF_STRING_SHORT41;
DROP TABLE MAP_OF_STRING_OBJECT42;
DROP TABLE MAP_OF_STRING_OBJECT43;
DROP TABLE MAP_OF_STRING_SIMPLE_CLASS45;
DROP TABLE MAP_OF_STRING_SIMPLE_CLASS46;
DROP TABLE MAP_OF_STRING_SIMPLE_INTERFACE48;
DROP TABLE MAP_OF_STRING_SIMPLE_INTERFACE49;
DROP TABLE MAP_OF_STRING_STRING51;
DROP TABLE MAP_OF_STRING_STRING52;
DROP TABLE MAP_OF_STRING_DATE54;
DROP TABLE MAP_OF_STRING_DATE55;
DROP TABLE MAP_OF_STRING_LOCALE57;
DROP TABLE MAP_OF_STRING_LOCALE58;
DROP TABLE MAP_OF_STRING_BIG_DECIMAL60;
DROP TABLE MAP_OF_STRING_BIG_DECIMAL61;
DROP TABLE MAP_OF_STRING_BIG_INTEGER63;
DROP TABLE MAP_OF_STRING_BIG_INTEGER64;
DROP TABLE MAP_OF_STRING_BYTE66;
DROP TABLE MAP_OF_STRING_BYTE67;
DROP TABLE MAP_OF_STRING_DOUBLE69;
DROP TABLE MAP_OF_STRING_DOUBLE70;
DROP TABLE MAP_OF_STRING_FLOAT72;
DROP TABLE MAP_OF_STRING_FLOAT73;
DROP TABLE MAP_OF_STRING_INTEGER75;
DROP TABLE MAP_OF_STRING_INTEGER76;
DROP TABLE MAP_OF_STRING_LONG78;
DROP TABLE MAP_OF_STRING_LONG79;
DROP TABLE MAP_OF_STRING_SHORT81;
DROP TABLE MAP_OF_STRING_SHORT82;
DROP TABLE MAP_OF_STRING_OBJECT84;
DROP TABLE MAP_OF_STRING_SIMPLE_CLASS87;
DROP TABLE MAP_OF_STRING_SIMPLE_INTERFACE90;
DROP TABLE MAP_OF_STRING_STRING93;
DROP TABLE MAP_OF_STRING_DATE96;
DROP TABLE MAP_OF_STRING_LOCALE99;
DROP TABLE MAP_OF_STRING_BIG_DECIMAL102;
DROP TABLE MAP_OF_STRING_BIG_INTEGER105;
DROP TABLE MAP_OF_STRING_BYTE108;
DROP TABLE MAP_OF_STRING_DOUBLE111;
DROP TABLE MAP_OF_STRING_FLOAT114;
DROP TABLE MAP_OF_STRING_INTEGER117;
DROP TABLE MAP_OF_STRING_LONG120;
DROP TABLE MAP_OF_STRING_SHORT123;
DROP TABLE MAP_OF_STRING_SIMPLEENUM126;
DROP TABLE MAP_OF_STRING_SIMPLEENUM127;
DROP TABLE MAP_OF_STRING_SIMPLEENUM128;
DROP TABLE MAP_OF_STRING_SIMPLEENUM129;
DROP TABLE MAP_OF_STRING_SIMPLEENUM130;
DROP TABLE MAP_OF_STRING_SIMPLEENUM131;
DROP TABLE MAP_OF_STRING_SIMPLEENUM133;
DROP TABLE MAP_OF_STRING_SIMPLEENUM134;
DROP TABLE MAP_OF_STRING_SIMPLEENUM135;
DROP TABLE MAP_OF_STRING_SIMPLEENUM136;
DROP TABLE MAP_OF_STRING_SIMPLEENUM137;
DROP TABLE MAP_OF_STRING_SIMPLEENUM138;
DROP TABLE MAPSTRINGKEY_COLLECTIONS;

DROP TABLE HASHMAP_STR_OBJECT0;
DROP TABLE HASHMAP_STR_OBJECT1;
DROP TABLE HASHMAP_STR_OBJECT2;
DROP TABLE HASHMAP_STR_SIMPLE_CLASS3;
DROP TABLE HASHMAP_STR_SIMPLE_CLASS4;
DROP TABLE HASHMAP_STR_SIMPLE_CLASS5;
DROP TABLE HASHMAP_STR_SIMPLE_INTERFACE6;
DROP TABLE HASHMAP_STR_SIMPLE_INTERFACE7;
DROP TABLE HASHMAP_STR_SIMPLE_INTERFACE8;
DROP TABLE HASHMAP_STR_STRING9;
DROP TABLE HASHMAP_STR_STRING10;
DROP TABLE HASHMAP_STR_STRING11;
DROP TABLE HASHMAP_STR_DATE12;
DROP TABLE HASHMAP_STR_DATE13;
DROP TABLE HASHMAP_STR_DATE14;
DROP TABLE HASHMAP_STR_LOCALE15;
DROP TABLE HASHMAP_STR_LOCALE16;
DROP TABLE HASHMAP_STR_LOCALE17;
DROP TABLE HASHMAP_STR_BIG_DECIMAL18;
DROP TABLE HASHMAP_STR_BIG_DECIMAL19;
DROP TABLE HASHMAP_STR_BIG_DECIMAL20;
DROP TABLE HASHMAP_STR_BIG_INTEGER21;
DROP TABLE HASHMAP_STR_BIG_INTEGER22;
DROP TABLE HASHMAP_STR_BIG_INTEGER23;
DROP TABLE HASHMAP_STR_BYTE24;
DROP TABLE HASHMAP_STR_BYTE25;
DROP TABLE HASHMAP_STR_BYTE26;
DROP TABLE HASHMAP_STR_DOUBLE27;
DROP TABLE HASHMAP_STR_DOUBLE28;
DROP TABLE HASHMAP_STR_DOUBLE29;
DROP TABLE HASHMAP_STR_FLOAT30;
DROP TABLE HASHMAP_STR_FLOAT31;
DROP TABLE HASHMAP_STR_FLOAT32;
DROP TABLE HASHMAP_STR_INTEGER33;
DROP TABLE HASHMAP_STR_INTEGER34;
DROP TABLE HASHMAP_STR_INTEGER35;
DROP TABLE HASHMAP_STR_LONG36;
DROP TABLE HASHMAP_STR_LONG37;
DROP TABLE HASHMAP_STR_LONG38;
DROP TABLE HASHMAP_STR_SHORT39;
DROP TABLE HASHMAP_STR_SHORT40;
DROP TABLE HASHMAP_STR_SHORT41;
DROP TABLE HASHMAP_STR_OBJECT42;
DROP TABLE HASHMAP_STR_OBJECT43;
DROP TABLE HASHMAP_STR_SIMPLE_CLASS45;
DROP TABLE HASHMAP_STR_SIMPLE_CLASS46;
DROP TABLE HASHMAP_STR_SIMPLE_INTERFACE48;
DROP TABLE HASHMAP_STR_SIMPLE_INTERFACE49;
DROP TABLE HASHMAP_STR_STRING51;
DROP TABLE HASHMAP_STR_STRING52;
DROP TABLE HASHMAP_STR_DATE54;
DROP TABLE HASHMAP_STR_DATE55;
DROP TABLE HASHMAP_STR_LOCALE57;
DROP TABLE HASHMAP_STR_LOCALE58;
DROP TABLE HASHMAP_STR_BIG_DECIMAL60;
DROP TABLE HASHMAP_STR_BIG_DECIMAL61;
DROP TABLE HASHMAP_STR_BIG_INTEGER63;
DROP TABLE HASHMAP_STR_BIG_INTEGER64;
DROP TABLE HASHMAP_STR_BYTE66;
DROP TABLE HASHMAP_STR_BYTE67;
DROP TABLE HASHMAP_STR_DOUBLE69;
DROP TABLE HASHMAP_STR_DOUBLE70;
DROP TABLE HASHMAP_STR_FLOAT72;
DROP TABLE HASHMAP_STR_FLOAT73;
DROP TABLE HASHMAP_STR_INTEGER75;
DROP TABLE HASHMAP_STR_INTEGER76;
DROP TABLE HASHMAP_STR_LONG78;
DROP TABLE HASHMAP_STR_LONG79;
DROP TABLE HASHMAP_STR_SHORT81;
DROP TABLE HASHMAP_STR_SHORT82;
DROP TABLE HASHMAP_STR_OBJECT84;
DROP TABLE HASHMAP_STR_SIMPLE_CLASS87;
DROP TABLE HASHMAP_STR_SIMPLE_INTERFACE90;
DROP TABLE HASHMAP_STR_STRING93;
DROP TABLE HASHMAP_STR_DATE96;
DROP TABLE HASHMAP_STR_LOCALE99;
DROP TABLE HASHMAP_STR_BIG_DECIMAL102;
DROP TABLE HASHMAP_STR_BIG_INTEGER105;
DROP TABLE HASHMAP_STR_BYTE108;
DROP TABLE HASHMAP_STR_DOUBLE111;
DROP TABLE HASHMAP_STR_FLOAT114;
DROP TABLE HASHMAP_STR_INTEGER117;
DROP TABLE HASHMAP_STR_LONG120;
DROP TABLE HASHMAP_STR_SHORT123;
DROP TABLE HASHMAPSTRINGKEY_COLLECTIONS;

DROP TABLE MAP_OBJECT0_STR;
DROP TABLE MAP_OBJECT1_STR;
DROP TABLE MAP_OBJECT2_STR;
DROP TABLE MAP_OBJECT3_STR;
DROP TABLE MAP_OBJECT4_STR;
DROP TABLE MAP_OBJECT6_STR;
DROP TABLE MAP_SIMPLE_CLASS9_STR;
DROP TABLE MAP_SIMPLE_CLASS10_STR;
DROP TABLE MAP_SIMPLE_CLASS11_STR;
DROP TABLE MAP_SIMPLE_CLASS12_STR;
DROP TABLE MAP_SIMPLE_CLASS13_STR;
DROP TABLE MAP_SIMPLE_CLASS15_STR;
DROP TABLE MAP_SIMPLE_INTERFACE18_STR;
DROP TABLE MAP_SIMPLE_INTERFACE19_STR;
DROP TABLE MAP_SIMPLE_INTERFACE20_STR;
DROP TABLE MAP_SIMPLE_INTERFACE21_STR;
DROP TABLE MAP_SIMPLE_INTERFACE22_STR;
DROP TABLE MAP_SIMPLE_INTERFACE24_STR;
DROP TABLE MAP_STRING27_STR;
DROP TABLE MAP_STRING28_STR;
DROP TABLE MAP_STRING29_STR;
DROP TABLE MAP_STRING30_STR;
DROP TABLE MAP_STRING31_STR;
DROP TABLE MAP_STRING33_STR;
DROP TABLE MAP_DATE36_STR;
DROP TABLE MAP_DATE37_STR;
DROP TABLE MAP_DATE38_STR;
DROP TABLE MAP_DATE39_STR;
DROP TABLE MAP_DATE40_STR;
DROP TABLE MAP_DATE42_STR;
DROP TABLE MAP_BIG_DECIMAL45_STR;
DROP TABLE MAP_BIG_DECIMAL46_STR;
DROP TABLE MAP_BIG_DECIMAL47_STR;
DROP TABLE MAP_BIG_DECIMAL48_STR;
DROP TABLE MAP_BIG_DECIMAL49_STR;
DROP TABLE MAP_BIG_DECIMAL51_STR;
DROP TABLE MAP_BIG_INTEGER54_STR;
DROP TABLE MAP_BIG_INTEGER55_STR;
DROP TABLE MAP_BIG_INTEGER56_STR;
DROP TABLE MAP_BIG_INTEGER57_STR;
DROP TABLE MAP_BIG_INTEGER58_STR;
DROP TABLE MAP_BIG_INTEGER60_STR;
DROP TABLE MAP_BYTE63_STR;
DROP TABLE MAP_BYTE64_STR;
DROP TABLE MAP_BYTE65_STR;
DROP TABLE MAP_BYTE66_STR;
DROP TABLE MAP_BYTE67_STR;
DROP TABLE MAP_BYTE69_STR;
DROP TABLE MAP_DOUBLE72_STR;
DROP TABLE MAP_DOUBLE73_STR;
DROP TABLE MAP_DOUBLE74_STR;
DROP TABLE MAP_DOUBLE75_STR;
DROP TABLE MAP_DOUBLE76_STR;
DROP TABLE MAP_DOUBLE78_STR;
DROP TABLE MAP_FLOAT81_STR;
DROP TABLE MAP_FLOAT82_STR;
DROP TABLE MAP_FLOAT83_STR;
DROP TABLE MAP_FLOAT84_STR;
DROP TABLE MAP_FLOAT85_STR;
DROP TABLE MAP_FLOAT87_STR;
DROP TABLE MAP_INTEGER90_STR;
DROP TABLE MAP_INTEGER91_STR;
DROP TABLE MAP_INTEGER92_STR;
DROP TABLE MAP_INTEGER93_STR;
DROP TABLE MAP_INTEGER94_STR;
DROP TABLE MAP_INTEGER96_STR;
DROP TABLE MAP_LONG99_STR;
DROP TABLE MAP_LONG100_STR;
DROP TABLE MAP_LONG101_STR;
DROP TABLE MAP_LONG102_STR;
DROP TABLE MAP_LONG103_STR;
DROP TABLE MAP_LONG105_STR;
DROP TABLE MAP_SHORT108_STR;
DROP TABLE MAP_SHORT109_STR;
DROP TABLE MAP_SHORT110_STR;
DROP TABLE MAP_SHORT111_STR;
DROP TABLE MAP_SHORT112_STR;
DROP TABLE MAP_SHORT114_STR;
DROP TABLE MAP_SIMPLEENUM117_STR;
DROP TABLE MAP_SIMPLEENUM118_STR;
DROP TABLE MAP_SIMPLEENUM119_STR;
DROP TABLE MAP_SIMPLEENUM120_STR;
DROP TABLE MAP_SIMPLEENUM121_STR;
DROP TABLE MAP_SIMPLEENUM122_STR;
DROP TABLE MAP_SIMPLEENUM124_STR;
DROP TABLE MAP_SIMPLEENUM125_STR;
DROP TABLE MAP_SIMPLEENUM126_STR;
DROP TABLE MAP_SIMPLEENUM127_STR;
DROP TABLE MAP_SIMPLEENUM128_STR;
DROP TABLE MAP_SIMPLEENUM129_STR;
DROP TABLE MAPSTRINGVALUE_COLLECTIONS;

DROP TABLE HASHTBL_STR_OBJECT0;
DROP TABLE HASHTBL_STR_OBJECT1;
DROP TABLE HASHTBL_STR_OBJECT2;
DROP TABLE HASHTBL_STR_SIMPLE_CLASS3;
DROP TABLE HASHTBL_STR_SIMPLE_CLASS4;
DROP TABLE HASHTBL_STR_SIMPLE_CLASS5;
DROP TABLE HASHTBL_STR_SIMPLE_INTERFACE6;
DROP TABLE HASHTBL_STR_SIMPLE_INTERFACE7;
DROP TABLE HASHTBL_STR_SIMPLE_INTERFACE8;
DROP TABLE HASHTBL_STR_STRING9;
DROP TABLE HASHTBL_STR_STRING10;
DROP TABLE HASHTBL_STR_STRING11;
DROP TABLE HASHTBL_STR_DATE12;
DROP TABLE HASHTBL_STR_DATE13;
DROP TABLE HASHTBL_STR_DATE14;
DROP TABLE HASHTBL_STR_LOCALE15;
DROP TABLE HASHTBL_STR_LOCALE16;
DROP TABLE HASHTBL_STR_LOCALE17;
DROP TABLE HASHTBL_STR_BIG_DECIMAL18;
DROP TABLE HASHTBL_STR_BIG_DECIMAL19;
DROP TABLE HASHTBL_STR_BIG_DECIMAL20;
DROP TABLE HASHTBL_STR_BIG_INTEGER21;
DROP TABLE HASHTBL_STR_BIG_INTEGER22;
DROP TABLE HASHTBL_STR_BIG_INTEGER23;
DROP TABLE HASHTBL_STR_BYTE24;
DROP TABLE HASHTBL_STR_BYTE25;
DROP TABLE HASHTBL_STR_BYTE26;
DROP TABLE HASHTBL_STR_DOUBLE27;
DROP TABLE HASHTBL_STR_DOUBLE28;
DROP TABLE HASHTBL_STR_DOUBLE29;
DROP TABLE HASHTBL_STR_FLOAT30;
DROP TABLE HASHTBL_STR_FLOAT31;
DROP TABLE HASHTBL_STR_FLOAT32;
DROP TABLE HASHTBL_STR_INTEGER33;
DROP TABLE HASHTBL_STR_INTEGER34;
DROP TABLE HASHTBL_STR_INTEGER35;
DROP TABLE HASHTBL_STR_LONG36;
DROP TABLE HASHTBL_STR_LONG37;
DROP TABLE HASHTBL_STR_LONG38;
DROP TABLE HASHTBL_STR_SHORT39;
DROP TABLE HASHTBL_STR_SHORT40;
DROP TABLE HASHTBL_STR_SHORT41;
DROP TABLE HASHTBL_STR_OBJECT42;
DROP TABLE HASHTBL_STR_OBJECT43;
DROP TABLE HASHTBL_STR_SIMPLE_CLASS45;
DROP TABLE HASHTBL_STR_SIMPLE_CLASS46;
DROP TABLE HASHTBL_STR_SIMPLE_INTERFACE48;
DROP TABLE HASHTBL_STR_SIMPLE_INTERFACE49;
DROP TABLE HASHTBL_STR_STRING51;
DROP TABLE HASHTBL_STR_STRING52;
DROP TABLE HASHTBL_STR_DATE54;
DROP TABLE HASHTBL_STR_DATE55;
DROP TABLE HASHTBL_STR_LOCALE57;
DROP TABLE HASHTBL_STR_LOCALE58;
DROP TABLE HASHTBL_STR_BIG_DECIMAL60;
DROP TABLE HASHTBL_STR_BIG_DECIMAL61;
DROP TABLE HASHTBL_STR_BIG_INTEGER63;
DROP TABLE HASHTBL_STR_BIG_INTEGER64;
DROP TABLE HASHTBL_STR_BYTE66;
DROP TABLE HASHTBL_STR_BYTE67;
DROP TABLE HASHTBL_STR_DOUBLE69;
DROP TABLE HASHTBL_STR_DOUBLE70;
DROP TABLE HASHTBL_STR_FLOAT72;
DROP TABLE HASHTBL_STR_FLOAT73;
DROP TABLE HASHTBL_STR_INTEGER75;
DROP TABLE HASHTBL_STR_INTEGER76;
DROP TABLE HASHTBL_STR_LONG78;
DROP TABLE HASHTBL_STR_LONG79;
DROP TABLE HASHTBL_STR_SHORT81;
DROP TABLE HASHTBL_STR_SHORT82;
DROP TABLE HASHTBL_STR_OBJECT84;
DROP TABLE HASHTBL_STR_SIMPLE_CLASS87;
DROP TABLE HASHTBL_STR_SIMPLE_INTERFACE90;
DROP TABLE HASHTBL_STR_STRING93;
DROP TABLE HASHTBL_STR_DATE96;
DROP TABLE HASHTBL_STR_LOCALE99;
DROP TABLE HASHTBL_STR_BIG_DECIMAL102;
DROP TABLE HASHTBL_STR_BIG_INTEGER105;
DROP TABLE HASHTBL_STR_BYTE108;
DROP TABLE HASHTBL_STR_DOUBLE111;
DROP TABLE HASHTBL_STR_FLOAT114;
DROP TABLE HASHTBL_STR_INTEGER117;
DROP TABLE HASHTBL_STR_LONG120;
DROP TABLE HASHTBL_STR_SHORT123;
DROP TABLE HASHTABLESTRINGKEY_COLLECTIONS;

DROP TABLE TREEMAP_STR_OBJECT0;
DROP TABLE TREEMAP_STR_OBJECT1;
DROP TABLE TREEMAP_STR_OBJECT2;
DROP TABLE TREEMAP_STR_SIMPLE_CLASS3;
DROP TABLE TREEMAP_STR_SIMPLE_CLASS4;
DROP TABLE TREEMAP_STR_SIMPLE_CLASS5;
DROP TABLE TREEMAP_STR_SIMPLE_INTERFACE6;
DROP TABLE TREEMAP_STR_SIMPLE_INTERFACE7;
DROP TABLE TREEMAP_STR_SIMPLE_INTERFACE8;
DROP TABLE TREEMAP_STR_STRING9;
DROP TABLE TREEMAP_STR_STRING10;
DROP TABLE TREEMAP_STR_STRING11;
DROP TABLE TREEMAP_STR_DATE12;
DROP TABLE TREEMAP_STR_DATE13;
DROP TABLE TREEMAP_STR_DATE14;
DROP TABLE TREEMAP_STR_LOCALE15;
DROP TABLE TREEMAP_STR_LOCALE16;
DROP TABLE TREEMAP_STR_LOCALE17;
DROP TABLE TREEMAP_STR_BIG_DECIMAL18;
DROP TABLE TREEMAP_STR_BIG_DECIMAL19;
DROP TABLE TREEMAP_STR_BIG_DECIMAL20;
DROP TABLE TREEMAP_STR_BIG_INTEGER21;
DROP TABLE TREEMAP_STR_BIG_INTEGER22;
DROP TABLE TREEMAP_STR_BIG_INTEGER23;
DROP TABLE TREEMAP_STR_BYTE24;
DROP TABLE TREEMAP_STR_BYTE25;
DROP TABLE TREEMAP_STR_BYTE26;
DROP TABLE TREEMAP_STR_DOUBLE27;
DROP TABLE TREEMAP_STR_DOUBLE28;
DROP TABLE TREEMAP_STR_DOUBLE29;
DROP TABLE TREEMAP_STR_FLOAT30;
DROP TABLE TREEMAP_STR_FLOAT31;
DROP TABLE TREEMAP_STR_FLOAT32;
DROP TABLE TREEMAP_STR_INTEGER33;
DROP TABLE TREEMAP_STR_INTEGER34;
DROP TABLE TREEMAP_STR_INTEGER35;
DROP TABLE TREEMAP_STR_LONG36;
DROP TABLE TREEMAP_STR_LONG37;
DROP TABLE TREEMAP_STR_LONG38;
DROP TABLE TREEMAP_STR_SHORT39;
DROP TABLE TREEMAP_STR_SHORT40;
DROP TABLE TREEMAP_STR_SHORT41;
DROP TABLE TREEMAP_STR_OBJECT42;
DROP TABLE TREEMAP_STR_OBJECT43;
DROP TABLE TREEMAP_STR_SIMPLE_CLASS45;
DROP TABLE TREEMAP_STR_SIMPLE_CLASS46;
DROP TABLE TREEMAP_STR_SIMPLE_INTERFACE48;
DROP TABLE TREEMAP_STR_SIMPLE_INTERFACE49;
DROP TABLE TREEMAP_STR_STRING51;
DROP TABLE TREEMAP_STR_STRING52;
DROP TABLE TREEMAP_STR_DATE54;
DROP TABLE TREEMAP_STR_DATE55;
DROP TABLE TREEMAP_STR_LOCALE57;
DROP TABLE TREEMAP_STR_LOCALE58;
DROP TABLE TREEMAP_STR_BIG_DECIMAL60;
DROP TABLE TREEMAP_STR_BIG_DECIMAL61;
DROP TABLE TREEMAP_STR_BIG_INTEGER63;
DROP TABLE TREEMAP_STR_BIG_INTEGER64;
DROP TABLE TREEMAP_STR_BYTE66;
DROP TABLE TREEMAP_STR_BYTE67;
DROP TABLE TREEMAP_STR_DOUBLE69;
DROP TABLE TREEMAP_STR_DOUBLE70;
DROP TABLE TREEMAP_STR_FLOAT72;
DROP TABLE TREEMAP_STR_FLOAT73;
DROP TABLE TREEMAP_STR_INTEGER75;
DROP TABLE TREEMAP_STR_INTEGER76;
DROP TABLE TREEMAP_STR_LONG78;
DROP TABLE TREEMAP_STR_LONG79;
DROP TABLE TREEMAP_STR_SHORT81;
DROP TABLE TREEMAP_STR_SHORT82;
DROP TABLE TREEMAP_STR_OBJECT84;
DROP TABLE TREEMAP_STR_SIMPLE_CLASS87;
DROP TABLE TREEMAP_STR_SIMPLE_INTERFACE90;
DROP TABLE TREEMAP_STR_STRING93;
DROP TABLE TREEMAP_STR_DATE96;
DROP TABLE TREEMAP_STR_LOCALE99;
DROP TABLE TREEMAP_STR_BIG_DECIMAL102;
DROP TABLE TREEMAP_STR_BIG_INTEGER105;
DROP TABLE TREEMAP_STR_BYTE108;
DROP TABLE TREEMAP_STR_DOUBLE111;
DROP TABLE TREEMAP_STR_FLOAT114;
DROP TABLE TREEMAP_STR_INTEGER117;
DROP TABLE TREEMAP_STR_LONG120;
DROP TABLE TREEMAP_STR_SHORT123;
DROP TABLE TREEMAPSTRINGKEY_COLLECTIONS;

DROP TABLE HASHMAP_OBJECT0_STR;
DROP TABLE HASHMAP_OBJECT1_STR;
DROP TABLE HASHMAP_OBJECT2_STR;
DROP TABLE HASHMAP_OBJECT3_STR;
DROP TABLE HASHMAP_OBJECT4_STR;
DROP TABLE HASHMAP_OBJECT6_STR;
DROP TABLE HASHMAP_SIMPLE_CLASS9_STR;
DROP TABLE HASHMAP_SIMPLE_CLASS10_STR;
DROP TABLE HASHMAP_SIMPLE_CLASS11_STR;
DROP TABLE HASHMAP_SIMPLE_CLASS12_STR;
DROP TABLE HASHMAP_SIMPLE_CLASS13_STR;
DROP TABLE HASHMAP_SIMPLE_CLASS15_STR;
DROP TABLE HASHMAP_SIMPLE_INTERFACE18_STR;
DROP TABLE HASHMAP_SIMPLE_INTERFACE19_STR;
DROP TABLE HASHMAP_SIMPLE_INTERFACE20_STR;
DROP TABLE HASHMAP_SIMPLE_INTERFACE21_STR;
DROP TABLE HASHMAP_SIMPLE_INTERFACE22_STR;
DROP TABLE HASHMAP_SIMPLE_INTERFACE24_STR;
DROP TABLE HASHMAP_STRING27_STR;
DROP TABLE HASHMAP_STRING28_STR;
DROP TABLE HASHMAP_STRING29_STR;
DROP TABLE HASHMAP_STRING30_STR;
DROP TABLE HASHMAP_STRING31_STR;
DROP TABLE HASHMAP_STRING33_STR;
DROP TABLE HASHMAP_DATE36_STR;
DROP TABLE HASHMAP_DATE37_STR;
DROP TABLE HASHMAP_DATE38_STR;
DROP TABLE HASHMAP_DATE39_STR;
DROP TABLE HASHMAP_DATE40_STR;
DROP TABLE HASHMAP_DATE42_STR;
DROP TABLE HASHMAP_BIG_DECIMAL45_STR;
DROP TABLE HASHMAP_BIG_DECIMAL46_STR;
DROP TABLE HASHMAP_BIG_DECIMAL47_STR;
DROP TABLE HASHMAP_BIG_DECIMAL48_STR;
DROP TABLE HASHMAP_BIG_DECIMAL49_STR;
DROP TABLE HASHMAP_BIG_DECIMAL51_STR;
DROP TABLE HASHMAP_BIG_INTEGER54_STR;
DROP TABLE HASHMAP_BIG_INTEGER55_STR;
DROP TABLE HASHMAP_BIG_INTEGER56_STR;
DROP TABLE HASHMAP_BIG_INTEGER57_STR;
DROP TABLE HASHMAP_BIG_INTEGER58_STR;
DROP TABLE HASHMAP_BIG_INTEGER60_STR;
DROP TABLE HASHMAP_BYTE63_STR;
DROP TABLE HASHMAP_BYTE64_STR;
DROP TABLE HASHMAP_BYTE65_STR;
DROP TABLE HASHMAP_BYTE66_STR;
DROP TABLE HASHMAP_BYTE67_STR;
DROP TABLE HASHMAP_BYTE69_STR;
DROP TABLE HASHMAP_DOUBLE72_STR;
DROP TABLE HASHMAP_DOUBLE73_STR;
DROP TABLE HASHMAP_DOUBLE74_STR;
DROP TABLE HASHMAP_DOUBLE75_STR;
DROP TABLE HASHMAP_DOUBLE76_STR;
DROP TABLE HASHMAP_DOUBLE78_STR;
DROP TABLE HASHMAP_FLOAT81_STR;
DROP TABLE HASHMAP_FLOAT82_STR;
DROP TABLE HASHMAP_FLOAT83_STR;
DROP TABLE HASHMAP_FLOAT84_STR;
DROP TABLE HASHMAP_FLOAT85_STR;
DROP TABLE HASHMAP_FLOAT87_STR;
DROP TABLE HASHMAP_INTEGER90_STR;
DROP TABLE HASHMAP_INTEGER91_STR;
DROP TABLE HASHMAP_INTEGER92_STR;
DROP TABLE HASHMAP_INTEGER93_STR;
DROP TABLE HASHMAP_INTEGER94_STR;
DROP TABLE HASHMAP_INTEGER96_STR;
DROP TABLE HASHMAP_LONG99_STR;
DROP TABLE HASHMAP_LONG100_STR;
DROP TABLE HASHMAP_LONG101_STR;
DROP TABLE HASHMAP_LONG102_STR;
DROP TABLE HASHMAP_LONG103_STR;
DROP TABLE HASHMAP_LONG105_STR;
DROP TABLE HASHMAP_SHORT108_STR;
DROP TABLE HASHMAP_SHORT109_STR;
DROP TABLE HASHMAP_SHORT110_STR;
DROP TABLE HASHMAP_SHORT111_STR;
DROP TABLE HASHMAP_SHORT112_STR;
DROP TABLE HASHMAP_SHORT114_STR;
DROP TABLE HASHMAPSTRINGVALUE_COLLECTIONS;

DROP TABLE HASHTBL_OBJECT0_STR;
DROP TABLE HASHTBL_OBJECT1_STR;
DROP TABLE HASHTBL_OBJECT2_STR;
DROP TABLE HASHTBL_OBJECT3_STR;
DROP TABLE HASHTBL_OBJECT4_STR;
DROP TABLE HASHTBL_OBJECT6_STR;
DROP TABLE HASHTBL_SIMPLE_CLASS9_STR;
DROP TABLE HASHTBL_SIMPLE_CLASS10_STR;
DROP TABLE HASHTBL_SIMPLE_CLASS11_STR;
DROP TABLE HASHTBL_SIMPLE_CLASS12_STR;
DROP TABLE HASHTBL_SIMPLE_CLASS13_STR;
DROP TABLE HASHTBL_SIMPLE_CLASS15_STR;
DROP TABLE HASHTBL_SIMPLE_INTERFACE18_STR;
DROP TABLE HASHTBL_SIMPLE_INTERFACE19_STR;
DROP TABLE HASHTBL_SIMPLE_INTERFACE20_STR;
DROP TABLE HASHTBL_SIMPLE_INTERFACE21_STR;
DROP TABLE HASHTBL_SIMPLE_INTERFACE22_STR;
DROP TABLE HASHTBL_SIMPLE_INTERFACE24_STR;
DROP TABLE HASHTBL_STRING27_STR;
DROP TABLE HASHTBL_STRING28_STR;
DROP TABLE HASHTBL_STRING29_STR;
DROP TABLE HASHTBL_STRING30_STR;
DROP TABLE HASHTBL_STRING31_STR;
DROP TABLE HASHTBL_STRING33_STR;
DROP TABLE HASHTBL_DATE36_STR;
DROP TABLE HASHTBL_DATE37_STR;
DROP TABLE HASHTBL_DATE38_STR;
DROP TABLE HASHTBL_DATE39_STR;
DROP TABLE HASHTBL_DATE40_STR;
DROP TABLE HASHTBL_DATE42_STR;
DROP TABLE HASHTBL_BIG_DECIMAL45_STR;
DROP TABLE HASHTBL_BIG_DECIMAL46_STR;
DROP TABLE HASHTBL_BIG_DECIMAL47_STR;
DROP TABLE HASHTBL_BIG_DECIMAL48_STR;
DROP TABLE HASHTBL_BIG_DECIMAL49_STR;
DROP TABLE HASHTBL_BIG_DECIMAL51_STR;
DROP TABLE HASHTBL_BIG_INTEGER54_STR;
DROP TABLE HASHTBL_BIG_INTEGER55_STR;
DROP TABLE HASHTBL_BIG_INTEGER56_STR;
DROP TABLE HASHTBL_BIG_INTEGER57_STR;
DROP TABLE HASHTBL_BIG_INTEGER58_STR;
DROP TABLE HASHTBL_BIG_INTEGER60_STR;
DROP TABLE HASHTBL_BYTE63_STR;
DROP TABLE HASHTBL_BYTE64_STR;
DROP TABLE HASHTBL_BYTE65_STR;
DROP TABLE HASHTBL_BYTE66_STR;
DROP TABLE HASHTBL_BYTE67_STR;
DROP TABLE HASHTBL_BYTE69_STR;
DROP TABLE HASHTBL_DOUBLE72_STR;
DROP TABLE HASHTBL_DOUBLE73_STR;
DROP TABLE HASHTBL_DOUBLE74_STR;
DROP TABLE HASHTBL_DOUBLE75_STR;
DROP TABLE HASHTBL_DOUBLE76_STR;
DROP TABLE HASHTBL_DOUBLE78_STR;
DROP TABLE HASHTBL_FLOAT81_STR;
DROP TABLE HASHTBL_FLOAT82_STR;
DROP TABLE HASHTBL_FLOAT83_STR;
DROP TABLE HASHTBL_FLOAT84_STR;
DROP TABLE HASHTBL_FLOAT85_STR;
DROP TABLE HASHTBL_FLOAT87_STR;
DROP TABLE HASHTBL_INTEGER90_STR;
DROP TABLE HASHTBL_INTEGER91_STR;
DROP TABLE HASHTBL_INTEGER92_STR;
DROP TABLE HASHTBL_INTEGER93_STR;
DROP TABLE HASHTBL_INTEGER94_STR;
DROP TABLE HASHTBL_INTEGER96_STR;
DROP TABLE HASHTBL_LONG99_STR;
DROP TABLE HASHTBL_LONG100_STR;
DROP TABLE HASHTBL_LONG101_STR;
DROP TABLE HASHTBL_LONG102_STR;
DROP TABLE HASHTBL_LONG103_STR;
DROP TABLE HASHTBL_LONG105_STR;
DROP TABLE HASHTBL_SHORT108_STR;
DROP TABLE HASHTBL_SHORT109_STR;
DROP TABLE HASHTBL_SHORT110_STR;
DROP TABLE HASHTBL_SHORT111_STR;
DROP TABLE HASHTBL_SHORT112_STR;
DROP TABLE HASHTBL_SHORT114_STR;
DROP TABLE HASHTBLSTRINGVALUE_COLLECTIONS;

DROP TABLE TREEMAP_OBJECT0_STR;
DROP TABLE TREEMAP_OBJECT1_STR;
DROP TABLE TREEMAP_OBJECT2_STR;
DROP TABLE TREEMAP_OBJECT3_STR;
DROP TABLE TREEMAP_OBJECT4_STR;
DROP TABLE TREEMAP_OBJECT6_STR;
DROP TABLE TREEMAP_SIMPLE_CLASS9_STR;
DROP TABLE TREEMAP_SIMPLE_CLASS10_STR;
DROP TABLE TREEMAP_SIMPLE_CLASS11_STR;
DROP TABLE TREEMAP_SIMPLE_CLASS12_STR;
DROP TABLE TREEMAP_SIMPLE_CLASS13_STR;
DROP TABLE TREEMAP_SIMPLE_CLASS15_STR;
DROP TABLE TREEMAP_SIMPLE_INTERFACE18_STR;
DROP TABLE TREEMAP_SIMPLE_INTERFACE19_STR;
DROP TABLE TREEMAP_SIMPLE_INTERFACE20_STR;
DROP TABLE TREEMAP_SIMPLE_INTERFACE21_STR;
DROP TABLE TREEMAP_SIMPLE_INTERFACE22_STR;
DROP TABLE TREEMAP_SIMPLE_INTERFACE24_STR;
DROP TABLE TREEMAP_STRING27_STR;
DROP TABLE TREEMAP_STRING28_STR;
DROP TABLE TREEMAP_STRING29_STR;
DROP TABLE TREEMAP_STRING30_STR;
DROP TABLE TREEMAP_STRING31_STR;
DROP TABLE TREEMAP_STRING33_STR;
DROP TABLE TREEMAP_DATE36_STR;
DROP TABLE TREEMAP_DATE37_STR;
DROP TABLE TREEMAP_DATE38_STR;
DROP TABLE TREEMAP_DATE39_STR;
DROP TABLE TREEMAP_DATE40_STR;
DROP TABLE TREEMAP_DATE42_STR;
DROP TABLE TREEMAP_BIG_DECIMAL45_STR;
DROP TABLE TREEMAP_BIG_DECIMAL46_STR;
DROP TABLE TREEMAP_BIG_DECIMAL47_STR;
DROP TABLE TREEMAP_BIG_DECIMAL48_STR;
DROP TABLE TREEMAP_BIG_DECIMAL49_STR;
DROP TABLE TREEMAP_BIG_DECIMAL51_STR;
DROP TABLE TREEMAP_BIG_INTEGER54_STR;
DROP TABLE TREEMAP_BIG_INTEGER55_STR;
DROP TABLE TREEMAP_BIG_INTEGER56_STR;
DROP TABLE TREEMAP_BIG_INTEGER57_STR;
DROP TABLE TREEMAP_BIG_INTEGER58_STR;
DROP TABLE TREEMAP_BIG_INTEGER60_STR;
DROP TABLE TREEMAP_BYTE63_STR;
DROP TABLE TREEMAP_BYTE64_STR;
DROP TABLE TREEMAP_BYTE65_STR;
DROP TABLE TREEMAP_BYTE66_STR;
DROP TABLE TREEMAP_BYTE67_STR;
DROP TABLE TREEMAP_BYTE69_STR;
DROP TABLE TREEMAP_DOUBLE72_STR;
DROP TABLE TREEMAP_DOUBLE73_STR;
DROP TABLE TREEMAP_DOUBLE74_STR;
DROP TABLE TREEMAP_DOUBLE75_STR;
DROP TABLE TREEMAP_DOUBLE76_STR;
DROP TABLE TREEMAP_DOUBLE78_STR;
DROP TABLE TREEMAP_FLOAT81_STR;
DROP TABLE TREEMAP_FLOAT82_STR;
DROP TABLE TREEMAP_FLOAT83_STR;
DROP TABLE TREEMAP_FLOAT84_STR;
DROP TABLE TREEMAP_FLOAT85_STR;
DROP TABLE TREEMAP_FLOAT87_STR;
DROP TABLE TREEMAP_INTEGER90_STR;
DROP TABLE TREEMAP_INTEGER91_STR;
DROP TABLE TREEMAP_INTEGER92_STR;
DROP TABLE TREEMAP_INTEGER93_STR;
DROP TABLE TREEMAP_INTEGER94_STR;
DROP TABLE TREEMAP_INTEGER96_STR;
DROP TABLE TREEMAP_LONG99_STR;
DROP TABLE TREEMAP_LONG100_STR;
DROP TABLE TREEMAP_LONG101_STR;
DROP TABLE TREEMAP_LONG102_STR;
DROP TABLE TREEMAP_LONG103_STR;
DROP TABLE TREEMAP_LONG105_STR;
DROP TABLE TREEMAP_SHORT108_STR;
DROP TABLE TREEMAP_SHORT109_STR;
DROP TABLE TREEMAP_SHORT110_STR;
DROP TABLE TREEMAP_SHORT111_STR;
DROP TABLE TREEMAP_SHORT112_STR;
DROP TABLE TREEMAP_SHORT114_STR;
DROP TABLE TREEMAPSTRINGVALUE_COLLECTIONS;

DROP TABLE FIELDSOFSIMPLECLASS;
DROP TABLE ALLTYPES;
DROP TABLE FIELDSOFBYTE;
DROP TABLE FIELDSOFBIGDECIMAL;
DROP TABLE FIELDSOFBIGINTEGER;
DROP TABLE FIELDSOFBOOLEAN;
DROP TABLE FIELDSOFCHARACTER;
DROP TABLE FIELDSOFDATE;
DROP TABLE FIELDSOFDOUBLE;
DROP TABLE FIELDSOFENUMNAME;
DROP TABLE FIELDSOFFLOAT;
DROP TABLE FIELDSOFINTEGER;
DROP TABLE FIELDSOFLOCALE;
DROP TABLE FIELDSOFLONG;
DROP TABLE FIELDSOFOBJECT;
DROP TABLE FIELDSOFSIMPLEINTERFACE;
DROP TABLE FIELDSOFPRIMITIVEBOOLEAN;
DROP TABLE FIELDSOFPRIMITIVEBYTE;
DROP TABLE FIELDSOFPRIMITIVECHAR;
DROP TABLE FIELDSOFPRIMITIVEDOUBLE;
DROP TABLE FIELDSOFPRIMITIVEFLOAT;
DROP TABLE FIELDSOFPRIMITIVEINT;
DROP TABLE FIELDSOFPRIMITIVELONG;
DROP TABLE FIELDSOFPRIMITIVESHORT;
DROP TABLE FIELDSOFSHORT;
DROP TABLE FIELDSOFSTRING;

DROP TABLE SIMPLE_CLASS;

CREATE TABLE SIMPLE_CLASS
(
    IDENTIFIER BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL,
    CONSTRAINT SIMPLE_CLASS_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE ALLTYPES
(
    ID INTEGER NOT NULL,
    PRIMITIVEBOOLEAN CHAR(1) CHECK (PRIMITIVEBOOLEAN IN ('Y','N')),
    PRIMITIVEBYTE SMALLINT,
    PRIMITIVECHAR INTEGER,
    PRIMITIVEDOUBLE DOUBLE,
    PRIMITIVEFLOAT REAL,
    PRIMITIVEINT INTEGER,
    PRIMITIVELONG BIGINT,
    PRIMITIVESHORT SMALLINT,
    BOOLEANVAL CHAR(1) CHECK (BOOLEANVAL IN ('Y','N')),
    BYTEVAL SMALLINT,
    CHARACTERVAL INTEGER,
    DOUBLEVAL DOUBLE,
    FLOATVAL REAL,
    INTEGERVAL INTEGER,
    LONGVAL BIGINT,
    SHORTVAL SMALLINT,
    STRINGVAL VARCHAR(255),
    LOCALEVAL CHAR(20),
    DATEVAL TIMESTAMP,
    BIGDECIMALVAL DECIMAL(25,10),
    BIGINTEGERVAL NUMERIC(31)
);

ALTER TABLE ALLTYPES ADD CONSTRAINT ALLTYPES_PK PRIMARY KEY (ID);

CREATE TABLE FIELDSOFBIGDECIMAL
(
    IDENTIFIER INTEGER NOT NULL,
    BIG_DECIMAL0 DECIMAL(27,16),
    BIG_DECIMAL1 DECIMAL(27,16),
    BIG_DECIMAL102 DECIMAL(27,16),
    BIG_DECIMAL103 DECIMAL(27,16),
    BIG_DECIMAL104 DECIMAL(27,16),
    BIG_DECIMAL108 DECIMAL(27,16),
    BIG_DECIMAL109 DECIMAL(27,16),
    BIG_DECIMAL11 DECIMAL(27,16),
    BIG_DECIMAL110 DECIMAL(27,16),
    BIG_DECIMAL112 DECIMAL(27,16),
    BIG_DECIMAL113 DECIMAL(27,16),
    BIG_DECIMAL114 DECIMAL(27,16),
    BIG_DECIMAL119 DECIMAL(27,16),
    BIG_DECIMAL12 DECIMAL(27,16),
    BIG_DECIMAL120 DECIMAL(27,16),
    BIG_DECIMAL121 DECIMAL(27,16),
    BIG_DECIMAL124 DECIMAL(27,16),
    BIG_DECIMAL125 DECIMAL(27,16),
    BIG_DECIMAL126 DECIMAL(27,16),
    BIG_DECIMAL128 DECIMAL(27,16),
    BIG_DECIMAL129 DECIMAL(27,16),
    BIG_DECIMAL13 DECIMAL(27,16),
    BIG_DECIMAL130 DECIMAL(27,16),
    BIG_DECIMAL138 DECIMAL(27,16),
    BIG_DECIMAL139 DECIMAL(27,16),
    BIG_DECIMAL140 DECIMAL(27,16),
    BIG_DECIMAL16 DECIMAL(27,16),
    BIG_DECIMAL17 DECIMAL(27,16),
    BIG_DECIMAL18 DECIMAL(27,16),
    BIG_DECIMAL2 DECIMAL(27,16),
    BIG_DECIMAL20 DECIMAL(27,16),
    BIG_DECIMAL21 DECIMAL(27,16),
    BIG_DECIMAL22 DECIMAL(27,16),
    BIG_DECIMAL30 DECIMAL(27,16),
    BIG_DECIMAL31 DECIMAL(27,16),
    BIG_DECIMAL32 DECIMAL(27,16),
    BIG_DECIMAL36 DECIMAL(27,16),
    BIG_DECIMAL37 DECIMAL(27,16),
    BIG_DECIMAL38 DECIMAL(27,16),
    BIG_DECIMAL4 DECIMAL(27,16),
    BIG_DECIMAL40 DECIMAL(27,16),
    BIG_DECIMAL41 DECIMAL(27,16),
    BIG_DECIMAL42 DECIMAL(27,16),
    BIG_DECIMAL47 DECIMAL(27,16),
    BIG_DECIMAL48 DECIMAL(27,16),
    BIG_DECIMAL49 DECIMAL(27,16),
    BIG_DECIMAL5 DECIMAL(27,16),
    BIG_DECIMAL52 DECIMAL(27,16),
    BIG_DECIMAL53 DECIMAL(27,16),
    BIG_DECIMAL54 DECIMAL(27,16),
    BIG_DECIMAL56 DECIMAL(27,16),
    BIG_DECIMAL57 DECIMAL(27,16),
    BIG_DECIMAL58 DECIMAL(27,16),
    BIG_DECIMAL6 DECIMAL(27,16),
    BIG_DECIMAL66 DECIMAL(27,16),
    BIG_DECIMAL67 DECIMAL(27,16),
    BIG_DECIMAL68 DECIMAL(27,16),
    BIG_DECIMAL72 DECIMAL(27,16),
    BIG_DECIMAL73 DECIMAL(27,16),
    BIG_DECIMAL74 DECIMAL(27,16),
    BIG_DECIMAL76 DECIMAL(27,16),
    BIG_DECIMAL77 DECIMAL(27,16),
    BIG_DECIMAL78 DECIMAL(27,16),
    BIG_DECIMAL83 DECIMAL(27,16),
    BIG_DECIMAL84 DECIMAL(27,16),
    BIG_DECIMAL85 DECIMAL(27,16),
    BIG_DECIMAL88 DECIMAL(27,16),
    BIG_DECIMAL89 DECIMAL(27,16),
    BIG_DECIMAL90 DECIMAL(27,16),
    BIG_DECIMAL92 DECIMAL(27,16),
    BIG_DECIMAL93 DECIMAL(27,16),
    BIG_DECIMAL94 DECIMAL(27,16)
);

ALTER TABLE FIELDSOFBIGDECIMAL ADD CONSTRAINT FIELDSOFBIGDPP_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFBIGINTEGER
(
    IDENTIFIER INTEGER NOT NULL,
    BIG_INTEGER0 NUMERIC(31),
    BIG_INTEGER1 NUMERIC(31),
    BIG_INTEGER102 NUMERIC(31),
    BIG_INTEGER103 NUMERIC(31),
    BIG_INTEGER104 NUMERIC(31),
    BIG_INTEGER108 NUMERIC(31),
    BIG_INTEGER109 NUMERIC(31),
    BIG_INTEGER11 NUMERIC(31),
    BIG_INTEGER110 NUMERIC(31),
    BIG_INTEGER112 NUMERIC(31),
    BIG_INTEGER113 NUMERIC(31),
    BIG_INTEGER114 NUMERIC(31),
    BIG_INTEGER119 NUMERIC(31),
    BIG_INTEGER12 NUMERIC(31),
    BIG_INTEGER120 NUMERIC(31),
    BIG_INTEGER121 NUMERIC(31),
    BIG_INTEGER124 NUMERIC(31),
    BIG_INTEGER125 NUMERIC(31),
    BIG_INTEGER126 NUMERIC(31),
    BIG_INTEGER128 NUMERIC(31),
    BIG_INTEGER129 NUMERIC(31),
    BIG_INTEGER13 NUMERIC(31),
    BIG_INTEGER130 NUMERIC(31),
    BIG_INTEGER138 NUMERIC(31),
    BIG_INTEGER139 NUMERIC(31),
    BIG_INTEGER140 NUMERIC(31),
    BIG_INTEGER16 NUMERIC(31),
    BIG_INTEGER17 NUMERIC(31),
    BIG_INTEGER18 NUMERIC(31),
    BIG_INTEGER2 NUMERIC(31),
    BIG_INTEGER20 NUMERIC(31),
    BIG_INTEGER21 NUMERIC(31),
    BIG_INTEGER22 NUMERIC(31),
    BIG_INTEGER30 NUMERIC(31),
    BIG_INTEGER31 NUMERIC(31),
    BIG_INTEGER32 NUMERIC(31),
    BIG_INTEGER36 NUMERIC(31),
    BIG_INTEGER37 NUMERIC(31),
    BIG_INTEGER38 NUMERIC(31),
    BIG_INTEGER4 NUMERIC(31),
    BIG_INTEGER40 NUMERIC(31),
    BIG_INTEGER41 NUMERIC(31),
    BIG_INTEGER42 NUMERIC(31),
    BIG_INTEGER47 NUMERIC(31),
    BIG_INTEGER48 NUMERIC(31),
    BIG_INTEGER49 NUMERIC(31),
    BIG_INTEGER5 NUMERIC(31),
    BIG_INTEGER52 NUMERIC(31),
    BIG_INTEGER53 NUMERIC(31),
    BIG_INTEGER54 NUMERIC(31),
    BIG_INTEGER56 NUMERIC(31),
    BIG_INTEGER57 NUMERIC(31),
    BIG_INTEGER58 NUMERIC(31),
    BIG_INTEGER6 NUMERIC(31),
    BIG_INTEGER66 NUMERIC(31),
    BIG_INTEGER67 NUMERIC(31),
    BIG_INTEGER68 NUMERIC(31),
    BIG_INTEGER72 NUMERIC(31),
    BIG_INTEGER73 NUMERIC(31),
    BIG_INTEGER74 NUMERIC(31),
    BIG_INTEGER76 NUMERIC(31),
    BIG_INTEGER77 NUMERIC(31),
    BIG_INTEGER78 NUMERIC(31),
    BIG_INTEGER83 NUMERIC(31),
    BIG_INTEGER84 NUMERIC(31),
    BIG_INTEGER85 NUMERIC(31),
    BIG_INTEGER88 NUMERIC(31),
    BIG_INTEGER89 NUMERIC(31),
    BIG_INTEGER90 NUMERIC(31),
    BIG_INTEGER92 NUMERIC(31),
    BIG_INTEGER93 NUMERIC(31),
    BIG_INTEGER94 NUMERIC(31)
);

ALTER TABLE FIELDSOFBIGINTEGER ADD CONSTRAINT FIELDSOFBIGI2S_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFBOOLEAN
(
    IDENTIFIER INTEGER NOT NULL,
    BOOLEAN0 CHAR(1) CHECK (BOOLEAN0 IN ('Y','N') OR BOOLEAN0 IS NULL),
    BOOLEAN1 CHAR(1) CHECK (BOOLEAN1 IN ('Y','N') OR BOOLEAN1 IS NULL),
    BOOLEAN102 CHAR(1) CHECK (BOOLEAN102 IN ('Y','N') OR BOOLEAN102 IS NULL),
    BOOLEAN103 CHAR(1) CHECK (BOOLEAN103 IN ('Y','N') OR BOOLEAN103 IS NULL),
    BOOLEAN104 CHAR(1) CHECK (BOOLEAN104 IN ('Y','N') OR BOOLEAN104 IS NULL),
    BOOLEAN108 CHAR(1) CHECK (BOOLEAN108 IN ('Y','N') OR BOOLEAN108 IS NULL),
    BOOLEAN109 CHAR(1) CHECK (BOOLEAN109 IN ('Y','N') OR BOOLEAN109 IS NULL),
    BOOLEAN11 CHAR(1) CHECK (BOOLEAN11 IN ('Y','N') OR BOOLEAN11 IS NULL),
    BOOLEAN110 CHAR(1) CHECK (BOOLEAN110 IN ('Y','N') OR BOOLEAN110 IS NULL),
    BOOLEAN112 CHAR(1) CHECK (BOOLEAN112 IN ('Y','N') OR BOOLEAN112 IS NULL),
    BOOLEAN113 CHAR(1) CHECK (BOOLEAN113 IN ('Y','N') OR BOOLEAN113 IS NULL),
    BOOLEAN114 CHAR(1) CHECK (BOOLEAN114 IN ('Y','N') OR BOOLEAN114 IS NULL),
    BOOLEAN119 CHAR(1) CHECK (BOOLEAN119 IN ('Y','N') OR BOOLEAN119 IS NULL),
    BOOLEAN12 CHAR(1) CHECK (BOOLEAN12 IN ('Y','N') OR BOOLEAN12 IS NULL),
    BOOLEAN120 CHAR(1) CHECK (BOOLEAN120 IN ('Y','N') OR BOOLEAN120 IS NULL),
    BOOLEAN121 CHAR(1) CHECK (BOOLEAN121 IN ('Y','N') OR BOOLEAN121 IS NULL),
    BOOLEAN124 CHAR(1) CHECK (BOOLEAN124 IN ('Y','N') OR BOOLEAN124 IS NULL),
    BOOLEAN125 CHAR(1) CHECK (BOOLEAN125 IN ('Y','N') OR BOOLEAN125 IS NULL),
    BOOLEAN126 CHAR(1) CHECK (BOOLEAN126 IN ('Y','N') OR BOOLEAN126 IS NULL),
    BOOLEAN128 CHAR(1) CHECK (BOOLEAN128 IN ('Y','N') OR BOOLEAN128 IS NULL),
    BOOLEAN129 CHAR(1) CHECK (BOOLEAN129 IN ('Y','N') OR BOOLEAN129 IS NULL),
    BOOLEAN13 CHAR(1) CHECK (BOOLEAN13 IN ('Y','N') OR BOOLEAN13 IS NULL),
    BOOLEAN130 CHAR(1) CHECK (BOOLEAN130 IN ('Y','N') OR BOOLEAN130 IS NULL),
    BOOLEAN138 CHAR(1) CHECK (BOOLEAN138 IN ('Y','N') OR BOOLEAN138 IS NULL),
    BOOLEAN139 CHAR(1) CHECK (BOOLEAN139 IN ('Y','N') OR BOOLEAN139 IS NULL),
    BOOLEAN140 CHAR(1) CHECK (BOOLEAN140 IN ('Y','N') OR BOOLEAN140 IS NULL),
    BOOLEAN16 CHAR(1) CHECK (BOOLEAN16 IN ('Y','N') OR BOOLEAN16 IS NULL),
    BOOLEAN17 CHAR(1) CHECK (BOOLEAN17 IN ('Y','N') OR BOOLEAN17 IS NULL),
    BOOLEAN18 CHAR(1) CHECK (BOOLEAN18 IN ('Y','N') OR BOOLEAN18 IS NULL),
    BOOLEAN2 CHAR(1) CHECK (BOOLEAN2 IN ('Y','N') OR BOOLEAN2 IS NULL),
    BOOLEAN20 CHAR(1) CHECK (BOOLEAN20 IN ('Y','N') OR BOOLEAN20 IS NULL),
    BOOLEAN21 CHAR(1) CHECK (BOOLEAN21 IN ('Y','N') OR BOOLEAN21 IS NULL),
    BOOLEAN22 CHAR(1) CHECK (BOOLEAN22 IN ('Y','N') OR BOOLEAN22 IS NULL),
    BOOLEAN30 CHAR(1) CHECK (BOOLEAN30 IN ('Y','N') OR BOOLEAN30 IS NULL),
    BOOLEAN31 CHAR(1) CHECK (BOOLEAN31 IN ('Y','N') OR BOOLEAN31 IS NULL),
    BOOLEAN32 CHAR(1) CHECK (BOOLEAN32 IN ('Y','N') OR BOOLEAN32 IS NULL),
    BOOLEAN36 CHAR(1) CHECK (BOOLEAN36 IN ('Y','N') OR BOOLEAN36 IS NULL),
    BOOLEAN37 CHAR(1) CHECK (BOOLEAN37 IN ('Y','N') OR BOOLEAN37 IS NULL),
    BOOLEAN38 CHAR(1) CHECK (BOOLEAN38 IN ('Y','N') OR BOOLEAN38 IS NULL),
    BOOLEAN4 CHAR(1) CHECK (BOOLEAN4 IN ('Y','N') OR BOOLEAN4 IS NULL),
    BOOLEAN40 CHAR(1) CHECK (BOOLEAN40 IN ('Y','N') OR BOOLEAN40 IS NULL),
    BOOLEAN41 CHAR(1) CHECK (BOOLEAN41 IN ('Y','N') OR BOOLEAN41 IS NULL),
    BOOLEAN42 CHAR(1) CHECK (BOOLEAN42 IN ('Y','N') OR BOOLEAN42 IS NULL),
    BOOLEAN47 CHAR(1) CHECK (BOOLEAN47 IN ('Y','N') OR BOOLEAN47 IS NULL),
    BOOLEAN48 CHAR(1) CHECK (BOOLEAN48 IN ('Y','N') OR BOOLEAN48 IS NULL),
    BOOLEAN49 CHAR(1) CHECK (BOOLEAN49 IN ('Y','N') OR BOOLEAN49 IS NULL),
    BOOLEAN5 CHAR(1) CHECK (BOOLEAN5 IN ('Y','N') OR BOOLEAN5 IS NULL),
    BOOLEAN52 CHAR(1) CHECK (BOOLEAN52 IN ('Y','N') OR BOOLEAN52 IS NULL),
    BOOLEAN53 CHAR(1) CHECK (BOOLEAN53 IN ('Y','N') OR BOOLEAN53 IS NULL),
    BOOLEAN54 CHAR(1) CHECK (BOOLEAN54 IN ('Y','N') OR BOOLEAN54 IS NULL),
    BOOLEAN56 CHAR(1) CHECK (BOOLEAN56 IN ('Y','N') OR BOOLEAN56 IS NULL),
    BOOLEAN57 CHAR(1) CHECK (BOOLEAN57 IN ('Y','N') OR BOOLEAN57 IS NULL),
    BOOLEAN58 CHAR(1) CHECK (BOOLEAN58 IN ('Y','N') OR BOOLEAN58 IS NULL),
    BOOLEAN6 CHAR(1) CHECK (BOOLEAN6 IN ('Y','N') OR BOOLEAN6 IS NULL),
    BOOLEAN66 CHAR(1) CHECK (BOOLEAN66 IN ('Y','N') OR BOOLEAN66 IS NULL),
    BOOLEAN67 CHAR(1) CHECK (BOOLEAN67 IN ('Y','N') OR BOOLEAN67 IS NULL),
    BOOLEAN68 CHAR(1) CHECK (BOOLEAN68 IN ('Y','N') OR BOOLEAN68 IS NULL),
    BOOLEAN72 CHAR(1) CHECK (BOOLEAN72 IN ('Y','N') OR BOOLEAN72 IS NULL),
    BOOLEAN73 CHAR(1) CHECK (BOOLEAN73 IN ('Y','N') OR BOOLEAN73 IS NULL),
    BOOLEAN74 CHAR(1) CHECK (BOOLEAN74 IN ('Y','N') OR BOOLEAN74 IS NULL),
    BOOLEAN76 CHAR(1) CHECK (BOOLEAN76 IN ('Y','N') OR BOOLEAN76 IS NULL),
    BOOLEAN77 CHAR(1) CHECK (BOOLEAN77 IN ('Y','N') OR BOOLEAN77 IS NULL),
    BOOLEAN78 CHAR(1) CHECK (BOOLEAN78 IN ('Y','N') OR BOOLEAN78 IS NULL),
    BOOLEAN83 CHAR(1) CHECK (BOOLEAN83 IN ('Y','N') OR BOOLEAN83 IS NULL),
    BOOLEAN84 CHAR(1) CHECK (BOOLEAN84 IN ('Y','N') OR BOOLEAN84 IS NULL),
    BOOLEAN85 CHAR(1) CHECK (BOOLEAN85 IN ('Y','N') OR BOOLEAN85 IS NULL),
    BOOLEAN88 CHAR(1) CHECK (BOOLEAN88 IN ('Y','N') OR BOOLEAN88 IS NULL),
    BOOLEAN89 CHAR(1) CHECK (BOOLEAN89 IN ('Y','N') OR BOOLEAN89 IS NULL),
    BOOLEAN90 CHAR(1) CHECK (BOOLEAN90 IN ('Y','N') OR BOOLEAN90 IS NULL),
    BOOLEAN92 CHAR(1) CHECK (BOOLEAN92 IN ('Y','N') OR BOOLEAN92 IS NULL),
    BOOLEAN93 CHAR(1) CHECK (BOOLEAN93 IN ('Y','N') OR BOOLEAN93 IS NULL),
    BOOLEAN94 CHAR(1) CHECK (BOOLEAN94 IN ('Y','N') OR BOOLEAN94 IS NULL)
);

ALTER TABLE FIELDSOFBOOLEAN ADD CONSTRAINT FIELDSOFBOOLS2_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFCHARACTER
(
    IDENTIFIER INTEGER NOT NULL,
    CHARACTER0 INTEGER,
    CHARACTER1 INTEGER,
    CHARACTER102 INTEGER,
    CHARACTER103 INTEGER,
    CHARACTER104 INTEGER,
    CHARACTER108 INTEGER,
    CHARACTER109 INTEGER,
    CHARACTER11 INTEGER,
    CHARACTER110 INTEGER,
    CHARACTER112 INTEGER,
    CHARACTER113 INTEGER,
    CHARACTER114 INTEGER,
    CHARACTER119 INTEGER,
    CHARACTER12 INTEGER,
    CHARACTER120 INTEGER,
    CHARACTER121 INTEGER,
    CHARACTER124 INTEGER,
    CHARACTER125 INTEGER,
    CHARACTER126 INTEGER,
    CHARACTER128 INTEGER,
    CHARACTER129 INTEGER,
    CHARACTER13 INTEGER,
    CHARACTER130 INTEGER,
    CHARACTER138 INTEGER,
    CHARACTER139 INTEGER,
    CHARACTER140 INTEGER,
    CHARACTER16 INTEGER,
    CHARACTER17 INTEGER,
    CHARACTER18 INTEGER,
    CHARACTER2 INTEGER,
    CHARACTER20 INTEGER,
    CHARACTER21 INTEGER,
    CHARACTER22 INTEGER,
    CHARACTER30 INTEGER,
    CHARACTER31 INTEGER,
    CHARACTER32 INTEGER,
    CHARACTER36 INTEGER,
    CHARACTER37 INTEGER,
    CHARACTER38 INTEGER,
    CHARACTER4 INTEGER,
    CHARACTER40 INTEGER,
    CHARACTER41 INTEGER,
    CHARACTER42 INTEGER,
    CHARACTER47 INTEGER,
    CHARACTER48 INTEGER,
    CHARACTER49 INTEGER,
    CHARACTER5 INTEGER,
    CHARACTER52 INTEGER,
    CHARACTER53 INTEGER,
    CHARACTER54 INTEGER,
    CHARACTER56 INTEGER,
    CHARACTER57 INTEGER,
    CHARACTER58 INTEGER,
    CHARACTER6 INTEGER,
    CHARACTER66 INTEGER,
    CHARACTER67 INTEGER,
    CHARACTER68 INTEGER,
    CHARACTER72 INTEGER,
    CHARACTER73 INTEGER,
    CHARACTER74 INTEGER,
    CHARACTER76 INTEGER,
    CHARACTER77 INTEGER,
    CHARACTER78 INTEGER,
    CHARACTER83 INTEGER,
    CHARACTER84 INTEGER,
    CHARACTER85 INTEGER,
    CHARACTER88 INTEGER,
    CHARACTER89 INTEGER,
    CHARACTER90 INTEGER,
    CHARACTER92 INTEGER,
    CHARACTER93 INTEGER,
    CHARACTER94 INTEGER
);

ALTER TABLE FIELDSOFCHARACTER ADD CONSTRAINT FIELDSOFCHAROV_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFDATE
(
    IDENTIFIER INTEGER NOT NULL,
    DATE0 TIMESTAMP,
    DATE1 TIMESTAMP,
    DATE102 TIMESTAMP,
    DATE103 TIMESTAMP,
    DATE104 TIMESTAMP,
    DATE108 TIMESTAMP,
    DATE109 TIMESTAMP,
    DATE11 TIMESTAMP,
    DATE110 TIMESTAMP,
    DATE112 TIMESTAMP,
    DATE113 TIMESTAMP,
    DATE114 TIMESTAMP,
    DATE119 TIMESTAMP,
    DATE12 TIMESTAMP,
    DATE120 TIMESTAMP,
    DATE121 TIMESTAMP,
    DATE124 TIMESTAMP,
    DATE125 TIMESTAMP,
    DATE126 TIMESTAMP,
    DATE128 TIMESTAMP,
    DATE129 TIMESTAMP,
    DATE13 TIMESTAMP,
    DATE130 TIMESTAMP,
    DATE138 TIMESTAMP,
    DATE139 TIMESTAMP,
    DATE140 TIMESTAMP,
    DATE16 TIMESTAMP,
    DATE17 TIMESTAMP,
    DATE18 TIMESTAMP,
    DATE2 TIMESTAMP,
    DATE20 TIMESTAMP,
    DATE21 TIMESTAMP,
    DATE22 TIMESTAMP,
    DATE30 TIMESTAMP,
    DATE31 TIMESTAMP,
    DATE32 TIMESTAMP,
    DATE36 TIMESTAMP,
    DATE37 TIMESTAMP,
    DATE38 TIMESTAMP,
    DATE4 TIMESTAMP,
    DATE40 TIMESTAMP,
    DATE41 TIMESTAMP,
    DATE42 TIMESTAMP,
    DATE47 TIMESTAMP,
    DATE48 TIMESTAMP,
    DATE49 TIMESTAMP,
    DATE5 TIMESTAMP,
    DATE52 TIMESTAMP,
    DATE53 TIMESTAMP,
    DATE54 TIMESTAMP,
    DATE56 TIMESTAMP,
    DATE57 TIMESTAMP,
    DATE58 TIMESTAMP,
    DATE6 TIMESTAMP,
    DATE66 TIMESTAMP,
    DATE67 TIMESTAMP,
    DATE68 TIMESTAMP,
    DATE72 TIMESTAMP,
    DATE73 TIMESTAMP,
    DATE74 TIMESTAMP,
    DATE76 TIMESTAMP,
    DATE77 TIMESTAMP,
    DATE78 TIMESTAMP,
    DATE83 TIMESTAMP,
    DATE84 TIMESTAMP,
    DATE85 TIMESTAMP,
    DATE88 TIMESTAMP,
    DATE89 TIMESTAMP,
    DATE90 TIMESTAMP,
    DATE92 TIMESTAMP,
    DATE93 TIMESTAMP,
    DATE94 TIMESTAMP
);

ALTER TABLE FIELDSOFDATE ADD CONSTRAINT FIELDSOFDATE_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFDOUBLE
(
    IDENTIFIER INTEGER NOT NULL,
    DOUBLE0 DOUBLE,
    DOUBLE1 DOUBLE,
    DOUBLE102 DOUBLE,
    DOUBLE103 DOUBLE,
    DOUBLE104 DOUBLE,
    DOUBLE108 DOUBLE,
    DOUBLE109 DOUBLE,
    DOUBLE11 DOUBLE,
    DOUBLE110 DOUBLE,
    DOUBLE112 DOUBLE,
    DOUBLE113 DOUBLE,
    DOUBLE114 DOUBLE,
    DOUBLE119 DOUBLE,
    DOUBLE12 DOUBLE,
    DOUBLE120 DOUBLE,
    DOUBLE121 DOUBLE,
    DOUBLE124 DOUBLE,
    DOUBLE125 DOUBLE,
    DOUBLE126 DOUBLE,
    DOUBLE128 DOUBLE,
    DOUBLE129 DOUBLE,
    DOUBLE13 DOUBLE,
    DOUBLE130 DOUBLE,
    DOUBLE138 DOUBLE,
    DOUBLE139 DOUBLE,
    DOUBLE140 DOUBLE,
    DOUBLE16 DOUBLE,
    DOUBLE17 DOUBLE,
    DOUBLE18 DOUBLE,
    DOUBLE2 DOUBLE,
    DOUBLE20 DOUBLE,
    DOUBLE21 DOUBLE,
    DOUBLE22 DOUBLE,
    DOUBLE30 DOUBLE,
    DOUBLE31 DOUBLE,
    DOUBLE32 DOUBLE,
    DOUBLE36 DOUBLE,
    DOUBLE37 DOUBLE,
    DOUBLE38 DOUBLE,
    DOUBLE4 DOUBLE,
    DOUBLE40 DOUBLE,
    DOUBLE41 DOUBLE,
    DOUBLE42 DOUBLE,
    DOUBLE47 DOUBLE,
    DOUBLE48 DOUBLE,
    DOUBLE49 DOUBLE,
    DOUBLE5 DOUBLE,
    DOUBLE52 DOUBLE,
    DOUBLE53 DOUBLE,
    DOUBLE54 DOUBLE,
    DOUBLE56 DOUBLE,
    DOUBLE57 DOUBLE,
    DOUBLE58 DOUBLE,
    DOUBLE6 DOUBLE,
    DOUBLE66 DOUBLE,
    DOUBLE67 DOUBLE,
    DOUBLE68 DOUBLE,
    DOUBLE72 DOUBLE,
    DOUBLE73 DOUBLE,
    DOUBLE74 DOUBLE,
    DOUBLE76 DOUBLE,
    DOUBLE77 DOUBLE,
    DOUBLE78 DOUBLE,
    DOUBLE83 DOUBLE,
    DOUBLE84 DOUBLE,
    DOUBLE85 DOUBLE,
    DOUBLE88 DOUBLE,
    DOUBLE89 DOUBLE,
    DOUBLE90 DOUBLE,
    DOUBLE92 DOUBLE,
    DOUBLE93 DOUBLE,
    DOUBLE94 DOUBLE
);

ALTER TABLE FIELDSOFDOUBLE ADD CONSTRAINT FIELDSOFDOUBLE_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFENUMNAME
(
    IDENTIFIER INTEGER NOT NULL,
    ENUM0 CHAR(2),
    ENUM1 CHAR(2),
    ENUM102 CHAR(2),
    ENUM103 CHAR(2),
    ENUM104 VARCHAR(256),
    ENUM108 VARCHAR(256),
    ENUM109 VARCHAR(256),
    ENUM11 VARCHAR(256),
    ENUM110 CHAR(2),
    ENUM112 CHAR(2),
    ENUM113 CHAR(2),
    ENUM114 CHAR(2),
    ENUM119 VARCHAR(256),
    ENUM12 VARCHAR(256),
    ENUM120 VARCHAR(256),
    ENUM121 VARCHAR(256),
    ENUM124 CHAR(2),
    ENUM125 CHAR(2),
    ENUM126 CHAR(2),
    ENUM128 CHAR(2),
    ENUM129 VARCHAR(256),
    ENUM13 VARCHAR(256),
    ENUM130 VARCHAR(256),
    ENUM138 VARCHAR(256),
    ENUM139 CHAR(2),
    ENUM140 CHAR(2),
    ENUM16 CHAR(2),
    ENUM17 CHAR(2),
    ENUM18 VARCHAR(256),
    ENUM2 VARCHAR(256),
    ENUM20 VARCHAR(256),
    ENUM21 VARCHAR(256),
    ENUM22 CHAR(2),
    ENUM30 CHAR(2),
    ENUM31 CHAR(2),
    ENUM32 CHAR(2),
    ENUM36 VARCHAR(256),
    ENUM37 VARCHAR(256),
    ENUM38 VARCHAR(256),
    ENUM4 VARCHAR(256),
    ENUM40 CHAR(2),
    ENUM41 CHAR(2),
    ENUM42 CHAR(2),
    ENUM47 CHAR(2),
    ENUM48 VARCHAR(256),
    ENUM49 VARCHAR(256),
    ENUM5 VARCHAR(256),
    ENUM52 VARCHAR(256),
    ENUM53 CHAR(2),
    ENUM54 CHAR(2),
    ENUM56 CHAR(2),
    ENUM57 CHAR(2),
    ENUM58 VARCHAR(256),
    ENUM6 VARCHAR(256),
    ENUM66 VARCHAR(256),
    ENUM67 VARCHAR(256),
    ENUM68 CHAR(2),
    ENUM72 CHAR(2),
    ENUM73 CHAR(2),
    ENUM74 CHAR(2),
    ENUM76 VARCHAR(256),
    ENUM77 VARCHAR(256),
    ENUM78 VARCHAR(256),
    ENUM83 VARCHAR(256),
    ENUM84 CHAR(2),
    ENUM85 CHAR(2),
    ENUM88 CHAR(2),
    ENUM89 CHAR(2),
    ENUM90 VARCHAR(256),
    ENUM92 VARCHAR(256),
    ENUM93 VARCHAR(256),
    ENUM94 VARCHAR(256)
);

ALTER TABLE FIELDSOFENUMNAME ADD CONSTRAINT 
      FIELDSOFENUMNAME_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFFLOAT
(
    IDENTIFIER INTEGER NOT NULL,
    FLOAT0 REAL,
    FLOAT1 REAL,
    FLOAT102 REAL,
    FLOAT103 REAL,
    FLOAT104 REAL,
    FLOAT108 REAL,
    FLOAT109 REAL,
    FLOAT11 REAL,
    FLOAT110 REAL,
    FLOAT112 REAL,
    FLOAT113 REAL,
    FLOAT114 REAL,
    FLOAT119 REAL,
    FLOAT12 REAL,
    FLOAT120 REAL,
    FLOAT121 REAL,
    FLOAT124 REAL,
    FLOAT125 REAL,
    FLOAT126 REAL,
    FLOAT128 REAL,
    FLOAT129 REAL,
    FLOAT13 REAL,
    FLOAT130 REAL,
    FLOAT138 REAL,
    FLOAT139 REAL,
    FLOAT140 REAL,
    FLOAT16 REAL,
    FLOAT17 REAL,
    FLOAT18 REAL,
    FLOAT2 REAL,
    FLOAT20 REAL,
    FLOAT21 REAL,
    FLOAT22 REAL,
    FLOAT30 REAL,
    FLOAT31 REAL,
    FLOAT32 REAL,
    FLOAT36 REAL,
    FLOAT37 REAL,
    FLOAT38 REAL,
    FLOAT4 REAL,
    FLOAT40 REAL,
    FLOAT41 REAL,
    FLOAT42 REAL,
    FLOAT47 REAL,
    FLOAT48 REAL,
    FLOAT49 REAL,
    FLOAT5 REAL,
    FLOAT52 REAL,
    FLOAT53 REAL,
    FLOAT54 REAL,
    FLOAT56 REAL,
    FLOAT57 REAL,
    FLOAT58 REAL,
    FLOAT6 REAL,
    FLOAT66 REAL,
    FLOAT67 REAL,
    FLOAT68 REAL,
    FLOAT72 REAL,
    FLOAT73 REAL,
    FLOAT74 REAL,
    FLOAT76 REAL,
    FLOAT77 REAL,
    FLOAT78 REAL,
    FLOAT83 REAL,
    FLOAT84 REAL,
    FLOAT85 REAL,
    FLOAT88 REAL,
    FLOAT89 REAL,
    FLOAT90 REAL,
    FLOAT92 REAL,
    FLOAT93 REAL,
    FLOAT94 REAL
);

ALTER TABLE FIELDSOFFLOAT ADD CONSTRAINT FIELDSOFFLOAT_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFINTEGER
(
    IDENTIFIER INTEGER NOT NULL,
    INTEGER0 INTEGER,
    INTEGER1 INTEGER,
    INTEGER102 INTEGER,
    INTEGER103 INTEGER,
    INTEGER104 INTEGER,
    INTEGER108 INTEGER,
    INTEGER109 INTEGER,
    INTEGER11 INTEGER,
    INTEGER110 INTEGER,
    INTEGER112 INTEGER,
    INTEGER113 INTEGER,
    INTEGER114 INTEGER,
    INTEGER119 INTEGER,
    INTEGER12 INTEGER,
    INTEGER120 INTEGER,
    INTEGER121 INTEGER,
    INTEGER124 INTEGER,
    INTEGER125 INTEGER,
    INTEGER126 INTEGER,
    INTEGER128 INTEGER,
    INTEGER129 INTEGER,
    INTEGER13 INTEGER,
    INTEGER130 INTEGER,
    INTEGER138 INTEGER,
    INTEGER139 INTEGER,
    INTEGER140 INTEGER,
    INTEGER16 INTEGER,
    INTEGER17 INTEGER,
    INTEGER18 INTEGER,
    INTEGER2 INTEGER,
    INTEGER20 INTEGER,
    INTEGER21 INTEGER,
    INTEGER22 INTEGER,
    INTEGER30 INTEGER,
    INTEGER31 INTEGER,
    INTEGER32 INTEGER,
    INTEGER36 INTEGER,
    INTEGER37 INTEGER,
    INTEGER38 INTEGER,
    INTEGER4 INTEGER,
    INTEGER40 INTEGER,
    INTEGER41 INTEGER,
    INTEGER42 INTEGER,
    INTEGER47 INTEGER,
    INTEGER48 INTEGER,
    INTEGER49 INTEGER,
    INTEGER5 INTEGER,
    INTEGER52 INTEGER,
    INTEGER53 INTEGER,
    INTEGER54 INTEGER,
    INTEGER56 INTEGER,
    INTEGER57 INTEGER,
    INTEGER58 INTEGER,
    INTEGER6 INTEGER,
    INTEGER66 INTEGER,
    INTEGER67 INTEGER,
    INTEGER68 INTEGER,
    INTEGER72 INTEGER,
    INTEGER73 INTEGER,
    INTEGER74 INTEGER,
    INTEGER76 INTEGER,
    INTEGER77 INTEGER,
    INTEGER78 INTEGER,
    INTEGER83 INTEGER,
    INTEGER84 INTEGER,
    INTEGER85 INTEGER,
    INTEGER88 INTEGER,
    INTEGER89 INTEGER,
    INTEGER90 INTEGER,
    INTEGER92 INTEGER,
    INTEGER93 INTEGER,
    INTEGER94 INTEGER
);

ALTER TABLE FIELDSOFINTEGER ADD CONSTRAINT FIELDSOFINTEV0_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFLOCALE
(
    IDENTIFIER INTEGER NOT NULL,
    LOCALE0 CHAR(20),
    LOCALE1 CHAR(20),
    LOCALE102 CHAR(20),
    LOCALE103 CHAR(20),
    LOCALE104 CHAR(20),
    LOCALE108 CHAR(20),
    LOCALE109 CHAR(20),
    LOCALE11 CHAR(20),
    LOCALE110 CHAR(20),
    LOCALE112 CHAR(20),
    LOCALE113 CHAR(20),
    LOCALE114 CHAR(20),
    LOCALE119 CHAR(20),
    LOCALE12 CHAR(20),
    LOCALE120 CHAR(20),
    LOCALE121 CHAR(20),
    LOCALE124 CHAR(20),
    LOCALE125 CHAR(20),
    LOCALE126 CHAR(20),
    LOCALE128 CHAR(20),
    LOCALE129 CHAR(20),
    LOCALE13 CHAR(20),
    LOCALE130 CHAR(20),
    LOCALE138 CHAR(20),
    LOCALE139 CHAR(20),
    LOCALE140 CHAR(20),
    LOCALE16 CHAR(20),
    LOCALE17 CHAR(20),
    LOCALE18 CHAR(20),
    LOCALE2 CHAR(20),
    LOCALE20 CHAR(20),
    LOCALE21 CHAR(20),
    LOCALE22 CHAR(20),
    LOCALE30 CHAR(20),
    LOCALE31 CHAR(20),
    LOCALE32 CHAR(20),
    LOCALE36 CHAR(20),
    LOCALE37 CHAR(20),
    LOCALE38 CHAR(20),
    LOCALE4 CHAR(20),
    LOCALE40 CHAR(20),
    LOCALE41 CHAR(20),
    LOCALE42 CHAR(20),
    LOCALE47 CHAR(20),
    LOCALE48 CHAR(20),
    LOCALE49 CHAR(20),
    LOCALE5 CHAR(20),
    LOCALE52 CHAR(20),
    LOCALE53 CHAR(20),
    LOCALE54 CHAR(20),
    LOCALE56 CHAR(20),
    LOCALE57 CHAR(20),
    LOCALE58 CHAR(20),
    LOCALE6 CHAR(20),
    LOCALE66 CHAR(20),
    LOCALE67 CHAR(20),
    LOCALE68 CHAR(20),
    LOCALE72 CHAR(20),
    LOCALE73 CHAR(20),
    LOCALE74 CHAR(20),
    LOCALE76 CHAR(20),
    LOCALE77 CHAR(20),
    LOCALE78 CHAR(20),
    LOCALE83 CHAR(20),
    LOCALE84 CHAR(20),
    LOCALE85 CHAR(20),
    LOCALE88 CHAR(20),
    LOCALE89 CHAR(20),
    LOCALE90 CHAR(20),
    LOCALE92 CHAR(20),
    LOCALE93 CHAR(20),
    LOCALE94 CHAR(20)
);

ALTER TABLE FIELDSOFLOCALE ADD CONSTRAINT FIELDSOFLOCALE_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFLONG
(
    IDENTIFIER INTEGER NOT NULL,
    LONG0 BIGINT,
    LONG1 BIGINT,
    LONG102 BIGINT,
    LONG103 BIGINT,
    LONG104 BIGINT,
    LONG108 BIGINT,
    LONG109 BIGINT,
    LONG11 BIGINT,
    LONG110 BIGINT,
    LONG112 BIGINT,
    LONG113 BIGINT,
    LONG114 BIGINT,
    LONG119 BIGINT,
    LONG12 BIGINT,
    LONG120 BIGINT,
    LONG121 BIGINT,
    LONG124 BIGINT,
    LONG125 BIGINT,
    LONG126 BIGINT,
    LONG128 BIGINT,
    LONG129 BIGINT,
    LONG13 BIGINT,
    LONG130 BIGINT,
    LONG138 BIGINT,
    LONG139 BIGINT,
    LONG140 BIGINT,
    LONG16 BIGINT,
    LONG17 BIGINT,
    LONG18 BIGINT,
    LONG2 BIGINT,
    LONG20 BIGINT,
    LONG21 BIGINT,
    LONG22 BIGINT,
    LONG30 BIGINT,
    LONG31 BIGINT,
    LONG32 BIGINT,
    LONG36 BIGINT,
    LONG37 BIGINT,
    LONG38 BIGINT,
    LONG4 BIGINT,
    LONG40 BIGINT,
    LONG41 BIGINT,
    LONG42 BIGINT,
    LONG47 BIGINT,
    LONG48 BIGINT,
    LONG49 BIGINT,
    LONG5 BIGINT,
    LONG52 BIGINT,
    LONG53 BIGINT,
    LONG54 BIGINT,
    LONG56 BIGINT,
    LONG57 BIGINT,
    LONG58 BIGINT,
    LONG6 BIGINT,
    LONG66 BIGINT,
    LONG67 BIGINT,
    LONG68 BIGINT,
    LONG72 BIGINT,
    LONG73 BIGINT,
    LONG74 BIGINT,
    LONG76 BIGINT,
    LONG77 BIGINT,
    LONG78 BIGINT,
    LONG83 BIGINT,
    LONG84 BIGINT,
    LONG85 BIGINT,
    LONG88 BIGINT,
    LONG89 BIGINT,
    LONG90 BIGINT,
    LONG92 BIGINT,
    LONG93 BIGINT,
    LONG94 BIGINT
);

ALTER TABLE FIELDSOFLONG ADD CONSTRAINT FIELDSOFLONG_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFOBJECT
(
    IDENTIFIER INTEGER NOT NULL,
    OBJECT1 LONG VARCHAR FOR BIT DATA,
    OBJECT102 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT103 LONG VARCHAR FOR BIT DATA,
    OBJECT104 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT109 LONG VARCHAR FOR BIT DATA,
    OBJECT11 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT110 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT112 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT113 LONG VARCHAR FOR BIT DATA,
    OBJECT114 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT119 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT12 LONG VARCHAR FOR BIT DATA,
    OBJECT120 LONG VARCHAR FOR BIT DATA,
    OBJECT121 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT125 LONG VARCHAR FOR BIT DATA,
    OBJECT126 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT128 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT129 LONG VARCHAR FOR BIT DATA,
    OBJECT13 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT130 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT138 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT139 LONG VARCHAR FOR BIT DATA,
    OBJECT140 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT17 LONG VARCHAR FOR BIT DATA,
    OBJECT18 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT2 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT20 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT21 LONG VARCHAR FOR BIT DATA,
    OBJECT22 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT30 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT31 LONG VARCHAR FOR BIT DATA,
    OBJECT32 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT37 LONG VARCHAR FOR BIT DATA,
    OBJECT38 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT4 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT40 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT41 LONG VARCHAR FOR BIT DATA,
    OBJECT42 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT47 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT48 LONG VARCHAR FOR BIT DATA,
    OBJECT49 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT5 LONG VARCHAR FOR BIT DATA,
    OBJECT53 LONG VARCHAR FOR BIT DATA,
    OBJECT54 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT56 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT57 LONG VARCHAR FOR BIT DATA,
    OBJECT58 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT6 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT66 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT67 LONG VARCHAR FOR BIT DATA,
    OBJECT68 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT73 LONG VARCHAR FOR BIT DATA,
    OBJECT74 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT76 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT77 LONG VARCHAR FOR BIT DATA,
    OBJECT78 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT83 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT84 LONG VARCHAR FOR BIT DATA,
    OBJECT85 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT89 LONG VARCHAR FOR BIT DATA,
    OBJECT90 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT92 BIGINT REFERENCES SIMPLE_CLASS,
    OBJECT93 LONG VARCHAR FOR BIT DATA,
    OBJECT94 BIGINT REFERENCES SIMPLE_CLASS
);

ALTER TABLE FIELDSOFOBJECT ADD CONSTRAINT FIELDSOFOBJECT_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFSIMPLEINTERFACE
(
    IDENTIFIER INTEGER NOT NULL,
    SIMPLEINTERFACE1 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE102 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE103 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE104 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE109 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE11 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE110 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE112 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE113 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE114 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE119 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE12 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE120 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE121 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE125 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE126 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE128 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE129 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE13 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE130 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE138 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE139 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE140 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE17 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE18 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE2 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE20 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE21 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE22 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE30 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE31 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE32 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE37 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE38 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE4 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE40 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE41 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE42 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE47 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE48 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE49 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE5 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE53 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE54 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE56 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE57 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE58 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE6 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE66 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE67 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE68 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE73 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE74 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE76 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE77 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE78 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE83 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE84 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE85 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE89 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE90 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE92 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLEINTERFACE93 LONG VARCHAR FOR BIT DATA,
    SIMPLEINTERFACE94 BIGINT REFERENCES SIMPLE_CLASS
);

ALTER TABLE FIELDSOFSIMPLEINTERFACE ADD CONSTRAINT FOSI_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVEBOOLEAN
(
    IDENTIFIER INTEGER NOT NULL,
    BOOLEAN0 CHAR(1) NOT NULL CHECK (BOOLEAN0 IN ('Y','N')),
    BOOLEAN1 CHAR(1) NOT NULL CHECK (BOOLEAN1 IN ('Y','N')),
    BOOLEAN102 CHAR(1) NOT NULL CHECK (BOOLEAN102 IN ('Y','N')),
    BOOLEAN103 CHAR(1) NOT NULL CHECK (BOOLEAN103 IN ('Y','N')),
    BOOLEAN104 CHAR(1) NOT NULL CHECK (BOOLEAN104 IN ('Y','N')),
    BOOLEAN108 CHAR(1) NOT NULL CHECK (BOOLEAN108 IN ('Y','N')),
    BOOLEAN109 CHAR(1) NOT NULL CHECK (BOOLEAN109 IN ('Y','N')),
    BOOLEAN11 CHAR(1) NOT NULL CHECK (BOOLEAN11 IN ('Y','N')),
    BOOLEAN110 CHAR(1) NOT NULL CHECK (BOOLEAN110 IN ('Y','N')),
    BOOLEAN112 CHAR(1) NOT NULL CHECK (BOOLEAN112 IN ('Y','N')),
    BOOLEAN113 CHAR(1) NOT NULL CHECK (BOOLEAN113 IN ('Y','N')),
    BOOLEAN114 CHAR(1) NOT NULL CHECK (BOOLEAN114 IN ('Y','N')),
    BOOLEAN119 CHAR(1) NOT NULL CHECK (BOOLEAN119 IN ('Y','N')),
    BOOLEAN12 CHAR(1) NOT NULL CHECK (BOOLEAN12 IN ('Y','N')),
    BOOLEAN120 CHAR(1) NOT NULL CHECK (BOOLEAN120 IN ('Y','N')),
    BOOLEAN121 CHAR(1) NOT NULL CHECK (BOOLEAN121 IN ('Y','N')),
    BOOLEAN124 CHAR(1) NOT NULL CHECK (BOOLEAN124 IN ('Y','N')),
    BOOLEAN125 CHAR(1) NOT NULL CHECK (BOOLEAN125 IN ('Y','N')),
    BOOLEAN126 CHAR(1) NOT NULL CHECK (BOOLEAN126 IN ('Y','N')),
    BOOLEAN128 CHAR(1) NOT NULL CHECK (BOOLEAN128 IN ('Y','N')),
    BOOLEAN129 CHAR(1) NOT NULL CHECK (BOOLEAN129 IN ('Y','N')),
    BOOLEAN13 CHAR(1) NOT NULL CHECK (BOOLEAN13 IN ('Y','N')),
    BOOLEAN130 CHAR(1) NOT NULL CHECK (BOOLEAN130 IN ('Y','N')),
    BOOLEAN138 CHAR(1) NOT NULL CHECK (BOOLEAN138 IN ('Y','N')),
    BOOLEAN139 CHAR(1) NOT NULL CHECK (BOOLEAN139 IN ('Y','N')),
    BOOLEAN140 CHAR(1) NOT NULL CHECK (BOOLEAN140 IN ('Y','N')),
    BOOLEAN16 CHAR(1) NOT NULL CHECK (BOOLEAN16 IN ('Y','N')),
    BOOLEAN17 CHAR(1) NOT NULL CHECK (BOOLEAN17 IN ('Y','N')),
    BOOLEAN18 CHAR(1) NOT NULL CHECK (BOOLEAN18 IN ('Y','N')),
    BOOLEAN2 CHAR(1) NOT NULL CHECK (BOOLEAN2 IN ('Y','N')),
    BOOLEAN20 CHAR(1) NOT NULL CHECK (BOOLEAN20 IN ('Y','N')),
    BOOLEAN21 CHAR(1) NOT NULL CHECK (BOOLEAN21 IN ('Y','N')),
    BOOLEAN22 CHAR(1) NOT NULL CHECK (BOOLEAN22 IN ('Y','N')),
    BOOLEAN30 CHAR(1) NOT NULL CHECK (BOOLEAN30 IN ('Y','N')),
    BOOLEAN31 CHAR(1) NOT NULL CHECK (BOOLEAN31 IN ('Y','N')),
    BOOLEAN32 CHAR(1) NOT NULL CHECK (BOOLEAN32 IN ('Y','N')),
    BOOLEAN36 CHAR(1) NOT NULL CHECK (BOOLEAN36 IN ('Y','N')),
    BOOLEAN37 CHAR(1) NOT NULL CHECK (BOOLEAN37 IN ('Y','N')),
    BOOLEAN38 CHAR(1) NOT NULL CHECK (BOOLEAN38 IN ('Y','N')),
    BOOLEAN4 CHAR(1) NOT NULL CHECK (BOOLEAN4 IN ('Y','N')),
    BOOLEAN40 CHAR(1) NOT NULL CHECK (BOOLEAN40 IN ('Y','N')),
    BOOLEAN41 CHAR(1) NOT NULL CHECK (BOOLEAN41 IN ('Y','N')),
    BOOLEAN42 CHAR(1) NOT NULL CHECK (BOOLEAN42 IN ('Y','N')),
    BOOLEAN47 CHAR(1) NOT NULL CHECK (BOOLEAN47 IN ('Y','N')),
    BOOLEAN48 CHAR(1) NOT NULL CHECK (BOOLEAN48 IN ('Y','N')),
    BOOLEAN49 CHAR(1) NOT NULL CHECK (BOOLEAN49 IN ('Y','N')),
    BOOLEAN5 CHAR(1) NOT NULL CHECK (BOOLEAN5 IN ('Y','N')),
    BOOLEAN52 CHAR(1) NOT NULL CHECK (BOOLEAN52 IN ('Y','N')),
    BOOLEAN53 CHAR(1) NOT NULL CHECK (BOOLEAN53 IN ('Y','N')),
    BOOLEAN54 CHAR(1) NOT NULL CHECK (BOOLEAN54 IN ('Y','N')),
    BOOLEAN56 CHAR(1) NOT NULL CHECK (BOOLEAN56 IN ('Y','N')),
    BOOLEAN57 CHAR(1) NOT NULL CHECK (BOOLEAN57 IN ('Y','N')),
    BOOLEAN58 CHAR(1) NOT NULL CHECK (BOOLEAN58 IN ('Y','N')),
    BOOLEAN6 CHAR(1) NOT NULL CHECK (BOOLEAN6 IN ('Y','N')),
    BOOLEAN66 CHAR(1) NOT NULL CHECK (BOOLEAN66 IN ('Y','N')),
    BOOLEAN67 CHAR(1) NOT NULL CHECK (BOOLEAN67 IN ('Y','N')),
    BOOLEAN68 CHAR(1) NOT NULL CHECK (BOOLEAN68 IN ('Y','N')),
    BOOLEAN72 CHAR(1) NOT NULL CHECK (BOOLEAN72 IN ('Y','N')),
    BOOLEAN73 CHAR(1) NOT NULL CHECK (BOOLEAN73 IN ('Y','N')),
    BOOLEAN74 CHAR(1) NOT NULL CHECK (BOOLEAN74 IN ('Y','N')),
    BOOLEAN76 CHAR(1) NOT NULL CHECK (BOOLEAN76 IN ('Y','N')),
    BOOLEAN77 CHAR(1) NOT NULL CHECK (BOOLEAN77 IN ('Y','N')),
    BOOLEAN78 CHAR(1) NOT NULL CHECK (BOOLEAN78 IN ('Y','N')),
    BOOLEAN83 CHAR(1) NOT NULL CHECK (BOOLEAN83 IN ('Y','N')),
    BOOLEAN84 CHAR(1) NOT NULL CHECK (BOOLEAN84 IN ('Y','N')),
    BOOLEAN85 CHAR(1) NOT NULL CHECK (BOOLEAN85 IN ('Y','N')),
    BOOLEAN88 CHAR(1) NOT NULL CHECK (BOOLEAN88 IN ('Y','N')),
    BOOLEAN89 CHAR(1) NOT NULL CHECK (BOOLEAN89 IN ('Y','N')),
    BOOLEAN90 CHAR(1) NOT NULL CHECK (BOOLEAN90 IN ('Y','N')),
    BOOLEAN92 CHAR(1) NOT NULL CHECK (BOOLEAN92 IN ('Y','N')),
    BOOLEAN93 CHAR(1) NOT NULL CHECK (BOOLEAN93 IN ('Y','N')),
    BOOLEAN94 CHAR(1) NOT NULL CHECK (BOOLEAN94 IN ('Y','N'))
);

ALTER TABLE FIELDSOFPRIMITIVEBOOLEAN ADD CONSTRAINT FIELDSOFPRIMC2_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVEBYTE
(
    IDENTIFIER INTEGER NOT NULL,
    BYTE0 SMALLINT NOT NULL,
    BYTE1 SMALLINT NOT NULL,
    BYTE102 SMALLINT NOT NULL,
    BYTE103 SMALLINT NOT NULL,
    BYTE104 SMALLINT NOT NULL,
    BYTE108 SMALLINT NOT NULL,
    BYTE109 SMALLINT NOT NULL,
    BYTE11 SMALLINT NOT NULL,
    BYTE110 SMALLINT NOT NULL,
    BYTE112 SMALLINT NOT NULL,
    BYTE113 SMALLINT NOT NULL,
    BYTE114 SMALLINT NOT NULL,
    BYTE119 SMALLINT NOT NULL,
    BYTE12 SMALLINT NOT NULL,
    BYTE120 SMALLINT NOT NULL,
    BYTE121 SMALLINT NOT NULL,
    BYTE124 SMALLINT NOT NULL,
    BYTE125 SMALLINT NOT NULL,
    BYTE126 SMALLINT NOT NULL,
    BYTE128 SMALLINT NOT NULL,
    BYTE129 SMALLINT NOT NULL,
    BYTE13 SMALLINT NOT NULL,
    BYTE130 SMALLINT NOT NULL,
    BYTE138 SMALLINT NOT NULL,
    BYTE139 SMALLINT NOT NULL,
    BYTE140 SMALLINT NOT NULL,
    BYTE16 SMALLINT NOT NULL,
    BYTE17 SMALLINT NOT NULL,
    BYTE18 SMALLINT NOT NULL,
    BYTE2 SMALLINT NOT NULL,
    BYTE20 SMALLINT NOT NULL,
    BYTE21 SMALLINT NOT NULL,
    BYTE22 SMALLINT NOT NULL,
    BYTE30 SMALLINT NOT NULL,
    BYTE31 SMALLINT NOT NULL,
    BYTE32 SMALLINT NOT NULL,
    BYTE36 SMALLINT NOT NULL,
    BYTE37 SMALLINT NOT NULL,
    BYTE38 SMALLINT NOT NULL,
    BYTE4 SMALLINT NOT NULL,
    BYTE40 SMALLINT NOT NULL,
    BYTE41 SMALLINT NOT NULL,
    BYTE42 SMALLINT NOT NULL,
    BYTE47 SMALLINT NOT NULL,
    BYTE48 SMALLINT NOT NULL,
    BYTE49 SMALLINT NOT NULL,
    BYTE5 SMALLINT NOT NULL,
    BYTE52 SMALLINT NOT NULL,
    BYTE53 SMALLINT NOT NULL,
    BYTE54 SMALLINT NOT NULL,
    BYTE56 SMALLINT NOT NULL,
    BYTE57 SMALLINT NOT NULL,
    BYTE58 SMALLINT NOT NULL,
    BYTE6 SMALLINT NOT NULL,
    BYTE66 SMALLINT NOT NULL,
    BYTE67 SMALLINT NOT NULL,
    BYTE68 SMALLINT NOT NULL,
    BYTE72 SMALLINT NOT NULL,
    BYTE73 SMALLINT NOT NULL,
    BYTE74 SMALLINT NOT NULL,
    BYTE76 SMALLINT NOT NULL,
    BYTE77 SMALLINT NOT NULL,
    BYTE78 SMALLINT NOT NULL,
    BYTE83 SMALLINT NOT NULL,
    BYTE84 SMALLINT NOT NULL,
    BYTE85 SMALLINT NOT NULL,
    BYTE88 SMALLINT NOT NULL,
    BYTE89 SMALLINT NOT NULL,
    BYTE90 SMALLINT NOT NULL,
    BYTE92 SMALLINT NOT NULL,
    BYTE93 SMALLINT NOT NULL,
    BYTE94 SMALLINT NOT NULL
);

ALTER TABLE FIELDSOFPRIMITIVEBYTE ADD CONSTRAINT FIELDSOFPRIMSD_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVECHAR
(
    IDENTIFIER INTEGER NOT NULL,
    CHAR0 CHAR(1) NOT NULL,
    CHAR1 CHAR(1) NOT NULL,
    CHAR102 CHAR(1) NOT NULL,
    CHAR103 CHAR(1) NOT NULL,
    CHAR104 CHAR(1) NOT NULL,
    CHAR108 CHAR(1) NOT NULL,
    CHAR109 CHAR(1) NOT NULL,
    CHAR11 CHAR(1) NOT NULL,
    CHAR110 CHAR(1) NOT NULL,
    CHAR112 CHAR(1) NOT NULL,
    CHAR113 CHAR(1) NOT NULL,
    CHAR114 CHAR(1) NOT NULL,
    CHAR119 CHAR(1) NOT NULL,
    CHAR12 CHAR(1) NOT NULL,
    CHAR120 CHAR(1) NOT NULL,
    CHAR121 CHAR(1) NOT NULL,
    CHAR124 CHAR(1) NOT NULL,
    CHAR125 CHAR(1) NOT NULL,
    CHAR126 CHAR(1) NOT NULL,
    CHAR128 CHAR(1) NOT NULL,
    CHAR129 CHAR(1) NOT NULL,
    CHAR13 CHAR(1) NOT NULL,
    CHAR130 CHAR(1) NOT NULL,
    CHAR138 CHAR(1) NOT NULL,
    CHAR139 CHAR(1) NOT NULL,
    CHAR140 CHAR(1) NOT NULL,
    CHAR16 CHAR(1) NOT NULL,
    CHAR17 CHAR(1) NOT NULL,
    CHAR18 CHAR(1) NOT NULL,
    CHAR2 CHAR(1) NOT NULL,
    CHAR20 CHAR(1) NOT NULL,
    CHAR21 CHAR(1) NOT NULL,
    CHAR22 CHAR(1) NOT NULL,
    CHAR30 CHAR(1) NOT NULL,
    CHAR31 CHAR(1) NOT NULL,
    CHAR32 CHAR(1) NOT NULL,
    CHAR36 CHAR(1) NOT NULL,
    CHAR37 CHAR(1) NOT NULL,
    CHAR38 CHAR(1) NOT NULL,
    CHAR4 CHAR(1) NOT NULL,
    CHAR40 CHAR(1) NOT NULL,
    CHAR41 CHAR(1) NOT NULL,
    CHAR42 CHAR(1) NOT NULL,
    CHAR47 CHAR(1) NOT NULL,
    CHAR48 CHAR(1) NOT NULL,
    CHAR49 CHAR(1) NOT NULL,
    CHAR5 CHAR(1) NOT NULL,
    CHAR52 CHAR(1) NOT NULL,
    CHAR53 CHAR(1) NOT NULL,
    CHAR54 CHAR(1) NOT NULL,
    CHAR56 CHAR(1) NOT NULL,
    CHAR57 CHAR(1) NOT NULL,
    CHAR58 CHAR(1) NOT NULL,
    CHAR6 CHAR(1) NOT NULL,
    CHAR66 CHAR(1) NOT NULL,
    CHAR67 CHAR(1) NOT NULL,
    CHAR68 CHAR(1) NOT NULL,
    CHAR72 CHAR(1) NOT NULL,
    CHAR73 CHAR(1) NOT NULL,
    CHAR74 CHAR(1) NOT NULL,
    CHAR76 CHAR(1) NOT NULL,
    CHAR77 CHAR(1) NOT NULL,
    CHAR78 CHAR(1) NOT NULL,
    CHAR83 CHAR(1) NOT NULL,
    CHAR84 CHAR(1) NOT NULL,
    CHAR85 CHAR(1) NOT NULL,
    CHAR88 CHAR(1) NOT NULL,
    CHAR89 CHAR(1) NOT NULL,
    CHAR90 CHAR(1) NOT NULL,
    CHAR92 CHAR(1) NOT NULL,
    CHAR93 CHAR(1) NOT NULL,
    CHAR94 CHAR(1) NOT NULL
);

ALTER TABLE FIELDSOFPRIMITIVECHAR ADD CONSTRAINT FIELDSOFPRIMQ3_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVEDOUBLE
(
    IDENTIFIER INTEGER NOT NULL,
    DOUBLE0 DOUBLE NOT NULL,
    DOUBLE1 DOUBLE NOT NULL,
    DOUBLE102 DOUBLE NOT NULL,
    DOUBLE103 DOUBLE NOT NULL,
    DOUBLE104 DOUBLE NOT NULL,
    DOUBLE108 DOUBLE NOT NULL,
    DOUBLE109 DOUBLE NOT NULL,
    DOUBLE11 DOUBLE NOT NULL,
    DOUBLE110 DOUBLE NOT NULL,
    DOUBLE112 DOUBLE NOT NULL,
    DOUBLE113 DOUBLE NOT NULL,
    DOUBLE114 DOUBLE NOT NULL,
    DOUBLE119 DOUBLE NOT NULL,
    DOUBLE12 DOUBLE NOT NULL,
    DOUBLE120 DOUBLE NOT NULL,
    DOUBLE121 DOUBLE NOT NULL,
    DOUBLE124 DOUBLE NOT NULL,
    DOUBLE125 DOUBLE NOT NULL,
    DOUBLE126 DOUBLE NOT NULL,
    DOUBLE128 DOUBLE NOT NULL,
    DOUBLE129 DOUBLE NOT NULL,
    DOUBLE13 DOUBLE NOT NULL,
    DOUBLE130 DOUBLE NOT NULL,
    DOUBLE138 DOUBLE NOT NULL,
    DOUBLE139 DOUBLE NOT NULL,
    DOUBLE140 DOUBLE NOT NULL,
    DOUBLE16 DOUBLE NOT NULL,
    DOUBLE17 DOUBLE NOT NULL,
    DOUBLE18 DOUBLE NOT NULL,
    DOUBLE2 DOUBLE NOT NULL,
    DOUBLE20 DOUBLE NOT NULL,
    DOUBLE21 DOUBLE NOT NULL,
    DOUBLE22 DOUBLE NOT NULL,
    DOUBLE30 DOUBLE NOT NULL,
    DOUBLE31 DOUBLE NOT NULL,
    DOUBLE32 DOUBLE NOT NULL,
    DOUBLE36 DOUBLE NOT NULL,
    DOUBLE37 DOUBLE NOT NULL,
    DOUBLE38 DOUBLE NOT NULL,
    DOUBLE4 DOUBLE NOT NULL,
    DOUBLE40 DOUBLE NOT NULL,
    DOUBLE41 DOUBLE NOT NULL,
    DOUBLE42 DOUBLE NOT NULL,
    DOUBLE47 DOUBLE NOT NULL,
    DOUBLE48 DOUBLE NOT NULL,
    DOUBLE49 DOUBLE NOT NULL,
    DOUBLE5 DOUBLE NOT NULL,
    DOUBLE52 DOUBLE NOT NULL,
    DOUBLE53 DOUBLE NOT NULL,
    DOUBLE54 DOUBLE NOT NULL,
    DOUBLE56 DOUBLE NOT NULL,
    DOUBLE57 DOUBLE NOT NULL,
    DOUBLE58 DOUBLE NOT NULL,
    DOUBLE6 DOUBLE NOT NULL,
    DOUBLE66 DOUBLE NOT NULL,
    DOUBLE67 DOUBLE NOT NULL,
    DOUBLE68 DOUBLE NOT NULL,
    DOUBLE72 DOUBLE NOT NULL,
    DOUBLE73 DOUBLE NOT NULL,
    DOUBLE74 DOUBLE NOT NULL,
    DOUBLE76 DOUBLE NOT NULL,
    DOUBLE77 DOUBLE NOT NULL,
    DOUBLE78 DOUBLE NOT NULL,
    DOUBLE83 DOUBLE NOT NULL,
    DOUBLE84 DOUBLE NOT NULL,
    DOUBLE85 DOUBLE NOT NULL,
    DOUBLE88 DOUBLE NOT NULL,
    DOUBLE89 DOUBLE NOT NULL,
    DOUBLE90 DOUBLE NOT NULL,
    DOUBLE92 DOUBLE NOT NULL,
    DOUBLE93 DOUBLE NOT NULL,
    DOUBLE94 DOUBLE NOT NULL
);

ALTER TABLE FIELDSOFPRIMITIVEDOUBLE ADD CONSTRAINT FIELDSOFPRIMHH_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVEFLOAT
(
    IDENTIFIER INTEGER NOT NULL,
    FLOAT0 REAL NOT NULL,
    FLOAT1 REAL NOT NULL,
    FLOAT102 REAL NOT NULL,
    FLOAT103 REAL NOT NULL,
    FLOAT104 REAL NOT NULL,
    FLOAT108 REAL NOT NULL,
    FLOAT109 REAL NOT NULL,
    FLOAT11 REAL NOT NULL,
    FLOAT110 REAL NOT NULL,
    FLOAT112 REAL NOT NULL,
    FLOAT113 REAL NOT NULL,
    FLOAT114 REAL NOT NULL,
    FLOAT119 REAL NOT NULL,
    FLOAT12 REAL NOT NULL,
    FLOAT120 REAL NOT NULL,
    FLOAT121 REAL NOT NULL,
    FLOAT124 REAL NOT NULL,
    FLOAT125 REAL NOT NULL,
    FLOAT126 REAL NOT NULL,
    FLOAT128 REAL NOT NULL,
    FLOAT129 REAL NOT NULL,
    FLOAT13 REAL NOT NULL,
    FLOAT130 REAL NOT NULL,
    FLOAT138 REAL NOT NULL,
    FLOAT139 REAL NOT NULL,
    FLOAT140 REAL NOT NULL,
    FLOAT16 REAL NOT NULL,
    FLOAT17 REAL NOT NULL,
    FLOAT18 REAL NOT NULL,
    FLOAT2 REAL NOT NULL,
    FLOAT20 REAL NOT NULL,
    FLOAT21 REAL NOT NULL,
    FLOAT22 REAL NOT NULL,
    FLOAT30 REAL NOT NULL,
    FLOAT31 REAL NOT NULL,
    FLOAT32 REAL NOT NULL,
    FLOAT36 REAL NOT NULL,
    FLOAT37 REAL NOT NULL,
    FLOAT38 REAL NOT NULL,
    FLOAT4 REAL NOT NULL,
    FLOAT40 REAL NOT NULL,
    FLOAT41 REAL NOT NULL,
    FLOAT42 REAL NOT NULL,
    FLOAT47 REAL NOT NULL,
    FLOAT48 REAL NOT NULL,
    FLOAT49 REAL NOT NULL,
    FLOAT5 REAL NOT NULL,
    FLOAT52 REAL NOT NULL,
    FLOAT53 REAL NOT NULL,
    FLOAT54 REAL NOT NULL,
    FLOAT56 REAL NOT NULL,
    FLOAT57 REAL NOT NULL,
    FLOAT58 REAL NOT NULL,
    FLOAT6 REAL NOT NULL,
    FLOAT66 REAL NOT NULL,
    FLOAT67 REAL NOT NULL,
    FLOAT68 REAL NOT NULL,
    FLOAT72 REAL NOT NULL,
    FLOAT73 REAL NOT NULL,
    FLOAT74 REAL NOT NULL,
    FLOAT76 REAL NOT NULL,
    FLOAT77 REAL NOT NULL,
    FLOAT78 REAL NOT NULL,
    FLOAT83 REAL NOT NULL,
    FLOAT84 REAL NOT NULL,
    FLOAT85 REAL NOT NULL,
    FLOAT88 REAL NOT NULL,
    FLOAT89 REAL NOT NULL,
    FLOAT90 REAL NOT NULL,
    FLOAT92 REAL NOT NULL,
    FLOAT93 REAL NOT NULL,
    FLOAT94 REAL NOT NULL
);

ALTER TABLE FIELDSOFPRIMITIVEFLOAT ADD CONSTRAINT FIELDSOFPRIMR3_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVEINT
(
    IDENTIFIER INTEGER NOT NULL,
    INT0 INTEGER NOT NULL,
    INT1 INTEGER NOT NULL,
    INT102 INTEGER NOT NULL,
    INT103 INTEGER NOT NULL,
    INT104 INTEGER NOT NULL,
    INT108 INTEGER NOT NULL,
    INT109 INTEGER NOT NULL,
    INT11 INTEGER NOT NULL,
    INT110 INTEGER NOT NULL,
    INT112 INTEGER NOT NULL,
    INT113 INTEGER NOT NULL,
    INT114 INTEGER NOT NULL,
    INT119 INTEGER NOT NULL,
    INT12 INTEGER NOT NULL,
    INT120 INTEGER NOT NULL,
    INT121 INTEGER NOT NULL,
    INT124 INTEGER NOT NULL,
    INT125 INTEGER NOT NULL,
    INT126 INTEGER NOT NULL,
    INT128 INTEGER NOT NULL,
    INT129 INTEGER NOT NULL,
    INT13 INTEGER NOT NULL,
    INT130 INTEGER NOT NULL,
    INT138 INTEGER NOT NULL,
    INT139 INTEGER NOT NULL,
    INT140 INTEGER NOT NULL,
    INT16 INTEGER NOT NULL,
    INT17 INTEGER NOT NULL,
    INT18 INTEGER NOT NULL,
    INT2 INTEGER NOT NULL,
    INT20 INTEGER NOT NULL,
    INT21 INTEGER NOT NULL,
    INT22 INTEGER NOT NULL,
    INT30 INTEGER NOT NULL,
    INT31 INTEGER NOT NULL,
    INT32 INTEGER NOT NULL,
    INT36 INTEGER NOT NULL,
    INT37 INTEGER NOT NULL,
    INT38 INTEGER NOT NULL,
    INT4 INTEGER NOT NULL,
    INT40 INTEGER NOT NULL,
    INT41 INTEGER NOT NULL,
    INT42 INTEGER NOT NULL,
    INT47 INTEGER NOT NULL,
    INT48 INTEGER NOT NULL,
    INT49 INTEGER NOT NULL,
    INT5 INTEGER NOT NULL,
    INT52 INTEGER NOT NULL,
    INT53 INTEGER NOT NULL,
    INT54 INTEGER NOT NULL,
    INT56 INTEGER NOT NULL,
    INT57 INTEGER NOT NULL,
    INT58 INTEGER NOT NULL,
    INT6 INTEGER NOT NULL,
    INT66 INTEGER NOT NULL,
    INT67 INTEGER NOT NULL,
    INT68 INTEGER NOT NULL,
    INT72 INTEGER NOT NULL,
    INT73 INTEGER NOT NULL,
    INT74 INTEGER NOT NULL,
    INT76 INTEGER NOT NULL,
    INT77 INTEGER NOT NULL,
    INT78 INTEGER NOT NULL,
    INT83 INTEGER NOT NULL,
    INT84 INTEGER NOT NULL,
    INT85 INTEGER NOT NULL,
    INT88 INTEGER NOT NULL,
    INT89 INTEGER NOT NULL,
    INT90 INTEGER NOT NULL,
    INT92 INTEGER NOT NULL,
    INT93 INTEGER NOT NULL,
    INT94 INTEGER NOT NULL
);

ALTER TABLE FIELDSOFPRIMITIVEINT ADD CONSTRAINT FIELDSOFPRIMT6_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVELONG
(
    IDENTIFIER INTEGER NOT NULL,
    LONG0 BIGINT NOT NULL,
    LONG1 BIGINT NOT NULL,
    LONG102 BIGINT NOT NULL,
    LONG103 BIGINT NOT NULL,
    LONG104 BIGINT NOT NULL,
    LONG108 BIGINT NOT NULL,
    LONG109 BIGINT NOT NULL,
    LONG11 BIGINT NOT NULL,
    LONG110 BIGINT NOT NULL,
    LONG112 BIGINT NOT NULL,
    LONG113 BIGINT NOT NULL,
    LONG114 BIGINT NOT NULL,
    LONG119 BIGINT NOT NULL,
    LONG12 BIGINT NOT NULL,
    LONG120 BIGINT NOT NULL,
    LONG121 BIGINT NOT NULL,
    LONG124 BIGINT NOT NULL,
    LONG125 BIGINT NOT NULL,
    LONG126 BIGINT NOT NULL,
    LONG128 BIGINT NOT NULL,
    LONG129 BIGINT NOT NULL,
    LONG13 BIGINT NOT NULL,
    LONG130 BIGINT NOT NULL,
    LONG138 BIGINT NOT NULL,
    LONG139 BIGINT NOT NULL,
    LONG140 BIGINT NOT NULL,
    LONG16 BIGINT NOT NULL,
    LONG17 BIGINT NOT NULL,
    LONG18 BIGINT NOT NULL,
    LONG2 BIGINT NOT NULL,
    LONG20 BIGINT NOT NULL,
    LONG21 BIGINT NOT NULL,
    LONG22 BIGINT NOT NULL,
    LONG30 BIGINT NOT NULL,
    LONG31 BIGINT NOT NULL,
    LONG32 BIGINT NOT NULL,
    LONG36 BIGINT NOT NULL,
    LONG37 BIGINT NOT NULL,
    LONG38 BIGINT NOT NULL,
    LONG4 BIGINT NOT NULL,
    LONG40 BIGINT NOT NULL,
    LONG41 BIGINT NOT NULL,
    LONG42 BIGINT NOT NULL,
    LONG47 BIGINT NOT NULL,
    LONG48 BIGINT NOT NULL,
    LONG49 BIGINT NOT NULL,
    LONG5 BIGINT NOT NULL,
    LONG52 BIGINT NOT NULL,
    LONG53 BIGINT NOT NULL,
    LONG54 BIGINT NOT NULL,
    LONG56 BIGINT NOT NULL,
    LONG57 BIGINT NOT NULL,
    LONG58 BIGINT NOT NULL,
    LONG6 BIGINT NOT NULL,
    LONG66 BIGINT NOT NULL,
    LONG67 BIGINT NOT NULL,
    LONG68 BIGINT NOT NULL,
    LONG72 BIGINT NOT NULL,
    LONG73 BIGINT NOT NULL,
    LONG74 BIGINT NOT NULL,
    LONG76 BIGINT NOT NULL,
    LONG77 BIGINT NOT NULL,
    LONG78 BIGINT NOT NULL,
    LONG83 BIGINT NOT NULL,
    LONG84 BIGINT NOT NULL,
    LONG85 BIGINT NOT NULL,
    LONG88 BIGINT NOT NULL,
    LONG89 BIGINT NOT NULL,
    LONG90 BIGINT NOT NULL,
    LONG92 BIGINT NOT NULL,
    LONG93 BIGINT NOT NULL,
    LONG94 BIGINT NOT NULL
);

ALTER TABLE FIELDSOFPRIMITIVELONG ADD CONSTRAINT FIELDSOFPRIMLL_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFPRIMITIVESHORT
(
    IDENTIFIER INTEGER NOT NULL,
    SHORT0 SMALLINT NOT NULL,
    SHORT1 SMALLINT NOT NULL,
    SHORT102 SMALLINT NOT NULL,
    SHORT103 SMALLINT NOT NULL,
    SHORT104 SMALLINT NOT NULL,
    SHORT108 SMALLINT NOT NULL,
    SHORT109 SMALLINT NOT NULL,
    SHORT11 SMALLINT NOT NULL,
    SHORT110 SMALLINT NOT NULL,
    SHORT112 SMALLINT NOT NULL,
    SHORT113 SMALLINT NOT NULL,
    SHORT114 SMALLINT NOT NULL,
    SHORT119 SMALLINT NOT NULL,
    SHORT12 SMALLINT NOT NULL,
    SHORT120 SMALLINT NOT NULL,
    SHORT121 SMALLINT NOT NULL,
    SHORT124 SMALLINT NOT NULL,
    SHORT125 SMALLINT NOT NULL,
    SHORT126 SMALLINT NOT NULL,
    SHORT128 SMALLINT NOT NULL,
    SHORT129 SMALLINT NOT NULL,
    SHORT13 SMALLINT NOT NULL,
    SHORT130 SMALLINT NOT NULL,
    SHORT138 SMALLINT NOT NULL,
    SHORT139 SMALLINT NOT NULL,
    SHORT140 SMALLINT NOT NULL,
    SHORT16 SMALLINT NOT NULL,
    SHORT17 SMALLINT NOT NULL,
    SHORT18 SMALLINT NOT NULL,
    SHORT2 SMALLINT NOT NULL,
    SHORT20 SMALLINT NOT NULL,
    SHORT21 SMALLINT NOT NULL,
    SHORT22 SMALLINT NOT NULL,
    SHORT30 SMALLINT NOT NULL,
    SHORT31 SMALLINT NOT NULL,
    SHORT32 SMALLINT NOT NULL,
    SHORT36 SMALLINT NOT NULL,
    SHORT37 SMALLINT NOT NULL,
    SHORT38 SMALLINT NOT NULL,
    SHORT4 SMALLINT NOT NULL,
    SHORT40 SMALLINT NOT NULL,
    SHORT41 SMALLINT NOT NULL,
    SHORT42 SMALLINT NOT NULL,
    SHORT47 SMALLINT NOT NULL,
    SHORT48 SMALLINT NOT NULL,
    SHORT49 SMALLINT NOT NULL,
    SHORT5 SMALLINT NOT NULL,
    SHORT52 SMALLINT NOT NULL,
    SHORT53 SMALLINT NOT NULL,
    SHORT54 SMALLINT NOT NULL,
    SHORT56 SMALLINT NOT NULL,
    SHORT57 SMALLINT NOT NULL,
    SHORT58 SMALLINT NOT NULL,
    SHORT6 SMALLINT NOT NULL,
    SHORT66 SMALLINT NOT NULL,
    SHORT67 SMALLINT NOT NULL,
    SHORT68 SMALLINT NOT NULL,
    SHORT72 SMALLINT NOT NULL,
    SHORT73 SMALLINT NOT NULL,
    SHORT74 SMALLINT NOT NULL,
    SHORT76 SMALLINT NOT NULL,
    SHORT77 SMALLINT NOT NULL,
    SHORT78 SMALLINT NOT NULL,
    SHORT83 SMALLINT NOT NULL,
    SHORT84 SMALLINT NOT NULL,
    SHORT85 SMALLINT NOT NULL,
    SHORT88 SMALLINT NOT NULL,
    SHORT89 SMALLINT NOT NULL,
    SHORT90 SMALLINT NOT NULL,
    SHORT92 SMALLINT NOT NULL,
    SHORT93 SMALLINT NOT NULL,
    SHORT94 SMALLINT NOT NULL
);

ALTER TABLE FIELDSOFPRIMITIVESHORT ADD CONSTRAINT FIELDSOFPRIMXB_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFSHORT
(
    IDENTIFIER INTEGER NOT NULL,
    SHORT0 SMALLINT,
    SHORT1 SMALLINT,
    SHORT102 SMALLINT,
    SHORT103 SMALLINT,
    SHORT104 SMALLINT,
    SHORT108 SMALLINT,
    SHORT109 SMALLINT,
    SHORT11 SMALLINT,
    SHORT110 SMALLINT,
    SHORT112 SMALLINT,
    SHORT113 SMALLINT,
    SHORT114 SMALLINT,
    SHORT119 SMALLINT,
    SHORT12 SMALLINT,
    SHORT120 SMALLINT,
    SHORT121 SMALLINT,
    SHORT124 SMALLINT,
    SHORT125 SMALLINT,
    SHORT126 SMALLINT,
    SHORT128 SMALLINT,
    SHORT129 SMALLINT,
    SHORT13 SMALLINT,
    SHORT130 SMALLINT,
    SHORT138 SMALLINT,
    SHORT139 SMALLINT,
    SHORT140 SMALLINT,
    SHORT16 SMALLINT,
    SHORT17 SMALLINT,
    SHORT18 SMALLINT,
    SHORT2 SMALLINT,
    SHORT20 SMALLINT,
    SHORT21 SMALLINT,
    SHORT22 SMALLINT,
    SHORT30 SMALLINT,
    SHORT31 SMALLINT,
    SHORT32 SMALLINT,
    SHORT36 SMALLINT,
    SHORT37 SMALLINT,
    SHORT38 SMALLINT,
    SHORT4 SMALLINT,
    SHORT40 SMALLINT,
    SHORT41 SMALLINT,
    SHORT42 SMALLINT,
    SHORT47 SMALLINT,
    SHORT48 SMALLINT,
    SHORT49 SMALLINT,
    SHORT5 SMALLINT,
    SHORT52 SMALLINT,
    SHORT53 SMALLINT,
    SHORT54 SMALLINT,
    SHORT56 SMALLINT,
    SHORT57 SMALLINT,
    SHORT58 SMALLINT,
    SHORT6 SMALLINT,
    SHORT66 SMALLINT,
    SHORT67 SMALLINT,
    SHORT68 SMALLINT,
    SHORT72 SMALLINT,
    SHORT73 SMALLINT,
    SHORT74 SMALLINT,
    SHORT76 SMALLINT,
    SHORT77 SMALLINT,
    SHORT78 SMALLINT,
    SHORT83 SMALLINT,
    SHORT84 SMALLINT,
    SHORT85 SMALLINT,
    SHORT88 SMALLINT,
    SHORT89 SMALLINT,
    SHORT90 SMALLINT,
    SHORT92 SMALLINT,
    SHORT93 SMALLINT,
    SHORT94 SMALLINT
);

ALTER TABLE FIELDSOFSHORT ADD CONSTRAINT FIELDSOFSHORT_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FIELDSOFSTRING
(
    IDENTIFIER INTEGER NOT NULL,
    STRING0 VARCHAR(255),
    STRING1 VARCHAR(255),
    STRING102 VARCHAR(255),
    STRING103 VARCHAR(255),
    STRING104 VARCHAR(255),
    STRING108 VARCHAR(255),
    STRING109 VARCHAR(255),
    STRING11 VARCHAR(255),
    STRING110 VARCHAR(255),
    STRING112 VARCHAR(255),
    STRING113 VARCHAR(255),
    STRING114 VARCHAR(255),
    STRING119 VARCHAR(255),
    STRING12 VARCHAR(255),
    STRING120 VARCHAR(255),
    STRING121 VARCHAR(255),
    STRING124 VARCHAR(255),
    STRING125 VARCHAR(255),
    STRING126 VARCHAR(255),
    STRING128 VARCHAR(255),
    STRING129 VARCHAR(255),
    STRING13 VARCHAR(255),
    STRING130 VARCHAR(255),
    STRING138 VARCHAR(255),
    STRING139 VARCHAR(255),
    STRING140 VARCHAR(255),
    STRING16 VARCHAR(255),
    STRING17 VARCHAR(255),
    STRING18 VARCHAR(255),
    STRING2 VARCHAR(255),
    STRING20 VARCHAR(255),
    STRING21 VARCHAR(255),
    STRING22 VARCHAR(255),
    STRING30 VARCHAR(255),
    STRING31 VARCHAR(255),
    STRING32 VARCHAR(255),
    STRING36 VARCHAR(255),
    STRING37 VARCHAR(255),
    STRING38 VARCHAR(255),
    STRING4 VARCHAR(255),
    STRING40 VARCHAR(255),
    STRING41 VARCHAR(255),
    STRING42 VARCHAR(255),
    STRING47 VARCHAR(255),
    STRING48 VARCHAR(255),
    STRING49 VARCHAR(255),
    STRING5 VARCHAR(255),
    STRING52 VARCHAR(255),
    STRING53 VARCHAR(255),
    STRING54 VARCHAR(255),
    STRING56 VARCHAR(255),
    STRING57 VARCHAR(255),
    STRING58 VARCHAR(255),
    STRING6 VARCHAR(255),
    STRING66 VARCHAR(255),
    STRING67 VARCHAR(255),
    STRING68 VARCHAR(255),
    STRING72 VARCHAR(255),
    STRING73 VARCHAR(255),
    STRING74 VARCHAR(255),
    STRING76 VARCHAR(255),
    STRING77 VARCHAR(255),
    STRING78 VARCHAR(255),
    STRING83 VARCHAR(255),
    STRING84 VARCHAR(255),
    STRING85 VARCHAR(255),
    STRING88 VARCHAR(255),
    STRING89 VARCHAR(255),
    STRING90 VARCHAR(255),
    STRING92 VARCHAR(255),
    STRING93 VARCHAR(255),
    STRING94 VARCHAR(255)
);

ALTER TABLE FIELDSOFSTRING ADD CONSTRAINT FIELDSOFSTRING_PK PRIMARY KEY (IDENTIFIER);

CREATE TABLE FieldsOfByte (
    IDENTIFIER INTEGER NOT NULL,
    BYTE0 SMALLINT,
    BYTE1 SMALLINT,
    BYTE2 SMALLINT,
    BYTE4 SMALLINT,
    BYTE5 SMALLINT,
    BYTE6 SMALLINT,
    BYTE11 SMALLINT,
    BYTE12 SMALLINT,
    BYTE13 SMALLINT,
    BYTE16 SMALLINT,
    BYTE17 SMALLINT,
    BYTE18 SMALLINT,
    BYTE20 SMALLINT,
    BYTE21 SMALLINT,
    BYTE22 SMALLINT,
    BYTE30 SMALLINT,
    BYTE31 SMALLINT,
    BYTE32 SMALLINT,
    BYTE36 SMALLINT,
    BYTE37 SMALLINT,
    BYTE38 SMALLINT,
    BYTE40 SMALLINT,
    BYTE41 SMALLINT,
    BYTE42 SMALLINT,
    BYTE43 SMALLINT,
    BYTE47 SMALLINT,
    BYTE48 SMALLINT,
    BYTE49 SMALLINT,
    BYTE52 SMALLINT,
    BYTE53 SMALLINT,
    BYTE54 SMALLINT,
    BYTE56 SMALLINT,
    BYTE57 SMALLINT,
    BYTE58 SMALLINT,
    BYTE66 SMALLINT,
    BYTE67 SMALLINT,
    BYTE68 SMALLINT,
    BYTE72 SMALLINT,
    BYTE73 SMALLINT,
    BYTE74 SMALLINT,
    BYTE76 SMALLINT,
    BYTE77 SMALLINT,
    BYTE78 SMALLINT,
    BYTE83 SMALLINT,
    BYTE84 SMALLINT,
    BYTE85 SMALLINT,
    BYTE88 SMALLINT,
    BYTE89 SMALLINT,
    BYTE90 SMALLINT,
    BYTE92 SMALLINT,
    BYTE93 SMALLINT,
    BYTE94 SMALLINT,
    BYTE102 SMALLINT,
    BYTE103 SMALLINT,
    BYTE104 SMALLINT,
    BYTE108 SMALLINT,
    BYTE109 SMALLINT,
    BYTE110 SMALLINT,
    BYTE112 SMALLINT,
    BYTE113 SMALLINT,
    BYTE114 SMALLINT,
    BYTE119 SMALLINT,
    BYTE120 SMALLINT,
    BYTE121 SMALLINT,
    BYTE124 SMALLINT,
    BYTE125 SMALLINT,
    BYTE126 SMALLINT,
    BYTE128 SMALLINT,
    BYTE129 SMALLINT,
    BYTE130 SMALLINT,
    BYTE138 SMALLINT,
    BYTE139 SMALLINT,
    BYTE140 SMALLINT,
    CONSTRAINT FieldsOfByte_PK PRIMARY KEY (IDENTIFIER)
);


CREATE TABLE FIELDSOFSIMPLECLASS
(
    IDENTIFIER INTEGER NOT NULL,
    ID1 BIGINT, INTFIELD1 INTEGER, STRINGFIELD1 VARCHAR(1024),
    SIMPLECLASS0 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS102 BIGINT REFERENCES SIMPLE_CLASS,
    ID103 BIGINT, INTFIELD103 INTEGER, STRINGFIELD103 VARCHAR(1024),
    SIMPLECLASS104 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS108 BIGINT REFERENCES SIMPLE_CLASS,
    ID109 BIGINT, INTFIELD109 INTEGER, STRINGFIELD109 VARCHAR(1024),
    SIMPLECLASS11 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS110 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS112 BIGINT REFERENCES SIMPLE_CLASS,
    ID113 BIGINT, INTFIELD113 INTEGER, STRINGFIELD113 VARCHAR(1024),
    SIMPLECLASS114 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS119 BIGINT REFERENCES SIMPLE_CLASS,
    ID12 BIGINT, INTFIELD12 INTEGER, STRINGFIELD12 VARCHAR(1024),
    ID120 BIGINT, INTFIELD120 INTEGER, STRINGFIELD120 VARCHAR(1024),
    SIMPLECLASS121 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS124 BIGINT REFERENCES SIMPLE_CLASS,
    ID125 BIGINT, INTFIELD125 INTEGER, STRINGFIELD125 VARCHAR(1024),
    SIMPLECLASS126 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS128 BIGINT REFERENCES SIMPLE_CLASS,
    ID129 BIGINT, INTFIELD129 INTEGER, STRINGFIELD129 VARCHAR(1024),
    SIMPLECLASS13 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS130 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS138 BIGINT REFERENCES SIMPLE_CLASS,
    ID139 BIGINT, INTFIELD139 INTEGER, STRINGFIELD139 VARCHAR(1024),
    SIMPLECLASS140 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS16 BIGINT REFERENCES SIMPLE_CLASS,
    ID17 BIGINT, INTFIELD17 INTEGER, STRINGFIELD17 VARCHAR(1024),
    SIMPLECLASS18 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS2 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS20 BIGINT REFERENCES SIMPLE_CLASS,
    ID21 BIGINT, INTFIELD21 INTEGER, STRINGFIELD21 VARCHAR(1024),
    SIMPLECLASS22 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS30 BIGINT REFERENCES SIMPLE_CLASS,
    ID31 BIGINT, INTFIELD31 INTEGER, STRINGFIELD31 VARCHAR(1024),
    SIMPLECLASS32 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS36 BIGINT REFERENCES SIMPLE_CLASS,
    ID37 BIGINT, INTFIELD37 INTEGER, STRINGFIELD37 VARCHAR(1024),
    SIMPLECLASS38 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS4 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS40 BIGINT REFERENCES SIMPLE_CLASS,
    ID41 BIGINT, INTFIELD41 INTEGER, STRINGFIELD41 VARCHAR(1024),
    SIMPLECLASS42 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS47 BIGINT REFERENCES SIMPLE_CLASS,
    ID48 BIGINT, INTFIELD48 INTEGER, STRINGFIELD48 VARCHAR(1024),
    SIMPLECLASS49 BIGINT REFERENCES SIMPLE_CLASS,
    ID5 BIGINT, INTFIELD5 INTEGER, STRINGFIELD5 VARCHAR(1024),
    SIMPLECLASS52 BIGINT REFERENCES SIMPLE_CLASS,
    ID53 BIGINT, INTFIELD53 INTEGER, STRINGFIELD53 VARCHAR(1024),
    SIMPLECLASS54 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS56 BIGINT REFERENCES SIMPLE_CLASS,
    ID57 BIGINT, INTFIELD57 INTEGER, STRINGFIELD57 VARCHAR(1024),
    SIMPLECLASS58 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS6 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS66 BIGINT REFERENCES SIMPLE_CLASS,
    ID67 BIGINT, INTFIELD67 INTEGER, STRINGFIELD67 VARCHAR(1024),
    SIMPLECLASS68 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS72 BIGINT REFERENCES SIMPLE_CLASS,
    ID73 BIGINT, INTFIELD73 INTEGER, STRINGFIELD73 VARCHAR(1024),
    SIMPLECLASS74 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS76 BIGINT REFERENCES SIMPLE_CLASS,
    ID77 BIGINT, INTFIELD77 INTEGER, STRINGFIELD77 VARCHAR(1024),
    SIMPLECLASS78 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS83 BIGINT REFERENCES SIMPLE_CLASS,
    ID84 BIGINT, INTFIELD84 INTEGER, STRINGFIELD84 VARCHAR(1024),
    SIMPLECLASS85 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS88 BIGINT REFERENCES SIMPLE_CLASS,
    ID89 BIGINT, INTFIELD89 INTEGER, STRINGFIELD89 VARCHAR(1024),
    SIMPLECLASS90 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS92 BIGINT REFERENCES SIMPLE_CLASS,
    ID93 BIGINT, INTFIELD93 INTEGER, STRINGFIELD93 VARCHAR(1024),
    SIMPLECLASS94 BIGINT REFERENCES SIMPLE_CLASS,
    SIMPLECLASS144 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS145 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS146 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS147 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS148 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS149 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS150 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS151 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS152 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS153 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS154 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS155 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS156 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS157 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS158 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS159 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS160 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS161 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS162 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS163 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS164 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS165 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS166 LONG VARCHAR FOR BIT DATA,
    SIMPLECLASS167 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT FieldsOfSimpCls_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE ARRAY_COLLECTIONS
(
   IDENTIFIER INTEGER NOT NULL,
   ARRAY_OF_STRING6 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_DATE8 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_LOCALE10 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_BIG_DECIMAL12 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_BIG_INTEGER14 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_BYTE16 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_DOUBLE18 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_FLOAT20 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_INTEGER22 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_LONG24 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_SHORT26 LONG VARCHAR FOR BIT DATA,
   ARRAY_OF_SIMPLEENUM28 LONG VARCHAR FOR BIT DATA,
   CONSTRAINT AC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE ARRAY_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    OBJVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE ARRAY_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE ARRAY_OF_SIMPLE_CLASS2
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    OBJVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE ARRAY_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE ARRAY_OF_SIMPLE_INTERFACE4
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    OBJVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE ARRAY_OF_SIMPLE_INTERFACE5
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE ARRAY_OF_STRING7
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE ARRAY_OF_DATE9
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    DATEVAL TIMESTAMP
);

CREATE TABLE ARRAY_OF_LOCALE11
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    LOCALEVAL CHAR(20)
);

CREATE TABLE ARRAY_OF_BIG_DECIMAL13
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE ARRAY_OF_BIG_INTEGER15
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE ARRAY_OF_BYTE17
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    BYTEVAL SMALLINT
);

CREATE TABLE ARRAY_OF_DOUBLE19
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    DOUBLEVAL DOUBLE
);

CREATE TABLE ARRAY_OF_FLOAT21
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    FLOATVAL REAL
);

CREATE TABLE ARRAY_OF_INTEGER23
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    INTEGERVAL INTEGER
);

CREATE TABLE ARRAY_OF_LONG25
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    LONGVAL BIGINT
);

CREATE TABLE ARRAY_OF_SHORT27
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    SHORTVAL SMALLINT
);

CREATE TABLE ARRAY_OF_SIMPLEENUM29
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    ENUMVAL CHAR(2)
);

CREATE TABLE ARRAY_OF_SIMPLEENUM30
(
    IDENTIFIER INTEGER REFERENCES ARRAY_COLLECTIONS NOT NULL,
    ORDER_COL BIGINT,
    ENUMVAL NUMERIC(2,0)
);

--CollectionCollections

CREATE TABLE COLLECTION_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
    COLLECTION_OF_STRING11 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_DATE14 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_LOCALE17 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_BIG_DECIMAL20 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_BIG_INTEGER23 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_BYTE26 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_DOUBLE29 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_FLOAT32 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_INTEGER35 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_LONG38 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_SHORT41 LONG VARCHAR FOR BIT DATA,
    COLLECTION_OF_SIMPLE_CLASS42 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT CC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE COLLECTION_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE COLLECTION_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE COLLECTION_OF_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE COLLECTION_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE COLLECTION_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE COLLECTION_OF_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE COLLECTION_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE COLLECTION_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE COLLECTION_OF_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE COLLECTION_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE COLLECTION_OF_STRING10
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE COLLECTION_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE COLLECTION_OF_DATE13
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE COLLECTION_OF_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE COLLECTION_OF_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE COLLECTION_OF_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE COLLECTION_OF_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE COLLECTION_OF_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE COLLECTION_OF_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE COLLECTION_OF_BYTE24
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE COLLECTION_OF_BYTE25
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE COLLECTION_OF_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE COLLECTION_OF_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE COLLECTION_OF_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE COLLECTION_OF_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE COLLECTION_OF_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE COLLECTION_OF_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE COLLECTION_OF_LONG36
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE COLLECTION_OF_LONG37
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE COLLECTION_OF_SHORT39
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

CREATE TABLE COLLECTION_OF_SHORT40
(
    IDENTIFIER INTEGER REFERENCES COLLECTION_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

--ListCollections

CREATE TABLE LIST_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
    LIST_OF_STRING11 LONG VARCHAR FOR BIT DATA,
    LIST_OF_DATE14 LONG VARCHAR FOR BIT DATA,
    LIST_OF_LOCALE17 LONG VARCHAR FOR BIT DATA,
    LIST_OF_BIG_DECIMAL20 LONG VARCHAR FOR BIT DATA,
    LIST_OF_BIG_INTEGER23 LONG VARCHAR FOR BIT DATA,
    LIST_OF_BYTE26 LONG VARCHAR FOR BIT DATA,
    LIST_OF_DOUBLE29 LONG VARCHAR FOR BIT DATA,
    LIST_OF_FLOAT32 LONG VARCHAR FOR BIT DATA,
    LIST_OF_INTEGER35 LONG VARCHAR FOR BIT DATA,
    LIST_OF_LONG38 LONG VARCHAR FOR BIT DATA,
    LIST_OF_SHORT41 LONG VARCHAR FOR BIT DATA,
    LIST_OF_SIMPLE_CLASS42 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT LC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE LIST_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE LIST_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE LIST_OF_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE LIST_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE LIST_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE LIST_OF_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE LIST_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE LIST_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE LIST_OF_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE LIST_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE LIST_OF_STRING10
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE LIST_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE LIST_OF_DATE13
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE LIST_OF_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE LIST_OF_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE LIST_OF_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE LIST_OF_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE LIST_OF_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE LIST_OF_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE LIST_OF_BYTE24
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE LIST_OF_BYTE25
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE LIST_OF_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE LIST_OF_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE LIST_OF_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE LIST_OF_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE LIST_OF_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE LIST_OF_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE LIST_OF_LONG36
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE LIST_OF_LONG37
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE LIST_OF_SHORT39
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

CREATE TABLE LIST_OF_SHORT40
(
    IDENTIFIER INTEGER REFERENCES LIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

--ArrayListCollections

CREATE TABLE ARRAYLIST_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
	ARRAYLIST_OF_STRING10 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_DATE13 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_LOCALE16 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_BIG_DECIMAL19 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_BIG_INTEGER22 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_BYTE25 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_DOUBLE28 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_FLOAT31 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_INTEGER34 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_LONG37 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_SHORT40 LONG VARCHAR FOR BIT DATA,
	ARRAYLIST_OF_SIMPLEENUM43 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT ALC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE ARRAYLIST_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    INDEX INTEGER NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE ARRAYLIST_OF_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_STRING11
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_DATE14
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    LOCALEVAL CHAR(20),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_LOCALE17
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    LOCALEVAL CHAR(20),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_BIG_DECIMAL20
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_BIG_INTEGER23
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_BYTE24
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_BYTE26
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_DOUBLE29
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    FLOATVAL REAL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_FLOAT32
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    FLOATVAL REAL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_INTEGER35
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_LONG36
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    LONGVAL BIGINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_LONG38
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    LONGVAL BIGINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SHORT39
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SHORT41
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLEENUM42
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPLEENUMVAL CHAR(2),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLEENUM44
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPLEENUMVAL CHAR(2),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLEENUM45
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPLEENUMVAL NUMERIC(2,0),
    INDEX INTEGER NOT NULL
);

CREATE TABLE ARRAYLIST_OF_SIMPLEENUM46
(
    IDENTIFIER INTEGER REFERENCES ARRAYLIST_COLLECTIONS NOT NULL,
    SIMPLEENUMVAL NUMERIC(2,0),
    INDEX INTEGER NOT NULL
);

--LinkedListCollections

CREATE TABLE LINKEDLIST_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
    LINKEDLIST_OF_STRING11 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_DATE14 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_LOCALE17 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_BIG_DECIMAL20 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_BIG_INTEGER23 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_BYTE26 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_DOUBLE29 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_FLOAT32 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_INTEGER35 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_LONG38 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_SHORT41 LONG VARCHAR FOR BIT DATA,
    LINKEDLIST_OF_SIMPLE_CLASS42 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT LLC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE LINKEDLIST_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE LINKEDLIST_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE LINKEDLIST_OF_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE LINKEDLIST_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE LINKEDLIST_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE LINKEDLIST_OF_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE LINKEDLIST_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE LINKEDLIST_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE LINKEDLIST_OF_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE LINKEDLIST_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE LINKEDLIST_OF_STRING10
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE LINKEDLIST_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE LINKEDLIST_OF_DATE13
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE LINKEDLIST_OF_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE LINKEDLIST_OF_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE LINKEDLIST_OF_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE LINKEDLIST_OF_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE LINKEDLIST_OF_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE LINKEDLIST_OF_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE LINKEDLIST_OF_BYTE24
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE LINKEDLIST_OF_BYTE25
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE LINKEDLIST_OF_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE LINKEDLIST_OF_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE LINKEDLIST_OF_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE LINKEDLIST_OF_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE LINKEDLIST_OF_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE LINKEDLIST_OF_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE LINKEDLIST_OF_LONG36
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE LINKEDLIST_OF_LONG37
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE LINKEDLIST_OF_SHORT39
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

CREATE TABLE LINKEDLIST_OF_SHORT40
(
    IDENTIFIER INTEGER REFERENCES LINKEDLIST_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

--VectorCollections

CREATE TABLE VECTOR_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
	VECTOR_OF_STRING11 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_DATE14 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_LOCALE17 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_BIG_DECIMAL20 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_BIG_INTEGER23 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_BYTE26 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_DOUBLE29 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_FLOAT32 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_INTEGER35 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_LONG38 LONG VARCHAR FOR BIT DATA,
	VECTOR_OF_SHORT41 LONG VARCHAR FOR BIT DATA,
    VECTOR_OF_SIMPLE_CLASS42 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT VC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE VECTOR_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE VECTOR_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE VECTOR_OF_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE VECTOR_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE VECTOR_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE VECTOR_OF_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE VECTOR_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE VECTOR_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE VECTOR_OF_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
	COLLVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE VECTOR_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE VECTOR_OF_STRING10
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE VECTOR_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE VECTOR_OF_DATE13
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE VECTOR_OF_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE VECTOR_OF_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE VECTOR_OF_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE VECTOR_OF_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE VECTOR_OF_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE VECTOR_OF_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE VECTOR_OF_BYTE24
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE VECTOR_OF_BYTE25
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE VECTOR_OF_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE VECTOR_OF_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE VECTOR_OF_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE VECTOR_OF_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE VECTOR_OF_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE VECTOR_OF_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE VECTOR_OF_LONG36
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE VECTOR_OF_LONG37
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE VECTOR_OF_SHORT39
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

CREATE TABLE VECTOR_OF_SHORT40
(
    IDENTIFIER INTEGER REFERENCES VECTOR_COLLECTIONS NOT NULL,
    ALLOW_DUPLICATES BIGINT NOT NULL,
    SHORTVAL SMALLINT
);

--SetCollections

CREATE TABLE SET_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
    SET_OF_OBJECT2 LONG VARCHAR FOR BIT DATA,
    SET_OF_SIMPLE_CLASS5 LONG VARCHAR FOR BIT DATA,
    SET_OF_SIMPLE_INTERFACE8 LONG VARCHAR FOR BIT DATA,
    SET_OF_STRING11 LONG VARCHAR FOR BIT DATA,
    SET_OF_DATE14 LONG VARCHAR FOR BIT DATA,
    SET_OF_LOCALE17 LONG VARCHAR FOR BIT DATA,
    SET_OF_BIG_DECIMAL20 LONG VARCHAR FOR BIT DATA,
    SET_OF_BIG_INTEGER23 LONG VARCHAR FOR BIT DATA,
    SET_OF_BYTE26 LONG VARCHAR FOR BIT DATA,
    SET_OF_DOUBLE29 LONG VARCHAR FOR BIT DATA,
    SET_OF_FLOAT32 LONG VARCHAR FOR BIT DATA,
    SET_OF_INTEGER35 LONG VARCHAR FOR BIT DATA,
    SET_OF_LONG38 LONG VARCHAR FOR BIT DATA,
    SET_OF_SHORT41 LONG VARCHAR FOR BIT DATA,
    SET_OF_SIMPLE_CLASS42 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT SC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE SET_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE SET_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE SET_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE SET_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE SET_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE SET_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE SET_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE SET_OF_STRING10
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE SET_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE SET_OF_DATE13
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE SET_OF_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE SET_OF_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE SET_OF_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE SET_OF_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE SET_OF_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE SET_OF_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE SET_OF_BYTE24
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE SET_OF_BYTE25
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE SET_OF_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE SET_OF_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE SET_OF_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE SET_OF_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE SET_OF_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE SET_OF_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE SET_OF_LONG36
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE SET_OF_LONG37
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE SET_OF_SHORT39
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT
);

CREATE TABLE SET_OF_SHORT40
(
    IDENTIFIER INTEGER REFERENCES SET_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT
);

--HashSetCollections

CREATE TABLE HASHSET_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
    HASHSET_OF_OBJECT2 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_SIMPLE_CLASS5 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_SIMPLE_INTERFACE8 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_STRING11 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_DATE14 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_LOCALE17 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_BIG_DECIMAL20 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_BIG_INTEGER23 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_BYTE26 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_DOUBLE29 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_FLOAT32 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_INTEGER35 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_LONG38 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_SHORT41 LONG VARCHAR FOR BIT DATA,
    HASHSET_OF_SIMPLE_CLASS42 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT HSC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE HASHSET_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHSET_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHSET_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHSET_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHSET_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHSET_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHSET_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE HASHSET_OF_STRING10
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024)
);

CREATE TABLE HASHSET_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE HASHSET_OF_DATE13
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP
);

CREATE TABLE HASHSET_OF_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE HASHSET_OF_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    LOCALEVAL CHAR(20)
);

CREATE TABLE HASHSET_OF_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE HASHSET_OF_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16)
);

CREATE TABLE HASHSET_OF_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE HASHSET_OF_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31)
);

CREATE TABLE HASHSET_OF_BYTE24
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE HASHSET_OF_BYTE25
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT
);

CREATE TABLE HASHSET_OF_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE HASHSET_OF_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE
);

CREATE TABLE HASHSET_OF_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE HASHSET_OF_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    FLOATVAL REAL
);

CREATE TABLE HASHSET_OF_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE HASHSET_OF_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER
);

CREATE TABLE HASHSET_OF_LONG36
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE HASHSET_OF_LONG37
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    LONGVAL BIGINT
);

CREATE TABLE HASHSET_OF_SHORT39
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT
);

CREATE TABLE HASHSET_OF_SHORT40
(
    IDENTIFIER INTEGER REFERENCES HASHSET_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT
);

--TreeSetCollections

CREATE TABLE TREESET_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
	TREESET_OF_STRING10 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_DATE13 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_BIG_DECIMAL16 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_BIG_INTEGER19 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_BYTE22 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_DOUBLE25 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_FLOAT28 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_INTEGER31 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_LONG34 LONG VARCHAR FOR BIT DATA,
	TREESET_OF_SHORT37 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT TSC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE TREESET_OF_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_STRING9
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024),
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_STRING11
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    STRINGVAL VARCHAR(1024),
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_DATE12
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_DATE14
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    DATEVAL TIMESTAMP,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_BIG_DECIMAL15
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16),
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_BIG_DECIMAL17
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    BIG_DECIMALVAL DECIMAL(27,16),
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_BIG_INTEGER18
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31),
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_BIG_INTEGER20
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    BIG_INTEGERVAL NUMERIC(31),
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_BYTE21
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_BYTE23
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    BYTEVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_DOUBLE24
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_DOUBLE26
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    DOUBLEVAL DOUBLE,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_FLOAT27
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    FLOATVAL REAL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_FLOAT29
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    FLOATVAL REAL,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_INTEGER30
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_INTEGER32
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    INTEGERVAL INTEGER,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_LONG33
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    LONGVAL BIGINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_LONG35
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    LONGVAL BIGINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SHORT36
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

CREATE TABLE TREESET_OF_SHORT38
(
    IDENTIFIER INTEGER REFERENCES TREESET_COLLECTIONS NOT NULL,
    SHORTVAL SMALLINT,
    INDEX INTEGER NOT NULL
);

--MapOfStringKeyCollections

CREATE TABLE MAPSTRINGKEY_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
	MAP_OF_STRING_OBJECT86 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_SIMPLECLASS89 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_SIMPLEINTERFACE92 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_STRING95 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_DATE98 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_LOCALE101 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_BIGDECIMAL104 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_BIGINTEGER107 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_BYTE110 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_DOUBLE113 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_FLOAT116 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_INTEGER119 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_LONG122 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_SHORT125 LONG VARCHAR FOR BIT DATA,
	MAP_OF_STRING_SIMPLEENUM132 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT MSKC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE MAP_OF_STRING_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OF_STRING_STRING9
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE MAP_OF_STRING_STRING10
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE MAP_OF_STRING_STRING11
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE MAP_OF_STRING_DATE12
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE MAP_OF_STRING_DATE13
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE MAP_OF_STRING_DATE14
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE MAP_OF_STRING_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE MAP_OF_STRING_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE MAP_OF_STRING_LOCALE17
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_DECIMAL20
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_INTEGER23
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BYTE24
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_BYTE25
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_BYTE26
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE MAP_OF_STRING_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE MAP_OF_STRING_DOUBLE29
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE MAP_OF_STRING_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE MAP_OF_STRING_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE MAP_OF_STRING_FLOAT32
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE MAP_OF_STRING_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE MAP_OF_STRING_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE MAP_OF_STRING_INTEGER35
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE MAP_OF_STRING_LONG36
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_LONG37
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_LONG38
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_SHORT39
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_SHORT40
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_SHORT41
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_OBJECT42
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OF_STRING_OBJECT43
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_CLASS45
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_CLASS46
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_INTERFACE48
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLE_INTERFACE49
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OF_STRING_STRING51
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE MAP_OF_STRING_STRING52
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE MAP_OF_STRING_DATE54
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE MAP_OF_STRING_DATE55
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE MAP_OF_STRING_LOCALE57
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE MAP_OF_STRING_LOCALE58
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_DECIMAL60
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_DECIMAL61
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_INTEGER63
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_INTEGER64
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BYTE66
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_BYTE67
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_DOUBLE69
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE MAP_OF_STRING_DOUBLE70
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE MAP_OF_STRING_FLOAT72
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE MAP_OF_STRING_FLOAT73
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE MAP_OF_STRING_INTEGER75
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE MAP_OF_STRING_INTEGER76
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE MAP_OF_STRING_LONG78
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_LONG79
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_SHORT81
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_SHORT82
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_OBJECT84
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE MAP_OF_STRING_SIMPLE_CLASS87
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE MAP_OF_STRING_SIMPLE_INTERFACE90
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE MAP_OF_STRING_STRING93
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE MAP_OF_STRING_DATE96
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE MAP_OF_STRING_LOCALE99
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_DECIMAL102
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BIG_INTEGER105
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE MAP_OF_STRING_BYTE108
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_DOUBLE111
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE MAP_OF_STRING_FLOAT114
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE MAP_OF_STRING_INTEGER117
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE MAP_OF_STRING_LONG120
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_SHORT123
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM126
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(2) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM127
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(2) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM128
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(2) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM129
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(2) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM130
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(2) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM131
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(2) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM133
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(2,0) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM134
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(2,0) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM135
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100),
    VALUEVAL NUMERIC(2,0)
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM136
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(2,0) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM137
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(2,0) NOT NULL
);

CREATE TABLE MAP_OF_STRING_SIMPLEENUM138
(
    IDENTIFIER INTEGER REFERENCES MAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(2,0) NOT NULL
);

--HashMapOfStringKeyCollections

CREATE TABLE HASHMAPSTRINGKEY_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
	HASHMAP_STR_OBJECT86 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_SIMPLECLASS89 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_SIMPLEINTERFACE92 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_STRING95 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_DATE98 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_LOCALE101 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_BIGDECIMAL104 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_BIGINTEGER107 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_BYTE110 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_DOUBLE113 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_FLOAT116 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_INTEGER119 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_LONG122 LONG VARCHAR FOR BIT DATA,
	HASHMAP_STR_SHORT125 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT HMSKC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE HASHMAP_STR_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_STR_STRING9
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHMAP_STR_STRING10
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHMAP_STR_STRING11
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHMAP_STR_DATE12
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHMAP_STR_DATE13
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHMAP_STR_DATE14
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHMAP_STR_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHMAP_STR_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHMAP_STR_LOCALE17
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_DECIMAL20
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_INTEGER23
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHMAP_STR_BYTE24
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_BYTE25
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_BYTE26
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHMAP_STR_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHMAP_STR_DOUBLE29
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHMAP_STR_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHMAP_STR_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHMAP_STR_FLOAT32
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHMAP_STR_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHMAP_STR_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHMAP_STR_INTEGER35
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHMAP_STR_LONG36
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHMAP_STR_LONG37
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHMAP_STR_LONG38
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHMAP_STR_SHORT39
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_SHORT40
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_SHORT41
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_OBJECT42
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_STR_OBJECT43
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_CLASS45
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_CLASS46
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_INTERFACE48
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_STR_SIMPLE_INTERFACE49
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_STR_STRING51
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHMAP_STR_STRING52
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHMAP_STR_DATE54
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHMAP_STR_DATE55
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHMAP_STR_LOCALE57
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHMAP_STR_LOCALE58
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_DECIMAL60
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_DECIMAL61
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_INTEGER63
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_INTEGER64
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHMAP_STR_BYTE66
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_BYTE67
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_DOUBLE69
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHMAP_STR_DOUBLE70
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHMAP_STR_FLOAT72
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHMAP_STR_FLOAT73
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHMAP_STR_INTEGER75
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHMAP_STR_INTEGER76
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHMAP_STR_LONG78
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHMAP_STR_LONG79
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHMAP_STR_SHORT81
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_SHORT82
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_OBJECT84
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE HASHMAP_STR_SIMPLE_CLASS87
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE HASHMAP_STR_SIMPLE_INTERFACE90
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE HASHMAP_STR_STRING93
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHMAP_STR_DATE96
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHMAP_STR_LOCALE99
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_DECIMAL102
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHMAP_STR_BIG_INTEGER105
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHMAP_STR_BYTE108
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHMAP_STR_DOUBLE111
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHMAP_STR_FLOAT114
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHMAP_STR_INTEGER117
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHMAP_STR_LONG120
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHMAP_STR_SHORT123
(
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

--HashtableOfStringKeyCollections

CREATE TABLE HASHTABLESTRINGKEY_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
	HASHTBL_STR_OBJECT86 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_SIMPLECLASS89 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_SIMPLEINTERFACE92 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_STRING95 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_DATE98 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_LOCALE101 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_BIGDECIMAL104 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_BIGINTEGER107 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_BYTE110 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_DOUBLE113 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_FLOAT116 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_INTEGER119 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_LONG122 LONG VARCHAR FOR BIT DATA,
	HASHTBL_STR_SHORT125 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT HTSKC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE HASHTBL_STR_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_STR_STRING9
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHTBL_STR_STRING10
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHTBL_STR_STRING11
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHTBL_STR_DATE12
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHTBL_STR_DATE13
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHTBL_STR_DATE14
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHTBL_STR_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHTBL_STR_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHTBL_STR_LOCALE17
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_DECIMAL20
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_INTEGER23
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHTBL_STR_BYTE24
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_BYTE25
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_BYTE26
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHTBL_STR_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHTBL_STR_DOUBLE29
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHTBL_STR_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHTBL_STR_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHTBL_STR_FLOAT32
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHTBL_STR_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHTBL_STR_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHTBL_STR_INTEGER35
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHTBL_STR_LONG36
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHTBL_STR_LONG37
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHTBL_STR_LONG38
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHTBL_STR_SHORT39
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_SHORT40
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_SHORT41
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_OBJECT42
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_STR_OBJECT43
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_CLASS45
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
     ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_CLASS46
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_INTERFACE48
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_STR_SIMPLE_INTERFACE49
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_STR_STRING51
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHTBL_STR_STRING52
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHTBL_STR_DATE54
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHTBL_STR_DATE55
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHTBL_STR_LOCALE57
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHTBL_STR_LOCALE58
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_DECIMAL60
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_DECIMAL61
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_INTEGER63
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_INTEGER64
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHTBL_STR_BYTE66
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_BYTE67
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_DOUBLE69
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHTBL_STR_DOUBLE70
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHTBL_STR_FLOAT72
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHTBL_STR_FLOAT73
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHTBL_STR_INTEGER75
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHTBL_STR_INTEGER76
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHTBL_STR_LONG78
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHTBL_STR_LONG79
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHTBL_STR_SHORT81
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_SHORT82
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_OBJECT84
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE HASHTBL_STR_SIMPLE_CLASS87
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE HASHTBL_STR_SIMPLE_INTERFACE90
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE HASHTBL_STR_STRING93
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE HASHTBL_STR_DATE96
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE HASHTBL_STR_LOCALE99
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_DECIMAL102
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE HASHTBL_STR_BIG_INTEGER105
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE HASHTBL_STR_BYTE108
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE HASHTBL_STR_DOUBLE111
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE HASHTBL_STR_FLOAT114
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE HASHTBL_STR_INTEGER117
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE HASHTBL_STR_LONG120
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE HASHTBL_STR_SHORT123
(
    IDENTIFIER INTEGER REFERENCES HASHTABLESTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

--HashMapOfStringValueCollections

CREATE TABLE HASHMAPSTRINGVALUE_COLLECTIONS (
    IDENTIFIER INTEGER NOT NULL,
    HASHMAP_OBJECT8_STR LONG VARCHAR FOR BIT DATA,
    HASHMAP_SIMPLE_CLASS17_STR LONG VARCHAR FOR BIT DATA,
    HASHMAP_SIMPLE_INTERFACE26_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_STRING35_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_DATE44_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_BIG_DECIMAL53_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_BIG_INTEGER62_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_BYTE71_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_DOUBLE80_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_FLOAT89_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_INTEGER98_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_LONG107_STR LONG VARCHAR FOR BIT DATA,
	HASHMAP_SHORT116_STR LONG VARCHAR FOR BIT DATA,
    CONSTRAINT HMSVC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE HASHMAP_OBJECT0_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_OBJECT1_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_OBJECT2_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_OBJECT3_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_OBJECT4_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_OBJECT6_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_CLASS9_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_CLASS10_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_CLASS11_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_CLASS12_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_CLASS13_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_CLASS15_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_INTERFACE18_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_INTERFACE19_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_INTERFACE20_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_INTERFACE21_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_INTERFACE22_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_SIMPLE_INTERFACE24_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHMAP_STRING27_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHMAP_STRING28_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHMAP_STRING29_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHMAP_STRING30_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHMAP_STRING31_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHMAP_STRING33_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHMAP_DATE36_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHMAP_DATE37_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHMAP_DATE38_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHMAP_DATE39_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHMAP_DATE40_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHMAP_DATE42_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHMAP_BIG_DECIMAL45_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHMAP_BIG_DECIMAL46_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHMAP_BIG_DECIMAL47_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHMAP_BIG_DECIMAL48_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHMAP_BIG_DECIMAL49_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHMAP_BIG_DECIMAL51_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHMAP_BIG_INTEGER54_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHMAP_BIG_INTEGER55_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHMAP_BIG_INTEGER56_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHMAP_BIG_INTEGER57_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHMAP_BIG_INTEGER58_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHMAP_BIG_INTEGER60_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHMAP_BYTE63_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_BYTE64_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_BYTE65_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_BYTE66_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_BYTE67_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_BYTE69_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_DOUBLE72_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHMAP_DOUBLE73_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHMAP_DOUBLE74_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHMAP_DOUBLE75_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHMAP_DOUBLE76_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHMAP_DOUBLE78_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHMAP_FLOAT81_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHMAP_FLOAT82_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHMAP_FLOAT83_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHMAP_FLOAT84_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHMAP_FLOAT85_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHMAP_FLOAT87_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHMAP_INTEGER90_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHMAP_INTEGER91_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHMAP_INTEGER92_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHMAP_INTEGER93_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHMAP_INTEGER94_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHMAP_INTEGER96_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHMAP_LONG99_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHMAP_LONG100_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHMAP_LONG101_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHMAP_LONG102_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHMAP_LONG103_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHMAP_LONG105_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHMAP_SHORT108_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_SHORT109_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_SHORT110_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_SHORT111_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_SHORT112_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHMAP_SHORT114_STR (
    IDENTIFIER INTEGER REFERENCES HASHMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

--HashtableOfStringValueCollections

CREATE TABLE HASHTBLSTRINGVALUE_COLLECTIONS (
    IDENTIFIER INTEGER NOT NULL,
    HASHTBL_OBJECT8_STR LONG VARCHAR FOR BIT DATA,
    HASHTBL_SIMPLE_CLASS17_STR LONG VARCHAR FOR BIT DATA,
    HASHTBL_SIMPLE_INTERFACE26_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_STRING35_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_DATE44_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_BIG_DECIMAL53_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_BIG_INTEGER62_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_BYTE71_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_DOUBLE80_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_FLOAT89_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_INTEGER98_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_LONG107_STR LONG VARCHAR FOR BIT DATA,
	HASHTBL_SHORT116_STR LONG VARCHAR FOR BIT DATA,
    CONSTRAINT HTSVC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE HASHTBL_OBJECT0_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_OBJECT1_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_OBJECT2_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_OBJECT3_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_OBJECT4_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_OBJECT6_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_CLASS9_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_CLASS10_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_CLASS11_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_CLASS12_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_CLASS13_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_CLASS15_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_INTERFACE18_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_INTERFACE19_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_INTERFACE20_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_INTERFACE21_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_INTERFACE22_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_SIMPLE_INTERFACE24_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE HASHTBL_STRING27_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHTBL_STRING28_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHTBL_STRING29_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHTBL_STRING30_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHTBL_STRING31_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHTBL_STRING33_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE HASHTBL_DATE36_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHTBL_DATE37_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHTBL_DATE38_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHTBL_DATE39_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHTBL_DATE40_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHTBL_DATE42_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE HASHTBL_BIG_DECIMAL45_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHTBL_BIG_DECIMAL46_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHTBL_BIG_DECIMAL47_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHTBL_BIG_DECIMAL48_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHTBL_BIG_DECIMAL49_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHTBL_BIG_DECIMAL51_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE HASHTBL_BIG_INTEGER54_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHTBL_BIG_INTEGER55_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHTBL_BIG_INTEGER56_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHTBL_BIG_INTEGER57_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHTBL_BIG_INTEGER58_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHTBL_BIG_INTEGER60_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE HASHTBL_BYTE63_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_BYTE64_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_BYTE65_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_BYTE66_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_BYTE67_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_BYTE69_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_DOUBLE72_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHTBL_DOUBLE73_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHTBL_DOUBLE74_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHTBL_DOUBLE75_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHTBL_DOUBLE76_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHTBL_DOUBLE78_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE HASHTBL_FLOAT81_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHTBL_FLOAT82_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHTBL_FLOAT83_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHTBL_FLOAT84_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHTBL_FLOAT85_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHTBL_FLOAT87_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE HASHTBL_INTEGER90_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHTBL_INTEGER91_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHTBL_INTEGER92_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHTBL_INTEGER93_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHTBL_INTEGER94_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHTBL_INTEGER96_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE HASHTBL_LONG99_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHTBL_LONG100_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHTBL_LONG101_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHTBL_LONG102_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHTBL_LONG103_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHTBL_LONG105_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE HASHTBL_SHORT108_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_SHORT109_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_SHORT110_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_SHORT111_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_SHORT112_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE HASHTBL_SHORT114_STR (
    IDENTIFIER INTEGER REFERENCES HASHTBLSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

--TreeMapOfStringValueCollections

CREATE TABLE TREEMAPSTRINGVALUE_COLLECTIONS (
    IDENTIFIER INTEGER NOT NULL,
    TREEMAP_OBJECT8_STR LONG VARCHAR FOR BIT DATA,
    TREEMAP_SIMPLE_CLASS17_STR LONG VARCHAR FOR BIT DATA,
    TREEMAP_SIMPLE_INTERFACE26_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_STRING35_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_DATE44_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_BIG_DECIMAL53_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_BIG_INTEGER62_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_BYTE71_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_DOUBLE80_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_FLOAT89_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_INTEGER98_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_LONG107_STR LONG VARCHAR FOR BIT DATA,
	TREEMAP_SHORT116_STR LONG VARCHAR FOR BIT DATA,
    CONSTRAINT TMSVC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE TREEMAP_OBJECT0_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_OBJECT1_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_OBJECT2_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_OBJECT3_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_OBJECT4_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_OBJECT6_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_CLASS9_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_CLASS10_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_CLASS11_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_CLASS12_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_CLASS13_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_CLASS15_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_INTERFACE18_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_INTERFACE19_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_INTERFACE20_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_INTERFACE21_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_INTERFACE22_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_SIMPLE_INTERFACE24_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_STRING27_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE TREEMAP_STRING28_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE TREEMAP_STRING29_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE TREEMAP_STRING30_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE TREEMAP_STRING31_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE TREEMAP_STRING33_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE TREEMAP_DATE36_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE TREEMAP_DATE37_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE TREEMAP_DATE38_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE TREEMAP_DATE39_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE TREEMAP_DATE40_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE TREEMAP_DATE42_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE TREEMAP_BIG_DECIMAL45_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE TREEMAP_BIG_DECIMAL46_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE TREEMAP_BIG_DECIMAL47_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE TREEMAP_BIG_DECIMAL48_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE TREEMAP_BIG_DECIMAL49_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE TREEMAP_BIG_DECIMAL51_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE TREEMAP_BIG_INTEGER54_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE TREEMAP_BIG_INTEGER55_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE TREEMAP_BIG_INTEGER56_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE TREEMAP_BIG_INTEGER57_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE TREEMAP_BIG_INTEGER58_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE TREEMAP_BIG_INTEGER60_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE TREEMAP_BYTE63_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_BYTE64_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_BYTE65_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_BYTE66_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_BYTE67_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_BYTE69_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_DOUBLE72_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE TREEMAP_DOUBLE73_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE TREEMAP_DOUBLE74_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE TREEMAP_DOUBLE75_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE TREEMAP_DOUBLE76_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE TREEMAP_DOUBLE78_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE TREEMAP_FLOAT81_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE TREEMAP_FLOAT82_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE TREEMAP_FLOAT83_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE TREEMAP_FLOAT84_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE TREEMAP_FLOAT85_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE TREEMAP_FLOAT87_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE TREEMAP_INTEGER90_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE TREEMAP_INTEGER91_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE TREEMAP_INTEGER92_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE TREEMAP_INTEGER93_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE TREEMAP_INTEGER94_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE TREEMAP_INTEGER96_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE TREEMAP_LONG99_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE TREEMAP_LONG100_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE TREEMAP_LONG101_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE TREEMAP_LONG102_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE TREEMAP_LONG103_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE TREEMAP_LONG105_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE TREEMAP_SHORT108_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_SHORT109_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_SHORT110_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_SHORT111_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_SHORT112_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE TREEMAP_SHORT114_STR (
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

--MapOfStringValueCollections

CREATE TABLE MAPSTRINGVALUE_COLLECTIONS (
    IDENTIFIER INTEGER NOT NULL,
    MAP_OBJECT8_STR LONG VARCHAR FOR BIT DATA,
    MAP_SIMPLE_CLASS17_STR LONG VARCHAR FOR BIT DATA,
    MAP_SIMPLE_INTERFACE26_STR LONG VARCHAR FOR BIT DATA,
	MAP_STRING35_STR LONG VARCHAR FOR BIT DATA,
	MAP_DATE44_STR LONG VARCHAR FOR BIT DATA,
	MAP_BIG_DECIMAL53_STR LONG VARCHAR FOR BIT DATA,
	MAP_BIG_INTEGER62_STR LONG VARCHAR FOR BIT DATA,
	MAP_BYTE71_STR LONG VARCHAR FOR BIT DATA,
	MAP_DOUBLE80_STR LONG VARCHAR FOR BIT DATA,
	MAP_FLOAT89_STR LONG VARCHAR FOR BIT DATA,
	MAP_INTEGER98_STR LONG VARCHAR FOR BIT DATA,
	MAP_LONG107_STR LONG VARCHAR FOR BIT DATA,
	MAP_SHORT116_STR LONG VARCHAR FOR BIT DATA,
	MAP_SIMPLEENUM123_STR LONG VARCHAR FOR BIT DATA,
    CONSTRAINT MSVC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE MAP_OBJECT0_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OBJECT1_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OBJECT2_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_OBJECT3_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OBJECT4_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_OBJECT6_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_SIMPLE_CLASS9_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_SIMPLE_CLASS10_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_SIMPLE_CLASS11_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_SIMPLE_CLASS12_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_SIMPLE_CLASS13_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_SIMPLE_CLASS15_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_SIMPLE_INTERFACE18_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_SIMPLE_INTERFACE19_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_SIMPLE_INTERFACE20_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE MAP_SIMPLE_INTERFACE21_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_SIMPLE_INTERFACE22_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_SIMPLE_INTERFACE24_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE MAP_STRING27_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE MAP_STRING28_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE MAP_STRING29_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE MAP_STRING30_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE MAP_STRING31_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE MAP_STRING33_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL VARCHAR(1024)
);

CREATE TABLE MAP_DATE36_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE MAP_DATE37_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE MAP_DATE38_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE MAP_DATE39_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE MAP_DATE40_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE MAP_DATE42_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL TIMESTAMP
);

CREATE TABLE MAP_BIG_DECIMAL45_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE MAP_BIG_DECIMAL46_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE MAP_BIG_DECIMAL47_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE MAP_BIG_DECIMAL48_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE MAP_BIG_DECIMAL49_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE MAP_BIG_DECIMAL51_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DECIMAL(27,16)
);

CREATE TABLE MAP_BIG_INTEGER54_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE MAP_BIG_INTEGER55_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE MAP_BIG_INTEGER56_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE MAP_BIG_INTEGER57_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE MAP_BIG_INTEGER58_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE MAP_BIG_INTEGER60_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(31)
);

CREATE TABLE MAP_BYTE63_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_BYTE64_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_BYTE65_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_BYTE66_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_BYTE67_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_BYTE69_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_DOUBLE72_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE MAP_DOUBLE73_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE MAP_DOUBLE74_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE MAP_DOUBLE75_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE MAP_DOUBLE76_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE MAP_DOUBLE78_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL DOUBLE
);

CREATE TABLE MAP_FLOAT81_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE MAP_FLOAT82_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE MAP_FLOAT83_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE MAP_FLOAT84_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE MAP_FLOAT85_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE MAP_FLOAT87_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL REAL
);

CREATE TABLE MAP_INTEGER90_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE MAP_INTEGER91_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE MAP_INTEGER92_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE MAP_INTEGER93_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE MAP_INTEGER94_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE MAP_INTEGER96_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL INTEGER
);

CREATE TABLE MAP_LONG99_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE MAP_LONG100_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE MAP_LONG101_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE MAP_LONG102_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE MAP_LONG103_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE MAP_LONG105_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL BIGINT
);

CREATE TABLE MAP_SHORT108_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_SHORT109_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_SHORT110_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_SHORT111_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_SHORT112_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_SHORT114_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL SMALLINT
);

CREATE TABLE MAP_SIMPLEENUM117_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL CHAR(2)
);

CREATE TABLE MAP_SIMPLEENUM118_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL CHAR(2)
);

CREATE TABLE MAP_SIMPLEENUM119_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL CHAR(2)
);

CREATE TABLE MAP_SIMPLEENUM120_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL CHAR(2)
);

CREATE TABLE MAP_SIMPLEENUM121_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL CHAR(2)
);

CREATE TABLE MAP_SIMPLEENUM122_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL CHAR(2)
);

CREATE TABLE MAP_SIMPLEENUM124_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(2,0)
);

CREATE TABLE MAP_SIMPLEENUM125_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(2,0)
);

CREATE TABLE MAP_SIMPLEENUM126_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(2,0)
);

CREATE TABLE MAP_SIMPLEENUM127_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(2,0)
);

CREATE TABLE MAP_SIMPLEENUM128_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(2,0)
);

CREATE TABLE MAP_SIMPLEENUM129_STR (
    IDENTIFIER INTEGER REFERENCES MAPSTRINGVALUE_COLLECTIONS NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL,
    KEYVAL NUMERIC(2,0)
);

--TreeMapOfStringKeyCollections

CREATE TABLE TREEMAPSTRINGKEY_COLLECTIONS
(
    IDENTIFIER INTEGER NOT NULL,
	TREEMAP_STR_OBJECT86 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_SIMPLECLASS89 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_SIMPLEINTERFACE92 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_STRING95 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_DATE98 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_LOCALE101 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_BIGDECIMAL104 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_BIGINTEGER107 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_BYTE110 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_DOUBLE113 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_FLOAT116 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_INTEGER119 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_LONG122 LONG VARCHAR FOR BIT DATA,
	TREEMAP_STR_SHORT125 LONG VARCHAR FOR BIT DATA,
    CONSTRAINT TMSKC_PK PRIMARY KEY (IDENTIFIER)
);

CREATE TABLE TREEMAP_STR_OBJECT0
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_OBJECT1
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_OBJECT2
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    OBJREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_CLASS3
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_CLASS4
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_CLASS5
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPCLSREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_INTERFACE6
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_INTERFACE7
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_INTERFACE8
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    SIMPINTREF BIGINT REFERENCES SIMPLE_CLASS NOT NULL
);

CREATE TABLE TREEMAP_STR_STRING9
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE TREEMAP_STR_STRING10
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE TREEMAP_STR_STRING11
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE TREEMAP_STR_DATE12
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE TREEMAP_STR_DATE13
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE TREEMAP_STR_DATE14
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE TREEMAP_STR_LOCALE15
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE TREEMAP_STR_LOCALE16
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE TREEMAP_STR_LOCALE17
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_DECIMAL18
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_DECIMAL19
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_DECIMAL20
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_INTEGER21
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_INTEGER22
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_INTEGER23
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE TREEMAP_STR_BYTE24
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_BYTE25
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_BYTE26
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_DOUBLE27
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE TREEMAP_STR_DOUBLE28
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE TREEMAP_STR_DOUBLE29
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE TREEMAP_STR_FLOAT30
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE TREEMAP_STR_FLOAT31
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE TREEMAP_STR_FLOAT32
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE TREEMAP_STR_INTEGER33
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE TREEMAP_STR_INTEGER34
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE TREEMAP_STR_INTEGER35
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE TREEMAP_STR_LONG36
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE TREEMAP_STR_LONG37
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE TREEMAP_STR_LONG38
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE TREEMAP_STR_SHORT39
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_SHORT40
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_SHORT41
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_OBJECT42
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_STR_OBJECT43
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_CLASS45
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_CLASS46
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_INTERFACE48
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_STR_SIMPLE_INTERFACE49
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    ID BIGINT NOT NULL,
    INTVAL INTEGER NOT NULL,
    STRINGVAL VARCHAR(128) NOT NULL
);

CREATE TABLE TREEMAP_STR_STRING51
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE TREEMAP_STR_STRING52
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE TREEMAP_STR_DATE54
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE TREEMAP_STR_DATE55
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE TREEMAP_STR_LOCALE57
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE TREEMAP_STR_LOCALE58
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_DECIMAL60
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_DECIMAL61
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_INTEGER63
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_INTEGER64
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE TREEMAP_STR_BYTE66
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_BYTE67
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_DOUBLE69
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE TREEMAP_STR_DOUBLE70
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE TREEMAP_STR_FLOAT72
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE TREEMAP_STR_FLOAT73
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE TREEMAP_STR_INTEGER75
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE TREEMAP_STR_INTEGER76
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE TREEMAP_STR_LONG78
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE TREEMAP_STR_LONG79
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE TREEMAP_STR_SHORT81
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_SHORT82
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_OBJECT84
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE TREEMAP_STR_SIMPLE_CLASS87
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE TREEMAP_STR_SIMPLE_INTERFACE90
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
	VALUEVAL LONG VARCHAR FOR BIT DATA
);

CREATE TABLE TREEMAP_STR_STRING93
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL VARCHAR(100) NOT NULL
);

CREATE TABLE TREEMAP_STR_DATE96
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL TIMESTAMP NOT NULL
);

CREATE TABLE TREEMAP_STR_LOCALE99
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL CHAR(20) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_DECIMAL102
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DECIMAL(27,16) NOT NULL
);

CREATE TABLE TREEMAP_STR_BIG_INTEGER105
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL NUMERIC(31) NOT NULL
);

CREATE TABLE TREEMAP_STR_BYTE108
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

CREATE TABLE TREEMAP_STR_DOUBLE111
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL DOUBLE NOT NULL
);

CREATE TABLE TREEMAP_STR_FLOAT114
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL REAL NOT NULL
);

CREATE TABLE TREEMAP_STR_INTEGER117
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL INTEGER NOT NULL
);

CREATE TABLE TREEMAP_STR_LONG120
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL BIGINT NOT NULL
);

CREATE TABLE TREEMAP_STR_SHORT123
(
    IDENTIFIER INTEGER REFERENCES TREEMAPSTRINGKEY_COLLECTIONS NOT NULL,
    KEYVAL VARCHAR(100) NOT NULL,
    VALUEVAL SMALLINT NOT NULL
);

-------------------------
--inheritance
-------------------------

DROP TABLE AllPersist;
DROP TABLE TopNonPersistB;
DROP TABLE TopPersist;
DROP TABLE FieldSameName;

CREATE TABLE AllPersist (
    KEY_VALUE INTEGER NOT NULL,
    DOUBLE_B DOUBLE,
    INT_B INTEGER,
    FLOAT_E REAL,
    SHORT_F SMALLINT,
    SECOND_OBJ INTEGER,
    THIRD_OBJ INTEGER,
    INT_H INTEGER,
    DISCRIMINATOR varchar(64) NOT NULL,
    CONSTRAINT AllPersist_PK PRIMARY KEY (KEY_VALUE),
    FOREIGN KEY (SECOND_OBJ) REFERENCES AllPersist (KEY_VALUE),
    FOREIGN KEY (THIRD_OBJ) REFERENCES AllPersist (KEY_VALUE)
);

CREATE TABLE TopNonPersistB (
    KEY_VALUE INTEGER NOT NULL,
    DOUBLE_B DOUBLE,
    INT_B INTEGER,
    FLOAT_E REAL,
    SHORT_F SMALLINT,
    SECOND_OBJ INTEGER,
    THIRD_OBJ INTEGER,
    INT_H INTEGER,
    DISCRIMINATOR varchar(64) NOT NULL,
    CONSTRAINT TopNonPersistB_PK PRIMARY KEY (KEY_VALUE),
    FOREIGN KEY (SECOND_OBJ) REFERENCES TopNonPersistB (KEY_VALUE),
    FOREIGN KEY (THIRD_OBJ) REFERENCES TopNonPersistB (KEY_VALUE)
);

CREATE TABLE TopPersist (
    KEY_VALUE INTEGER NOT NULL,
    DOUBLE_B DOUBLE,
    INT_B INTEGER,
    FLOAT_E REAL,
    SHORT_F SMALLINT,
    SECOND_OBJ INTEGER,
    THIRD_OBJ INTEGER,
    INT_H INTEGER,
    DISCRIMINATOR varchar(64) NOT NULL,
    CONSTRAINT TopPersist_PK PRIMARY KEY (KEY_VALUE),
    FOREIGN KEY (SECOND_OBJ) REFERENCES TopPersist (KEY_VALUE),
    FOREIGN KEY (THIRD_OBJ) REFERENCES TopPersist (KEY_VALUE)
);

CREATE TABLE FieldSameName (
    KEY_VALUE INTEGER NOT NULL,
    N2 DOUBLE,
    N3 INTEGER,
    FSN2_N3 REAL,
    FSN3_N1 SMALLINT,
    FSN3_N2 INTEGER,
    FSN3_N3 INTEGER,
    FSN4_N3 INTEGER,
    DISCRIMINATOR varchar(64) NOT NULL,
    CONSTRAINT FieldSameName_PK PRIMARY KEY (KEY_VALUE),
    FOREIGN KEY (FSN3_N2) REFERENCES FieldSameName (KEY_VALUE),
    FOREIGN KEY (FSN3_N3) REFERENCES FieldSameName (KEY_VALUE)
);

-------------------------
--instancecallbacks
-------------------------

DROP TABLE ICNonPersistFds;
DROP TABLE InstanceCallbacks;

CREATE TABLE ICNonPersistFds (
    ICKEY INTEGER NOT NULL,
    D DOUBLE,
    S SMALLINT,
    FLOATVAL REAL,
    INTVAL INTEGER,
    CONSTRAINT ICNP_PK PRIMARY KEY (ICKEY)
);

CREATE TABLE InstanceCallbacks (
    ICKEY INTEGER NOT NULL,
    NAME VARCHAR(64),
    TIMEDATE TIMESTAMP,
    NEXTOBJ INTEGER,
    PARENT INTEGER,
    INTVAL INTEGER,
    DOUBLEVAL DOUBLE,
    CHILD2DEL INTEGER,
    CHARVAL CHAR(254),
    CONSTRAINT IC_PK PRIMARY KEY (ICKEY)
);

-------------------------
--lifecycle
-------------------------

DROP TABLE STATETRANSITIONOBJ;

CREATE TABLE STATETRANSITIONOBJ (
    ID INTEGER NOT NULL,
    INT_FIELD INTEGER NOT NULL,
    CONSTRAINT STOBJ_PK PRIMARY KEY (ID)
);

-------------------------
--lifecycle-callbacks
-------------------------

DROP TABLE LIFECYCLELISTENERATTACH;

CREATE TABLE LIFECYCLELISTENERATTACH (
    ID INTEGER NOT NULL,
    CONSTRAINT LIFECYCLE_ATTACH_PK PRIMARY KEY (ID)
);

DROP TABLE LIFECYCLELISTENERCLEAR;

CREATE TABLE LIFECYCLELISTENERCLEAR (
    ID INTEGER NOT NULL,
    CONSTRAINT LIFECYCLE_CLEAR_PK PRIMARY KEY (ID)
);

DROP TABLE LIFECYCLELISTENERDELETE;

CREATE TABLE LIFECYCLELISTENERDELETE (
    ID INTEGER NOT NULL,
    CONSTRAINT LIFECYCLE_DELETE_PK PRIMARY KEY (ID)
);

DROP TABLE LIFECYCLELISTENERDETACH;

CREATE TABLE LIFECYCLELISTENERDETACH (
    ID INTEGER NOT NULL,
    CONSTRAINT LIFECYCLE_DETACH_PK PRIMARY KEY (ID)
);

DROP TABLE LIFECYCLELISTENERLOAD;

CREATE TABLE LIFECYCLELISTENERLOAD (
    ID INTEGER NOT NULL,
    VALUE INTEGER NOT NULL,
    CONSTRAINT LIFECYCLE_LOAD_PK PRIMARY KEY (ID)
);

DROP TABLE LIFECYCLELISTENERSTORE;

CREATE TABLE LIFECYCLELISTENERSTORE (
    ID INTEGER NOT NULL,
    CONSTRAINT LIFECYCLE_STORE_PK PRIMARY KEY (ID)
);

-- disconnect;
