/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HttpConfig {
    public static final String PROP_INVALIDATE_SESSION = "org.apache.felix.http.session.invalidate";
    public static final boolean DEFAULT_INVALIDATE_SESSION = true;
    public static final String PROP_UNIQUE_SESSION_ID = "org.apache.felix.http.session.uniqueid";
    public static final boolean DEFAULT_UNIQUE_SESSION_ID = true;
    private volatile boolean uniqueSessionId;
    private volatile boolean invalidateContainerSession;
    public static final String PROP_CONTAINER_ADDED_ATTRIBUTE = "org.apache.felix.http.session.container.attribute";
    private volatile Set<String> containerAddedAttribueSet;

    public boolean isUniqueSessionId() {
        return this.uniqueSessionId;
    }

    public void setUniqueSessionId(boolean appendSessionId) {
        this.uniqueSessionId = appendSessionId;
    }

    public boolean isInvalidateContainerSession() {
        return this.invalidateContainerSession;
    }

    public void setInvalidateContainerSession(boolean invalidateContainerSession) {
        this.invalidateContainerSession = invalidateContainerSession;
    }

    public Set<String> getContainerAddedAttribueSet() {
        return this.containerAddedAttribueSet;
    }

    public void setContainerAddedAttribueSet(Set<String> containerAddedAttribueSet) {
        this.containerAddedAttribueSet = containerAddedAttribueSet;
    }

    public void configure(@NotNull Dictionary<String, Object> props) {
        this.setUniqueSessionId(this.getBooleanProperty(props, PROP_UNIQUE_SESSION_ID, true));
        this.setInvalidateContainerSession(this.getBooleanProperty(props, PROP_INVALIDATE_SESSION, true));
        this.setContainerAddedAttribueSet(this.getStringSetProperty(props, PROP_CONTAINER_ADDED_ATTRIBUTE));
    }

    private boolean getBooleanProperty(Dictionary<String, Object> props, String name, boolean defValue) {
        Object v = props.get(name);
        if (v != null) {
            String value = String.valueOf(v);
            return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        }
        return defValue;
    }

    private String[] getStringArrayProperty(Dictionary<String, Object> props, String name, String[] defValue) {
        Object value = props.get(name);
        if (value instanceof String) {
            String stringVal = ((String)value).trim();
            if (stringVal.length() > 0) {
                return stringVal.split(",");
            }
        } else if (value instanceof String[]) {
            String[] stringArr = (String[])value;
            ArrayList<String> list = new ArrayList<String>();
            for (String stringVal : stringArr) {
                if (stringVal.trim().length() <= 0) continue;
                list.add(stringVal.trim());
            }
            if (list.size() > 0) {
                return list.toArray(new String[list.size()]);
            }
        } else if (value instanceof Collection) {
            ArrayList<String> conv = new ArrayList<String>();
            for (Object object : (Collection)value) {
                if (object == null) continue;
                conv.add(String.valueOf(object));
            }
            if (conv.size() > 0) {
                return conv.toArray(new String[conv.size()]);
            }
        }
        return defValue;
    }

    private Set<String> getStringSetProperty(Dictionary<String, Object> props, String name) {
        String[] array = this.getStringArrayProperty(props, name, new String[0]);
        HashSet<String> propertySet = new HashSet<String>();
        for (String property : array) {
            if (property == null || "".equals(property.trim())) continue;
            propertySet.add(property);
        }
        return propertySet;
    }
}

