/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.codehaus.groovy.runtime.ArrayGroovyMethods;

public class Iterators {
    public static <T> Iterator<T> iterate(T seed, UnaryOperator<T> advance) {
        Objects.requireNonNull(advance);
        return new IterateIterator<T>(seed, advance);
    }

    public static <T> Iterator<T> generate(Supplier<? extends T> next) {
        Objects.requireNonNull(next);
        return new GenerateIterator<T>(next);
    }

    public static <K, T> Iterator<Map<K, T>> combine(Map<K, ? extends Iterator<T>> map) {
        return Iterators.combine(map, false);
    }

    public static <K, T> Iterator<Map<K, T>> combine(Map<K, ? extends Iterator<T>> map, boolean fairOrdering) {
        if (fairOrdering) {
            return new CrossByIndexIterator(map);
        }
        return new CrossProductIterator(map);
    }

    private static final class IterateIterator<T>
    implements Iterator<T> {
        private final UnaryOperator<T> advance;
        private T next;
        private boolean first;

        private IterateIterator(T seed, UnaryOperator<T> advance) {
            this.next = seed;
            this.first = true;
            this.advance = advance;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            if (this.first) {
                this.first = false;
            } else {
                this.next = this.advance.apply(this.next);
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GenerateIterator<T>
    implements Iterator<T> {
        private final Supplier<? extends T> next;

        private GenerateIterator(Supplier<? extends T> next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            return this.next.get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CrossByIndexIterator<K, T>
    implements Iterator<Map<K, T>> {
        private final Map<K, LazyCachedIterator<T>> sources;
        private final List<K> keys = new ArrayList<K>();
        private final Queue<int[]> indexQueue = new LinkedList<int[]>();
        private final Set<int[]> seen = new HashSet<int[]>();
        private Map<K, T> nextItem = null;
        private int currentDepth = 0;

        private CrossByIndexIterator(Map<K, ? extends Iterator<T>> iterators) {
            this.sources = new LinkedHashMap<K, LazyCachedIterator<T>>();
            for (Map.Entry<K, Iterator<T>> entry : iterators.entrySet()) {
                K key = entry.getKey();
                this.keys.add(key);
                this.sources.put(key, new LazyCachedIterator<T>(entry.getValue()));
            }
            this.enqueueDepth(this.currentDepth);
            this.fetchNext();
        }

        private void fetchNext() {
            this.nextItem = null;
            while (this.nextItem == null) {
                while (!this.indexQueue.isEmpty()) {
                    int[] indices = this.indexQueue.poll();
                    if (!this.seen.add(indices)) continue;
                    LinkedHashMap<K, T> combination = new LinkedHashMap<K, T>();
                    boolean valid = true;
                    for (int i = 0; i < this.sources.size(); ++i) {
                        K key = this.keys.get(i);
                        T val = this.sources.get(key).get(indices[i]);
                        if (val == null) {
                            valid = false;
                            break;
                        }
                        combination.put(key, val);
                    }
                    if (!valid) continue;
                    this.nextItem = combination;
                    return;
                }
                ++this.currentDepth;
                if (this.enqueueDepth(this.currentDepth)) continue;
                return;
            }
        }

        private boolean enqueueDepth(int depth) {
            this.generateIndices(new int[this.sources.size()], 0, depth);
            return !this.indexQueue.isEmpty();
        }

        private void generateIndices(int[] current, int pos, int max) {
            if (pos == current.length) {
                if (max == ArrayGroovyMethods.max(current)) {
                    this.indexQueue.add((int[])current.clone());
                }
                return;
            }
            int size = this.sources.get(this.keys.get(pos)).size();
            int i = 0;
            while (i <= max && i < size) {
                current[pos] = i++;
                this.generateIndices(current, pos + 1, max);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public Map<K, T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("CrossByIndexIterator has been exhausted and contains no more elements");
            }
            Map<K, T> result = this.nextItem;
            this.fetchNext();
            return result;
        }
    }

    private static class CrossProductIterator<K, T>
    implements Iterator<Map<K, T>> {
        private final Map<K, Collection<T>> cache;
        private final Map<K, Iterator<T>> iterators = new LinkedHashMap<K, Iterator<T>>();
        private final List<K> keys = new ArrayList<K>();
        private Map<K, T> current;
        private boolean loaded;
        private boolean exhausted;
        private final Map<K, Boolean> usingCache = new LinkedHashMap<K, Boolean>();

        private CrossProductIterator(Map<K, ? extends Iterator<T>> iterators) {
            this.cache = new LinkedHashMap<K, Collection<T>>();
            for (Map.Entry<K, Iterator<T>> entry : iterators.entrySet()) {
                K key = entry.getKey();
                this.keys.add(key);
                this.iterators.put(key, entry.getValue());
                this.cache.put(key, new ArrayList());
                this.usingCache.put(key, false);
            }
        }

        private void loadFirst() {
            this.current = new LinkedHashMap<K, T>();
            for (K key : this.keys) {
                Iterator<T> iterator = this.iterators.get(key);
                if (!iterator.hasNext()) {
                    this.exhausted = true;
                    return;
                }
                T next = iterator.next();
                this.current.put(key, next);
                this.cache.get(key).add(next);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.loaded) {
                this.loadNext();
                this.loaded = true;
            }
            return !this.exhausted;
        }

        @Override
        public Map<K, T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("CrossProductIterator has been exhausted and contains no more elements");
            }
            Map<K, T> ret = this.current;
            this.loaded = false;
            return ret;
        }

        private void loadNext() {
            if (this.current == null) {
                this.loadFirst();
            } else {
                this.current = new LinkedHashMap<K, T>(this.current);
                for (int i = this.keys.size() - 1; i >= 0; --i) {
                    K key = this.keys.get(i);
                    if (this.iterators.get(key).hasNext()) {
                        T next = this.iterators.get(key).next();
                        this.current.put(key, next);
                        if (this.usingCache.get(key).booleanValue()) break;
                        this.cache.get(key).add(next);
                        break;
                    }
                    if (i > 0) {
                        this.usingCache.put(key, true);
                        this.iterators.put(key, this.cache.get(key).iterator());
                        this.current.put(key, this.iterators.get(key).next());
                        continue;
                    }
                    this.exhausted = true;
                }
            }
        }
    }

    private static class LazyCachedIterator<T> {
        private final Iterator<T> source;
        private final List<T> cache = new ArrayList<T>();

        private LazyCachedIterator(Iterator<T> source) {
            this.source = source;
        }

        private T get(int index) {
            while (this.cache.size() <= index) {
                if (this.source.hasNext()) {
                    this.cache.add(this.source.next());
                    continue;
                }
                return null;
            }
            return this.cache.get(index);
        }

        private int size() {
            if (this.source.hasNext()) {
                return Integer.MAX_VALUE;
            }
            return this.cache.size();
        }
    }
}

