/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactionalobjects;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.LockMode;
import org.multiverse.api.Txn;
import org.multiverse.api.exceptions.LockedException;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.predicates.BooleanPredicate;
import org.multiverse.api.references.TxnBoolean;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.GammaStmUtils;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.ThreadLocalGammaObjectPool;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;

public class GammaTxnBoolean
extends BaseGammaTxnRef
implements TxnBoolean {
    public GammaTxnBoolean(boolean value) {
        this((GammaStm)GlobalStmInstance.getGlobalStmInstance(), value);
    }

    public GammaTxnBoolean(GammaTxn tx) {
        this(tx, false);
    }

    public GammaTxnBoolean(GammaTxn tx, boolean value) {
        super(tx.getConfig().stm, 4);
        this.arriveAndLock(1, 3);
        Tranlocal tranlocal = this.openForConstruction(tx);
        tranlocal.long_value = GammaStmUtils.booleanAsLong(value);
    }

    public GammaTxnBoolean(GammaStm stm) {
        this(stm, false);
    }

    public GammaTxnBoolean(GammaStm stm, boolean b) {
        super(stm, 4);
        this.long_value = GammaStmUtils.booleanAsLong(b);
        this.version = 1L;
    }

    @Override
    public final boolean get() {
        return this.get(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final boolean get(Txn tx) {
        return this.get(GammaStmUtils.asGammaTxn(tx));
    }

    public final boolean get(GammaTxn tx) {
        return GammaStmUtils.longAsBoolean(this.openForRead((GammaTxn)tx, (int)0).long_value);
    }

    @Override
    public final boolean getAndLock(LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), lockMode);
    }

    @Override
    public final boolean getAndLock(Txn tx, LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.asGammaTxn(tx), lockMode);
    }

    public final boolean getAndLock(GammaTxn tx, LockMode lockMode) {
        return GammaStmUtils.longAsBoolean(this.getLong(GammaStmUtils.asGammaTxn(tx), lockMode));
    }

    @Override
    public final boolean set(boolean value) {
        return this.set(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final boolean set(Txn tx, boolean value) {
        return this.set(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final boolean set(GammaTxn tx, boolean value) {
        this.openForWrite((GammaTxn)tx, (int)0).long_value = GammaStmUtils.booleanAsLong(value);
        return value;
    }

    @Override
    public final boolean setAndLock(boolean value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final boolean setAndLock(Txn tx, boolean value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final boolean setAndLock(GammaTxn tx, boolean value, LockMode lockMode) {
        return GammaStmUtils.longAsBoolean(this.setLong(tx, lockMode, GammaStmUtils.booleanAsLong(value), false));
    }

    @Override
    public final boolean getAndSet(boolean value) {
        return this.getAndSet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final boolean getAndSet(Txn tx, boolean value) {
        return this.getAndSet(GammaStmUtils.asGammaTxn(tx), value);
    }

    @Override
    public final boolean getAndSetAndLock(boolean value, LockMode lockMode) {
        return this.getAndSetAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final boolean getAndSetAndLock(Txn tx, boolean value, LockMode lockMode) {
        return this.getAndSetAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final boolean getAndSetAndLock(GammaTxn tx, boolean value, LockMode lockMode) {
        return GammaStmUtils.longAsBoolean(this.setLong(tx, lockMode, GammaStmUtils.booleanAsLong(value), true));
    }

    public final boolean getAndSet(GammaTxn tx, boolean value) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        boolean oldValue = GammaStmUtils.longAsBoolean(tranlocal.long_value);
        tranlocal.long_value = GammaStmUtils.booleanAsLong(value);
        return oldValue;
    }

    @Override
    public final boolean atomicGet() {
        return GammaStmUtils.longAsBoolean(this.atomicGetLong());
    }

    @Override
    public final boolean atomicWeakGet() {
        return GammaStmUtils.longAsBoolean(this.long_value);
    }

    @Override
    public final boolean atomicSet(boolean newValue) {
        return GammaStmUtils.longAsBoolean(this.atomicSetLong(GammaStmUtils.booleanAsLong(newValue), false));
    }

    @Override
    public final boolean atomicGetAndSet(boolean newValue) {
        return GammaStmUtils.longAsBoolean(this.atomicSetLong(GammaStmUtils.booleanAsLong(newValue), true));
    }

    @Override
    public final void commute(BooleanFunction function) {
        this.commute(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final void commute(Txn tx, BooleanFunction function) {
        this.commute(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final void commute(GammaTxn tx, BooleanFunction function) {
        this.openForCommute(tx, (Function)function);
    }

    @Override
    public final boolean getAndAlter(BooleanFunction function) {
        return this.getAndAlter(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final boolean getAndAlter(Txn tx, BooleanFunction function) {
        return this.getAndAlter(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final boolean getAndAlter(GammaTxn tx, BooleanFunction function) {
        return this.alter(tx, function, true);
    }

    @Override
    public final boolean alterAndGet(BooleanFunction function) {
        return this.alterAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final boolean alterAndGet(Txn tx, BooleanFunction function) {
        return this.alterAndGet(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final boolean alterAndGet(GammaTxn tx, BooleanFunction function) {
        return this.alter(tx, function, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean alter(GammaTxn tx, BooleanFunction function, boolean returnOld) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (function == null) {
            tx.abort();
            throw new NullPointerException("Function can't be null");
        }
        Tranlocal write = this.openForWrite(tx, 0);
        boolean abort = true;
        try {
            boolean oldValue = GammaStmUtils.longAsBoolean(write.long_value);
            write.long_value = GammaStmUtils.booleanAsLong(function.call(oldValue));
            abort = false;
            boolean bl = returnOld ? oldValue : GammaStmUtils.longAsBoolean(write.long_value);
            return bl;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final boolean atomicAlterAndGet(BooleanFunction function) {
        return this.atomicAlter(function, false);
    }

    @Override
    public final boolean atomicGetAndAlter(BooleanFunction function) {
        return this.atomicAlter(function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean atomicAlter(BooleanFunction function, boolean returnOld) {
        boolean newValue;
        if (function == null) {
            throw new NullPointerException("Function can't be null");
        }
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        boolean oldValue = GammaStmUtils.longAsBoolean(this.long_value);
        boolean abort = true;
        try {
            newValue = function.call(oldValue);
            abort = false;
        }
        finally {
            if (abort) {
                this.departAfterFailureAndUnlock();
            }
        }
        if (oldValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.long_value = GammaStmUtils.booleanAsLong(newValue);
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return returnOld ? oldValue : newValue;
    }

    @Override
    public final boolean atomicCompareAndSet(boolean expectedValue, boolean newValue) {
        return this.atomicCompareAndSetLong(GammaStmUtils.booleanAsLong(expectedValue), GammaStmUtils.booleanAsLong(newValue));
    }

    @Override
    public final void await(boolean value) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final void await(Txn tx, boolean value) {
        this.await(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final void await(GammaTxn tx, boolean value) {
        if (GammaStmUtils.longAsBoolean(this.openForRead((GammaTxn)tx, (int)0).long_value) != value) {
            tx.retry();
        }
    }

    @Override
    public final void await(BooleanPredicate predicate) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), predicate);
    }

    @Override
    public final void await(Txn tx, BooleanPredicate predicate) {
        this.await(GammaStmUtils.asGammaTxn(tx), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await(GammaTxn tx, BooleanPredicate predicate) {
        Tranlocal tranlocal = this.openForRead(tx, 0);
        boolean abort = true;
        try {
            if (!predicate.evaluate(GammaStmUtils.longAsBoolean(tranlocal.long_value))) {
                tx.retry();
            }
            abort = false;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final String toDebugString() {
        return String.format("GammaTxnBoolean{orec=%s, version=%s, value=%s, hasListeners=%s)", this.___toOrecString(), this.version, GammaStmUtils.longAsBoolean(this.long_value), this.listeners != null);
    }

    @Override
    public final String toString() {
        return this.toString(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final String toString(Txn tx) {
        return this.toString(GammaStmUtils.asGammaTxn(tx));
    }

    public final String toString(GammaTxn tx) {
        return Boolean.toString(this.get(tx));
    }

    @Override
    public final String atomicToString() {
        return Boolean.toString(this.atomicGet());
    }
}

